/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems.ai;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.lazywizard.lazylib.CollectionUtils;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SWP_ZeroAI
implements ShipSystemAIScript {
    private static final float SECONDS_TO_LOOK_AHEAD = 0.25f;
    private CombatEngineAPI engine;
    private final CollectionUtils.CollectionFilter<DamagingProjectileAPI> filterMisses = new CollectionUtils.CollectionFilter<DamagingProjectileAPI>(){

        public boolean accept(DamagingProjectileAPI proj) {
            if (!(proj.getOwner() != SWP_ZeroAI.this.ship.getOwner() || proj instanceof MissileAPI && ((MissileAPI)proj).isFizzling())) {
                return false;
            }
            if (proj instanceof MissileAPI && (((MissileAPI)proj).getEngineController().isTurningLeft() || ((MissileAPI)proj).getEngineController().isTurningRight())) {
                return false;
            }
            return CollisionUtils.getCollides((Vector2f)proj.getLocation(), (Vector2f)Vector2f.add((Vector2f)proj.getLocation(), (Vector2f)((Vector2f)new Vector2f((ReadableVector2f)proj.getVelocity()).scale(0.25f)), null), (Vector2f)SWP_ZeroAI.this.ship.getLocation(), (float)SWP_ZeroAI.this.ship.getCollisionRadius()) && Math.abs(MathUtils.getShortestRotation((float)proj.getFacing(), (float)VectorUtils.getAngle((Vector2f)proj.getLocation(), (Vector2f)SWP_ZeroAI.this.ship.getLocation()))) <= 90.0f;
        }
    };
    private ShipwideAIFlags flags;
    private ShipAPI ship;
    private final IntervalUtil tracker = new IntervalUtil(0.5f, 1.0f);
    private final IntervalUtil tracker2 = new IntervalUtil(0.05f, 0.3f);

    private static Vector2f getClamped(Vector2f origin, Vector2f target, float clamp) {
        Vector2f d = new Vector2f();
        Vector2f.sub((Vector2f)target, (Vector2f)origin, (Vector2f)d);
        float l = d.length();
        if (l > clamp) {
            d.scale(clamp / l);
        }
        Vector2f.add((Vector2f)origin, (Vector2f)d, (Vector2f)d);
        return d;
    }

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        this.tracker.advance(amount);
        this.tracker2.advance(amount);
        if (this.tracker.intervalElapsed()) {
            if (this.ship.getHullLevel() > 0.67f) {
                return;
            }
            List possibleTargets = CombatUtils.getShipsWithinRange((Vector2f)this.ship.getLocation(), (float)5000.0f);
            Iterator iter = possibleTargets.iterator();
            while (iter.hasNext()) {
                ShipAPI possibleTarget = (ShipAPI)iter.next();
                if (!possibleTarget.isFighter() && !possibleTarget.isDrone() && possibleTarget.isAlive() && possibleTarget != this.ship && possibleTarget.getOwner() != this.ship.getOwner()) continue;
                iter.remove();
            }
            if (possibleTargets.size() > 0) {
                this.ship.giveCommand(ShipCommand.TOGGLE_SHIELD_OR_PHASE_CLOAK, null, 0);
            }
        }
        if (this.tracker2.intervalElapsed()) {
            if (!AIUtils.canUseSystemThisFrame((ShipAPI)this.ship) || this.ship.getPhaseCloak().isActive()) {
                return;
            }
            boolean shouldUseSystem = false;
            List<Object> nearbyThreats = new ArrayList(100);
            for (Object tmp : this.engine.getProjectiles()) {
                if (!MathUtils.isWithinRange((Vector2f)tmp.getLocation(), (Vector2f)this.ship.getLocation(), (float)1250.0f)) continue;
                nearbyThreats.add(tmp);
            }
            nearbyThreats = CollectionUtils.filter(nearbyThreats, this.filterMisses);
            List nearbyMissiles = AIUtils.getNearbyEnemyMissiles((CombatEntityAPI)this.ship, (float)500.0f);
            for (Object missile : nearbyMissiles) {
                if (!missile.getEngineController().isTurningLeft() && !missile.getEngineController().isTurningRight()) continue;
                nearbyThreats.add(missile);
            }
            float decisionLevel = 0.0f;
            for (Object threat : nearbyThreats) {
                decisionLevel = (float)((double)decisionLevel + Math.pow(threat.getDamageAmount() * (threat.getDamageType() == DamageType.FRAGMENTATION ? 0.25f : 1.0f) / 125.0f, 1.3f));
            }
            List nearbyBeams = this.engine.getBeams();
            for (Object beam : nearbyBeams) {
                if (beam.getDamageTarget() != this.ship) continue;
                float damage = beam.getWeapon().getDerivedStats().getSustainedDps() < beam.getWeapon().getDerivedStats().getDps() ? beam.getWeapon().getDerivedStats().getBurstDamage() / beam.getWeapon().getDerivedStats().getBurstFireDuration() : beam.getWeapon().getDerivedStats().getDps();
                decisionLevel = (float)((double)decisionLevel + Math.pow(damage * (beam.getWeapon().getDamageType() == DamageType.FRAGMENTATION ? 0.25f : 1.0f) / 125.0f, 1.3f));
            }
            decisionLevel *= 0.33f;
            if (!this.flags.hasFlag(ShipwideAIFlags.AIFlags.HAS_INCOMING_DAMAGE)) {
                decisionLevel *= 0.75f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.PURSUING)) {
                decisionLevel *= 0.5f;
                decisionLevel += 10.0f;
            } else if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.BACK_OFF) || this.flags.hasFlag(ShipwideAIFlags.AIFlags.BACK_OFF_MIN_RANGE) || this.flags.hasFlag(ShipwideAIFlags.AIFlags.BACKING_OFF)) {
                decisionLevel *= 0.5f;
                decisionLevel += 10.0f;
            }
            List weapons = this.ship.getAllWeapons();
            for (WeaponAPI weapon : weapons) {
                if (!weapon.isFiring() || !(weapon.getCooldownRemaining() <= 0.0f)) continue;
                if (weapon.getId().contentEquals("zeroannihilator")) {
                    decisionLevel -= 30.0f;
                }
                if (!weapon.getId().contentEquals("zerobeam")) continue;
                decisionLevel -= 60.0f;
            }
            if (decisionLevel * MathUtils.getRandomNumberInRange((float)0.5f, (float)1.0f) >= (float)Math.random() * 12.5f + 7.5f) {
                shouldUseSystem = true;
            }
            float maxDistance = this.ship.getHullLevel() > 0.67f ? 300.0f : (this.ship.getHullLevel() > 0.33f ? 450.0f : 600.0f);
            switch (this.ship.getHullSpec().getBaseHullId()) {
                case "ssp_superzero": {
                    maxDistance += 150.0f;
                    break;
                }
                case "ssp_hyperzero": {
                    maxDistance += 300.0f;
                    break;
                }
            }
            if (shouldUseSystem) {
                Vector2f point;
                if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.PURSUING) && this.ship.getShipTarget() != null) {
                    this.ship.getMouseTarget().set((ReadableVector2f)this.ship.getShipTarget().getLocation());
                    this.ship.giveCommand(ShipCommand.USE_SYSTEM, (Object)SWP_ZeroAI.getClamped(this.ship.getLocation(), this.ship.getShipTarget().getLocation(), maxDistance), 0);
                } else if ((this.flags.hasFlag(ShipwideAIFlags.AIFlags.BACK_OFF) || this.flags.hasFlag(ShipwideAIFlags.AIFlags.BACK_OFF_MIN_RANGE) || this.flags.hasFlag(ShipwideAIFlags.AIFlags.BACKING_OFF)) && this.ship.getShipTarget() != null) {
                    point = new Vector2f((ReadableVector2f)this.ship.getShipTarget().getLocation());
                    Vector2f.sub((Vector2f)this.ship.getLocation(), (Vector2f)point, (Vector2f)point);
                    Vector2f.add((Vector2f)point, (Vector2f)this.ship.getLocation(), (Vector2f)point);
                    this.ship.getMouseTarget().set((ReadableVector2f)point);
                    this.ship.giveCommand(ShipCommand.USE_SYSTEM, (Object)SWP_ZeroAI.getClamped(this.ship.getLocation(), point, maxDistance), 0);
                } else {
                    point = MathUtils.getPointOnCircumference((Vector2f)this.ship.getLocation(), (float)300.0f, (float)(this.ship.getFacing() + (Math.random() > 0.5 ? 90.0f : -90.0f) * ((float)Math.random() * 0.5f + 0.75f)));
                    this.ship.getMouseTarget().set((ReadableVector2f)point);
                    this.ship.giveCommand(ShipCommand.USE_SYSTEM, (Object)SWP_ZeroAI.getClamped(this.ship.getLocation(), point, maxDistance), 0);
                }
            }
        }
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.flags = flags;
        this.engine = engine;
    }
}

