/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems.ai;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import org.lwjgl.util.vector.Vector2f;

public class SWP_SensorArrayAI
implements ShipSystemAIScript {
    public static final float HARD_FLUX_FACTOR = 0.25f;
    public static final float REMAINING_FLUX_FACTOR_ACTIVATE = 0.25f;
    public static final float REMAINING_FLUX_FACTOR_DEACTIVATE = 0.5f;
    private ShipwideAIFlags flags;
    private ShipAPI ship;
    private ShipSystemAPI system;
    private final IntervalUtil tracker = new IntervalUtil(0.5f, 1.0f);

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        this.tracker.advance(amount);
        if (this.tracker.intervalElapsed()) {
            if (this.system.getCooldownRemaining() > 0.0f) {
                return;
            }
            float weight = 0.0f;
            if (this.system.isActive()) {
                float fluxThreshold = this.ship.getFluxTracker().getMaxFlux() * 0.5f;
                if (this.ship.getFluxTracker().getMaxFlux() - this.ship.getFluxTracker().getCurrFlux() >= fluxThreshold) {
                    weight = 9.0f;
                }
            } else {
                float fluxThreshold = this.ship.getFluxTracker().getMaxFlux() * 0.25f;
                float hardFluxThreshold = this.ship.getFluxTracker().getMaxFlux() * 0.25f;
                if (this.ship.getFluxTracker().getMaxFlux() - this.ship.getFluxTracker().getCurrFlux() < fluxThreshold || this.ship.getFluxTracker().getHardFlux() >= hardFluxThreshold) {
                    weight = -9.0f;
                }
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.PURSUING)) {
                weight += 5.0f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.BACKING_OFF) || this.flags.hasFlag(ShipwideAIFlags.AIFlags.BACK_OFF)) {
                weight -= 5.0f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.BACK_OFF_MIN_RANGE)) {
                weight -= 5.0f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.DO_NOT_USE_FLUX)) {
                weight -= 10.0f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.HARASS_MOVE_IN)) {
                weight += 5.0f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.HAS_INCOMING_DAMAGE) || this.flags.hasFlag(ShipwideAIFlags.AIFlags.NEEDS_HELP)) {
                weight -= 5.0f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.IN_CRITICAL_DPS_DANGER)) {
                weight -= 10.0f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.KEEP_SHIELDS_ON)) {
                weight -= 5.0f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.RUN_QUICKLY)) {
                weight -= 10.0f;
            }
            if (this.ship.getFluxTracker().getFluxLevel() >= 0.25f) {
                this.flags.setFlag(ShipwideAIFlags.AIFlags.OK_TO_CANCEL_SYSTEM_USE_TO_VENT);
            } else {
                this.flags.unsetFlag(ShipwideAIFlags.AIFlags.OK_TO_CANCEL_SYSTEM_USE_TO_VENT);
            }
            if (!this.system.isActive() && weight >= 0.0f) {
                this.ship.useSystem();
            } else if (this.system.isActive() && weight < 0.0f) {
                this.ship.useSystem();
            }
        }
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.system = system;
        this.flags = flags;
    }
}

