/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems.ai;

import com.fs.starfarer.api.combat.CombatAssignmentType;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lwjgl.util.vector.Vector2f;

public class SWP_PunisherJetsAI
implements ShipSystemAIScript {
    private CombatEngineAPI engine;
    private ShipwideAIFlags flags;
    private ShipAPI ship;
    private final IntervalUtil tracker = new IntervalUtil(0.75f, 1.5f);

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine.isPaused()) {
            return;
        }
        this.tracker.advance(amount);
        if (this.tracker.intervalElapsed()) {
            float angleToTargetSpot;
            if (!AIUtils.canUseSystemThisFrame((ShipAPI)this.ship)) {
                return;
            }
            float decisionLevel = 0.0f;
            CombatFleetManagerAPI.AssignmentInfo assignment = this.engine.getFleetManager(this.ship.getOwner()).getTaskManager(this.ship.isAlly()).getAssignmentFor(this.ship);
            Vector2f targetSpot = assignment != null && assignment.getTarget() != null ? assignment.getTarget().getLocation() : null;
            boolean pointedAtTargetSpot = false;
            if (targetSpot != null && MathUtils.getShortestRotation((float)(angleToTargetSpot = VectorUtils.getAngle((Vector2f)this.ship.getLocation(), (Vector2f)targetSpot)), (float)this.ship.getFacing()) <= 45.0f) {
                pointedAtTargetSpot = true;
            }
            boolean pointedAtTarget = false;
            boolean pointedAwayFromTarget = false;
            if (target != null) {
                float angleToTarget = VectorUtils.getAngle((Vector2f)this.ship.getLocation(), (Vector2f)target.getLocation());
                if (MathUtils.getShortestRotation((float)angleToTarget, (float)this.ship.getFacing()) <= 45.0f) {
                    pointedAtTarget = true;
                } else if (MathUtils.getShortestRotation((float)angleToTarget, (float)this.ship.getFacing()) >= 90.0f) {
                    pointedAwayFromTarget = true;
                }
            }
            if (assignment != null && assignment.getType() == CombatAssignmentType.RETREAT) {
                float retreatDirection;
                float f = retreatDirection = this.ship.getOwner() == 0 ? 270.0f : 90.0f;
                if (Math.abs(MathUtils.getShortestRotation((float)this.ship.getFacing(), (float)retreatDirection)) <= 60.0f) {
                    decisionLevel += 15.0f;
                } else if (Math.abs(MathUtils.getShortestRotation((float)this.ship.getFacing(), (float)retreatDirection)) > 90.0f) {
                    decisionLevel -= 15.0f;
                }
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.RUN_QUICKLY)) {
                decisionLevel = pointedAwayFromTarget ? (decisionLevel += 10.0f) : (decisionLevel -= 10.0f);
            } else if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.PURSUING) || this.flags.hasFlag(ShipwideAIFlags.AIFlags.HARASS_MOVE_IN)) {
                if (pointedAtTarget) {
                    decisionLevel += 10.0f;
                }
            } else if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.MANEUVER_TARGET)) {
                if (pointedAtTarget) {
                    decisionLevel += 8.0f;
                }
            } else if (targetSpot != null && pointedAtTargetSpot && !pointedAtTarget) {
                decisionLevel += 12.0f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.DO_NOT_PURSUE)) {
                decisionLevel -= 5.0f;
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.NEEDS_HELP)) {
                decisionLevel = pointedAwayFromTarget ? (decisionLevel += 5.0f) : (decisionLevel -= 10.0f);
            }
            if (this.flags.hasFlag(ShipwideAIFlags.AIFlags.BACK_OFF) || this.flags.hasFlag(ShipwideAIFlags.AIFlags.BACK_OFF_MIN_RANGE) || this.flags.hasFlag(ShipwideAIFlags.AIFlags.BACKING_OFF)) {
                decisionLevel = pointedAwayFromTarget ? (decisionLevel += 5.0f) : (decisionLevel *= 0.5f);
            }
            if (decisionLevel >= 7.0f) {
                this.ship.useSystem();
            }
        }
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.flags = flags;
        this.engine = engine;
    }
}

