/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems.ai;

import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.ArrayList;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class SWP_PhaseShuntDriveAI
implements ShipSystemAIScript {
    private CombatEngineAPI engine = null;
    private ShipwideAIFlags flags;
    private ShipAPI ship;
    private final IntervalUtil tracker = new IntervalUtil(0.25f, 1.0f);

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        this.tracker.advance(amount);
        this.flags.setFlag(ShipwideAIFlags.AIFlags.DO_NOT_VENT, 1.0f);
        if (this.ship.getFluxTracker().getFluxLevel() <= 0.25f) {
            this.flags.setFlag(ShipwideAIFlags.AIFlags.DO_NOT_USE_SHIELDS, 1.0f);
        }
        if (this.tracker.intervalElapsed()) {
            if (!AIUtils.canUseSystemThisFrame((ShipAPI)this.ship)) {
                return;
            }
            ArrayList possibleTargets = new ArrayList(100);
            possibleTargets.addAll(CombatUtils.getProjectilesWithinRange((Vector2f)this.ship.getLocation(), (float)500.0f));
            possibleTargets.addAll(CombatUtils.getMissilesWithinRange((Vector2f)this.ship.getLocation(), (float)500.0f));
            float decisionLevel = 0.0f;
            for (DamagingProjectileAPI possibleTarget : possibleTargets) {
                if (possibleTarget.getOwner() == this.ship.getOwner() || possibleTarget.isFading() || possibleTarget.getCollisionClass() == CollisionClass.NONE) continue;
                if (possibleTarget.getDamageType() == DamageType.FRAGMENTATION) {
                    decisionLevel += (float)Math.sqrt(0.25f * possibleTarget.getDamageAmount() + possibleTarget.getEmpAmount() * 0.25f);
                    continue;
                }
                decisionLevel += (float)Math.sqrt(possibleTarget.getDamageAmount() + possibleTarget.getEmpAmount() * 0.25f);
            }
            if (decisionLevel > 50.0f) {
                this.ship.useSystem();
            }
        }
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.flags = flags;
        this.engine = engine;
    }
}

