/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems.ai;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.List;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class SWP_ForceImpederAI
implements ShipSystemAIScript {
    private ShipAPI ship;
    private final IntervalUtil tracker = new IntervalUtil(2.0f, 3.0f);

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        this.tracker.advance(amount);
        Vector2f shipLoc = this.ship.getLocation();
        if (this.tracker.intervalElapsed()) {
            if (!AIUtils.canUseSystemThisFrame((ShipAPI)this.ship)) {
                return;
            }
            boolean shouldUseSystem = false;
            float repulseRadius = 1500.0f;
            List nearbyEnemies = AIUtils.getNearbyEnemies((CombatEntityAPI)this.ship, (float)repulseRadius);
            List nearbyMissiles = AIUtils.getNearbyEnemyMissiles((CombatEntityAPI)this.ship, (float)repulseRadius);
            List nearbyBullets = CombatUtils.getProjectilesWithinRange((Vector2f)shipLoc, (float)repulseRadius);
            if (nearbyMissiles.size() > 0 || nearbyEnemies.size() > 0 || nearbyBullets.size() > 0) {
                shouldUseSystem = true;
            }
            if (this.ship.getSystem().isActive() ^ shouldUseSystem) {
                this.ship.useSystem();
            }
        }
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
    }
}

