/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems.ai;

import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.Iterator;
import java.util.List;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class SWP_FluxDisturberAI
implements ShipSystemAIScript {
    public static final float HARD_FLUX_THRESHOLD = 0.5f;
    public static final float REMAINING_FLUX_THRESHOLD = 10000.0f;
    public static final float SECONDS_BETWEEN_USES = 2.0f;
    public static final float TARGET_FLUX_REMAINING_BONUS = 1.0f;
    public static final float TARGET_FLUX_REMAINING_BONUS_THRESHOLD = 4000.0f;
    private CombatEngineAPI engine;
    private ShipAPI ship;
    private ShipSystemAPI system;
    private float timer = 0.0f;
    private final IntervalUtil tracker = new IntervalUtil(0.5f, 1.0f);

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        this.tracker.advance(amount);
        if (this.timer > 0.0f) {
            this.timer -= amount;
        }
        if (this.tracker.intervalElapsed()) {
            if (this.system.getCooldownRemaining() > 0.0f) {
                return;
            }
            float targetedAllies = 0.0f;
            float targetedEnemies = 0.0f;
            List possibleTargets = CombatUtils.getShipsWithinRange((Vector2f)this.ship.getLocation(), (float)2500.0f);
            Iterator iter = possibleTargets.iterator();
            while (iter.hasNext()) {
                ShipAPI possibleTarget = (ShipAPI)iter.next();
                if (possibleTarget.isHulk() || possibleTarget.getFluxTracker().isOverloaded() || possibleTarget.getFluxTracker().isVenting() || target == this.ship) {
                    iter.remove();
                    continue;
                }
                if (possibleTarget.getCollisionClass() == CollisionClass.NONE) {
                    iter.remove();
                    continue;
                }
                float value = 0.0f;
                float fluxRemaining = possibleTarget.getFluxTracker().getMaxFlux() - possibleTarget.getFluxTracker().getCurrFlux();
                float bonus = 1.0f * Math.max(0.0f, (4000.0f - fluxRemaining) / 4000.0f) + 1.0f;
                if (possibleTarget.isFighter()) {
                    value = 0.25f * bonus;
                } else if (possibleTarget.isFrigate()) {
                    value = 1.5f * bonus;
                } else if (possibleTarget.isDestroyer()) {
                    value = 2.0f * bonus;
                } else if (possibleTarget.isCruiser()) {
                    value = 1.5f * bonus;
                } else if (possibleTarget.isCapital()) {
                    value = 1.0f * bonus;
                }
                if (possibleTarget.getOwner() == this.ship.getOwner() ^ this.ship.getHullSpec().getBaseHullId().contentEquals("ssp_excelsior")) {
                    if (possibleTarget.isFighter() && possibleTarget.getOwner() == this.ship.getOwner()) continue;
                    targetedAllies += value * 0.75f;
                    continue;
                }
                targetedEnemies += value;
            }
            boolean shield = false;
            if (this.ship.getShield() != null && this.ship.getShield().isOn()) {
                shield = true;
            }
            if (shield) {
                if (this.timer <= 0.0f && targetedEnemies >= 5.0f && targetedEnemies - targetedAllies >= 2.0f && this.ship.getFluxTracker().getMaxFlux() - this.ship.getFluxTracker().getCurrFlux() >= 10000.0f && this.ship.getFluxTracker().getHardFlux() / this.ship.getFluxTracker().getMaxFlux() <= 0.5f) {
                    if (!this.system.isActive()) {
                        this.ship.useSystem();
                    }
                } else if (this.system.isActive()) {
                    this.ship.useSystem();
                    this.timer = 2.0f;
                }
            } else if (this.timer <= 0.0f && targetedEnemies - targetedAllies >= 2.0f && this.ship.getFluxTracker().getMaxFlux() - this.ship.getFluxTracker().getCurrFlux() >= 10000.0f && this.ship.getFluxTracker().getHardFlux() / this.ship.getFluxTracker().getMaxFlux() <= 0.5f) {
                if (!this.system.isActive()) {
                    this.ship.useSystem();
                }
            } else if (this.system.isActive()) {
                this.ship.useSystem();
                this.timer = 2.0f;
            }
        }
    }

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.system = system;
        this.engine = engine;
    }
}

