/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;

public class SWP_TimeFieldStats
extends BaseShipSystemScript {
    public static final Color JITTER_COLOR = new Color(70, 190, 255, 55);
    public static final Color JITTER_UNDER_COLOR = new Color(70, 190, 255, 155);
    public static final float MAX_RANGE = 1500.0f;
    public static final float MAX_TIME_MULT = 3.0f;

    private static Set<ShipAPI> getFighters(ShipAPI carrier) {
        HashSet<ShipAPI> result = new HashSet<ShipAPI>(20);
        for (ShipAPI ship : Global.getCombatEngine().getShips()) {
            if (!ship.isFighter() || ship.getWing() == null || ship.getWing().getSourceShip() != carrier) continue;
            result.add(ship);
        }
        return result;
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ShipAPI ship = (ShipAPI)stats.getEntity();
        boolean player = ship == Global.getCombatEngine().getPlayerShip();
        String statId = id + "_" + ship.getId();
        if (state == ShipSystemStatsScript.State.IDLE) {
            this.unapply(stats, id);
            return;
        }
        float jitterLevel = effectLevel;
        float jitterRangeBonus = 0.0f;
        float maxRangeBonus = 10.0f;
        if (state == ShipSystemStatsScript.State.IN) {
            jitterLevel = effectLevel / (1.0f / ship.getSystem().getChargeUpDur());
            if (jitterLevel > 1.0f) {
                jitterLevel = 1.0f;
            }
            jitterRangeBonus = jitterLevel * maxRangeBonus;
        } else if (state == ShipSystemStatsScript.State.ACTIVE) {
            jitterLevel = 1.0f;
            jitterRangeBonus = maxRangeBonus;
        } else if (state == ShipSystemStatsScript.State.OUT) {
            jitterRangeBonus = jitterLevel * maxRangeBonus;
        }
        jitterLevel = (float)Math.sqrt(jitterLevel);
        float effectLevelSquared = effectLevel * effectLevel;
        ship.setJitter((Object)this, JITTER_COLOR, jitterLevel * 0.75f, 3, 0.0f, jitterRangeBonus * 1.5f);
        ship.setJitterUnder((Object)this, JITTER_UNDER_COLOR, jitterLevel * 0.5f, 25, 0.0f + jitterRangeBonus, 10.0f + jitterRangeBonus * 1.5f);
        float shipTimeMult = 1.0f + 2.0f * effectLevelSquared;
        stats.getTimeMult().modifyMult(statId, shipTimeMult);
        if (player) {
            Global.getCombatEngine().getTimeMult().modifyMult(statId, 1.0f / shipTimeMult);
        } else {
            Global.getCombatEngine().getTimeMult().unmodify(statId);
        }
        ship.getEngineController().fadeToOtherColor((Object)this, JITTER_COLOR, new Color(0, 0, 0, 0), effectLevelSquared, 0.5f);
        ship.getEngineController().extendFlame((Object)this, -0.25f, -0.25f, -0.25f);
        Set<ShipAPI> carriedFighters = SWP_TimeFieldStats.getFighters(ship);
        for (ShipAPI fighter : carriedFighters) {
            float atten = 1.0f;
            if (!fighter.isAlive()) {
                fighter.getMutableStats().getTimeMult().unmodify(statId);
                continue;
            }
            float fighterJitterLevel = jitterLevel * atten;
            float fighterJitterRangeBonus = jitterRangeBonus * atten;
            float fighterEffectLevelSquared = effectLevelSquared * atten;
            fighter.setJitter((Object)this, JITTER_COLOR, fighterJitterLevel, 2, 0.0f, 0.0f + fighterJitterRangeBonus);
            fighter.setJitterUnder((Object)this, JITTER_UNDER_COLOR, fighterJitterLevel, 15, 0.0f, 5.0f + fighterJitterRangeBonus);
            float fighterTimeMult = 1.0f + 2.0f * fighterEffectLevelSquared;
            fighter.getMutableStats().getTimeMult().modifyMult(statId, fighterTimeMult);
            fighter.getEngineController().fadeToOtherColor((Object)this, JITTER_COLOR, new Color(0, 0, 0, 0), fighterEffectLevelSquared, 0.5f);
            fighter.getEngineController().extendFlame((Object)this, -0.25f, -0.25f, -0.25f);
        }
        for (ShipAPI fighter : Global.getCombatEngine().getShips()) {
            if (!fighter.isFighter() || carriedFighters.contains(fighter)) continue;
            fighter.getMutableStats().getTimeMult().unmodify(statId);
        }
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        if (state != ShipSystemStatsScript.State.IDLE) {
            if (index == 0) {
                return new ShipSystemStatsScript.StatusData("\u65f6\u95f4\u6d41\u901f\u6539\u53d8", false);
            }
            if (index == 1) {
                return new ShipSystemStatsScript.StatusData("\u6218\u673a\u65f6\u95f4\u6d41\u901f\u6539\u53d8", false);
            }
        }
        return null;
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ShipAPI ship = (ShipAPI)stats.getEntity();
        String statId = id + "_" + ship.getId();
        Global.getCombatEngine().getTimeMult().unmodify(statId);
        stats.getTimeMult().unmodify(statId);
        for (ShipAPI fighter : Global.getCombatEngine().getShips()) {
            if (!fighter.isFighter()) continue;
            fighter.getMutableStats().getTimeMult().unmodify(statId);
        }
    }
}

