/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import data.scripts.util.SWP_Util;
import java.awt.Color;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lwjgl.util.vector.Vector2f;

public class SWP_SonidoStats
extends BaseShipSystemScript {
    private static final Color COLOR1 = new Color(255, 255, 255);
    private static final Color COLOR2 = new Color(150, 150, 150);
    private static final Color COLOR3 = new Color(100, 0, 0);
    private static final Color COLOR4 = new Color(255, 50, 50);
    private static final Color COLOR5 = new Color(50, 0, 0);
    private static final Color COLOR6 = new Color(150, 50, 200);
    private boolean done = false;

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ShipAPI ship = (ShipAPI)stats.getEntity();
        if (!this.done) {
            int amountscalar;
            this.done = true;
            Vector2f origin = ship.getLocation();
            if (!ship.getPhaseCloak().isActive()) {
                Global.getSoundPlayer().playSound("sonido_activate", 1.0f, 1.0f, ship.getLocation(), ship.getVelocity());
            }
            switch (ship.getHullSpec().getBaseHullId()) {
                case "ssp_hyperzero": {
                    amountscalar = 3;
                    break;
                }
                case "ssp_superzero": {
                    amountscalar = 2;
                    break;
                }
                default: {
                    amountscalar = 1;
                }
            }
            float shipRadius = SWP_Util.effectiveRadius(ship);
            block16: for (int i = 0; i < 6 * amountscalar; ++i) {
                Vector2f point1 = MathUtils.getRandomPointInCircle((Vector2f)origin, (float)(shipRadius * 1.25f));
                Vector2f point2 = MathUtils.getRandomPointInCircle((Vector2f)origin, (float)(shipRadius * 1.25f));
                if (ship.getPhaseCloak() != null && ship.getPhaseCloak().isActive()) {
                    Global.getCombatEngine().spawnEmpArc(ship, point1, (CombatEntityAPI)new SimpleEntity(point1), (CombatEntityAPI)new SimpleEntity(point2), DamageType.ENERGY, 0.0f, 0.0f, 1000.0f, null, 10.0f, COLOR1, COLOR1);
                    continue;
                }
                switch (ship.getHullSpec().getBaseHullId()) {
                    case "ssp_hyperzero": {
                        Global.getCombatEngine().spawnEmpArc(ship, point1, (CombatEntityAPI)new SimpleEntity(point1), (CombatEntityAPI)new SimpleEntity(point2), DamageType.ENERGY, 0.0f, 0.0f, 1000.0f, null, 10.0f, COLOR2, COLOR1);
                        continue block16;
                    }
                    case "ssp_superzero": {
                        Global.getCombatEngine().spawnEmpArc(ship, point1, (CombatEntityAPI)new SimpleEntity(point1), (CombatEntityAPI)new SimpleEntity(point2), DamageType.ENERGY, 0.0f, 0.0f, 1000.0f, null, 7.5f, COLOR3, COLOR4);
                        continue block16;
                    }
                    default: {
                        Global.getCombatEngine().spawnEmpArc(ship, point1, (CombatEntityAPI)new SimpleEntity(point1), (CombatEntityAPI)new SimpleEntity(point2), DamageType.ENERGY, 0.0f, 0.0f, 1000.0f, null, 5.0f, COLOR5, COLOR6);
                    }
                }
            }
        }
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        this.done = false;
    }
}

