/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import data.scripts.util.SWP_Multi;
import data.scripts.util.SWP_Util;
import java.awt.Color;
import java.util.List;
import org.dark.shaders.light.LightAPI;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class SWP_ShieldBreakerStats
extends BaseShipSystemScript {
    private static final Color COLOR1 = new Color(225, 200, 255);
    private static final Color COLOR2 = new Color(150, 100, 200);
    private static final Vector2f ZERO = new Vector2f();
    public boolean activated = true;

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = (ShipAPI)stats.getEntity();
        if (state == ShipSystemStatsScript.State.IN && this.activated) {
            Global.getSoundPlayer().playSound("shieldbreaker_charge", 1.0f, 2.0f, ship.getLocation(), ship.getVelocity());
            this.activated = false;
        }
        if (state == ShipSystemStatsScript.State.OUT) {
            if (!this.activated) {
                StandardLight light = new StandardLight(ship.getLocation(), ZERO, ZERO, null);
                light.setIntensity(3.0f);
                light.setSize(2500.0f);
                light.setColor(COLOR1);
                light.fadeOut(2.0f);
                LightShader.addLight((LightAPI)light);
                float shipRadius = SWP_Util.effectiveRadius(ship);
                boolean didAnything = false;
                List targets = CombatUtils.getShipsWithinRange((Vector2f)ship.getLocation(), (float)1500.0f);
                for (ShipAPI target : targets) {
                    if (!target.isAlive() || target.getShield() == null || target == ship || target.getOwner() == ship.getOwner() && (target.isFighter() || target.isDrone())) continue;
                    didAnything = true;
                    for (int i = 0; i < 7; ++i) {
                        Global.getCombatEngine().spawnEmpArc(ship, MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), (CombatEntityAPI)ship, (CombatEntityAPI)target, DamageType.ENERGY, 500.0f, 4000.0f, 100000.0f, null, 20.0f, COLOR2, COLOR1);
                    }
                    if (target.getShield().isOn()) {
                        target.getFluxTracker().increaseFlux((2000.0f - MathUtils.getDistance((CombatEntityAPI)target, (CombatEntityAPI)ship)) * 10.0f, true);
                    }
                    CombatUtils.applyForce((CombatEntityAPI)SWP_Multi.getRoot(target), (Vector2f)VectorUtils.getDirectionalVector((Vector2f)target.getLocation(), (Vector2f)ship.getLocation()), (float)1500.0f);
                }
                if (didAnything) {
                    Global.getSoundPlayer().playSound("shieldbreaker_blast", 1.0f, 2.0f, ship.getLocation(), ship.getVelocity());
                }
            }
            this.activated = true;
        }
    }
}

