/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems;

import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;

public class SWP_SensorArrayStats
extends BaseShipSystemScript {
    public static final float SENSOR_RANGE_PERCENT = 100.0f;
    public static final float WEAPON_RANGE_PERCENT = 50.0f;

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        float sensorRangePercent = 100.0f * effectLevel;
        float weaponRangePercent = 50.0f * effectLevel;
        stats.getSightRadiusMod().modifyPercent(id, sensorRangePercent);
        stats.getBallisticWeaponRangeBonus().modifyPercent(id, weaponRangePercent);
        stats.getEnergyWeaponRangeBonus().modifyPercent(id, weaponRangePercent);
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        float sensorRangePercent = 100.0f * effectLevel;
        float weaponRangePercent = 50.0f * effectLevel;
        if (index == 0) {
            return new ShipSystemStatsScript.StatusData("\u4f20\u611f\u5668\u5f3a\u5ea6 +" + (int)sensorRangePercent + "%", false);
        }
        if (index == 1) {
            return null;
        }
        if (index == 2) {
            return new ShipSystemStatsScript.StatusData("\u6b66\u5668\u5c04\u7a0b +" + (int)weaponRangePercent + "%", false);
        }
        return null;
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        stats.getSightRadiusMod().unmodify(id);
        stats.getBallisticWeaponRangeBonus().unmodify(id);
        stats.getEnergyWeaponRangeBonus().unmodify(id);
        stats.getMaxSpeed().unmodify(id);
    }
}

