/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.SoundAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import org.lwjgl.util.vector.Vector2f;

public class SWP_PunisherJetsStats
extends BaseShipSystemScript {
    private static final Vector2f ZERO = new Vector2f();
    private SoundAPI sound = null;
    private boolean started = false;

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = (ShipAPI)stats.getEntity();
        if (ship != null) {
            if (!this.started) {
                float pitch;
                this.started = true;
                switch (ship.getHullSize()) {
                    case FIGHTER: {
                        pitch = 1.3f;
                        break;
                    }
                    case FRIGATE: {
                        pitch = 1.25f;
                        break;
                    }
                    default: {
                        pitch = 1.15f;
                        break;
                    }
                    case CRUISER: {
                        pitch = 1.0f;
                        break;
                    }
                    case CAPITAL_SHIP: {
                        pitch = 0.9f;
                    }
                }
                this.sound = Global.getSoundPlayer().playSound("swp_punisherjets_activate", pitch, 1.0f, ship.getLocation(), ZERO);
            }
            if (this.sound != null) {
                this.sound.setLocation(ship.getLocation().x, ship.getLocation().y);
            }
        }
        if (state == ShipSystemStatsScript.State.OUT) {
            stats.getMaxSpeed().modifyFlat(id, 0.0f);
            stats.getMaxSpeed().modifyPercent(id, 100.0f * effectLevel);
            stats.getMaxTurnRate().modifyPercent(id, 100.0f * effectLevel);
            stats.getAcceleration().modifyPercent(id, 150.0f * effectLevel);
            stats.getDeceleration().modifyPercent(id, 200.0f);
        } else {
            stats.getMaxSpeed().modifyFlat(id, 100.0f * effectLevel);
            stats.getMaxSpeed().modifyPercent(id, 100.0f * effectLevel);
            stats.getAcceleration().modifyFlat(id, 150.0f * effectLevel);
            stats.getAcceleration().modifyPercent(id, 150.0f * effectLevel);
            stats.getDeceleration().modifyPercent(id, 100.0f * effectLevel);
            stats.getTurnAcceleration().modifyFlat(id, 50.0f * effectLevel);
            stats.getTurnAcceleration().modifyPercent(id, 300.0f * effectLevel);
            stats.getMaxTurnRate().modifyFlat(id, 25.0f * effectLevel);
            stats.getMaxTurnRate().modifyPercent(id, 100.0f * effectLevel);
        }
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        if (index == 0) {
            return new ShipSystemStatsScript.StatusData("\u63d0\u9ad8\u673a\u52a8\u6027", false);
        }
        if (index == 1) {
            return new ShipSystemStatsScript.StatusData("\u63d0\u9ad8\u6700\u9ad8\u822a\u901f", false);
        }
        return null;
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        this.started = false;
        stats.getMaxSpeed().unmodify(id);
        stats.getMaxTurnRate().unmodify(id);
        stats.getTurnAcceleration().unmodify(id);
        stats.getAcceleration().unmodify(id);
        stats.getDeceleration().unmodify(id);
        this.sound = null;
    }
}

