/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.util.SWP_Util;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dark.shaders.light.LightAPI;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SWP_PrismaticRayStats
extends BaseShipSystemScript {
    private static final float ANGLE_FORCE_MULTIPLIER = 0.5f;
    private static final float DAMAGE_MOD_VS_CAPITAL = 0.15f;
    private static final float DAMAGE_MOD_VS_CRUISER = 0.2f;
    private static final float DAMAGE_MOD_VS_DESTROYER = 1.0f;
    private static final float DAMAGE_MOD_VS_FIGHTER = 0.95f;
    private static final float DAMAGE_MOD_VS_FRIGATE = 0.9f;
    private static final Map<DamageType, Float> DAMAGE_TYPE_POWER_ABSORBTION_MULTIPLIERS = new HashMap<DamageType, Float>(5);
    private static final String DATA_KEY = "SWP_PrismaticRay";
    private static final Color EXPLOSION_COLOR = new Color(255, 100, 200);
    private static final float EXPLOSION_DAMAGE_AMOUNT = 1000.0f;
    private static final DamageType EXPLOSION_DAMAGE_TYPE = DamageType.ENERGY;
    private static final float EXPLOSION_DAMAGE_VS_ALLIES_MODIFIER = 0.05f;
    private static final float EXPLOSION_RADIUS = 500.0f;
    private static final String EXPLOSION_SOUND = "rayblast";
    private static final float EXPLOSION_VISUAL_RADIUS = 1000.0f;
    private static final float MAX_EXPLOSION_RADIUS = 1000.0f;
    private static final float MAX_POWER_MULTIPLIER = 100.0f;
    private static final float MAX_RANGE_MULTIPLIER = 100.0f;
    private static final float MIN_POWER_MULTIPLIER = 2.0f;
    private static final float POWER_PER_FRIENDLY_DAMAGE_ABSORBED = 0.001f;
    private static final float POWER_PER_HOSTILE_DAMAGE_ABSORBED = 0.0011f;
    private static final float SPARK_BRIGHTNESS = 2.5f;
    private static final Color SPARK_COLOR = new Color(255, 175, 200);
    private static final float SPARK_DURATION = 0.5f;
    private static final float SPARK_RADIUS = 5.0f;
    private static final float TEXT_AMOUNT_MULTIPLIER = 1000.0f;
    private static final Color TEXT_COLOR = new Color(0, 187, 255);
    private static final float VELOCITY_FORCE_MULTIPLIER = 2000.0f;
    private static final Vector2f ZERO = new Vector2f();
    private float absorbedPower = 0.0f;
    private StandardLight prismalight = null;
    private ShipAPI ship;

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        MegaArc arc;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        CombatEngineAPI engine = Global.getCombatEngine();
        this.ship = (ShipAPI)stats.getEntity();
        if (!engine.getCustomData().containsKey(DATA_KEY)) {
            engine.getCustomData().put(DATA_KEY, new LocalData());
        }
        LocalData localData = (LocalData)engine.getCustomData().get(DATA_KEY);
        List<MegaArc> arcs = localData.arcs;
        List<MegaArc> newarcs = localData.newarcs;
        if (this.prismalight == null && state == ShipSystemStatsScript.State.IN) {
            this.absorbedPower = 0.01f;
            this.prismalight = new StandardLight(ZERO, ZERO, ZERO, (CombatEntityAPI)this.ship);
            this.prismalight.setIntensity(1.0f);
            this.prismalight.setSize(3000.0f);
            this.prismalight.setColor((float)Math.random(), (float)Math.random(), (float)Math.random());
            this.prismalight.fadeIn(0.1f);
            LightShader.addLight((LightAPI)this.prismalight);
        } else if (this.prismalight != null) {
            this.prismalight.setColor((float)Math.random(), (float)Math.random(), (float)Math.random());
        }
        Iterator<MegaArc> iter = arcs.iterator();
        while (iter.hasNext()) {
            arc = iter.next();
            if (!(Math.random() >= 0.5) || !arc.advance(engine.getElapsedInLastFrame() * 2.0f * engine.getTimeMult().getModifiedValue())) continue;
            iter.remove();
        }
        iter = newarcs.iterator();
        while (iter.hasNext()) {
            arc = iter.next();
            arcs.add(arc);
            iter.remove();
        }
        for (CombatEntityAPI entity : CombatUtils.getEntitiesWithinRange((Vector2f)this.ship.getLocation(), (float)(this.ship.getCollisionRadius() * 100.0f))) {
            DamagingProjectileAPI proj;
            if (!(entity instanceof DamagingProjectileAPI) || (proj = (DamagingProjectileAPI)entity).getBaseDamageAmount() <= 0.0f) continue;
            if (state != ShipSystemStatsScript.State.OUT && MathUtils.getDistance((CombatEntityAPI)this.ship, (CombatEntityAPI)proj) <= this.ship.getCollisionRadius()) {
                this.absorbProjectile(proj);
                continue;
            }
            this.suckInProjectile(proj, state, effectLevel);
        }
        if (state == ShipSystemStatsScript.State.OUT) {
            this.ship.setPhased(false);
        } else {
            this.ship.setPhased(true);
        }
        if (state == ShipSystemStatsScript.State.OUT && this.absorbedPower > 0.0f) {
            this.doASplosion();
            this.absorbedPower = 0.0f;
        }
        if (state == ShipSystemStatsScript.State.OUT && this.prismalight != null) {
            this.prismalight.fadeOut(5.0f);
            this.prismalight = null;
        }
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        LocalData localData;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        this.ship = (ShipAPI)stats.getEntity();
        this.ship.setPhased(false);
        if (!Global.getCombatEngine().getCustomData().containsKey(DATA_KEY)) {
            Global.getCombatEngine().getCustomData().put(DATA_KEY, new LocalData());
        }
        if ((localData = (LocalData)Global.getCombatEngine().getCustomData().get(DATA_KEY)) != null) {
            List<MegaArc> arcs = localData.arcs;
            List<MegaArc> newarcs = localData.newarcs;
            arcs.clear();
            newarcs.clear();
        }
    }

    private void absorbProjectile(DamagingProjectileAPI proj) {
        CombatEngineAPI engine = Global.getCombatEngine();
        if (this.ship == null || engine == null) {
            return;
        }
        float powerAbsorbed = proj.getDamageAmount();
        powerAbsorbed *= proj.getOwner() == this.ship.getOwner() ? 0.001f : 0.0011f;
        engine.addFloatingDamageText(this.ship.getLocation(), (powerAbsorbed *= DAMAGE_TYPE_POWER_ABSORBTION_MULTIPLIERS.get(proj.getDamageType()).floatValue()) * 1000.0f, TEXT_COLOR, (CombatEntityAPI)this.ship, (CombatEntityAPI)proj);
        this.absorbedPower += powerAbsorbed;
        this.ship.setHitpoints(Math.min(this.ship.getHitpoints() + powerAbsorbed * 150.0f, this.ship.getMaxHitpoints()));
        float sparkAngle = VectorUtils.getAngle((Vector2f)proj.getLocation(), (Vector2f)this.ship.getLocation());
        sparkAngle = (float)((double)sparkAngle * (Math.PI / 180));
        Vector2f sparkVect = new Vector2f((float)Math.cos(sparkAngle), (float)Math.sin(sparkAngle));
        float distance = MathUtils.getDistance((CombatEntityAPI)proj, (CombatEntityAPI)this.ship);
        float visualEffect = (float)Math.sqrt(powerAbsorbed * 1000.0f);
        sparkVect.scale(3.0f * distance / 0.5f);
        Global.getSoundPlayer().playSound("crystalsuck", 1.0f, Math.min(Math.max(visualEffect * 0.2f, 0.4f), 2.0f), proj.getLocation(), sparkVect);
        engine.addHitParticle(proj.getLocation(), sparkVect, 5.0f * visualEffect + 5.0f, 2.5f, 0.5f, SPARK_COLOR);
        engine.removeEntity((CombatEntityAPI)proj);
    }

    private void doASplosion() {
        int i;
        CombatEngineAPI engine = Global.getCombatEngine();
        if (this.ship == null || engine == null) {
            return;
        }
        LocalData localData = (LocalData)engine.getCustomData().get(DATA_KEY);
        List<MegaArc> arcs = localData.arcs;
        float power = this.absorbedPower;
        power = Math.max(power, 2.0f);
        power = Math.min(power, 100.0f);
        power = (float)Math.sqrt(power);
        engine.spawnExplosion(this.ship.getLocation(), this.ship.getVelocity(), EXPLOSION_COLOR, 1000.0f * power, 0.21f * power);
        engine.spawnExplosion(this.ship.getLocation(), this.ship.getVelocity(), EXPLOSION_COLOR, 1000.0f * power / 2.0f, 0.19f * power);
        for (i = 0; i < 5; ++i) {
            StandardLight light = new StandardLight();
            light.setLocation(MathUtils.getRandomPointInCircle((Vector2f)this.ship.getLocation(), (float)(1000.0f * power)));
            light.setIntensity(1.0f);
            light.setSize(2000.0f);
            light.setColor((float)Math.random(), (float)Math.random(), (float)Math.random());
            light.fadeOut(5.0f);
            LightShader.addLight((LightAPI)light);
        }
        Global.getSoundPlayer().playSound(EXPLOSION_SOUND, 1.0f, power, this.ship.getLocation(), this.ship.getVelocity());
        for (i = 0; i < (int)(power * 2.5f); ++i) {
            Vector2f direction = new Vector2f(1.0f, 0.0f);
            VectorUtils.rotate((Vector2f)direction, (float)((float)Math.random() * 360.0f), (Vector2f)direction);
            Color color = new Color((int)((float)Math.random() * 255.0f), (int)((float)Math.random() * 255.0f), (int)((float)Math.random() * 255.0f), 150);
            Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255);
            arcs.add(new MegaArc(this.ship, this.ship.getLocation(), direction, (float)Math.random() * 600.0f + 600.0f, (float)Math.random() * 15.0f + 25.0f, (float)Math.random() * 1.5f + 2.0f, color, color2));
        }
        float explosionRadius = Math.min(1000.0f, 500.0f * power);
        for (CombatEntityAPI tmp : CombatUtils.getEntitiesWithinRange((Vector2f)this.ship.getLocation(), (float)explosionRadius)) {
            if (tmp == this.ship) continue;
            float mod = 1.0f - MathUtils.getDistance((CombatEntityAPI)this.ship, (CombatEntityAPI)tmp) / explosionRadius;
            float damage = 1000.0f * (mod *= power);
            if (!(tmp instanceof ShipAPI)) continue;
            ShipAPI victim = (ShipAPI)tmp;
            if (victim.getHullSize() == ShipAPI.HullSize.FIGHTER) {
                damage /= 0.95f;
            } else if (victim.getHullSize() == ShipAPI.HullSize.FRIGATE) {
                damage /= 0.9f;
            } else if (victim.getHullSize() == ShipAPI.HullSize.DESTROYER) {
                damage /= 1.0f;
            } else if (victim.getHullSize() == ShipAPI.HullSize.CRUISER) {
                damage /= 0.2f;
            } else if (victim.getHullSize() == ShipAPI.HullSize.CAPITAL_SHIP) {
                damage /= 0.15f;
            }
            if (victim.getOwner() == this.ship.getOwner()) {
                damage *= 0.05f;
            }
            float shipRadius = SWP_Util.effectiveRadius(victim);
            for (int x = 0; x < 4; ++x) {
                engine.spawnEmpArc(this.ship, this.ship.getLocation(), (CombatEntityAPI)victim, (CombatEntityAPI)victim, EXPLOSION_DAMAGE_TYPE, damage / 10.0f, 0.0f, explosionRadius * 3.0f, null, 20.0f * power, EXPLOSION_COLOR, EXPLOSION_COLOR);
                engine.spawnEmpArc(this.ship, MathUtils.getRandomPointInCircle((Vector2f)victim.getLocation(), (float)shipRadius), (CombatEntityAPI)victim, (CombatEntityAPI)victim, EXPLOSION_DAMAGE_TYPE, damage / 10.0f, 0.0f, explosionRadius, null, 10.0f * power, EXPLOSION_COLOR, EXPLOSION_COLOR);
            }
        }
    }

    private void suckInProjectile(DamagingProjectileAPI proj, ShipSystemStatsScript.State state, float effectLevel) {
        if (proj instanceof MissileAPI) {
            ((MissileAPI)proj).flameOut();
        }
        if (this.ship == null) {
            return;
        }
        float fromToAngle = VectorUtils.getAngle((Vector2f)this.ship.getLocation(), (Vector2f)proj.getLocation());
        float angleDif = MathUtils.getShortestRotation((float)fromToAngle, (float)MathUtils.clampAngle((float)(proj.getFacing() + 180.0f)));
        float amount = Global.getCombatEngine().getElapsedInLastFrame();
        float distance = MathUtils.getDistance((Vector2f)this.ship.getLocation(), (Vector2f)proj.getLocation());
        float force = this.ship.getCollisionRadius() / distance * effectLevel * 0.5f;
        float dAngle = angleDif * amount * force;
        fromToAngle = (float)((double)fromToAngle * (Math.PI / 180));
        Vector2f speedUp = new Vector2f((float)Math.cos(fromToAngle) * amount, (float)Math.sin(fromToAngle) * amount);
        speedUp.scale(2000.0f);
        if (state != ShipSystemStatsScript.State.OUT) {
            dAngle = -dAngle;
            speedUp.scale(-1.0f);
        }
        Vector2f.add((Vector2f)proj.getVelocity(), (Vector2f)speedUp, (Vector2f)proj.getVelocity());
        VectorUtils.rotate((Vector2f)proj.getVelocity(), (float)dAngle, (Vector2f)proj.getVelocity());
        proj.setFacing(MathUtils.clampAngle((float)(proj.getFacing() + dAngle * 57.29578f)));
    }

    static {
        DAMAGE_TYPE_POWER_ABSORBTION_MULTIPLIERS.put(DamageType.ENERGY, Float.valueOf(1.0f));
        DAMAGE_TYPE_POWER_ABSORBTION_MULTIPLIERS.put(DamageType.FRAGMENTATION, Float.valueOf(0.35f));
        DAMAGE_TYPE_POWER_ABSORBTION_MULTIPLIERS.put(DamageType.HIGH_EXPLOSIVE, Float.valueOf(0.9f));
        DAMAGE_TYPE_POWER_ABSORBTION_MULTIPLIERS.put(DamageType.KINETIC, Float.valueOf(0.85f));
        DAMAGE_TYPE_POWER_ABSORBTION_MULTIPLIERS.put(DamageType.OTHER, Float.valueOf(0.5f));
    }

    private static final class MegaArc {
        private final Color color;
        private final Color color2;
        private final Vector2f direction;
        private final IntervalUtil interval = new IntervalUtil(0.035f, 0.035f);
        private final Vector2f location;
        private float remaining;
        private final ShipAPI source;
        private final float speed;
        private final float thickness;

        private MegaArc(ShipAPI source, Vector2f location, Vector2f direction, float speed, float thickness, float lifetime, Color color, Color color2) {
            this.source = source;
            this.location = new Vector2f((ReadableVector2f)location);
            this.direction = new Vector2f((ReadableVector2f)direction);
            this.speed = speed;
            this.thickness = thickness;
            this.remaining = lifetime;
            this.color = color;
            this.color2 = color2;
        }

        private boolean advance(float amount) {
            LocalData localData = (LocalData)Global.getCombatEngine().getCustomData().get(SWP_PrismaticRayStats.DATA_KEY);
            if (localData == null) {
                return true;
            }
            List<MegaArc> newarcs = localData.newarcs;
            this.interval.advance(amount);
            boolean intervalElapsed = this.interval.intervalElapsed();
            Vector2f newLocation = new Vector2f((ReadableVector2f)this.direction);
            newLocation.scale(this.speed * amount);
            Vector2f.add((Vector2f)newLocation, (Vector2f)this.location, (Vector2f)newLocation);
            if (intervalElapsed) {
                Global.getCombatEngine().spawnEmpArc(this.source, this.location, (CombatEntityAPI)new SimpleEntity(newLocation), (CombatEntityAPI)new SimpleEntity(newLocation), DamageType.ENERGY, 0.0f, 0.0f, 10000.0f, null, this.thickness, this.color, this.color2);
                VectorUtils.rotate((Vector2f)this.direction, (float)((float)Math.random() * 40.0f - 20.0f), (Vector2f)this.direction);
            }
            this.location.set((ReadableVector2f)newLocation);
            if (intervalElapsed) {
                List targets = CombatUtils.getEntitiesWithinRange((Vector2f)newLocation, (float)100.0f);
                for (CombatEntityAPI target : targets) {
                    DamagingProjectileAPI proj;
                    if (target == this.source || target.getCollisionClass() == CollisionClass.NONE || target instanceof DamagingProjectileAPI && (proj = (DamagingProjectileAPI)target).getBaseDamageAmount() <= 0.0f) continue;
                    if (target.getOwner() == this.source.getOwner()) {
                        Global.getCombatEngine().applyDamage(target, newLocation, 150.0f, EXPLOSION_DAMAGE_TYPE, 30.0f, false, false, (Object)this.source);
                        continue;
                    }
                    Global.getCombatEngine().applyDamage(target, newLocation, 3000.0f, EXPLOSION_DAMAGE_TYPE, 600.0f, false, false, (Object)this.source);
                }
                if (Math.random() > 0.96) {
                    Global.getSoundPlayer().playSound("crystalsuck", 1.0f + (float)Math.random(), 0.5f, this.location, ZERO);
                    Vector2f newDirection = new Vector2f(1.0f, 0.0f);
                    VectorUtils.rotate((Vector2f)newDirection, (float)((float)Math.random() * 360.0f), (Vector2f)newDirection);
                    newarcs.add(new MegaArc(this.source, this.location, newDirection, this.speed + (float)Math.random() * 100.0f - 50.0f, Math.max(this.thickness - (float)Math.random() * 5.0f, 2.5f), Math.max(this.remaining + (float)Math.random() * 0.5f - 0.25f, 0.01f), this.color, this.color2));
                }
            }
            this.remaining -= amount;
            return this.remaining <= 0.0f;
        }
    }

    private static final class LocalData {
        final List<MegaArc> arcs = new ArrayList<MegaArc>(100);
        final List<MegaArc> newarcs = new ArrayList<MegaArc>(100);

        private LocalData() {
        }
    }
}

