/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.SoundAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.util.SWP_Util;
import java.awt.Color;
import java.util.List;
import org.dark.shaders.distortion.DistortionAPI;
import org.dark.shaders.distortion.DistortionShader;
import org.dark.shaders.distortion.WaveDistortion;
import org.dark.shaders.light.LightAPI;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.lazywizard.lazylib.FastTrig;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SWP_PhaseTunnelerStats
extends BaseShipSystemScript {
    private static final String CHARGEUP_SOUND = "phasetunneler";
    private static final float DAMAGE_MOD_VS_CAPITAL = 0.2f;
    private static final float DAMAGE_MOD_VS_CRUISER = 0.4f;
    private static final float DAMAGE_MOD_VS_DESTROYER = 1.0f;
    private static final float DAMAGE_MOD_VS_FIGHTER = 0.7f;
    private static final float DAMAGE_MOD_VS_FRIGATE = 0.8f;
    private static final float DISTORTION_BLAST_RADIUS = 1500.0f;
    private static final Color EXPLOSION_COLOR = new Color(255, 255, 255);
    private static final float EXPLOSION_DAMAGE_AMOUNT = 5000.0f;
    private static final DamageType EXPLOSION_DAMAGE_TYPE = DamageType.ENERGY;
    private static final float EXPLOSION_DAMAGE_VS_ALLIES_MODIFIER = 0.25f;
    private static final float EXPLOSION_EMP_DAMAGE_AMOUNT = 5000.0f;
    private static final float EXPLOSION_EMP_VS_ALLIES_MODIFIER = 0.25f;
    private static final float EXPLOSION_FORCE_VS_ALLIES_MODIFIER = 0.3f;
    private static final float EXPLOSION_PUSH_RADIUS = 1000.0f;
    private static final float EXPLOSION_VISUAL_RADIUS = 1500.0f;
    private static final float FORCE_VS_ASTEROID = 1500.0f;
    private static final float FORCE_VS_CAPITAL = 200.0f;
    private static final float FORCE_VS_CRUISER = 350.0f;
    private static final float FORCE_VS_DESTROYER = 900.0f;
    private static final float FORCE_VS_FIGHTER = 1250.0f;
    private static final float FORCE_VS_FRIGATE = 1000.0f;
    private static final int MAX_PARTICLES_PER_FRAME = 30;
    private static final Color PARTICLE_COLOR = new Color(255, 255, 255);
    private static final float PARTICLE_OPACITY = 0.5f;
    private static final float PARTICLE_RADIUS = 600.0f;
    private static final float PARTICLE_SIZE = 10.0f;
    private static final Vector2f ZERO = new Vector2f();
    private final IntervalUtil interval = new IntervalUtil(0.035f, 0.035f);
    private final IntervalUtil interval2 = new IntervalUtil(0.015f, 0.015f);
    private boolean isActive = false;
    private StandardLight light = null;
    private Vector2f novaLocation = null;
    private float novaTime = -1.0f;
    private SoundAPI sound = null;

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ShipAPI ship = (ShipAPI)stats.getEntity();
        if (state == ShipSystemStatsScript.State.IN) {
            if (!this.isActive) {
                this.isActive = true;
                this.sound = Global.getSoundPlayer().playSound(CHARGEUP_SOUND, 1.0f, 2.0f, ship.getLocation(), ship.getVelocity());
                this.light = new StandardLight();
                this.light.setIntensity(1.25f);
                this.light.setSize(1500.0f);
                this.light.setColor(PARTICLE_COLOR);
                this.light.fadeIn(1.95f);
                this.light.setLifetime(0.1f);
                this.light.setAutoFadeOutTime(0.17f);
                LightShader.addLight((LightAPI)this.light);
            }
            Vector2f loc = new Vector2f((ReadableVector2f)ship.getLocation());
            loc.x = (float)((double)loc.x - 70.0 * FastTrig.cos((double)((double)ship.getFacing() * Math.PI / 180.0)));
            loc.y = (float)((double)loc.y - 70.0 * FastTrig.sin((double)((double)ship.getFacing() * Math.PI / 180.0)));
            this.light.setLocation(loc);
            this.interval2.advance(Global.getCombatEngine().getElapsedInLastFrame());
            if (this.interval2.intervalElapsed()) {
                int numParticlesThisFrame = Math.round(effectLevel * 30.0f);
                for (int x = 0; x < numParticlesThisFrame; ++x) {
                    Vector2f particlePos = MathUtils.getRandomPointOnCircumference((Vector2f)ship.getLocation(), (float)600.0f);
                    Vector2f particleVel = Vector2f.sub((Vector2f)ship.getLocation(), (Vector2f)particlePos, null);
                    Global.getCombatEngine().addSmokeParticle(particlePos, particleVel, 10.0f, 0.5f, 1.0f, PARTICLE_COLOR);
                }
            }
        } else if (state == ShipSystemStatsScript.State.OUT && this.isActive) {
            CombatEngineAPI engine = Global.getCombatEngine();
            engine.spawnExplosion(ship.getLocation(), ship.getVelocity(), EXPLOSION_COLOR, 1500.0f, 0.2f);
            engine.spawnExplosion(ship.getLocation(), ship.getVelocity(), EXPLOSION_COLOR, 750.0f, 0.2f);
            Vector2f loc = new Vector2f((ReadableVector2f)ship.getLocation());
            loc.x = (float)((double)loc.x - 70.0 * FastTrig.cos((double)((double)ship.getFacing() * Math.PI / 180.0)));
            loc.y = (float)((double)loc.y - 70.0 * FastTrig.sin((double)((double)ship.getFacing() * Math.PI / 180.0)));
            this.light = new StandardLight(loc, ZERO, ZERO, null);
            this.light.setIntensity(2.0f);
            this.light.setSize(3000.0f);
            this.light.setColor(EXPLOSION_COLOR);
            this.light.fadeOut(1.25f);
            LightShader.addLight((LightAPI)this.light);
            WaveDistortion wave = new WaveDistortion(loc, ZERO);
            wave.setSize(1500.0f);
            wave.setIntensity(112.50001f);
            wave.fadeInSize(1.2f);
            wave.fadeOutIntensity(0.9f);
            wave.setSize(375.0f);
            DistortionShader.addDistortion((DistortionAPI)wave);
            if (ship.getHullLevel() <= 0.5f) {
                this.novaLocation = loc;
                this.novaTime = 0.0f;
                engine.addHitParticle(loc, ZERO, 500.0f, 1.0f, 0.3f, EXPLOSION_COLOR);
                engine.spawnExplosion(loc, ZERO, EXPLOSION_COLOR, 1000.0f, 0.05f);
                Global.getSoundPlayer().playSound("phasetunneler_blast", 1.0f, 2.0f, loc, ZERO);
            }
            try {
                this.sound.setLocation(ship.getLocation().x, ship.getLocation().y);
            }
            catch (Exception ex) {
                Global.getSoundPlayer().playSound(CHARGEUP_SOUND, 2.0f, 2.0f, ship.getLocation(), ship.getVelocity());
            }
            for (CombatEntityAPI tmp : CombatUtils.getEntitiesWithinRange((Vector2f)ship.getLocation(), (float)1000.0f)) {
                DamagingProjectileAPI proj;
                if (tmp == ship) continue;
                float mod = 1.0f - MathUtils.getDistance((CombatEntityAPI)ship, (CombatEntityAPI)tmp) / 1000.0f;
                float force = 1500.0f * mod;
                float damage = 5000.0f * mod;
                float emp = 5000.0f * mod;
                if (tmp instanceof ShipAPI) {
                    ShipAPI victim = (ShipAPI)tmp;
                    if (victim.getHullSize() == ShipAPI.HullSize.FIGHTER) {
                        force = 1250.0f * mod;
                        damage /= 0.7f;
                    } else if (victim.getHullSize() == ShipAPI.HullSize.FRIGATE) {
                        force = 1000.0f * mod;
                        damage /= 0.8f;
                    } else if (victim.getHullSize() == ShipAPI.HullSize.DESTROYER) {
                        force = 900.0f * mod;
                        damage /= 1.0f;
                    } else if (victim.getHullSize() == ShipAPI.HullSize.CRUISER) {
                        force = 350.0f * mod;
                        damage /= 0.4f;
                    } else if (victim.getHullSize() == ShipAPI.HullSize.CAPITAL_SHIP) {
                        force = 200.0f * mod;
                        damage /= 0.2f;
                    }
                    if (victim.getOwner() == ship.getOwner()) {
                        damage *= 0.25f;
                        emp *= 0.25f;
                        force *= 0.3f;
                    }
                    float shipRadius = SWP_Util.effectiveRadius(victim);
                    if (victim.getShield() != null && victim.getShield().isOn() && victim.getShield().isWithinArc(ship.getLocation())) {
                        victim.getFluxTracker().increaseFlux(damage * 2.0f, true);
                    } else {
                        for (int x = 0; x < 5; ++x) {
                            engine.spawnEmpArc(ship, MathUtils.getRandomPointInCircle((Vector2f)victim.getLocation(), (float)shipRadius), (CombatEntityAPI)victim, (CombatEntityAPI)victim, EXPLOSION_DAMAGE_TYPE, damage / 10.0f, emp / 5.0f, 1000.0f, null, 2.0f, EXPLOSION_COLOR, EXPLOSION_COLOR);
                        }
                    }
                }
                if (tmp instanceof DamagingProjectileAPI && (proj = (DamagingProjectileAPI)tmp).getBaseDamageAmount() <= 0.0f) continue;
                Vector2f dir = VectorUtils.getDirectionalVector((Vector2f)ship.getLocation(), (Vector2f)tmp.getLocation());
                dir.scale(force);
                Vector2f.add((Vector2f)tmp.getVelocity(), (Vector2f)dir, (Vector2f)tmp.getVelocity());
            }
            this.isActive = false;
        }
        if (this.novaTime >= 0.0f) {
            this.novaTime += Global.getCombatEngine().getElapsedInLastFrame();
            this.interval.advance(Global.getCombatEngine().getElapsedInLastFrame());
            if (this.interval.intervalElapsed()) {
                float offset = (float)Math.random() * 360.0f;
                for (int i = 0; i < (int)(this.novaTime * 5.0f) + 4; ++i) {
                    float angle = (float)i / (this.novaTime * 5.0f + 4.0f) * 360.0f + offset;
                    if (angle >= 360.0f) {
                        angle -= 360.0f;
                    }
                    float distance = (float)Math.random() * 100.0f + this.novaTime * 1500.0f;
                    Vector2f point1 = MathUtils.getPointOnCircumference((Vector2f)this.novaLocation, (float)distance, (float)angle);
                    Vector2f point2 = MathUtils.getPointOnCircumference((Vector2f)this.novaLocation, (float)distance, (float)(angle + 360.0f / (this.novaTime * 5.0f + 4.0f) * ((float)Math.random() + 1.0f)));
                    Global.getCombatEngine().spawnEmpArc(ship, point1, (CombatEntityAPI)new SimpleEntity(point1), (CombatEntityAPI)new SimpleEntity(point2), DamageType.ENERGY, 0.0f, 0.0f, 10000.0f, null, 40.0f, EXPLOSION_COLOR, EXPLOSION_COLOR);
                }
                List targets = CombatUtils.getShipsWithinRange((Vector2f)this.novaLocation, (float)(this.novaTime * 1500.0f + 25.0f));
                for (ShipAPI target : targets) {
                    if (target == ship) continue;
                    float dist = MathUtils.getDistance((Vector2f)this.novaLocation, (Vector2f)target.getLocation());
                    float dist2 = this.novaTime * 1500.0f + 50.0f;
                    if (!(dist - target.getCollisionRadius() <= dist2) || !(dist + target.getCollisionRadius() >= dist2)) continue;
                    if (target.getOwner() == ship.getOwner()) {
                        Global.getCombatEngine().applyDamage((CombatEntityAPI)target, target.getLocation(), 300.0f, DamageType.ENERGY, 150.0f, false, false, (Object)ship);
                        continue;
                    }
                    Global.getCombatEngine().applyDamage((CombatEntityAPI)target, target.getLocation(), 3000.0f, DamageType.ENERGY, 1500.0f, false, false, (Object)ship);
                }
            }
            if (this.novaTime >= 1.0f) {
                this.novaTime = -1.0f;
            }
        }
    }
}

