/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import data.scripts.util.SWP_AnamorphicFlare;
import java.awt.Color;
import java.util.ArrayList;
import org.dark.shaders.distortion.DistortionAPI;
import org.dark.shaders.distortion.DistortionShader;
import org.dark.shaders.distortion.RippleDistortion;
import org.dark.shaders.light.LightAPI;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SWP_PhaseShuntDriveStats
extends BaseShipSystemScript {
    private static final Color COLOR1 = new Color(255, 150, 200);
    private static final Color COLOR2 = new Color(255, 0, 200);
    private static final Color COLOR3 = new Color(255, 0, 255);
    private static final Vector2f ZERO = new Vector2f();
    public boolean activated = true;

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = (ShipAPI)stats.getEntity();
        if (state == ShipSystemStatsScript.State.IN) {
            this.activated = false;
        }
        if (state == ShipSystemStatsScript.State.OUT) {
            if (!this.activated) {
                StandardLight light = new StandardLight(ship.getLocation(), ZERO, ZERO, null);
                light.setIntensity(3.0f);
                light.setSize(600.0f);
                light.setColor(COLOR1);
                light.fadeOut(0.25f);
                LightShader.addLight((LightAPI)light);
                float fluxLevel = ship.getFluxTracker().getCurrFlux() / stats.getFluxCapacity().getBaseValue();
                float range = 700.0f / (1.0f + fluxLevel);
                Global.getCombatEngine().spawnExplosion(ship.getLocation(), ZERO, COLOR1, range, 0.25f);
                ArrayList targets = new ArrayList(Global.getCombatEngine().getProjectiles().size() / 4);
                targets.addAll(CombatUtils.getProjectilesWithinRange((Vector2f)ship.getLocation(), (float)range));
                targets.addAll(CombatUtils.getMissilesWithinRange((Vector2f)ship.getLocation(), (float)range));
                targets.addAll(CombatUtils.getAsteroidsWithinRange((Vector2f)ship.getLocation(), (float)range));
                float total = 0.0f;
                for (CombatEntityAPI target : targets) {
                    float level;
                    if (target instanceof DamagingProjectileAPI) {
                        DamagingProjectileAPI proj = (DamagingProjectileAPI)target;
                        if (proj.getBaseDamageAmount() <= 0.0f) continue;
                        level = proj.getDamageType() == DamageType.FRAGMENTATION ? proj.getDamageAmount() * 0.25f + proj.getEmpAmount() * 0.25f : proj.getDamageAmount() + proj.getEmpAmount() * 0.25f;
                    } else {
                        level = target.getMass();
                    }
                    float sqrtLevel = (float)Math.sqrt(level);
                    float sqrtLevel2 = (float)Math.sqrt(sqrtLevel);
                    SWP_AnamorphicFlare.createStripFlare(ship, new Vector2f((ReadableVector2f)target.getLocation()), Global.getCombatEngine(), sqrtLevel / 20.0f, 1, sqrtLevel / 20.0f, sqrtLevel / 5.0f, (float)Math.random() * 360.0f, 0.0f, 1.0f, COLOR2, COLOR3);
                    RippleDistortion ripple = new RippleDistortion(target.getLocation(), ZERO);
                    ripple.setSize(sqrtLevel * 15.0f);
                    ripple.setIntensity(sqrtLevel * 1.5f);
                    ripple.setFrameRate(240.0f / sqrtLevel2);
                    ripple.fadeInSize(sqrtLevel2 / 4.0f);
                    ripple.fadeOutIntensity(sqrtLevel2 / 4.0f);
                    DistortionShader.addDistortion((DistortionAPI)ripple);
                    Global.getCombatEngine().spawnEmpArc(ship, new Vector2f((ReadableVector2f)target.getLocation()), (CombatEntityAPI)new SimpleEntity(target.getLocation()), (CombatEntityAPI)ship, DamageType.ENERGY, 0.0f, 0.0f, 500.0f, null, sqrtLevel / 10.0f, COLOR2, COLOR3);
                    ship.getFluxTracker().increaseFlux(level, true);
                    Global.getCombatEngine().removeEntity(target);
                    total += level;
                }
                Global.getCombatEngine().addFloatingDamageText(ship.getLocation(), total, COLOR2, (CombatEntityAPI)ship, (CombatEntityAPI)ship);
                Global.getSoundPlayer().playSound("swp_phaseshuntdrive_impact", 1.0f, 0.25f + (float)Math.sqrt(total) / 30.0f, ship.getLocation(), ZERO);
            }
            this.activated = true;
        }
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        this.activated = false;
    }
}

