/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.shaders.SWP_OmegaDriveShader;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SWP_OmegaDriveStats
extends BaseShipSystemScript {
    private static final Color COLOR1 = new Color(255, 255, 255, 255);
    private static final Color COLOR2 = new Color(255, 255, 255, 50);
    private static final String DATA_KEY = "SWP_OmegaDrive";
    private static final Vector2f ZERO = new Vector2f();
    private final IntervalUtil interval = new IntervalUtil(0.1f, 0.1f);
    private ShipAPI ship;
    private boolean started = false;
    private float teleportCooldown = 0.0f;

    private static Vector2f getClamped(Vector2f origin, Vector2f target, float clamp) {
        Vector2f d = new Vector2f();
        Vector2f.sub((Vector2f)target, (Vector2f)origin, (Vector2f)d);
        float l = d.length();
        if (l > 0.0f) {
            d.scale(clamp / l);
        }
        Vector2f.add((Vector2f)origin, (Vector2f)d, (Vector2f)d);
        return d;
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        CombatEngineAPI engine = Global.getCombatEngine();
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        this.ship = (ShipAPI)stats.getEntity();
        if (this.ship.getHullLevel() > 0.67f) {
            return;
        }
        this.ship.setPhased(true);
        if (!engine.getCustomData().containsKey(DATA_KEY)) {
            engine.getCustomData().put(DATA_KEY, new LocalData());
        }
        LocalData localData = (LocalData)engine.getCustomData().get(DATA_KEY);
        List<DamagingProjectileAPI> orbs = localData.orbs;
        ShipAPI playerShip = engine.getPlayerShip();
        stats.getFluxCapacity().modifyMult(id, effectLevel * 100.0f);
        if (state == ShipSystemStatsScript.State.IN && !this.started) {
            this.started = true;
            Global.getSoundPlayer().playUISound("omegadrive_activate", 1.0f, 0.75f);
        }
        if (state == ShipSystemStatsScript.State.ACTIVE && this.ship != playerShip && playerShip != null) {
            this.teleportCooldown -= Global.getCombatEngine().getElapsedInLastFrame();
            if (AIUtils.canUseSystemThisFrame((ShipAPI)this.ship) && this.teleportCooldown <= 0.0f) {
                float maxDistance = this.ship.getHullLevel() > 0.67f ? 300.0f : (this.ship.getHullLevel() > 0.33f ? 450.0f : 600.0f);
                switch (this.ship.getHullSpec().getBaseHullId()) {
                    case "ssp_superzero": {
                        maxDistance += 150.0f;
                        break;
                    }
                    case "ssp_hyperzero": {
                        maxDistance += 300.0f;
                        break;
                    }
                }
                if (MathUtils.getDistance((CombatEntityAPI)this.ship, (CombatEntityAPI)playerShip) > 1000.0f) {
                    this.ship.getMouseTarget().set((ReadableVector2f)playerShip.getLocation());
                    this.ship.giveCommand(ShipCommand.USE_SYSTEM, (Object)SWP_OmegaDriveStats.getClamped(this.ship.getLocation(), playerShip.getLocation(), maxDistance * 2.0f), 0);
                } else {
                    Vector2f point = MathUtils.getPointOnCircumference((Vector2f)this.ship.getLocation(), (float)300.0f, (float)(this.ship.getFacing() + (Math.random() > 0.5 ? 90.0f : -90.0f) * ((float)Math.random() * 0.2f + 0.9f)));
                    this.ship.getMouseTarget().set((ReadableVector2f)point);
                    this.ship.giveCommand(ShipCommand.USE_SYSTEM, (Object)SWP_OmegaDriveStats.getClamped(this.ship.getLocation(), point, maxDistance), 0);
                }
                for (int i = 0; i < 2; ++i) {
                    float angle = VectorUtils.getAngle((Vector2f)this.ship.getLocation(), (Vector2f)playerShip.getLocation()) + (float)Math.random() * 120.0f - 60.0f;
                    Vector2f point = MathUtils.getPointOnCircumference((Vector2f)this.ship.getLocation(), (float)150.0f, (float)angle);
                    DamagingProjectileAPI proj = (DamagingProjectileAPI)engine.spawnProjectile(this.ship, null, "omegaorb", point, angle, null);
                    orbs.add(proj);
                }
                engine.addHitParticle(this.ship.getLocation(), ZERO, 300.0f, 5.0f, 0.35f, COLOR1);
                engine.spawnExplosion(this.ship.getLocation(), ZERO, COLOR1, 600.0f, 0.25f);
                Global.getSoundPlayer().playSound("omegaorb_fire", 1.0f, 1.0f, this.ship.getLocation(), ZERO);
                this.teleportCooldown = 0.2f;
            }
        }
        this.ship.getMutableStats().getTimeMult().modifyMult(id, 1.0f + effectLevel * 4.0f);
        Global.getCombatEngine().getTimeMult().modifyMult(id, 1.0f / (1.0f + effectLevel * 9.0f));
        if (this.ship != playerShip && playerShip != null) {
            playerShip.getMutableStats().getTimeMult().modifyMult(id, 1.0f + effectLevel * 4.0f);
            playerShip.setCollisionClass(CollisionClass.NONE);
            playerShip.getMutableStats().getBallisticRoFMult().modifyMult(id, 1.0f - effectLevel);
            playerShip.getMutableStats().getMissileRoFMult().modifyMult(id, 1.0f - effectLevel);
            playerShip.getMutableStats().getEnergyRoFMult().modifyMult(id, 1.0f - effectLevel);
        }
        this.interval.advance(Global.getCombatEngine().getElapsedInLastFrame());
        boolean drawGraphics = this.interval.intervalElapsed();
        Iterator<DamagingProjectileAPI> iter = orbs.iterator();
        while (iter.hasNext()) {
            DamagingProjectileAPI proj = iter.next();
            if (!engine.isEntityInPlay((CombatEntityAPI)proj)) {
                iter.remove();
                continue;
            }
            if (drawGraphics && Math.random() < 0.1) {
                Vector2f point1 = MathUtils.getRandomPointInCircle((Vector2f)proj.getLocation(), (float)((float)Math.random() * 250.0f));
                engine.spawnEmpArc(this.ship, proj.getLocation(), (CombatEntityAPI)new SimpleEntity(proj.getLocation()), (CombatEntityAPI)new SimpleEntity(point1), DamageType.ENERGY, 0.0f, 0.0f, 1000.0f, null, 10.0f, COLOR1, COLOR1);
            }
            if (playerShip == null || playerShip.getHullSpec().getBaseHullId().contentEquals("ssp_superhyperion") && playerShip.getSystem() != null && playerShip.getSystem().isActive() || !(MathUtils.getDistance((Vector2f)proj.getLocation(), (Vector2f)playerShip.getLocation()) <= 75.0f)) continue;
            engine.addHitParticle(proj.getLocation(), ZERO, 250.0f, 1.0f, 0.1f, COLOR1);
            engine.spawnExplosion(proj.getLocation(), ZERO, COLOR2, 400.0f, 0.1f);
            for (int i = 0; i < 5; ++i) {
                float angle = (float)Math.random() * 360.0f;
                float distance = (float)Math.random() * 200.0f + 100.0f;
                Vector2f point1 = MathUtils.getPointOnCircumference((Vector2f)proj.getLocation(), (float)distance, (float)angle);
                Vector2f point2 = MathUtils.getPointOnCircumference((Vector2f)proj.getLocation(), (float)distance, (float)(angle + 30.0f * (float)Math.random() + 15.0f));
                engine.spawnEmpArc(this.ship, point1, (CombatEntityAPI)new SimpleEntity(point1), (CombatEntityAPI)new SimpleEntity(point2), DamageType.ENERGY, 0.0f, 0.0f, 1000.0f, null, 40.0f, COLOR1, COLOR1);
            }
            switch (this.ship.getHullSpec().getBaseHullId()) {
                case "ssp_hyperzero": {
                    engine.applyDamage((CombatEntityAPI)playerShip, playerShip.getLocation(), 30000.0f, DamageType.ENERGY, 0.0f, false, false, (Object)this.ship);
                    break;
                }
                case "ssp_superzero": {
                    engine.applyDamage((CombatEntityAPI)playerShip, playerShip.getLocation(), 22500.0f, DamageType.ENERGY, 0.0f, false, false, (Object)this.ship);
                    break;
                }
                default: {
                    engine.applyDamage((CombatEntityAPI)playerShip, playerShip.getLocation(), 15000.0f, DamageType.ENERGY, 0.0f, false, false, (Object)this.ship);
                }
            }
            Global.getSoundPlayer().playSound("omegaorb_impact", 1.0f, 1.0f, proj.getLocation(), ZERO);
            engine.removeEntity((CombatEntityAPI)proj);
            iter.remove();
        }
        SWP_OmegaDriveShader.setActive(true, effectLevel);
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        LocalData localData;
        CombatEngineAPI engine = Global.getCombatEngine();
        this.started = false;
        SWP_OmegaDriveShader.setActive(false, 0.0f);
        stats.getFluxCapacity().unmodify(id);
        ShipAPI playerShip = engine.getPlayerShip();
        this.ship = (ShipAPI)stats.getEntity();
        this.ship.setPhased(false);
        if (!engine.getCustomData().containsKey(DATA_KEY)) {
            engine.getCustomData().put(DATA_KEY, new LocalData());
        }
        if ((localData = (LocalData)Global.getCombatEngine().getCustomData().get(DATA_KEY)) != null) {
            List<DamagingProjectileAPI> orbs = localData.orbs;
            for (DamagingProjectileAPI proj : orbs) {
                engine.addHitParticle(proj.getLocation(), ZERO, 100.0f, 1.0f, 0.5f, COLOR1);
                engine.spawnExplosion(proj.getLocation(), ZERO, COLOR1, 100.0f, 0.15f);
                engine.removeEntity((CombatEntityAPI)proj);
            }
            orbs.clear();
        }
        this.ship.getMutableStats().getTimeMult().unmodify(id);
        Global.getCombatEngine().getTimeMult().unmodify(id);
        if (this.ship != playerShip && playerShip != null) {
            playerShip.getMutableStats().getTimeMult().unmodify(id);
            playerShip.setCollisionClass(CollisionClass.SHIP);
            playerShip.getMutableStats().getBallisticRoFMult().unmodify();
            playerShip.getMutableStats().getMissileRoFMult().unmodify();
            playerShip.getMutableStats().getEnergyRoFMult().unmodify();
        }
    }

    private static final class LocalData {
        final List<DamagingProjectileAPI> orbs = new LinkedList<DamagingProjectileAPI>();

        private LocalData() {
        }
    }
}

