/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import java.awt.Color;
import java.util.List;
import org.dark.shaders.distortion.DistortionAPI;
import org.dark.shaders.distortion.DistortionShader;
import org.dark.shaders.distortion.WaveDistortion;
import org.dark.shaders.light.LightAPI;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SWP_ForceBurstStats
extends BaseShipSystemScript {
    public static final float FEEDBACK_PARTICLE_BRIGHTNESS = 1.0f;
    public static final float FEEDBACK_PARTICLE_DURATION = 1.0f;
    public static final int FEEDBACK_PARTICLE_MAX_PER_REPULSE = 5;
    public static final float FEEDBACK_PARTICLE_SIZEFACTOR = 5.0f;
    public static final float MIN_REPULSOR_PARTICLE_SIZE = 5.0f;
    public static final float REPULSOR_SIZE_FACTOR_MAX = 0.1f;
    public static final float REPULSOR_SIZE_FACTOR_MIN = 0.02f;
    private static final float COLLISION_RADIUS_REPULSOR_RADIUS_FACTOR = 10.0f;
    private static final Color LIGHT_COLOR = new Color(255, 255, 255);
    private static final float LIGHT_DURATION = 0.5f;
    private static final float LIGHT_INTENSITY = 1.25f;
    private static final float LIGHT_SIZE_INCREASE = 300.0f;
    private static final float MIN_REPULSOR_RADIUS = 750.0f;
    private static final float REPULSOR_FORCE = 400000.0f;
    private static final int REPULSOR_PARTICLE_COUNT = 350;
    private static final float REPULSOR_PARTICLE_DURATION = 0.6f;
    private static final Vector2f ZERO = new Vector2f();
    private boolean done = true;

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI ship = (ShipAPI)stats.getEntity();
        if (this.done) {
            Global.getSoundPlayer().playSound("forceburst", 1.0f, 2.0f, ship.getLocation(), ship.getVelocity());
        }
        this.done = false;
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        CombatEngineAPI engine = Global.getCombatEngine();
        if (!(stats.getEntity() instanceof ShipAPI) || engine.isPaused() || this.done) {
            return;
        }
        this.done = true;
        ShipAPI ship = (ShipAPI)stats.getEntity();
        Vector2f shipLoc = ship.getLocation();
        float repulseRadius = Math.max(ship.getCollisionRadius() * 10.0f, 750.0f);
        StandardLight light = new StandardLight(shipLoc, ZERO, ZERO, null);
        light.setIntensity(1.25f);
        light.setSize(repulseRadius + 300.0f);
        light.setColor(LIGHT_COLOR);
        light.fadeOut(0.5f);
        LightShader.addLight((LightAPI)light);
        WaveDistortion wave = new WaveDistortion(shipLoc, ZERO);
        wave.setSize(repulseRadius * 3.0f);
        wave.setIntensity(repulseRadius * 0.15f);
        wave.fadeInSize(0.75f);
        wave.fadeOutIntensity(0.5f);
        DistortionShader.addDistortion((DistortionAPI)wave);
        float radiusExpansionRate = repulseRadius / 0.6f;
        ship.setCollisionClass(CollisionClass.SHIP);
        float angle = 0.0f;
        while ((double)angle < Math.PI * 2) {
            float speed = (float)Math.pow(Math.random(), 0.3);
            float randDur = (0.6f + 0.6f * (float)Math.random()) / 2.0f;
            Vector2f randPoint = MathUtils.getPointOnCircumference((Vector2f)shipLoc, (float)ship.getCollisionRadius(), (float)(angle * 57.295776f));
            Vector2f velocity = new Vector2f(ship.getVelocity().x + (float)Math.cos(angle) * radiusExpansionRate * speed, ship.getVelocity().y + (float)Math.sin(angle) * radiusExpansionRate * speed);
            float randSize = MathUtils.getRandomNumberInRange((float)(0.02f * repulseRadius), (float)(0.1f * repulseRadius));
            randSize = Math.max(randSize * 0.4f, 5.0f);
            engine.addHitParticle(randPoint, velocity, randSize, 1.0f, randDur, LIGHT_COLOR);
            angle = (float)((double)angle + 0.017951958020513102);
        }
        List nearbyEnemies = CombatUtils.getShipsWithinRange((Vector2f)shipLoc, (float)repulseRadius);
        for (ShipAPI thisEnemy : nearbyEnemies) {
            if (thisEnemy.getCollisionClass() == CollisionClass.NONE) continue;
            this.push((CombatEntityAPI)ship, (CombatEntityAPI)thisEnemy, 1.0f - MathUtils.getDistance((CombatEntityAPI)ship, (CombatEntityAPI)thisEnemy) / repulseRadius);
        }
        List nearbyAsteroids = CombatUtils.getAsteroidsWithinRange((Vector2f)shipLoc, (float)repulseRadius);
        for (CombatEntityAPI asteroid : nearbyAsteroids) {
            this.push((CombatEntityAPI)ship, asteroid, 1.0f - MathUtils.getDistance((CombatEntityAPI)ship, (CombatEntityAPI)asteroid) / repulseRadius);
        }
        int numRepulseParticles = 0;
        for (DamagingProjectileAPI thisProj : engine.getProjectiles()) {
            if (thisProj.getBaseDamageAmount() <= 0.0f || thisProj.getOwner() == ship.getOwner()) continue;
            Vector2f thisProjLoc = thisProj.getLocation();
            Vector2f thisProjVel = thisProj.getVelocity();
            if (MathUtils.getDistanceSquared((Vector2f)shipLoc, (Vector2f)thisProjLoc) > repulseRadius * repulseRadius) continue;
            if (numRepulseParticles < 5) {
                ++numRepulseParticles;
                float scaleFactor = thisProj.getDamageType() == DamageType.FRAGMENTATION ? (float)Math.sqrt(thisProj.getDamageAmount() * 0.25f) : (float)Math.sqrt(thisProj.getDamageAmount() * 1.0f);
                scaleFactor = Math.min(scaleFactor, 40.0f);
                engine.addHitParticle(thisProjLoc, ship.getVelocity(), 5.0f * scaleFactor, 1.0f, 1.0f, LIGHT_COLOR);
            }
            float returnAngle = MathUtils.clampAngle((float)(VectorUtils.getFacing((Vector2f)thisProjVel) + MathUtils.getRandomNumberInRange((float)170.0f, (float)190.0f)));
            thisProjVel.set((ReadableVector2f)MathUtils.getPointOnCircumference(null, (float)(thisProjVel.length() * 1.3f), (float)returnAngle));
            thisProj.setFacing(returnAngle);
            thisProj.setOwner(ship.getOwner());
            thisProj.setSource(ship);
        }
    }

    private void push(CombatEntityAPI source, CombatEntityAPI target, float forceMultiplier) {
        if (source.getOwner() == target.getOwner()) {
            return;
        }
        Vector2f pushVec = VectorUtils.getDirectionalVector((Vector2f)source.getLocation(), (Vector2f)target.getLocation());
        float magnitude = 1.0f / Math.max(1.0f, target.getMass()) * forceMultiplier;
        pushVec.x *= magnitude * 400000.0f;
        pushVec.y *= magnitude * 400000.0f;
        Vector2f.add((Vector2f)pushVec, (Vector2f)target.getVelocity(), (Vector2f)target.getVelocity());
    }
}

