/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import data.scripts.util.SWP_Util;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dark.shaders.light.LightAPI;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.Vector2f;

public class SWP_FaerieVortexStats
extends BaseShipSystemScript {
    private static final float ANGLE_FORCE_MULTIPLIER = 0.5f;
    private static final float DAMAGE_MOD_VS_CAPITAL = 0.15f;
    private static final float DAMAGE_MOD_VS_CRUISER = 0.2f;
    private static final float DAMAGE_MOD_VS_DESTROYER = 0.5f;
    private static final float DAMAGE_MOD_VS_FIGHTER = 0.95f;
    private static final float DAMAGE_MOD_VS_FRIGATE = 0.9f;
    private static final Map<DamageType, Float> DAMAGE_TYPE_POWER_ABSORBTION_MULTIPLIERS = new HashMap<DamageType, Float>(5);
    private static final Color EXPLOSION_COLOR = new Color(255, 75, 50);
    private static final float EXPLOSION_DAMAGE_AMOUNT = 2000.0f;
    private static final DamageType EXPLOSION_DAMAGE_TYPE = DamageType.ENERGY;
    private static final float EXPLOSION_DAMAGE_VS_ALLIES_MODIFIER = 0.25f;
    private static final float EXPLOSION_EMP_DAMAGE_AMOUNT = 4000.0f;
    private static final float EXPLOSION_EMP_VS_ALLIES_MODIFIER = 0.05f;
    private static final float EXPLOSION_RADIUS = 750.0f;
    private static final String EXPLOSION_SOUND = "vortex_blast";
    private static final float EXPLOSION_VISUAL_RADIUS = 750.0f;
    private static final float MAX_EXPLOSION_RADIUS = 5000.0f;
    private static final float MAX_POWER_MULTIPLIER = 100.0f;
    private static final float MAX_RANGE_MULTIPLIER = 40.0f;
    private static final float MIN_POWER_MULTIPLIER = 0.5f;
    private static final float POWER_PER_FRIENDLY_DAMAGE_ABSORBED = 4.0E-4f;
    private static final float POWER_PER_HOSTILE_DAMAGE_ABSORBED = 8.0E-4f;
    private static final float SPARK_BRIGHTNESS = 2.5f;
    private static final Color SPARK_COLOR = new Color(255, 50, 25);
    private static final float SPARK_DURATION = 0.5f;
    private static final float SPARK_RADIUS = 10.0f;
    private static final float TEXT_AMOUNT_MULTIPLIER = 1000.0f;
    private static final Color TEXT_COLOR = new Color(255, 187, 0);
    private static final float VELOCITY_FORCE_MULTIPLIER = 2000.0f;
    private static final Vector2f ZERO = new Vector2f();
    private float absorbedPower = 0.0f;
    private ShipAPI ship;

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        this.ship = (ShipAPI)stats.getEntity();
        for (CombatEntityAPI entity : CombatUtils.getEntitiesWithinRange((Vector2f)this.ship.getLocation(), (float)(this.ship.getCollisionRadius() * 40.0f))) {
            DamagingProjectileAPI proj;
            if (!(entity instanceof DamagingProjectileAPI) || (proj = (DamagingProjectileAPI)entity).getBaseDamageAmount() <= 0.0f) continue;
            if (state != ShipSystemStatsScript.State.OUT && MathUtils.getDistance((CombatEntityAPI)this.ship, (CombatEntityAPI)proj) <= this.ship.getCollisionRadius()) {
                this.absorbProjectile(proj);
                continue;
            }
            this.suckInProjectile(proj, state, effectLevel);
        }
        if (state == ShipSystemStatsScript.State.OUT) {
            this.ship.setPhased(false);
        } else {
            this.ship.setPhased(true);
        }
        if (state == ShipSystemStatsScript.State.OUT && this.absorbedPower > 0.0f) {
            this.doASplosion();
            this.absorbedPower = 0.0f;
        }
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        if (this.ship == null) {
            return;
        }
        this.ship.setPhased(false);
    }

    private void absorbProjectile(DamagingProjectileAPI proj) {
        CombatEngineAPI engine = Global.getCombatEngine();
        if (this.ship == null || engine == null) {
            return;
        }
        float powerAbsorbed = proj.getDamageAmount();
        powerAbsorbed *= proj.getOwner() == this.ship.getOwner() ? 4.0E-4f : 8.0E-4f;
        engine.addFloatingDamageText(this.ship.getLocation(), (powerAbsorbed *= DAMAGE_TYPE_POWER_ABSORBTION_MULTIPLIERS.get(proj.getDamageType()).floatValue()) * 1000.0f, TEXT_COLOR, (CombatEntityAPI)this.ship, (CombatEntityAPI)proj);
        this.absorbedPower += powerAbsorbed;
        this.ship.setHitpoints(Math.min(this.ship.getHitpoints() + powerAbsorbed * 200.0f, this.ship.getMaxHitpoints()));
        float sparkAngle = VectorUtils.getAngle((Vector2f)proj.getLocation(), (Vector2f)this.ship.getLocation());
        sparkAngle = (float)((double)sparkAngle * (Math.PI / 180));
        Vector2f sparkVect = new Vector2f((float)Math.cos(sparkAngle), (float)Math.sin(sparkAngle));
        float distance = MathUtils.getDistance((CombatEntityAPI)proj, (CombatEntityAPI)this.ship);
        float visualEffect = (float)Math.sqrt(powerAbsorbed * 1000.0f);
        sparkVect.scale(3.0f * distance / 0.5f);
        Global.getSoundPlayer().playSound("vortex_absorb", 1.0f, Math.min(Math.max(visualEffect * 0.04f, 0.1f), 0.5f), proj.getLocation(), sparkVect);
        engine.addHitParticle(proj.getLocation(), sparkVect, 10.0f * visualEffect + 10.0f, 2.5f, 0.5f, SPARK_COLOR);
        engine.removeEntity((CombatEntityAPI)proj);
    }

    private void doASplosion() {
        CombatEngineAPI engine = Global.getCombatEngine();
        if (this.ship == null || engine == null) {
            return;
        }
        float power = this.absorbedPower;
        power = Math.max(power, 0.5f);
        power = Math.min(power, 100.0f);
        power = (float)Math.sqrt(power);
        engine.spawnExplosion(this.ship.getLocation(), this.ship.getVelocity(), EXPLOSION_COLOR, 750.0f * power, 0.21f * power);
        engine.spawnExplosion(this.ship.getLocation(), this.ship.getVelocity(), EXPLOSION_COLOR, 750.0f * power / 2.0f, 0.19f * power);
        StandardLight light = new StandardLight(this.ship.getLocation(), ZERO, ZERO, null);
        light.setIntensity(3.0f);
        light.setSize(1500.0f);
        light.setColor(EXPLOSION_COLOR);
        light.fadeOut(1.25f);
        LightShader.addLight((LightAPI)light);
        Global.getSoundPlayer().playSound(EXPLOSION_SOUND, 1.0f, power, this.ship.getLocation(), this.ship.getVelocity());
        float explosionRadius = Math.min(5000.0f, 750.0f * power);
        List targets = CombatUtils.getShipsWithinRange((Vector2f)this.ship.getLocation(), (float)explosionRadius);
        for (ShipAPI tmp : targets) {
            if (tmp == this.ship) continue;
            float mod = 1.0f - MathUtils.getDistance((CombatEntityAPI)this.ship, (CombatEntityAPI)tmp) / explosionRadius;
            float damage = 2000.0f * (mod *= power);
            float emp = 4000.0f * mod;
            if (tmp.getHullSize() == ShipAPI.HullSize.FIGHTER) {
                damage /= 0.95f;
            } else if (tmp.getHullSize() == ShipAPI.HullSize.FRIGATE) {
                damage /= 0.9f;
            } else if (tmp.getHullSize() == ShipAPI.HullSize.DESTROYER) {
                damage /= 0.5f;
            } else if (tmp.getHullSize() == ShipAPI.HullSize.CRUISER) {
                damage /= 0.2f;
            } else if (tmp.getHullSize() == ShipAPI.HullSize.CAPITAL_SHIP) {
                damage /= 0.15f;
            }
            if (tmp.getOwner() == this.ship.getOwner()) {
                damage *= 0.25f;
                emp *= 0.05f;
            }
            float shipRadius = SWP_Util.effectiveRadius(tmp);
            for (int x = 0; x < 4; ++x) {
                engine.spawnEmpArc(this.ship, this.ship.getLocation(), (CombatEntityAPI)tmp, (CombatEntityAPI)tmp, EXPLOSION_DAMAGE_TYPE, damage / 10.0f, emp / 5.0f, explosionRadius * 3.0f, null, 20.0f * power, EXPLOSION_COLOR, EXPLOSION_COLOR);
                engine.spawnEmpArc(this.ship, MathUtils.getRandomPointInCircle((Vector2f)tmp.getLocation(), (float)shipRadius), (CombatEntityAPI)tmp, (CombatEntityAPI)tmp, EXPLOSION_DAMAGE_TYPE, damage / 10.0f, emp / 5.0f, explosionRadius, null, 10.0f * power, EXPLOSION_COLOR, EXPLOSION_COLOR);
            }
        }
    }

    private void suckInProjectile(DamagingProjectileAPI proj, ShipSystemStatsScript.State state, float effectLevel) {
        if (proj instanceof MissileAPI) {
            ((MissileAPI)proj).flameOut();
        }
        if (this.ship == null) {
            return;
        }
        float fromToAngle = VectorUtils.getAngle((Vector2f)this.ship.getLocation(), (Vector2f)proj.getLocation());
        float angleDif = MathUtils.getShortestRotation((float)fromToAngle, (float)MathUtils.clampAngle((float)(proj.getFacing() + 180.0f)));
        float amount = Global.getCombatEngine().getElapsedInLastFrame();
        float distance = MathUtils.getDistance((Vector2f)this.ship.getLocation(), (Vector2f)proj.getLocation());
        float force = this.ship.getCollisionRadius() / distance * effectLevel * 0.5f;
        float dAngle = angleDif * amount * force;
        fromToAngle = (float)((double)fromToAngle * (Math.PI / 180));
        Vector2f speedUp = new Vector2f((float)Math.cos(fromToAngle) * amount, (float)Math.sin(fromToAngle) * amount);
        speedUp.scale(2000.0f);
        if (state != ShipSystemStatsScript.State.OUT) {
            dAngle = -dAngle;
            speedUp.scale(-1.0f);
        }
        Vector2f.add((Vector2f)proj.getVelocity(), (Vector2f)speedUp, (Vector2f)proj.getVelocity());
        VectorUtils.rotate((Vector2f)proj.getVelocity(), (float)dAngle, (Vector2f)proj.getVelocity());
        proj.setFacing(MathUtils.clampAngle((float)(proj.getFacing() + dAngle * 57.29578f)));
    }

    static {
        DAMAGE_TYPE_POWER_ABSORBTION_MULTIPLIERS.put(DamageType.ENERGY, Float.valueOf(1.0f));
        DAMAGE_TYPE_POWER_ABSORBTION_MULTIPLIERS.put(DamageType.FRAGMENTATION, Float.valueOf(0.35f));
        DAMAGE_TYPE_POWER_ABSORBTION_MULTIPLIERS.put(DamageType.HIGH_EXPLOSIVE, Float.valueOf(0.9f));
        DAMAGE_TYPE_POWER_ABSORBTION_MULTIPLIERS.put(DamageType.KINETIC, Float.valueOf(0.85f));
        DAMAGE_TYPE_POWER_ABSORBTION_MULTIPLIERS.put(DamageType.OTHER, Float.valueOf(0.5f));
    }
}

