/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.ArmorGridAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.IntervalUtil;
import java.awt.Color;
import java.util.Random;
import org.lwjgl.util.vector.Vector2f;

public class SWP_ExcelsiorPhaseStats
extends BaseShipSystemScript {
    private static final float ARMOR_REPAIR_MULTIPLIER = 300.0f;
    private static final float HULL_REPAIR_MULTIPLIER = 100.0f;
    private static final float MAX_TIME_MULT_MAX = 5.0f;
    private static final float SHIP_ALPHA_MULT = 0.25f;
    private static final float SPARK_BRIGHTNESS = 0.9f;
    private static final Color SPARK_COLOR = new Color(255, 0, 200);
    private static final float SPARK_DURATION = 0.5f;
    private static final float SPARK_MAX_RADIUS = 5.0f;
    private final Object STATUSKEY1 = new Object();
    private final Object STATUSKEY2 = new Object();
    private final Object STATUSKEY3 = new Object();
    private final Object STATUSKEY4 = new Object();
    private final Object STATUSKEY5 = new Object();
    private final IntervalUtil interval = new IntervalUtil(0.033f, 0.033f);
    private final Random rand = new Random();

    public static Vector2f getCellLocation(ShipAPI ship, float x, float y) {
        float xx = x - (float)ship.getArmorGrid().getGrid().length / 2.0f;
        float yy = y - (float)ship.getArmorGrid().getGrid()[0].length / 2.0f;
        float cellSize = ship.getArmorGrid().getCellSize();
        Vector2f cellLoc = new Vector2f();
        float theta = (float)((double)((ship.getFacing() - 90.0f) / 360.0f) * (Math.PI * 2));
        cellLoc.x = (float)((double)xx * Math.cos(theta) - (double)yy * Math.sin(theta)) * cellSize + ship.getLocation().x;
        cellLoc.y = (float)((double)xx * Math.sin(theta) + (double)yy * Math.cos(theta)) * cellSize + ship.getLocation().y;
        return cellLoc;
    }

    public static float getMaxTimeMult(MutableShipStatsAPI stats) {
        return 1.0f + 4.0f * stats.getDynamic().getValue("phase_time_mult");
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        CombatEngineAPI engine = Global.getCombatEngine();
        String actualId = id;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ShipAPI ship = (ShipAPI)stats.getEntity();
        boolean player = ship == engine.getPlayerShip();
        actualId = actualId + "_" + ship.getId();
        if (player) {
            this.maintainStatus(ship);
        }
        if (engine.isPaused()) {
            return;
        }
        if (state == ShipSystemStatsScript.State.COOLDOWN || state == ShipSystemStatsScript.State.IDLE) {
            this.unapply(stats, actualId);
            return;
        }
        float fluxLevel = ship.getFluxTracker().getCurrFlux() / stats.getFluxCapacity().getBaseValue();
        this.interval.advance(engine.getElapsedInLastFrame());
        if (this.interval.intervalElapsed()) {
            ArmorGridAPI armorGrid = ship.getArmorGrid();
            int x = this.rand.nextInt(armorGrid.getGrid().length);
            int y = this.rand.nextInt(armorGrid.getGrid()[0].length);
            float newArmor = armorGrid.getArmorValue(x, y);
            float cellSize = armorGrid.getCellSize();
            if (ship == engine.getPlayerShip()) {
                engine.maintainStatusForPlayerShip(this.STATUSKEY1, "graphics/icons/hullsys/phase_cloak.png", "\u76f8\u4f4d\u9a71\u52a8", "\u5e45\u80fd\u6392\u653e", true);
            }
            if (Float.compare(newArmor, armorGrid.getMaxArmorInCell()) < 0) {
                armorGrid.setArmorValue(x, y, Math.min(armorGrid.getMaxArmorInCell(), newArmor += 300.0f * this.interval.getIntervalDuration() * fluxLevel));
                Vector2f cellLoc = SWP_ExcelsiorPhaseStats.getCellLocation(ship, x, y);
                cellLoc.x += cellSize * 0.1f - cellSize * (float)Math.random();
                cellLoc.y += cellSize * 0.1f - cellSize * (float)Math.random();
                engine.addHitParticle(cellLoc, ship.getVelocity(), 5.0f * (float)Math.random() + 5.0f, 0.9f, 0.5f, SPARK_COLOR);
                if (ship == engine.getPlayerShip()) {
                    engine.maintainStatusForPlayerShip(this.STATUSKEY3, "graphics/icons/hullsys/phase_cloak.png", "\u76f8\u4f4d\u9a71\u52a8", "\u88c5\u7532\u7ed3\u6784\u4fee\u590d", false);
                }
            }
            ship.setHitpoints(Math.min(ship.getHitpoints() + this.interval.getIntervalDuration() * 100.0f * fluxLevel, ship.getMaxHitpoints()));
        }
        if (ship.getFluxTracker().getCurrFlux() < 0.0f) {
            ship.getFluxTracker().setCurrFlux(100.0f);
            ship.giveCommand(ShipCommand.TOGGLE_SHIELD_OR_PHASE_CLOAK, null, 0);
        }
        if (state == ShipSystemStatsScript.State.OUT) {
            stats.getMaxSpeed().unmodify(actualId);
            stats.getMaxTurnRate().unmodify(actualId);
        } else {
            float level = (1.0f + fluxLevel * 0.5f) * effectLevel;
            stats.getMaxSpeed().modifyFlat(actualId, 200.0f * level);
            stats.getMaxTurnRate().modifyPercent(actualId, 200.0f * level);
            stats.getAcceleration().modifyFlat(actualId, 1000.0f * level);
            stats.getDeceleration().modifyFlat(actualId, 1000.0f * level);
            stats.getTurnAcceleration().modifyPercent(actualId, 300.0f * level);
            if (ship == engine.getPlayerShip()) {
                engine.maintainStatusForPlayerShip(this.STATUSKEY4, "graphics/icons/hullsys/phase_cloak.png", "\u76f8\u4f4d\u9a71\u52a8", "+" + (int)(200.0f * level) + " \u822a\u901f", false);
                engine.maintainStatusForPlayerShip(this.STATUSKEY5, "graphics/icons/hullsys/phase_cloak.png", "\u76f8\u4f4d\u9a71\u52a8", "+" + (int)(200.0f * level) + "% \u673a\u52a8\u6027", false);
            }
            if (ship.getFluxTracker().getCurrFlux() <= 50.0f) {
                ship.giveCommand(ShipCommand.TOGGLE_SHIELD_OR_PHASE_CLOAK, null, 0);
            }
        }
        float levelForAlpha = effectLevel;
        ship.setPhased(true);
        ship.setExtraAlphaMult(1.0f - 0.75f * levelForAlpha);
        ship.setApplyExtraAlphaToEngines(true);
        float shipTimeMult = Math.min(Math.max(1.0f + (SWP_ExcelsiorPhaseStats.getMaxTimeMult(stats) - 1.0f) * effectLevel * Math.max(0.0f, fluxLevel), 1.0f), SWP_ExcelsiorPhaseStats.getMaxTimeMult(stats));
        stats.getTimeMult().modifyMult(actualId, shipTimeMult);
        if (player) {
            engine.getTimeMult().modifyMult(actualId, 1.0f / shipTimeMult);
        } else {
            engine.getTimeMult().unmodify(actualId);
        }
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ShipAPI ship = (ShipAPI)stats.getEntity();
        stats.getMaxSpeed().unmodify(id);
        stats.getMaxTurnRate().unmodify(id);
        stats.getTurnAcceleration().unmodify(id);
        stats.getAcceleration().unmodify(id);
        stats.getDeceleration().unmodify(id);
        Global.getCombatEngine().getTimeMult().unmodify(id);
        stats.getTimeMult().unmodify(id);
        ship.setPhased(false);
        ship.setExtraAlphaMult(1.0f);
    }

    private void maintainStatus(ShipAPI playerShip) {
        ShipSystemAPI cloak = playerShip.getPhaseCloak();
        if (cloak == null) {
            cloak = playerShip.getSystem();
        }
        if (cloak == null) {
            return;
        }
        Global.getCombatEngine().maintainStatusForPlayerShip(this.STATUSKEY2, cloak.getSpecAPI().getIconSpriteName(), cloak.getDisplayName(), "\u65f6\u95f4\u6d41\u901f\u6539\u53d8", false);
    }
}

