/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import java.awt.Color;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class SWP_ChronoBoostStats
extends BaseShipSystemScript {
    public static final float DAM_MULT = 0.1f;
    public static final Color JITTER_COLOR = new Color(165, 90, 255, 10);
    public static final Color JITTER_UNDER_COLOR = new Color(165, 90, 255, 200);
    public static final float MAX_TIME_MULT = 3.0f;
    public static final float MIN_TIME_MULT = 0.1f;
    private float totalDurationWarped = 0.0f;
    private boolean warping = false;
    protected Object STATUSKEY1 = new Object();

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        float shipTimeMult;
        String actualId = id;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ShipAPI ship = (ShipAPI)stats.getEntity();
        boolean player = ship == Global.getCombatEngine().getPlayerShip();
        actualId = actualId + "_" + ship.getId();
        if (player) {
            this.maintainStatus(ship);
        }
        float jitterLevel = effectLevel;
        float jitterRangeBonus = 0.0f;
        float maxRangeBonus = 10.0f;
        if (state == ShipSystemStatsScript.State.IN) {
            jitterLevel = effectLevel / (1.0f / ship.getSystem().getChargeUpDur());
            if (jitterLevel > 1.0f) {
                jitterLevel = 1.0f;
            }
            jitterRangeBonus = jitterLevel * maxRangeBonus;
        } else if (state == ShipSystemStatsScript.State.ACTIVE) {
            jitterLevel = 1.0f;
            jitterRangeBonus = maxRangeBonus;
        } else if (state == ShipSystemStatsScript.State.OUT) {
            jitterRangeBonus = jitterLevel * maxRangeBonus;
        }
        jitterLevel = (float)Math.sqrt(jitterLevel);
        ship.setJitter((Object)this, JITTER_COLOR, jitterLevel, 3, 0.0f, 0.0f + jitterRangeBonus);
        ship.setJitterUnder((Object)this, JITTER_UNDER_COLOR, jitterLevel, 25, 0.0f, 7.0f + jitterRangeBonus);
        if (!ship.isPhased()) {
            shipTimeMult = 1.0f + 2.0f * effectLevel;
            ship.getMutableStats().getCRLossPerSecondPercent().unmodify(actualId);
            this.warping = false;
        } else {
            shipTimeMult = 33.333332f;
            this.totalDurationWarped += Global.getCombatEngine().getElapsedInLastFrame();
            if (ship.getTimeDeployedForCRReduction() >= ship.getHullSpec().getNoCRLossTime()) {
                ship.getMutableStats().getCRLossPerSecondPercent().modifyMult(actualId, 3.0f);
            }
            ship.getMutableStats().getPeakCRDuration().modifyFlat(actualId, -this.totalDurationWarped * 2.0f / ship.getMutableStats().getPeakCRDuration().getMult());
            if (!this.warping) {
                if (!player) {
                    Global.getSoundPlayer().playSound("swp_chrono_boost_warp", 1.0f, 1.15f, ship.getLocation(), new Vector2f());
                }
                this.warping = true;
            }
        }
        stats.getTimeMult().modifyMult(actualId, shipTimeMult);
        if (player) {
            Global.getCombatEngine().getTimeMult().modifyMult(actualId, 1.0f / shipTimeMult);
        } else {
            Global.getCombatEngine().getTimeMult().unmodify(actualId);
        }
        ship.getEngineController().fadeToOtherColor((Object)this, JITTER_COLOR, new Color(0, 0, 0, 0), effectLevel, 0.5f);
        ship.getEngineController().extendFlame((Object)this, -0.25f, -0.25f, -0.25f);
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        String actualId = id;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ShipAPI ship = (ShipAPI)stats.getEntity();
        actualId = actualId + "_" + ship.getId();
        Global.getCombatEngine().getTimeMult().unmodify(actualId);
        stats.getTimeMult().unmodify(actualId);
        stats.getCRLossPerSecondPercent().unmodify(actualId);
    }

    private void maintainStatus(ShipAPI playerShip) {
        ShipSystemAPI system = playerShip.getSystem();
        if (system == null) {
            return;
        }
        String title = system.getDisplayName();
        String display = "\u65f6\u95f4\u6d41\u901f\u6539\u53d8";
        if (playerShip.isPhased()) {
            int index;
            while (Math.random() < 0.5) {
                index = MathUtils.getRandomNumberInRange((int)0, (int)(title.length() - 1));
                if (index == 0) {
                    title = (char)(MathUtils.getRandom().nextInt(26) + 97) + title.substring(index + 1);
                    continue;
                }
                if (index == title.length() - 1) {
                    title = title.substring(0, index) + (char)(MathUtils.getRandom().nextInt(26) + 97);
                    continue;
                }
                title = title.substring(0, index) + (char)(MathUtils.getRandom().nextInt(26) + 97) + title.substring(index + 1);
            }
            while (Math.random() < 0.5) {
                index = MathUtils.getRandomNumberInRange((int)0, (int)(display.length() - 1));
                if (index == 0) {
                    display = (char)(MathUtils.getRandom().nextInt(26) + 97) + display.substring(index + 1);
                    continue;
                }
                if (index == display.length() - 1) {
                    display = display.substring(0, index) + (char)(MathUtils.getRandom().nextInt(26) + 97);
                    continue;
                }
                display = display.substring(0, index) + (char)(MathUtils.getRandom().nextInt(26) + 97) + display.substring(index + 1);
            }
        }
        Global.getCombatEngine().maintainStatusForPlayerShip(this.STATUSKEY1, system.getSpecAPI().getIconSpriteName(), title, display, false);
    }
}

