/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.impl.combat.PhaseCloakStats;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import java.awt.Color;

public class SWP_BossCloakStats
extends PhaseCloakStats {
    private static final Color JITTER_COLOR = new Color(255, 0, 100, 255);
    private static final float MAX_TIME_MULT = 4.0f;
    protected Object JITTERKEY1 = new Object();
    protected Object JITTERKEY2 = new Object();

    public static float getMaxTimeMult(MutableShipStatsAPI stats) {
        return 1.0f + 3.0f * stats.getDynamic().getValue("phase_time_mult");
    }

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        String actualId = id;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ShipAPI ship = (ShipAPI)stats.getEntity();
        boolean player = ship == Global.getCombatEngine().getPlayerShip();
        actualId = actualId + "_" + ship.getId();
        if (player) {
            this.maintainStatus(ship, effectLevel);
        }
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        if (state == ShipSystemStatsScript.State.COOLDOWN || state == ShipSystemStatsScript.State.IDLE) {
            this.unapply(stats, actualId);
            return;
        }
        float level = effectLevel;
        float jitterRangeBonus = 0.0f;
        float levelForAlpha = level;
        stats.getMaxSpeed().modifyFlat(actualId, 25.0f * effectLevel);
        stats.getMaxSpeed().modifyPercent(actualId, 25.0f * effectLevel);
        stats.getAcceleration().modifyFlat(actualId, 25.0f * effectLevel);
        stats.getAcceleration().modifyPercent(actualId, 100.0f * effectLevel);
        stats.getDeceleration().modifyFlat(actualId, 10.0f * effectLevel);
        stats.getDeceleration().modifyPercent(actualId, 40.0f * effectLevel);
        stats.getTurnAcceleration().modifyFlat(actualId, 25.0f * effectLevel);
        stats.getTurnAcceleration().modifyPercent(actualId, 50.0f * effectLevel);
        stats.getMaxTurnRate().modifyFlat(actualId, 25.0f * effectLevel);
        stats.getMaxTurnRate().modifyPercent(actualId, 50.0f * effectLevel);
        ship.setPhased(true);
        ship.setJitter(this.JITTERKEY1, JITTER_COLOR, level * 0.5f, 1, 0.0f, 0.0f + jitterRangeBonus);
        ship.setJitterUnder(this.JITTERKEY2, JITTER_COLOR, level * 0.5f, 11, 0.0f, 7.0f + jitterRangeBonus);
        ship.setExtraAlphaMult(1.0f - 0.75f * levelForAlpha);
        ship.setApplyExtraAlphaToEngines(true);
        float shipTimeMult = 1.0f + (SWP_BossCloakStats.getMaxTimeMult(stats) - 1.0f) * levelForAlpha;
        stats.getTimeMult().modifyMult(actualId, shipTimeMult);
        if (player) {
            Global.getCombatEngine().getTimeMult().modifyMult(actualId, 1.0f / shipTimeMult);
        } else {
            Global.getCombatEngine().getTimeMult().unmodify(actualId);
        }
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ShipAPI ship = (ShipAPI)stats.getEntity();
        Global.getCombatEngine().getTimeMult().unmodify(id);
        stats.getTimeMult().unmodify(id);
        ship.setPhased(false);
        ship.setExtraAlphaMult(1.0f);
        stats.getMaxSpeed().unmodify(id);
        stats.getMaxTurnRate().unmodify(id);
        stats.getTurnAcceleration().unmodify(id);
        stats.getAcceleration().unmodify(id);
        stats.getDeceleration().unmodify(id);
    }

    private void maintainStatus(ShipAPI playerShip, float effectLevel) {
        float level = effectLevel;
        float f = 0.0f;
        ShipSystemAPI cloak = playerShip.getPhaseCloak();
        if (cloak == null) {
            cloak = playerShip.getSystem();
        }
        if (cloak == null) {
            return;
        }
        if (level > f) {
            Global.getCombatEngine().maintainStatusForPlayerShip(this.STATUSKEY2, cloak.getSpecAPI().getIconSpriteName(), cloak.getDisplayName(), "\u65f6\u95f4\u6d41\u901f\u6539\u53d8", false);
        }
    }
}

