/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shipsystems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.impl.combat.AcausalDisruptorStats;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;

public class SWP_AcausalDisruptorStats
extends AcausalDisruptorStats {
    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ShipAPI ship = (ShipAPI)stats.getEntity();
        stats.getEnergyWeaponDamageMult().modifyMult(id, 0.5f);
        float jitterLevel = effectLevel;
        if (state == ShipSystemStatsScript.State.OUT) {
            jitterLevel *= jitterLevel;
        }
        float maxRangeBonus = 50.0f;
        float jitterRangeBonus = jitterLevel * maxRangeBonus;
        ship.setJitterUnder((Object)this, JITTER_UNDER_COLOR, jitterLevel, 21, 0.0f, 3.0f + jitterRangeBonus);
        ship.setJitter((Object)this, JITTER_COLOR, jitterLevel, 4, 0.0f, 0.0f + jitterRangeBonus);
        String targetKey = ship.getId() + "_acausal_target";
        Object foundTarget = Global.getCombatEngine().getCustomData().get(targetKey);
        if (state == ShipSystemStatsScript.State.IN) {
            ShipAPI target;
            for (WeaponAPI weapon : ship.getAllWeapons()) {
                if (weapon.getType() != WeaponAPI.WeaponType.MISSILE || !(weapon.getCooldownRemaining() < 1.0f)) continue;
                weapon.setRemainingCooldownTo(1.0f);
            }
            if (foundTarget == null && (target = this.findTarget(ship)) != null) {
                Global.getCombatEngine().getCustomData().put(targetKey, target);
                float baseCapacity = ship.getMutableStats().getFluxCapacity().getBaseValue();
                if (target.isDestroyer()) {
                    ship.getSystem().setFluxPerSecond(baseCapacity * 0.15f);
                }
                if (target.isCruiser()) {
                    ship.getSystem().setFluxPerSecond(baseCapacity * 0.3f);
                }
                if (target.isCapital()) {
                    ship.getSystem().setFluxPerSecond(baseCapacity * 0.45f);
                }
            }
        } else if (effectLevel >= 1.0f) {
            ship.getSystem().setFluxPerSecond(0.0f);
            if (foundTarget instanceof ShipAPI) {
                ShipAPI target = (ShipAPI)foundTarget;
                if (target.getFluxTracker().isOverloadedOrVenting()) {
                    target = ship;
                }
                this.applyEffectToTarget(ship, target);
            }
        } else if (state == ShipSystemStatsScript.State.OUT && foundTarget != null) {
            Global.getCombatEngine().getCustomData().remove(targetKey);
        }
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        float percent = 50.0f;
        if (index == 0) {
            return new ShipSystemStatsScript.StatusData((int)percent + "% \u7684\u80fd\u91cf\u4f24\u5bb3\u964d\u4f4e", true);
        }
        if (index == 1) {
            return new ShipSystemStatsScript.StatusData("\u5bfc\u5f39\u7cfb\u7edf\u4e2d\u65ad", true);
        }
        return null;
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        if (stats.getEntity() instanceof ShipAPI) {
            ShipAPI ship = (ShipAPI)stats.getEntity();
            ship.getSystem().setFluxPerSecond(0.0f);
        }
        stats.getEnergyWeaponDamageMult().unmodify(id);
    }
}

