/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.shaders;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.dark.shaders.util.ShaderAPI;
import org.dark.shaders.util.ShaderLib;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;

public class SWP_OmegaDriveShader
implements ShaderAPI {
    private static boolean active = false;
    private static float degree = 1.0f;
    private boolean enabled = false;
    private final int[] index = new int[3];
    private int program = 0;
    private boolean validated = false;

    public static void setActive(boolean nowActive, float newDegree) {
        active = nowActive;
        degree = newDegree;
    }

    public SWP_OmegaDriveShader() {
        String fragShader;
        String vertShader;
        if (!ShaderLib.areShadersAllowed()) {
            return;
        }
        try {
            vertShader = Global.getSettings().loadText("data/shaders/omega/omega.vert");
            fragShader = Global.getSettings().loadText("data/shaders/omega/omega.frag");
        }
        catch (IOException ex) {
            return;
        }
        this.program = ShaderLib.loadShader((String)vertShader, (String)fragShader);
        if (this.program == 0) {
            return;
        }
        GL20.glUseProgram((int)this.program);
        this.index[0] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"tex");
        this.index[1] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"degree");
        this.index[2] = GL20.glGetUniformLocation((int)this.program, (CharSequence)"time");
        GL20.glUniform1i((int)this.index[0], (int)0);
        GL20.glUseProgram((int)0);
        this.enabled = true;
    }

    public void advance(float amount, List<InputEventAPI> events) {
    }

    public void destroy() {
        if (this.program != 0) {
            ByteBuffer countbb = ByteBuffer.allocateDirect(4);
            ByteBuffer shadersbb = ByteBuffer.allocateDirect(8);
            IntBuffer count = countbb.asIntBuffer();
            IntBuffer shaders = shadersbb.asIntBuffer();
            GL20.glGetAttachedShaders((int)this.program, (IntBuffer)count, (IntBuffer)shaders);
            for (int i = 0; i < 2; ++i) {
                GL20.glDeleteShader((int)shaders.get());
            }
            GL20.glDeleteProgram((int)this.program);
        }
    }

    public ShaderAPI.RenderOrder getRenderOrder() {
        return ShaderAPI.RenderOrder.SCREEN_SPACE;
    }

    public void initCombat() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void renderInScreenCoords(ViewportAPI viewport) {
    }

    public void renderInWorldCoords(ViewportAPI viewport) {
        if (!this.enabled) {
            return;
        }
        if (!active) {
            return;
        }
        this.draw();
    }

    private void draw() {
        ShaderLib.beginDraw((int)this.program);
        GL20.glUniform1f((int)this.index[1], (float)degree);
        GL20.glUniform1f((int)this.index[2], (float)Global.getCombatEngine().getTotalElapsedTime(true));
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)ShaderLib.getScreenTexture());
        if (!this.validated) {
            this.validated = true;
            GL20.glValidateProgram((int)this.program);
            if (GL20.glGetProgrami((int)this.program, (int)35715) == 0) {
                Global.getLogger(ShaderLib.class).log((Priority)Level.ERROR, (Object)ShaderLib.getProgramLogInfo((int)this.program));
                ShaderLib.exitDraw();
                this.enabled = false;
                return;
            }
        }
        GL11.glDisable((int)3042);
        ShaderLib.screenDraw((int)ShaderLib.getScreenTexture(), (int)33984);
        ShaderLib.exitDraw();
    }
}

