/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;

public class SWP_SupplyConservationProgram
extends BaseHullMod {
    public static final float CREW_MULT = 0.5f;
    public static final float CR_PEAK_PENALTY = 50.0f;
    public static final float CR_PENALTY = 100.0f;
    public static final float LOGISTICS_BONUS = 50.0f;

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getMinCrewMod().modifyMult(id, 0.5f);
        stats.getSuppliesPerMonth().modifyMult(id, 0.5f);
        stats.getPeakCRDuration().modifyMult(id, 0.5f);
        stats.getCRLossPerSecondPercent().modifyPercent(id, 100.0f);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "\u4e00\u534a";
        }
        if (index == 1) {
            return "\u4e00\u534a";
        }
        if (index == 2) {
            return "\u4e00\u534a";
        }
        if (index == 3) {
            return "\u4e24\u500d";
        }
        return null;
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (ship.getHullSpec().getNoCRLossTime() >= 10000.0f || ship.getHullSpec().getCRLossPerSecond() <= 0.0f) {
            return "\u8230\u8239\u5df2\u7ecf\u8fc7\u4e8e\u9ad8\u6548\u4e86";
        }
        if (ship.getVariant().hasHullMod("civgrade")) {
            return "\u4e0d\u80fd\u88ab\u5b89\u88c5\u5728\u6c11\u7528\u8239\u4e0a";
        }
        if (ship.getVariant().hasHullMod("automated")) {
            return "\u4e0d\u80fd\u5b89\u88c5\u5728\u5168\u81ea\u52a8\u8230\u8239\u4e0a";
        }
        if (ship.getVariant().hasHullMod("maximized_ordinance")) {
            return "\u4e0e\u6781\u9650\u88c5\u914d\u4e0d\u517c\u5bb9";
        }
        return null;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return ship != null && !ship.getVariant().getHullMods().contains("civgrade") && !ship.getVariant().getHullMods().contains("automated") && (ship.getHullSpec().getNoCRLossTime() < 10000.0f || ship.getHullSpec().getCRLossPerSecond() > 0.0f) && !ship.getVariant().getHullMods().contains("maximized_ordinance");
    }
}

