/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.everyframe.SWP_BlockedHullmodDisplayScript;
import data.scripts.util.SWP_Util;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SWP_ShieldBypass
extends BaseHullMod {
    public static final float FLUX_BONUS = 50.0f;
    private static final Set<String> BLOCKED_HULLMODS = new HashSet<String>(7);

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        Collection<String> builtIn = SWP_Util.getBuiltInHullMods(ship);
        for (String tmp : BLOCKED_HULLMODS) {
            if (!ship.getVariant().getHullMods().contains(tmp) || builtIn.contains(tmp)) continue;
            ship.getVariant().removeMod(tmp);
            SWP_BlockedHullmodDisplayScript.showBlocked(ship);
        }
        ship.setShield(ShieldAPI.ShieldType.NONE, 0.0f, 0.0f, 90.0f);
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getShieldDamageTakenMult().modifyMult(id, 0.0f);
        stats.getShieldUpkeepMult().modifyMult(id, 0.0f);
        stats.getFluxDissipation().modifyPercent(id, 50.0f);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "50";
        }
        return null;
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (ship == null || ship.getShield() == null) {
            return "\u8be5\u8230\u8239\u6ca1\u6709\u5b89\u88c5\u62a4\u76fe";
        }
        Collection<String> builtIn = SWP_Util.getBuiltInHullMods(ship);
        if (ship.getVariant().hasHullMod("frontshield")) {
            return "\u4e0e\u5b9a\u5411\u62a4\u76fe\u751f\u6210\u5668\u51b2\u7a81";
        }
        if (ship.getVariant().hasHullMod("frontemitter") && !builtIn.contains("frontemitter")) {
            return "\u4e0e\u56fa\u5316\u62a4\u76fe\u53d1\u751f\u5668\u51b2\u7a81";
        }
        if (ship.getVariant().hasHullMod("adaptiveshields") && !builtIn.contains("adaptiveshields")) {
            return "\u4e0e\u5168\u89d2\u62a4\u76fe\u53d1\u751f\u5668\u51b2\u7a81";
        }
        if (ship.getVariant().hasHullMod("stabilizedshieldemitter") && !builtIn.contains("stabilizedshieldemitter")) {
            return "\u4e0e\u7a33\u5b9a\u62a4\u76fe\u51b2\u7a81";
        }
        if (ship.getVariant().hasHullMod("hardenedshieldemitter") && !builtIn.contains("hardenedshieldemitter")) {
            return "\u4e0e\u5f3a\u5316\u62a4\u76fe\u51b2\u7a81";
        }
        if (ship.getVariant().hasHullMod("advancedshieldemitter") && !builtIn.contains("advancedshieldemitter")) {
            return "\u4e0e\u654f\u6377\u62a4\u76fe\u51b2\u7a81";
        }
        if (ship.getVariant().hasHullMod("extendedshieldemitter") && !builtIn.contains("extendedshieldemitter")) {
            return "\u4e0e\u6269\u5c55\u62a4\u76fe\u51b2\u7a81";
        }
        return null;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        Collection<String> builtIn = SWP_Util.getBuiltInHullMods(ship);
        return !(ship == null || ship.getHullSpec().getDefenseType() != ShieldAPI.ShieldType.FRONT && ship.getHullSpec().getDefenseType() != ShieldAPI.ShieldType.OMNI || ship.getHullSpec().getDefenseType() == ShieldAPI.ShieldType.NONE || ship.getVariant().getHullMods().contains("frontshield") || ship.getVariant().getHullMods().contains("frontemitter") && !builtIn.contains("frontemitter") || ship.getVariant().getHullMods().contains("adaptiveshields") && !builtIn.contains("adaptiveshields") || ship.getVariant().getHullMods().contains("stabilizedshieldemitter") && !builtIn.contains("stabilizedshieldemitter") || ship.getVariant().getHullMods().contains("hardenedshieldemitter") && !builtIn.contains("hardenedshieldemitter") || ship.getVariant().getHullMods().contains("advancedshieldemitter") && !builtIn.contains("advancedshieldemitter") || ship.getVariant().getHullMods().contains("extendedshieldemitter") && !builtIn.contains("extendedshieldemitter"));
    }

    static {
        BLOCKED_HULLMODS.add("frontshield");
        BLOCKED_HULLMODS.add("frontemitter");
        BLOCKED_HULLMODS.add("adaptiveshields");
        BLOCKED_HULLMODS.add("stabilizedshieldemitter");
        BLOCKED_HULLMODS.add("hardenedshieldemitter");
        BLOCKED_HULLMODS.add("advancedshieldemitter");
        BLOCKED_HULLMODS.add("extendedshieldemitter");
    }
}

