/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.hullmods;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.characters.MutableCharacterStatsAPI;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class SWP_MaximizedOrdinance
extends BaseHullMod {
    private static final float ENGINE_MALFUNCTION_PROB = 0.025f;
    private static final float WEAPON_MALFUNCTION_PROB = 0.025f;
    private static BlackMagic magic = null;

    public static void addMember(FleetMemberAPI member) {
        if (magic == null || SWP_MaximizedOrdinance.magic.isDone()) {
            magic = new BlackMagic();
            Thread magicThread = new Thread(magic);
            magicThread.start();
        }
        SWP_MaximizedOrdinance.magic.addMember(member);
    }

    public static void addShip(ShipAPI ship) {
        if (magic == null || SWP_MaximizedOrdinance.magic.isDone()) {
            magic = new BlackMagic();
            Thread magicThread = new Thread(magic);
            magicThread.start();
        }
        SWP_MaximizedOrdinance.magic.addShip(ship);
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getWeaponMalfunctionChance().modifyFlat(id, 0.025f);
        stats.getEngineMalfunctionChance().modifyFlat(id, 0.025f);
        ShipAPI ship = (ShipAPI)stats.getEntity();
        if (ship == null) {
            return;
        }
        SectorAPI sector = Global.getSector();
        if (sector != null) {
            CampaignFleetAPI player = Global.getSector().getPlayerFleet();
            if (player != null) {
                for (FleetMemberAPI member : player.getFleetData().getMembersListCopy()) {
                    if (member.getId() == null || ship.getFleetMemberId() == null || !member.getId().contentEquals(ship.getFleetMemberId())) continue;
                    SWP_MaximizedOrdinance.addMember(member);
                    return;
                }
                SWP_MaximizedOrdinance.addShip(ship);
            } else {
                SWP_MaximizedOrdinance.addShip(ship);
            }
        } else {
            SWP_MaximizedOrdinance.addShip(ship);
        }
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        return null;
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (ship.getVariant().hasHullMod("civgrade")) {
            return "\u4e0d\u80fd\u88ab\u5b89\u88c5\u5728\u6c11\u7528\u8239\u4e0a";
        }
        if (ship.getVariant().hasHullMod("supply_conservation_program")) {
            return "\u4e0e\u540e\u52e4\u4fdd\u969c\u51b2\u7a81";
        }
        return null;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return ship != null && !ship.getVariant().getHullMods().contains("civgrade") && !ship.getVariant().getHullMods().contains("supply_conservation_program");
    }

    public static final class BlackMagic
    implements Runnable {
        private boolean done = false;
        private final Set<WeakReference<FleetMemberAPI>> members = new LinkedHashSet<WeakReference<FleetMemberAPI>>(5);
        private final Set<WeakReference<ShipAPI>> ships = new LinkedHashSet<WeakReference<ShipAPI>>(5);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                Object player;
                SectorAPI sector = Global.getSector();
                MutableCharacterStatsAPI stats = null;
                if (sector != null && (player = sector.getPlayerPerson()) != null) {
                    stats = player.getStats();
                }
                player = this;
                synchronized (player) {
                    Iterator<WeakReference<ShipAPI>> iter = this.ships.iterator();
                    while (iter.hasNext()) {
                        WeakReference<ShipAPI> reference = iter.next();
                        ShipAPI ship = (ShipAPI)reference.get();
                        if (ship == null) {
                            iter.remove();
                            continue;
                        }
                        if (ship.getVariant().hasHullMod("maximized_ordinance")) continue;
                        if (ship.getVariant().computeOPCost(stats) > ship.getHullSpec().getOrdnancePoints(stats)) {
                            ship.getVariant().addMod("maximized_ordinance");
                            continue;
                        }
                        if (sector == null || sector.isPaused()) continue;
                        iter.remove();
                    }
                    Iterator<WeakReference<FleetMemberAPI>> iter2 = this.members.iterator();
                    while (iter2.hasNext()) {
                        WeakReference<FleetMemberAPI> reference = iter2.next();
                        FleetMemberAPI member = (FleetMemberAPI)reference.get();
                        if (member == null) {
                            iter2.remove();
                            continue;
                        }
                        if (member.getVariant().hasHullMod("maximized_ordinance")) continue;
                        if (member.getVariant().computeOPCost(stats) > member.getHullSpec().getOrdnancePoints(stats)) {
                            member.getVariant().addMod("maximized_ordinance");
                            continue;
                        }
                        if (sector == null || sector.isPaused()) continue;
                        iter2.remove();
                    }
                    if (this.ships.isEmpty() && this.members.isEmpty()) {
                        break;
                    }
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
            this.done = true;
        }

        private synchronized void addMember(FleetMemberAPI member) {
            this.members.add(new WeakReference<FleetMemberAPI>(member));
        }

        private synchronized void addShip(ShipAPI ship) {
            this.ships.add(new WeakReference<ShipAPI>(ship));
        }

        private boolean isDone() {
            return this.done;
        }
    }
}

