/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipEngineControllerAPI;
import java.util.List;

public class SWP_LinkedHull
extends BaseHullMod {
    private static void advanceChild(ShipAPI child, ShipAPI parent) {
        ShipEngineControllerAPI ec = parent.getEngineController();
        if (ec != null) {
            ShipEngineControllerAPI cec;
            if (parent.isAlive()) {
                if (ec.isAccelerating()) {
                    child.giveCommand(ShipCommand.ACCELERATE, null, 0);
                }
                if (ec.isAcceleratingBackwards()) {
                    child.giveCommand(ShipCommand.ACCELERATE_BACKWARDS, null, 0);
                }
                if (ec.isDecelerating()) {
                    child.giveCommand(ShipCommand.DECELERATE, null, 0);
                }
                if (ec.isStrafingLeft()) {
                    child.giveCommand(ShipCommand.STRAFE_LEFT, null, 0);
                }
                if (ec.isStrafingRight()) {
                    child.giveCommand(ShipCommand.STRAFE_RIGHT, null, 0);
                }
                if (ec.isTurningLeft()) {
                    child.giveCommand(ShipCommand.TURN_LEFT, null, 0);
                }
                if (ec.isTurningRight()) {
                    child.giveCommand(ShipCommand.TURN_RIGHT, null, 0);
                }
            }
            if ((cec = child.getEngineController()) != null && (ec.isFlamingOut() || ec.isFlamedOut()) && !cec.isFlamingOut() && !cec.isFlamedOut()) {
                child.getEngineController().forceFlameout(true);
            }
        }
        if (parent.isHulk() && parent.getHullSpec().getBaseHullId().contentEquals("swp_wall")) {
            child.setParentStation(null);
            child.setStationSlot(null);
        }
    }

    private static void advanceParent(ShipAPI parent, List<ShipAPI> children) {
        ShipEngineControllerAPI ec = parent.getEngineController();
        if (ec != null) {
            int originalEngines;
            float originalMass;
            switch (parent.getHullSpec().getBaseHullId()) {
                default: {
                    originalMass = 5500.0f;
                    originalEngines = 19;
                    break;
                }
                case "swp_boss_sporeship": {
                    originalMass = 14700.0f;
                    originalEngines = 21;
                }
            }
            float thrustPerEngine = originalMass / (float)originalEngines;
            int zeroFluxBoost = ec.getShipEngines().size();
            float workingEngines = ec.getShipEngines().size();
            int currentEngines = ec.getShipEngines().size();
            for (ShipAPI child : children) {
                ShipEngineControllerAPI cec;
                if (child.getParentStation() != parent || child.getStationSlot() == null || !child.isAlive() || (cec = child.getEngineController()) == null) continue;
                if (child.getFluxTracker().isEngineBoostActive()) {
                    zeroFluxBoost += cec.getShipEngines().size();
                }
                workingEngines += (float)cec.getShipEngines().size() * (1.0f - cec.computeDisabledFraction());
                currentEngines += cec.getShipEngines().size();
            }
            float thrust = workingEngines * thrustPerEngine;
            float enginePerformance = thrust / Math.max(1.0f, parent.getMassWithModules());
            float zeroFluxPercentage = (float)zeroFluxBoost / Math.max(1.0f, (float)currentEngines);
            parent.getMutableStats().getAcceleration().modifyMult("swp_linkedhull", enginePerformance);
            parent.getMutableStats().getDeceleration().modifyMult("swp_linkedhull", enginePerformance);
            parent.getMutableStats().getTurnAcceleration().modifyMult("swp_linkedhull", enginePerformance);
            parent.getMutableStats().getMaxTurnRate().modifyMult("swp_linkedhull", enginePerformance);
            parent.getMutableStats().getMaxSpeed().modifyMult("swp_linkedhull", enginePerformance);
            parent.getMutableStats().getZeroFluxSpeedBoost().modifyMult("swp_linkedhull", zeroFluxPercentage);
        }
    }

    public void advanceInCombat(ShipAPI ship, float amount) {
        List children;
        ShipAPI parent = ship.getParentStation();
        if (parent != null) {
            SWP_LinkedHull.advanceChild(ship, parent);
        }
        if ((children = ship.getChildModulesCopy()) != null && !children.isEmpty()) {
            SWP_LinkedHull.advanceParent(ship, children);
        }
    }
}

