/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.hullmods;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.util.SWP_Multi;
import data.scripts.util.SWP_Util;
import java.awt.Color;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lazywizard.lazylib.combat.entities.AnchoredEntity;
import org.lwjgl.util.vector.Vector2f;

public class SWP_ExcelsiorReactor
extends BaseHullMod {
    public static final float BEAM_DAMAGE_REDUCTION = 50.0f;
    public static final float EMP_DAMAGE_REDUCTION = 50.0f;
    public static final float OVERLOAD_MULT = 50.0f;
    public static final float VENT_BONUS = 200.0f;
    private final IntervalUtil interval = new IntervalUtil(0.1f, 0.1f);

    public void advanceInCombat(ShipAPI ship, float amount) {
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        this.interval.advance(amount);
        if (ship.getFluxTracker().isOverloaded()) {
            if (this.interval.intervalElapsed() && Math.random() < 0.2) {
                float shipRadius = SWP_Util.effectiveRadius(ship);
                Global.getCombatEngine().spawnEmpArc(ship, MathUtils.getRandomPointOnCircumference((Vector2f)ship.getLocation(), (float)(shipRadius * ((float)Math.random() + 1.0f))), (CombatEntityAPI)ship, (CombatEntityAPI)ship, DamageType.ENERGY, 100.0f, 100.0f, 500.0f, null, 15.0f, new Color(255, 150, 200), new Color(255, 150, 255));
            }
        } else if (ship.getFluxTracker().isVenting() && this.interval.intervalElapsed()) {
            float scale = ship.getMutableStats().getVentRateMult().getModifiedValue() * 2.0f / 3.0f * ship.getMutableStats().getFluxDissipation().getModifiedValue() / 50.0f;
            if (Math.random() < 0.3 * Math.sqrt(scale)) {
                float range = (float)Math.sqrt(ship.getFluxTracker().getCurrFlux()) * (float)Math.sqrt(scale) * 4.0f;
                List targets = AIUtils.getNearbyEnemies((CombatEntityAPI)ship, (float)range);
                if (targets.size() > 0) {
                    ShipAPI target = (ShipAPI)targets.get(MathUtils.getRandom().nextInt(targets.size()));
                    if (SWP_Multi.isWithinEmpRange(ship.getLocation(), range * 1.25f, target)) {
                        Global.getCombatEngine().spawnEmpArc(ship, MathUtils.getRandomPointOnCircumference((Vector2f)ship.getLocation(), (float)30.0f), (CombatEntityAPI)ship, (CombatEntityAPI)target, DamageType.ENERGY, 70.0f * scale, 70.0f * scale, range * 1.25f, "swp_excelsior_vent", 5.0f * scale, new Color(255, 50, 150), new Color(255, 100, 200));
                    }
                } else {
                    AnchoredEntity entity = new AnchoredEntity((CombatEntityAPI)ship, MathUtils.getRandomPointOnCircumference((Vector2f)ship.getLocation(), (float)30.0f));
                    Global.getCombatEngine().spawnEmpArc(ship, MathUtils.getRandomPointOnCircumference((Vector2f)ship.getLocation(), (float)range), (CombatEntityAPI)entity, (CombatEntityAPI)entity, DamageType.ENERGY, 0.0f, 0.0f, range * 2.0f, null, 5.0f * scale, new Color(255, 50, 150), new Color(255, 100, 200));
                }
            }
        }
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getOverloadTimeMod().modifyMult(id, 0.5f);
        stats.getVentRateMult().modifyPercent(id, 200.0f);
        stats.getEmpDamageTakenMult().modifyPercent(id, -50.0f);
        stats.getBeamDamageTakenMult().modifyPercent(id, -50.0f);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "50";
        }
        if (index == 1) {
            return "200";
        }
        if (index == 2) {
            return "50";
        }
        if (index == 3) {
            return "50";
        }
        return null;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return false;
    }
}

