/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import data.scripts.everyframe.SWP_BlockedHullmodDisplayScript;
import java.util.HashSet;
import java.util.Set;

public class SWP_AdditionalCrewQuarters
extends BaseHullMod {
    public static final float MAXCREW_BONUS0 = 20.0f;
    public static final float MAXCREW_BONUS1 = 40.0f;
    public static final float MAXCREW_BONUS2 = 60.0f;
    public static final float MAXCREW_BONUS3 = 100.0f;
    private static final Set<String> BLOCKED_HULLMODS = new HashSet<String>(1);

    public void applyEffectsAfterShipCreation(ShipAPI ship, String id) {
        for (String tmp : BLOCKED_HULLMODS) {
            if (!ship.getVariant().getHullMods().contains(tmp)) continue;
            ship.getVariant().removeMod(tmp);
            SWP_BlockedHullmodDisplayScript.showBlocked(ship);
        }
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        if (hullSize == ShipAPI.HullSize.FRIGATE) {
            stats.getMaxCrewMod().modifyFlat(id, 20.0f);
        }
        if (hullSize == ShipAPI.HullSize.DESTROYER) {
            stats.getMaxCrewMod().modifyFlat(id, 40.0f);
        }
        if (hullSize == ShipAPI.HullSize.CRUISER) {
            stats.getMaxCrewMod().modifyFlat(id, 60.0f);
        }
        if (hullSize == ShipAPI.HullSize.CAPITAL_SHIP) {
            stats.getMaxCrewMod().modifyFlat(id, 100.0f);
        }
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "20";
        }
        if (index == 1) {
            return "40";
        }
        if (index == 2) {
            return "60";
        }
        if (index == 3) {
            return "100";
        }
        return null;
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (ship.getVariant().hasHullMod("diableavionics_cramped")) {
            return "\u4e0d\u80fd\u5b89\u88c5\u5728\u72ed\u7a84\u8239\u4f53\u4e0a";
        }
        if (ship.getVariant().hasHullMod("ilk_AICrew")) {
            return "\u4e0e\u9ad8\u7ea7\u4eba\u5de5\u667a\u80fd\u51b2\u7a81";
        }
        if (ship.getVariant().hasHullMod("cargo_expansion")) {
            return "\u4e0e\u6269\u5c55\u8d27\u8231\u51b2\u7a81";
        }
        if (ship.getVariant().hasHullMod("fuel_expansion")) {
            return "\u4e0e\u6269\u5c55\u71c3\u6cb9\u7f50\u51b2\u7a81";
        }
        if (ship.getVariant().hasHullMod("automated")) {
            return "\u4e0d\u80fd\u5b89\u88c5\u5728\u5168\u81ea\u52a8\u8230\u8239\u4e0a";
        }
        return null;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return ship != null && !ship.getVariant().getHullMods().contains("ilk_AICrew") && !ship.getVariant().getHullMods().contains("cargo_expansion") && !ship.getVariant().getHullMods().contains("fuel_expansion") && !ship.getVariant().getHullMods().contains("automated") && !ship.getVariant().getHullMods().contains("diableavionics_cramped");
    }

    static {
        BLOCKED_HULLMODS.add("ilk_AICrew");
    }
}

