/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.everyframe;

import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipEngineControllerAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import data.scripts.util.SWP_Util;
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dark.shaders.light.LightAPI;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SWP_SystemLightInjector
extends BaseEveryFrameCombatPlugin {
    private static final String DATA_KEY = "SWP_LightInjector";
    private static final Vector2f ZERO = new Vector2f();
    private CombatEngineAPI engine;

    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        LocalData localData = (LocalData)this.engine.getCustomData().get(DATA_KEY);
        Map<ShipAPI, StandardLight> lights = localData.lights;
        List ships = this.engine.getShips();
        int shipsSize = ships.size();
        block16: for (int i = 0; i < shipsSize; ++i) {
            String id;
            ShipAPI ship = (ShipAPI)ships.get(i);
            if (ship.isHulk()) continue;
            float shipRadius = SWP_Util.effectiveRadius(ship);
            ShipSystemAPI system = ship.getSystem();
            if (system == null) continue;
            switch (id = system.getId()) {
                case "punisherjets": {
                    StandardLight light;
                    if (!system.isActive()) continue block16;
                    Vector2f location = null;
                    if (ship.getEngineController() == null) continue block16;
                    List engines = ship.getEngineController().getShipEngines();
                    int num = 0;
                    int enginesSize = engines.size();
                    for (int j = 0; j < enginesSize; ++j) {
                        ShipEngineControllerAPI.ShipEngineAPI eng = (ShipEngineControllerAPI.ShipEngineAPI)engines.get(j);
                        if (!eng.isActive() || eng.isDisabled()) continue;
                        ++num;
                        if (location == null) {
                            location = new Vector2f((ReadableVector2f)eng.getLocation());
                            continue;
                        }
                        Vector2f.add((Vector2f)location, (Vector2f)eng.getLocation(), (Vector2f)location);
                    }
                    if (location == null) continue block16;
                    location.scale(1.0f / (float)num);
                    if (lights.containsKey(ship)) {
                        light = lights.get(ship);
                        light.setLocation(location);
                        if ((!system.isActive() || system.isOn()) && !system.isChargedown() || light.isFadingOut()) continue block16;
                        light.fadeOut(0.4f);
                        continue block16;
                    }
                    light = new StandardLight(location, ZERO, ZERO, null);
                    float intensity = (float)Math.sqrt(shipRadius) / 20.0f;
                    float size = intensity * 400.0f;
                    light.setIntensity(intensity);
                    light.setSize(size);
                    Color color = null;
                    if (!ship.getEngineController().getShipEngines().isEmpty()) {
                        color = ((ShipEngineControllerAPI.ShipEngineAPI)ship.getEngineController().getShipEngines().get(0)).getEngineColor();
                    }
                    if (color != null) {
                        light.setColor(color);
                    }
                    light.fadeIn(0.4f);
                    lights.put(ship, light);
                    LightShader.addLight((LightAPI)light);
                    continue block16;
                }
                case "victoryjets": {
                    StandardLight light;
                    if (!system.isActive()) continue block16;
                    Vector2f location = null;
                    if (ship.getEngineController() == null) continue block16;
                    List engines = ship.getEngineController().getShipEngines();
                    int num = 0;
                    int enginesSize = engines.size();
                    for (int j = 0; j < enginesSize; ++j) {
                        ShipEngineControllerAPI.ShipEngineAPI eng = (ShipEngineControllerAPI.ShipEngineAPI)engines.get(j);
                        if (!eng.isActive() || eng.isDisabled()) continue;
                        ++num;
                        if (location == null) {
                            location = new Vector2f((ReadableVector2f)eng.getLocation());
                            continue;
                        }
                        Vector2f.add((Vector2f)location, (Vector2f)eng.getLocation(), (Vector2f)location);
                    }
                    if (location == null) continue block16;
                    location.scale(1.0f / (float)num);
                    if (lights.containsKey(ship)) {
                        light = lights.get(ship);
                        light.setLocation(location);
                        if ((!system.isActive() || system.isOn()) && !system.isChargedown() || light.isFadingOut()) continue block16;
                        light.fadeOut(1.0f);
                        continue block16;
                    }
                    light = new StandardLight(location, ZERO, ZERO, null);
                    float intensity = (float)Math.sqrt(shipRadius) / 10.0f;
                    float size = intensity * 200.0f;
                    light.setIntensity(intensity);
                    light.setSize(size);
                    Color color = null;
                    if (!ship.getEngineController().getShipEngines().isEmpty()) {
                        color = ((ShipEngineControllerAPI.ShipEngineAPI)ship.getEngineController().getShipEngines().get(0)).getEngineColor();
                    }
                    if (color != null) {
                        light.setColor(color);
                    }
                    light.fadeIn(0.5f);
                    lights.put(ship, light);
                    LightShader.addLight((LightAPI)light);
                    continue block16;
                }
                case "aresdrive": {
                    StandardLight light;
                    if (!system.isActive()) continue block16;
                    Vector2f location = null;
                    if (ship.getEngineController() == null) continue block16;
                    List engines = ship.getEngineController().getShipEngines();
                    int num = 0;
                    int enginesSize = engines.size();
                    for (int j = 0; j < enginesSize; ++j) {
                        ShipEngineControllerAPI.ShipEngineAPI eng = (ShipEngineControllerAPI.ShipEngineAPI)engines.get(j);
                        if (!eng.isActive() || eng.isDisabled()) continue;
                        ++num;
                        if (location == null) {
                            location = new Vector2f((ReadableVector2f)eng.getLocation());
                            continue;
                        }
                        Vector2f.add((Vector2f)location, (Vector2f)eng.getLocation(), (Vector2f)location);
                    }
                    if (location == null) continue block16;
                    location.scale(1.0f / (float)num);
                    if (lights.containsKey(ship)) {
                        light = lights.get(ship);
                        light.setLocation(location);
                        if ((!system.isActive() || system.isOn()) && !system.isChargedown() || light.isFadingOut()) continue block16;
                        light.fadeOut(1.0f);
                        continue block16;
                    }
                    light = new StandardLight(location, ZERO, ZERO, null);
                    float intensity = (float)Math.sqrt(shipRadius) / 10.0f;
                    float size = intensity * 200.0f;
                    light.setIntensity(intensity);
                    light.setSize(size);
                    light.setColor(1.0f, 0.6f, 0.4f);
                    light.fadeIn(0.5f);
                    lights.put(ship, light);
                    LightShader.addLight((LightAPI)light);
                    continue block16;
                }
                case "nikejets": {
                    StandardLight light;
                    if (!system.isActive()) continue block16;
                    Vector2f location = null;
                    if (ship.getEngineController() == null) continue block16;
                    List engines = ship.getEngineController().getShipEngines();
                    int num = 0;
                    int enginesSize = engines.size();
                    for (int j = 0; j < enginesSize; ++j) {
                        ShipEngineControllerAPI.ShipEngineAPI eng = (ShipEngineControllerAPI.ShipEngineAPI)engines.get(j);
                        if (!eng.isActive() || eng.isDisabled()) continue;
                        ++num;
                        if (location == null) {
                            location = new Vector2f((ReadableVector2f)eng.getLocation());
                            continue;
                        }
                        Vector2f.add((Vector2f)location, (Vector2f)eng.getLocation(), (Vector2f)location);
                    }
                    if (location == null) continue block16;
                    location.scale(1.0f / (float)num);
                    if (lights.containsKey(ship)) {
                        light = lights.get(ship);
                        light.setLocation(location);
                        if ((!system.isActive() || system.isOn()) && !system.isChargedown() || light.isFadingOut()) continue block16;
                        light.fadeOut(1.0f);
                        continue block16;
                    }
                    light = new StandardLight(location, ZERO, ZERO, null);
                    float intensity = (float)Math.sqrt(shipRadius) / 15.0f;
                    float size = intensity * 200.0f;
                    light.setIntensity(intensity);
                    light.setSize(size);
                    light.setColor(0.4f, 0.6f, 1.0f);
                    light.fadeIn(1.0f);
                    lights.put(ship, light);
                    LightShader.addLight((LightAPI)light);
                    continue block16;
                }
                case "fluxdisturber": {
                    StandardLight light;
                    if (!system.isActive()) continue block16;
                    Vector2f location = ship.getLocation();
                    if (lights.containsKey(ship)) {
                        light = lights.get(ship);
                        light.setLocation(location);
                        if ((!system.isActive() || system.isOn()) && !system.isChargedown() || light.isFadingOut()) continue block16;
                        light.fadeOut(0.25f);
                        continue block16;
                    }
                    light = new StandardLight(location, ZERO, ZERO, null);
                    light.setIntensity(0.4f);
                    light.setSize(1750.0f);
                    light.setColor(0.7f, 0.5f, 0.9f);
                    light.fadeIn(3.0f);
                    lights.put(ship, light);
                    LightShader.addLight((LightAPI)light);
                    continue block16;
                }
                case "forceimpeder": {
                    StandardLight light;
                    if (!system.isActive()) continue block16;
                    Vector2f location = ship.getLocation();
                    if (lights.containsKey(ship)) {
                        light = lights.get(ship);
                        light.setLocation(location);
                        light.setColor((float)Math.random() * 0.5f + 0.5f, (float)Math.random() * 0.5f + 0.5f, (float)Math.random() * 0.5f + 0.5f);
                        if ((!system.isActive() || system.isOn()) && !system.isChargedown() || light.isFadingOut()) continue block16;
                        light.fadeOut(1.0f);
                        continue block16;
                    }
                    light = new StandardLight(location, ZERO, ZERO, null);
                    light.setIntensity(0.5f);
                    light.setSize(4000.0f);
                    light.setColor((float)Math.random() * 0.5f + 0.5f, (float)Math.random() * 0.5f + 0.5f, (float)Math.random() * 0.5f + 0.5f);
                    light.fadeIn(2.0f);
                    lights.put(ship, light);
                    LightShader.addLight((LightAPI)light);
                    continue block16;
                }
            }
        }
        Iterator<Map.Entry<ShipAPI, StandardLight>> iter = lights.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<ShipAPI, StandardLight> entry = iter.next();
            ShipAPI ship = entry.getKey();
            if ((ship.getSystem() == null || ship.getSystem().isActive()) && ship.isAlive()) continue;
            StandardLight light = entry.getValue();
            light.unattach();
            light.fadeOut(0.0f);
            iter.remove();
        }
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
        engine.getCustomData().put(DATA_KEY, new LocalData());
    }

    private static final class LocalData {
        final Map<ShipAPI, StandardLight> lights = new LinkedHashMap<ShipAPI, StandardLight>(100);

        private LocalData() {
        }
    }
}

