/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.everyframe;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.awt.Color;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SWP_SplitterWeaponPlugin
extends BaseEveryFrameCombatPlugin {
    private static final float CANISTER_DEFAULT_RANGE = 3000.0f;
    private static final float CANISTER_DEFAULT_SPEED = 700.0f;
    private static final Color CANISTER_DETONATION_COLOR = new Color(255, 100, 75, 255);
    private static final float CANISTER_DETONATION_DURATION = 1.0f;
    private static final float CANISTER_DETONATION_SIZE = 200.0f;
    private static final String CANISTER_DETONATION_SOUND_ID = "swp_canistercannon_split";
    private static final float CANISTER_FUSE_DISTANCE = 500.0f;
    private static final Color CANISTER_PARTICLE_COLOR = new Color(255, 150, 150, 255);
    private static final int CANISTER_PARTICLE_COUNT = 100;
    private static final String CANISTER_PROJECTILE_ID = "swp_canistercannon_shot";
    private static final float CANISTER_SPLIT_DISTANCE = 300.0f;
    private static final float CANISTER_SPREAD_FORCE_MAX = 300.0f;
    private static final float CANISTER_SPREAD_FORCE_MIN = 100.0f;
    private static final int CANISTER_SUBMUNITIONS = 20;
    private static final String CANISTER_SUBMUNITION_WEAPON_ID = "swp_canister_sub";
    private static final String DATA_KEY = "SWP_SpliterWeapon";
    private static final float GUNGNIR_DEFAULT_RANGE = 1500.0f;
    private static final float GUNGNIR_DEFAULT_SPEED = 550.0f;
    private static final Color GUNGNIR_DETONATION_COLOR = new Color(255, 150, 75, 225);
    private static final float GUNGNIR_DETONATION_DURATION = 0.6f;
    private static final float GUNGNIR_DETONATION_SIZE = 120.0f;
    private static final String GUNGNIR_DETONATION_SOUND_ID = "swp_gungnir_split";
    private static final float GUNGNIR_FUSE_DISTANCE = 200.0f;
    private static final Color GUNGNIR_PARTICLE_COLOR = new Color(255, 150, 150, 200);
    private static final int GUNGNIR_PARTICLE_COUNT = 40;
    private static final String GUNGNIR_PROJECTILE_ID = "swp_gungnir_shot";
    private static final float GUNGNIR_SPLIT_DISTANCE = 600.0f;
    private static final float GUNGNIR_SPREAD_FORCE_MAX = 80.0f;
    private static final float GUNGNIR_SPREAD_FORCE_MIN = 30.0f;
    private static final int GUNGNIR_SUBMUNITIONS = 8;
    private static final String GUNGNIR_SUBMUNITION_WEAPON_ID = "ssp_gungnir_sub";
    private static final float ORIGINAL_PROJECTILE_DAMAGE_MULTIPLIER = 0.5f;
    private CombatEngineAPI engine;

    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        LocalData localData = (LocalData)this.engine.getCustomData().get(DATA_KEY);
        Set<DamagingProjectileAPI> projectileSet = localData.projectileSet;
        List projectiles = this.engine.getProjectiles();
        int size = projectiles.size();
        block8: for (int i = 0; i < size; ++i) {
            float rangeScalar;
            float speedScalar;
            int particleCount;
            Color particleColor;
            String detonateSound;
            float detonateDuration;
            float detonateSize;
            Color detonateColor;
            float defaultSpeed;
            float defaultRange;
            float splitForceMax;
            float splitForceMin;
            float splitDistance;
            float fuseDistance;
            int submunitions;
            String newSpec;
            DamagingProjectileAPI proj = (DamagingProjectileAPI)projectiles.get(i);
            String spec = proj.getProjectileSpecId();
            if (spec == null) continue;
            switch (spec) {
                case "swp_gungnir_shot": {
                    newSpec = GUNGNIR_SUBMUNITION_WEAPON_ID;
                    submunitions = 8;
                    fuseDistance = 200.0f;
                    splitDistance = 600.0f;
                    splitForceMin = 80.0f;
                    splitForceMax = 30.0f;
                    defaultRange = 1500.0f;
                    defaultSpeed = 550.0f;
                    detonateColor = GUNGNIR_DETONATION_COLOR;
                    detonateSize = 120.0f;
                    detonateDuration = 0.6f;
                    detonateSound = GUNGNIR_DETONATION_SOUND_ID;
                    particleColor = GUNGNIR_PARTICLE_COLOR;
                    particleCount = 40;
                    break;
                }
                case "swp_canistercannon_shot": {
                    newSpec = CANISTER_SUBMUNITION_WEAPON_ID;
                    submunitions = 20;
                    fuseDistance = 500.0f;
                    splitDistance = 300.0f;
                    splitForceMin = 300.0f;
                    splitForceMax = 100.0f;
                    defaultRange = 3000.0f;
                    defaultSpeed = 700.0f;
                    detonateColor = CANISTER_DETONATION_COLOR;
                    detonateSize = 200.0f;
                    detonateDuration = 1.0f;
                    detonateSound = CANISTER_DETONATION_SOUND_ID;
                    particleColor = CANISTER_PARTICLE_COLOR;
                    particleCount = 100;
                    break;
                }
                default: {
                    continue block8;
                }
            }
            if (proj.isFading() || proj.didDamage()) {
                projectileSet.remove(proj);
                continue;
            }
            if (!projectileSet.contains(proj)) {
                projectileSet.add(proj);
                proj.getDamage().setDamage(proj.getDamage().getDamage() * 0.5f);
            }
            boolean shouldSplit = false;
            Vector2f loc = proj.getLocation();
            Vector2f vel = proj.getVelocity();
            if (proj.getSource() != null) {
                speedScalar = proj.getSource().getMutableStats().getProjectileSpeedMult().getModifiedValue();
                rangeScalar = proj.getSource().getMutableStats().getBallisticWeaponRangeBonus().computeEffective(defaultRange) / defaultRange;
            } else {
                rangeScalar = 1.0f;
                speedScalar = 1.0f;
            }
            float speed = defaultSpeed * speedScalar;
            float fuseTime = fuseDistance / speed;
            if (proj.getElapsed() < fuseTime) continue;
            float detonateTime = proj.getWeapon() != null ? (proj.getWeapon().getRange() - splitDistance) / speed : (defaultRange - (splitDistance *= rangeScalar)) / speed;
            if (proj.getElapsed() >= detonateTime) {
                shouldSplit = true;
            }
            if (!shouldSplit) {
                Vector2f projection = new Vector2f(splitDistance, 0.0f);
                VectorUtils.rotate((Vector2f)projection, (float)proj.getFacing(), (Vector2f)projection);
                Vector2f.add((Vector2f)loc, (Vector2f)projection, (Vector2f)projection);
                List checkList = this.engine.getShips();
                LinkedList<ShipAPI> finalList = new LinkedList<ShipAPI>();
                int listSize = checkList.size();
                for (int j = 0; j < listSize; ++j) {
                    Vector2f point;
                    ShipAPI ship = (ShipAPI)checkList.get(j);
                    boolean isInShields = false;
                    if (ship.getShield() != null && ship.getShield().isOn() && MathUtils.isWithinRange((Vector2f)loc, (Vector2f)ship.getLocation(), (float)(ship.getShield().getRadius() + splitDistance))) {
                        isInShields = ship.getShield().isWithinArc(loc);
                    }
                    if (!isInShields && !MathUtils.isWithinRange((Vector2f)loc, (Vector2f)ship.getLocation(), (float)(ship.getCollisionRadius() + splitDistance))) continue;
                    if (isInShields) {
                        if (!CollisionUtils.getCollides((Vector2f)loc, (Vector2f)projection, (Vector2f)ship.getLocation(), (float)ship.getShield().getRadius())) continue;
                        finalList.add(ship);
                        continue;
                    }
                    if (!CollisionUtils.getCollides((Vector2f)loc, (Vector2f)projection, (Vector2f)ship.getLocation(), (float)ship.getCollisionRadius()) || (point = CollisionUtils.getCollisionPoint((Vector2f)loc, (Vector2f)projection, (CombatEntityAPI)ship)) == null || !(MathUtils.getDistance((Vector2f)loc, (Vector2f)point) <= splitDistance)) continue;
                    finalList.add(ship);
                }
                ShipAPI closest = null;
                float closestSquareDistance = Float.MAX_VALUE;
                listSize = finalList.size();
                for (int j = 0; j < listSize; ++j) {
                    ShipAPI ship = (ShipAPI)finalList.get(j);
                    float squareDistance = MathUtils.getDistanceSquared((Vector2f)loc, (Vector2f)ship.getLocation());
                    if (!(squareDistance < closestSquareDistance)) continue;
                    closestSquareDistance = squareDistance;
                    closest = ship;
                }
                if (closest != null && (closest.getOwner() == 1 || closest.getOwner() == 0) && closest.getOwner() != proj.getOwner()) {
                    shouldSplit = true;
                }
            }
            if (!shouldSplit) continue;
            Vector2f scaledVel = new Vector2f((ReadableVector2f)vel);
            scaledVel.scale(0.5f);
            this.engine.spawnExplosion(loc, scaledVel, detonateColor, detonateSize, detonateDuration);
            Global.getSoundPlayer().playSound(detonateSound, 1.0f, 1.0f, loc, scaledVel);
            float forceMultiplier = vel.length() / speed;
            for (int j = 0; j < particleCount; ++j) {
                Vector2f randomVel = MathUtils.getRandomPointOnCircumference(null, (float)(speedScalar / rangeScalar * forceMultiplier * MathUtils.getRandomNumberInRange((float)splitForceMin, (float)splitForceMax)));
                randomVel.scale((float)Math.random() + 0.75f);
                Vector2f.add((Vector2f)vel, (Vector2f)randomVel, (Vector2f)randomVel);
                randomVel.scale((float)Math.random() + 0.25f);
                this.engine.addHitParticle(loc, randomVel, (float)Math.random() * 2.0f + 6.0f, 1.0f, ((float)Math.random() * 0.75f + 1.25f) * detonateDuration, particleColor);
            }
            Vector2f defaultVel = new Vector2f(defaultSpeed * speedScalar, 0.0f);
            VectorUtils.rotate((Vector2f)defaultVel, (float)proj.getFacing(), (Vector2f)defaultVel);
            Vector2f actualVel = new Vector2f();
            for (int j = 0; j < submunitions; ++j) {
                Vector2f randomVel = MathUtils.getRandomPointOnCircumference(null, (float)(speedScalar / rangeScalar * forceMultiplier * MathUtils.getRandomNumberInRange((float)splitForceMin, (float)splitForceMax)));
                Vector2f.add((Vector2f)defaultVel, (Vector2f)randomVel, (Vector2f)actualVel);
                Vector2f.add((Vector2f)vel, (Vector2f)randomVel, (Vector2f)randomVel);
                DamagingProjectileAPI subProj = (DamagingProjectileAPI)this.engine.spawnProjectile(proj.getSource(), proj.getWeapon(), newSpec, loc, VectorUtils.getFacing((Vector2f)actualVel), randomVel);
                Vector2f subVel = subProj.getVelocity();
                Vector2f.sub((Vector2f)subVel, (Vector2f)defaultVel, (Vector2f)subVel);
            }
            projectileSet.remove(proj);
            this.engine.removeEntity((CombatEntityAPI)proj);
        }
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
        Global.getCombatEngine().getCustomData().put(DATA_KEY, new LocalData());
    }

    private static final class LocalData {
        final Set<DamagingProjectileAPI> projectileSet = new HashSet<DamagingProjectileAPI>(100);

        private LocalData() {
        }
    }
}

