/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.everyframe;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import data.scripts.util.SWP_Util;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SWP_MegaPulseHoming
extends BaseEveryFrameCombatPlugin {
    private static final float ACCELERATION = 900.0f;
    private static final String DATA_KEY = "SWP_MegaPulse";
    private static final float MAX_SPEED = 600.0f;
    private CombatEngineAPI engine;

    private static ShipAPI findBestTarget(DamagingProjectileAPI proj) {
        ShipAPI source = proj.getSource();
        if (source != null && source.getShipTarget() != null && !source.getShipTarget().isHulk()) {
            return source.getShipTarget();
        }
        return AIUtils.getNearestEnemy((CombatEntityAPI)proj);
    }

    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        LocalData localData = (LocalData)this.engine.getCustomData().get(DATA_KEY);
        Map<DamagingProjectileAPI, CombatEntityAPI> targets = localData.targets;
        List activeProjectiles = this.engine.getProjectiles();
        for (DamagingProjectileAPI projectile : activeProjectiles) {
            if (projectile.getWeapon() == null || !projectile.getWeapon().getId().contentEquals("megapulse") || projectile.didDamage() || projectile.isFading() || targets.containsKey(projectile) || projectile.getProjectileSpecId() == null) continue;
            targets.put(projectile, (CombatEntityAPI)SWP_MegaPulseHoming.findBestTarget(projectile));
        }
        if (targets.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<DamagingProjectileAPI, CombatEntityAPI>> iter = targets.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<DamagingProjectileAPI, CombatEntityAPI> entry = iter.next();
            DamagingProjectileAPI projectile = entry.getKey();
            CombatEntityAPI target = entry.getValue();
            if (projectile.didDamage() || !this.engine.isEntityInPlay((CombatEntityAPI)projectile)) {
                iter.remove();
                continue;
            }
            if (target == null || target instanceof ShipAPI && ((ShipAPI)target).isHulk() || projectile.getOwner() == target.getOwner() || !Global.getCombatEngine().isEntityInPlay(target)) {
                entry.setValue((CombatEntityAPI)SWP_MegaPulseHoming.findBestTarget(projectile));
                continue;
            }
            float distance = MathUtils.getDistance((Vector2f)target.getLocation(), (Vector2f)projectile.getLocation());
            float buff = projectile.getSource().getMutableStats().getProjectileSpeedMult().getModifiedValue();
            Vector2f guidedTarget = SWP_Util.intercept(projectile.getLocation(), projectile.getVelocity().length(), 900.0f * buff, 600.0f * buff, target.getLocation(), target.getVelocity());
            if (guidedTarget == null) {
                Vector2f projection = new Vector2f((ReadableVector2f)target.getVelocity());
                float scalar = distance / (projectile.getVelocity().length() + 1.0f);
                projection.scale(scalar);
                guidedTarget = Vector2f.add((Vector2f)target.getLocation(), (Vector2f)projection, null);
            }
            Vector2f acceleration = VectorUtils.getDirectionalVector((Vector2f)projectile.getLocation(), (Vector2f)guidedTarget);
            acceleration.scale(900.0f * buff * amount);
            Vector2f.add((Vector2f)acceleration, (Vector2f)projectile.getVelocity(), (Vector2f)acceleration);
            float speed = acceleration.length();
            if (speed > 600.0f * buff) {
                acceleration.scale(600.0f * buff / speed);
            }
            projectile.getVelocity().set((ReadableVector2f)acceleration);
        }
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
        Global.getCombatEngine().getCustomData().put(DATA_KEY, new LocalData());
    }

    private static final class LocalData {
        final Map<DamagingProjectileAPI, CombatEntityAPI> targets = new LinkedHashMap<DamagingProjectileAPI, CombatEntityAPI>(50);

        private LocalData() {
        }
    }
}

