/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.everyframe;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatAssignmentType;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.MutableStat;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.mission.FleetSide;
import data.scripts.util.SWP_Util;
import java.util.List;
import org.lwjgl.util.vector.Vector2f;

public class SWP_IBBPlugin
extends BaseEveryFrameCombatPlugin {
    private CombatEngineAPI engine;

    public void advance(float amount, List<InputEventAPI> events) {
        CampaignFleetAPI fleet;
        FleetDataAPI data;
        if (this.engine == null) {
            return;
        }
        if (!this.engine.isInCampaign()) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        boolean isFamousBounty = false;
        boolean isFlagshipAlive = false;
        ShipAPI flagship = null;
        CombatFleetManagerAPI manager = this.engine.getFleetManager(FleetSide.ENEMY);
        for (FleetMemberAPI member : manager.getDeployedCopy()) {
            ShipAPI fs;
            data = member.getFleetData();
            if (data == null || (fleet = data.getFleet()) == null || !fleet.getFaction().getId().contentEquals("famous_bounty")) continue;
            isFamousBounty = true;
            if (fleet.getFlagship() == null || (fs = manager.getShipFor(fleet.getFlagship())) == null) break;
            isFlagshipAlive = fs.isAlive();
            flagship = fs;
            break;
        }
        if (flagship == null) {
            for (FleetMemberAPI member : manager.getReservesCopy()) {
                Vector2f safeSpawn;
                data = member.getFleetData();
                if (data == null || (fleet = data.getFleet()) == null || !fleet.getFaction().getId().contentEquals("famous_bounty")) continue;
                isFamousBounty = true;
                if (fleet.getFlagship() != null && fleet.getFlagship().getId().contentEquals(member.getId())) {
                    isFlagshipAlive = true;
                    safeSpawn = SWP_Util.getSafeSpawn(SWP_Util.getMemberRadiusEstimate(member), FleetSide.ENEMY, Global.getCombatEngine().getMapWidth(), Global.getCombatEngine().getMapHeight());
                    flagship = manager.spawnFleetMember(member, safeSpawn, 270.0f, 2.0f);
                    manager.removeFromReserves(member);
                }
                if (!SWP_Util.SPECIAL_SHIPS.contains(member.getHullId())) continue;
                member.getStats().getDynamic().getStat("individual_ship_recovery_mod").modifyFlat("swp_ibbbonus", 1.0f);
                if (fleet.getFlagship() != null && fleet.getFlagship().getId().contentEquals(member.getId())) continue;
                safeSpawn = SWP_Util.getSafeSpawn(SWP_Util.getMemberRadiusEstimate(member), FleetSide.ENEMY, Global.getCombatEngine().getMapWidth(), Global.getCombatEngine().getMapHeight());
                manager.spawnFleetMember(member, safeSpawn, 270.0f, 2.0f);
                manager.removeFromReserves(member);
            }
        }
        if (isFamousBounty) {
            manager.getTaskManager(false).setPreventFullRetreat(isFlagshipAlive);
            if (isFlagshipAlive && flagship != null && manager.getTaskManager(flagship.isAlly()).getAssignmentFor(flagship) != null && manager.getTaskManager(flagship.isAlly()).getAssignmentFor(flagship).getType() == CombatAssignmentType.RETREAT) {
                manager.getTaskManager(flagship.isAlly()).orderSearchAndDestroy(manager.getDeployedFleetMember(flagship), false);
                MutableStat.StatMod mod = manager.getTaskManager(flagship.isAlly()).getCommandPointsStat().getFlatStatMod("famousBounty");
                if (mod == null) {
                    manager.getTaskManager(flagship.isAlly()).getCommandPointsStat().modifyFlat("famousBounty", 1.0f);
                } else {
                    mod.value += 1.0f;
                }
            }
        }
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
    }
}

