/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.everyframe;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SWP_FluxDisturberPlugin
extends BaseEveryFrameCombatPlugin {
    public static final float DISTURBER_EMPPERSECOND = 500.0f;
    public static final float DISTURBER_FLUXPERSECOND = 1000.0f;
    public static final float DISTURBER_INTERVAL = 0.25f;
    public static final float DISTURBER_RANGE = 2500.0f;
    public static final float MAX_TARGETS = 15.0f;
    private static final String DATA_KEY = "SWP_FluxDisturber";
    private CombatEngineAPI engine;

    public static void addDisturbing(ShipAPI ship, float effectLevel) {
        LocalData localData = (LocalData)Global.getCombatEngine().getCustomData().get(DATA_KEY);
        if (localData == null) {
            return;
        }
        Map<ShipAPI, Float> disturberList = localData.disturberList;
        Map<ShipAPI, IntervalUtil> trackerList = localData.trackerList;
        if (disturberList.containsKey(ship)) {
            disturberList.put(ship, Float.valueOf(effectLevel));
        } else {
            disturberList.put(ship, Float.valueOf(effectLevel));
            trackerList.put(ship, new IntervalUtil(0.25f, 0.25f));
        }
    }

    public static void removeDisturbing(ShipAPI ship) {
        LocalData localData = (LocalData)Global.getCombatEngine().getCustomData().get(DATA_KEY);
        if (localData == null) {
            return;
        }
        Map<ShipAPI, Float> disturberList = localData.disturberList;
        Map<ShipAPI, IntervalUtil> trackerList = localData.trackerList;
        disturberList.remove(ship);
        trackerList.remove(ship);
    }

    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        LocalData localData = (LocalData)this.engine.getCustomData().get(DATA_KEY);
        Map<ShipAPI, Float> disturberList = localData.disturberList;
        Map<ShipAPI, IntervalUtil> trackerList = localData.trackerList;
        for (Map.Entry<ShipAPI, Float> entry : disturberList.entrySet()) {
            ShipAPI ship = entry.getKey();
            IntervalUtil tracker = trackerList.get(ship);
            tracker.advance(amount * ship.getMutableStats().getTimeMult().getModifiedValue());
            float effectLevel = entry.getValue().floatValue();
            float glowRand = (float)Math.random();
            List weapons = ship.getAllWeapons();
            for (WeaponAPI weapon : weapons) {
                SpriteAPI sprite;
                if (weapon.getId().contentEquals("ssp_cathedralglow1")) {
                    if (effectLevel > 0.0f) {
                        weapon.getAnimation().setFrame(1);
                        sprite = weapon.getSprite();
                        sprite.setAdditiveBlend();
                        sprite.setColor(new Color(150, 100, 200, (int)(255.0f * effectLevel * (glowRand * 0.5f + 0.5f))));
                    } else {
                        weapon.getAnimation().setFrame(0);
                    }
                }
                if (!weapon.getId().contentEquals("ssp_cathedralglow2")) continue;
                if (effectLevel > 0.0f) {
                    weapon.getAnimation().setFrame(1);
                    sprite = weapon.getSprite();
                    sprite.setAdditiveBlend();
                    sprite.setColor(new Color(200, 150, 255, (int)(255.0f * effectLevel * (glowRand * 0.5f + 0.5f))));
                    continue;
                }
                weapon.getAnimation().setFrame(0);
            }
            if (!tracker.intervalElapsed()) continue;
            List targets = CombatUtils.getShipsWithinRange((Vector2f)ship.getLocation(), (float)2500.0f);
            Iterator iter = targets.iterator();
            while (iter.hasNext()) {
                ShipAPI target = (ShipAPI)iter.next();
                if (!target.isHulk() && target != ship && (!target.isFighter() || target.getOwner() != ship.getOwner()) && !target.getFluxTracker().isOverloadedOrVenting() && target.getCollisionClass() != CollisionClass.NONE) continue;
                iter.remove();
            }
            float chance = Math.min(15.0f / (float)targets.size(), 1.0f);
            for (ShipAPI target : targets) {
                float distance;
                if (target == ship || (float)Math.random() >= chance) continue;
                target.getFluxTracker().increaseFlux(1000.0f * effectLevel * 0.25f, true);
                Vector2f origin = new Vector2f((ReadableVector2f)ship.getLocation());
                float angle = VectorUtils.getAngle((Vector2f)ship.getLocation(), (Vector2f)target.getLocation()) - ship.getFacing();
                if (angle < 0.0f) {
                    angle += 360.0f;
                }
                if (angle >= 0.0f && angle < 57.5f) {
                    distance = 420.0f;
                    angle = 45.6f;
                } else if (angle >= 57.5f && angle < 89.9f) {
                    distance = 393.0f;
                    angle = 69.4f;
                } else if (angle >= 89.9f && angle < 121.75f) {
                    distance = 389.0f;
                    angle = 110.4f;
                } else if (angle >= 121.75f && angle < 179.45f) {
                    distance = 390.0f;
                    angle = 133.1f;
                } else if (angle >= 179.45f && angle < 237.4f) {
                    distance = 384.0f;
                    angle = 225.8f;
                } else if (angle >= 237.4f && angle < 270.0f) {
                    distance = 380.0f;
                    angle = 249.0f;
                } else if (angle >= 270.0f && angle < 303.2f) {
                    distance = 382.0f;
                    angle = 291.0f;
                } else {
                    distance = 412.0f;
                    angle = 315.4f;
                }
                angle += ship.getFacing();
                if (angle >= 360.0f) {
                    angle -= 360.0f;
                }
                origin.x += distance;
                origin = VectorUtils.rotateAroundPivot((Vector2f)origin, (Vector2f)ship.getLocation(), (float)angle, (Vector2f)origin);
                ShipAPI empTarget = target;
                if (Math.random() < (double)Math.max(1.0f / (float)targets.size(), 0.06666667f)) {
                    Global.getCombatEngine().spawnEmpArc(ship, origin, (CombatEntityAPI)ship, (CombatEntityAPI)empTarget, DamageType.ENERGY, 0.0f, 500.0f * effectLevel * 0.25f, 100000.0f, "disabled_medium", 20.0f * effectLevel, new Color(150, 100, 200, (int)(200.0f * effectLevel + 55.0f)), new Color(255, 255, 255, (int)(200.0f * effectLevel + 55.0f)));
                    continue;
                }
                Global.getCombatEngine().spawnEmpArc(ship, origin, (CombatEntityAPI)ship, (CombatEntityAPI)empTarget, DamageType.ENERGY, 0.0f, 500.0f * effectLevel * 0.25f, 100000.0f, null, 20.0f * effectLevel, new Color(150, 100, 200, (int)(200.0f * effectLevel + 55.0f)), new Color(255, 255, 255, (int)(200.0f * effectLevel + 55.0f)));
            }
        }
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
        Global.getCombatEngine().getCustomData().put(DATA_KEY, new LocalData());
    }

    private static final class LocalData {
        final Map<ShipAPI, Float> disturberList = new HashMap<ShipAPI, Float>(2);
        final Map<ShipAPI, IntervalUtil> trackerList = new HashMap<ShipAPI, IntervalUtil>(2);

        private LocalData() {
        }
    }
}

