/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.everyframe;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import java.awt.Color;
import java.util.List;
import org.dark.shaders.distortion.DistortionAPI;
import org.dark.shaders.distortion.DistortionShader;
import org.dark.shaders.distortion.RippleDistortion;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class SWP_ExcelsiorPlugin
extends BaseEveryFrameCombatPlugin {
    private static final Color COLOR_1 = new Color(255, 150, 200);
    private static final Color COLOR_2 = new Color(255, 100, 150);
    private static final Color COLOR_3 = new Color(180, 60, 120);
    private static final Vector2f ZERO = new Vector2f();
    private CombatEngineAPI engine;

    public void advance(float amount, List<InputEventAPI> events) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        List activeProjectiles = this.engine.getProjectiles();
        for (DamagingProjectileAPI projectile : activeProjectiles) {
            Vector2f point2;
            float distance;
            float angle;
            Vector2f particle_velocity;
            float speed;
            float duration;
            Vector2f spawn_location;
            float size;
            float distance2;
            if (projectile.getWeapon() == null || projectile.getSource() == null || projectile.getProjectileSpecId() == null || !projectile.getProjectileSpecId().contentEquals("swp_excelsiorcannon_shot")) continue;
            ShipAPI ship = projectile.getSource();
            if (ship.getFluxTracker().getCurrFlux() >= 7500.0f) {
                int i;
                this.engine.spawnProjectile(ship, projectile.getWeapon(), "ssp_excelsiorcannon_75", projectile.getLocation(), projectile.getFacing(), ship.getVelocity());
                for (i = 0; i < 25; ++i) {
                    distance2 = (float)Math.random() * 15.0f;
                    size = (float)Math.random() * 8.0f + 8.0f;
                    float angle2 = (float)Math.random() * 270.0f - 135.0f;
                    spawn_location = MathUtils.getPointOnCircumference((Vector2f)projectile.getLocation(), (float)distance2, (float)(angle2 + projectile.getFacing()));
                    duration = (float)Math.random() * 0.25f + 0.25f;
                    speed = 20.0f * distance2 / duration;
                    particle_velocity = MathUtils.getPointOnCircumference((Vector2f)ship.getVelocity(), (float)speed, (float)(angle2 + projectile.getFacing()));
                    this.engine.addHitParticle(spawn_location, particle_velocity, size, 1.0f, duration, COLOR_1);
                }
                for (i = 0; i < 2; ++i) {
                    angle = (float)Math.random() * 360.0f;
                    distance = (float)Math.random() * 40.0f;
                    Vector2f point1 = MathUtils.getPointOnCircumference((Vector2f)projectile.getLocation(), (float)distance, (float)angle);
                    point2 = MathUtils.getPointOnCircumference((Vector2f)projectile.getLocation(), (float)(distance + (float)Math.random() * 60.0f), (float)angle);
                    this.engine.spawnEmpArc(ship, point1, (CombatEntityAPI)new SimpleEntity(point1), (CombatEntityAPI)new SimpleEntity(point2), DamageType.ENERGY, 0.0f, 0.0f, 1000.0f, null, 30.0f, COLOR_2, COLOR_1);
                }
                this.engine.spawnExplosion(projectile.getLocation(), ship.getVelocity(), COLOR_2, 200.0f, 0.175f);
                this.engine.addSmoothParticle(projectile.getLocation(), ship.getVelocity(), 400.0f, 0.5f, 0.125f, COLOR_3);
                RippleDistortion ripple = new RippleDistortion(projectile.getLocation(), ship.getVelocity());
                ripple.setSize(200.0f);
                ripple.setIntensity(20.0f);
                ripple.setFrameRate(180.0f);
                ripple.fadeInSize(0.4f);
                ripple.fadeOutIntensity(0.35f);
                DistortionShader.addDistortion((DistortionAPI)ripple);
                ship.getFluxTracker().decreaseFlux(125.0f);
                Global.getSoundPlayer().playSound("swp_fluxshuntcannon_75_fire", 1.0f, 1.0f, new Vector2f((ReadableVector2f)projectile.getLocation()), ZERO);
            } else if (ship.getFluxTracker().getCurrFlux() >= 5000.0f) {
                int i;
                this.engine.spawnProjectile(ship, projectile.getWeapon(), "ssp_excelsiorcannon_50", projectile.getLocation(), projectile.getFacing(), ship.getVelocity());
                for (i = 0; i < 20; ++i) {
                    distance2 = (float)Math.random() * 12.5f;
                    size = (float)Math.random() * 7.0f + 7.0f;
                    float angle3 = (float)Math.random() * 270.0f - 135.0f;
                    spawn_location = MathUtils.getPointOnCircumference((Vector2f)projectile.getLocation(), (float)distance2, (float)(angle3 + projectile.getFacing()));
                    duration = (float)Math.random() * 0.2f + 0.2f;
                    speed = 20.0f * distance2 / duration;
                    particle_velocity = MathUtils.getPointOnCircumference((Vector2f)ship.getVelocity(), (float)speed, (float)(angle3 + projectile.getFacing()));
                    this.engine.addHitParticle(spawn_location, particle_velocity, size, 1.0f, duration, COLOR_1);
                }
                for (i = 0; i < 1; ++i) {
                    angle = (float)Math.random() * 360.0f;
                    distance = (float)Math.random() * 30.0f;
                    Vector2f point1 = MathUtils.getPointOnCircumference((Vector2f)projectile.getLocation(), (float)distance, (float)angle);
                    point2 = MathUtils.getPointOnCircumference((Vector2f)projectile.getLocation(), (float)(distance + (float)Math.random() * 45.0f), (float)angle);
                    this.engine.spawnEmpArc(ship, point1, (CombatEntityAPI)new SimpleEntity(point1), (CombatEntityAPI)new SimpleEntity(point2), DamageType.ENERGY, 0.0f, 0.0f, 1000.0f, null, 25.0f, COLOR_2, COLOR_1);
                }
                this.engine.spawnExplosion(projectile.getLocation(), ship.getVelocity(), COLOR_2, 175.0f, 0.15f);
                this.engine.addSmoothParticle(projectile.getLocation(), ship.getVelocity(), 350.0f, 0.4f, 0.1f, COLOR_3);
                ship.getFluxTracker().decreaseFlux(100.0f);
                Global.getSoundPlayer().playSound("swp_fluxshuntcannon_50_fire", 1.0f, 1.0f, new Vector2f((ReadableVector2f)projectile.getLocation()), ZERO);
            } else if (ship.getFluxTracker().getCurrFlux() >= 3000.0f) {
                this.engine.spawnProjectile(ship, projectile.getWeapon(), "ssp_excelsiorcannon_30", projectile.getLocation(), projectile.getFacing(), ship.getVelocity());
                for (int i = 0; i < 15; ++i) {
                    distance2 = (float)Math.random() * 10.0f;
                    size = (float)Math.random() * 6.0f + 6.0f;
                    float angle4 = (float)Math.random() * 270.0f - 135.0f;
                    spawn_location = MathUtils.getPointOnCircumference((Vector2f)projectile.getLocation(), (float)distance2, (float)(angle4 + projectile.getFacing()));
                    duration = (float)Math.random() * 0.15f + 0.15f;
                    speed = 20.0f * distance2 / duration;
                    particle_velocity = MathUtils.getPointOnCircumference((Vector2f)ship.getVelocity(), (float)speed, (float)(angle4 + projectile.getFacing()));
                    this.engine.addHitParticle(spawn_location, particle_velocity, size, 1.0f, duration, COLOR_1);
                }
                this.engine.spawnExplosion(projectile.getLocation(), ship.getVelocity(), COLOR_2, 150.0f, 0.125f);
                this.engine.addSmoothParticle(projectile.getLocation(), ship.getVelocity(), 300.0f, 0.3f, 0.075f, COLOR_3);
                ship.getFluxTracker().decreaseFlux(75.0f);
                Global.getSoundPlayer().playSound("swp_fluxshuntcannon_30_fire", 1.0f, 1.0f, new Vector2f((ReadableVector2f)projectile.getLocation()), ZERO);
            } else if (ship.getFluxTracker().getCurrFlux() >= 1500.0f) {
                this.engine.spawnProjectile(ship, projectile.getWeapon(), "ssp_excelsiorcannon_15", projectile.getLocation(), projectile.getFacing(), ship.getVelocity());
                for (int i = 0; i < 10; ++i) {
                    distance2 = (float)Math.random() * 7.5f;
                    size = (float)Math.random() * 5.0f + 5.0f;
                    float angle5 = (float)Math.random() * 270.0f - 135.0f;
                    spawn_location = MathUtils.getPointOnCircumference((Vector2f)projectile.getLocation(), (float)distance2, (float)(angle5 + projectile.getFacing()));
                    duration = (float)Math.random() * 0.1f + 0.1f;
                    speed = 20.0f * distance2 / duration;
                    particle_velocity = MathUtils.getPointOnCircumference((Vector2f)ship.getVelocity(), (float)speed, (float)(angle5 + projectile.getFacing()));
                    this.engine.addHitParticle(spawn_location, particle_velocity, size, 1.0f, duration, COLOR_1);
                }
                this.engine.spawnExplosion(projectile.getLocation(), ship.getVelocity(), COLOR_2, 125.0f, 0.1f);
                ship.getFluxTracker().decreaseFlux(50.0f);
                Global.getSoundPlayer().playSound("swp_fluxshuntcannon_15_fire", 1.0f, 1.0f, new Vector2f((ReadableVector2f)projectile.getLocation()), ZERO);
            } else if (ship.getFluxTracker().getCurrFlux() >= 500.0f) {
                this.engine.spawnProjectile(ship, projectile.getWeapon(), "ssp_excelsiorcannon_5", projectile.getLocation(), projectile.getFacing(), ship.getVelocity());
                this.engine.spawnExplosion(projectile.getLocation(), ship.getVelocity(), COLOR_2, 100.0f, 0.075f);
                ship.getFluxTracker().decreaseFlux(25.0f);
                Global.getSoundPlayer().playSound("swp_fluxshuntcannon_5_fire", 1.0f, 1.0f, new Vector2f((ReadableVector2f)projectile.getLocation()), ZERO);
            } else {
                this.engine.spawnProjectile(ship, projectile.getWeapon(), "ssp_excelsiorcannon_0", projectile.getLocation(), projectile.getFacing(), ship.getVelocity());
                ship.getFluxTracker().decreaseFlux(5.0f);
                Global.getSoundPlayer().playSound("swp_fluxshuntcannon_0_fire", 1.0f, 1.0f, new Vector2f((ReadableVector2f)projectile.getLocation()), ZERO);
            }
            this.engine.removeEntity((CombatEntityAPI)projectile);
        }
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
    }
}

