/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignMissionPlugin;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.events.CampaignEventManagerAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.impl.campaign.missions.BaseCampaignMission;
import com.fs.starfarer.api.util.Highlights;
import data.scripts.SWPModPlugin;
import data.scripts.campaign.events.SWP_IBBTracker;
import data.scripts.campaign.missions.SWP_FamousBountyEvent;
import data.scripts.util.SWP_Util;
import java.awt.Color;
import java.util.ArrayList;

public class SWP_FamousBountyMission
extends BaseCampaignMission {
    private float duration = 60.0f;
    private SWP_FamousBountyEvent.FamousBountyStage thisStage;

    public SWP_FamousBountyMission(SectorEntityToken token) {
        this.event = Global.getSector().getEventManager().primeEvent(new CampaignEventTarget(token), "famous_bounty", null);
        if (this.event != null && this.event.isDone()) {
            this.event = null;
        } else if (this.event != null) {
            this.thisStage = ((SWP_FamousBountyEvent)this.event).getStage();
            SWP_IBBTracker.getTracker().reportStagePosted(this.thisStage);
        }
    }

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        if (this.event == null || this.event.isDone() || !SWP_IBBTracker.getTracker().isStagePosted(this.thisStage)) {
            this.event = null;
            Global.getSector().getMissionBoard().removeMission((CampaignMissionPlugin)this, true);
            return;
        }
        this.duration -= days;
        if (this.duration < 0.0f) {
            if (SWP_IBBTracker.getTracker().isStagePosted(this.thisStage)) {
                ((SWP_FamousBountyEvent)this.event).endEvent(true);
            }
            Global.getSector().getMissionBoard().removeMission((CampaignMissionPlugin)this, true);
        }
    }

    public boolean canPlayerAccept() {
        if (SWPModPlugin.isExerelin) {
            return true;
        }
        FactionAPI playerFaction = Global.getSector().getFaction("player");
        RepLevel minStanding = RepLevel.SUSPICIOUS;
        boolean good = false;
        for (String factionId : SWP_FamousBountyEvent.IBB_FACTIONS) {
            FactionAPI faction;
            try {
                faction = Global.getSector().getFaction(factionId);
            }
            catch (Exception e) {
                continue;
            }
            if (faction == null) continue;
            good |= playerFaction.isAtWorst(factionId, minStanding);
        }
        return good;
    }

    public String getAcceptTooltip() {
        if (this.canPlayerAccept()) {
            return null;
        }
        FactionAPI playerFaction = Global.getSector().getFaction("player");
        RepLevel minStanding = RepLevel.SUSPICIOUS;
        ArrayList<String> naughtyFactions = new ArrayList<String>(SWP_FamousBountyEvent.IBB_FACTIONS.size());
        for (String factionId : SWP_FamousBountyEvent.IBB_FACTIONS) {
            FactionAPI faction;
            try {
                faction = Global.getSector().getFaction(factionId);
            }
            catch (Exception e) {
                continue;
            }
            if (faction == null || playerFaction.isAtWorst(factionId, minStanding)) continue;
            naughtyFactions.add(faction.getDisplayName());
        }
        String factions = SWP_Util.getOrJoined(naughtyFactions.toArray(new String[naughtyFactions.size()]));
        return "\u9700\u8981: " + factions + " - " + minStanding.getDisplayName().toLowerCase() + " \u6216\u66f4\u597d";
    }

    public Highlights getAcceptTooltipHighlights() {
        String tooltip = this.getAcceptTooltip();
        if (tooltip == null) {
            return null;
        }
        Highlights h = new Highlights();
        FactionAPI faction = Global.getSector().getFaction("independent");
        RepLevel minStanding = RepLevel.SUSPICIOUS;
        h.setText(new String[]{minStanding.getDisplayName().toLowerCase()});
        h.setColors(new Color[]{faction.getRelColor(minStanding)});
        return h;
    }

    public PersonAPI getImportantPerson() {
        return ((SWP_FamousBountyEvent)this.event).initPerson(Global.getSector().getFaction("famous_bounty"));
    }

    public String getName() {
        PersonAPI person = ((SWP_FamousBountyEvent)this.event).initPerson(Global.getSector().getFaction("famous_bounty"));
        return "\u661f\u9645\u8d4f\u91d1\u59d4\u5458 - " + person.getName().getFullName();
    }

    public CampaignEventPlugin getPrimedEvent() {
        return this.event;
    }

    public SWP_FamousBountyEvent.FamousBountyStage getStage() {
        if (this.event == null) {
            return null;
        }
        return ((SWP_FamousBountyEvent)this.event).getStage();
    }

    public void playerAccept(SectorEntityToken entity) {
        super.playerAccept(entity);
        this.event.setParam((Object)entity.getMarket());
        CampaignEventManagerAPI eventManager = Global.getSector().getEventManager();
        eventManager.startEvent(this.event);
    }
}

