/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.campaign.missions;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.BaseOnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.BattleAPI;
import com.fs.starfarer.api.campaign.CampaignEventListener;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetAssignment;
import com.fs.starfarer.api.campaign.InteractionDialogAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.OnMessageDeliveryScript;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.comm.CommMessageAPI;
import com.fs.starfarer.api.campaign.comm.MessagePriority;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.campaign.events.CampaignEventPlugin;
import com.fs.starfarer.api.campaign.events.CampaignEventTarget;
import com.fs.starfarer.api.characters.FullName;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.BattleCreationContext;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.FleetEncounterContext;
import com.fs.starfarer.api.impl.campaign.FleetInteractionDialogPluginImpl;
import com.fs.starfarer.api.impl.campaign.events.BaseEventPlugin;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactory;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV2;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParams;
import com.fs.starfarer.api.impl.campaign.ids.Ranks;
import com.fs.starfarer.api.loading.FleetCompositionDoctrineAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import data.scripts.SWPModPlugin;
import data.scripts.campaign.SWP_FleetFactory;
import data.scripts.campaign.events.SWP_IBBTracker;
import data.scripts.util.SWP_Util;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.log4j.Logger;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class SWP_FamousBountyEvent
extends BaseEventPlugin {
    public static final Set<String> BANNED_SYSTEMS = new HashSet<String>(1);
    public static final Set<String> IBB_FACTIONS = new LinkedHashSet<String>(6);
    public static final int MAX_BOUNTY_STAGE = FamousBountyStage.values().length - 1;
    public static Logger log = Global.getLogger(SWP_FamousBountyEvent.class);
    private float bountyCredits = 0.0f;
    private FactionAPI bountyFaction = null;
    private final IntervalUtil checkInterval = new IntervalUtil(0.5f, 1.0f);
    private boolean completed = false;
    private final float duration = 180.0f;
    private float elapsedDays = 0.0f;
    private boolean ended = false;
    private FleetMemberAPI flagship;
    private String flagshipName;
    private CampaignFleetAPI fleet;
    private SectorEntityToken hideoutLocation = null;
    private boolean \u5b83 = false;
    private MessagePriority messagePriority;
    private float payment = 0.0f;
    private PersonAPI person;
    private String targetDesc;
    private String targetDescLong;
    private FamousBountyStage thisStage;

    public static int calculatePowerLevel(FamousBountyStage stage) {
        float pointFactor = 5.0f * (stage.qf / 4.0f + 0.875f);
        if (stage.fleetFaction.contentEquals("tritachyon")) {
            pointFactor *= 1.2f;
        }
        if (stage.fleetFaction.contentEquals("remnant")) {
            pointFactor *= 1.1f;
        }
        if (stage.fleetFaction.contentEquals("lions_guard")) {
            pointFactor *= 1.3f;
        }
        if (stage.fleetFaction.contentEquals("pirates")) {
            pointFactor *= 0.75f;
        }
        if (stage.fleetFaction.contentEquals("derelict")) {
            pointFactor *= 0.6f;
        }
        if (stage.fleetFaction.contentEquals("shadow_industry")) {
            pointFactor *= 1.1f;
        }
        if (stage.fleetFaction.contentEquals("domain")) {
            pointFactor *= 1.1f;
        }
        if (stage.fleetFaction.contentEquals("sector")) {
            pointFactor *= 1.2f;
        }
        if (stage.fleetFaction.contentEquals("everything")) {
            pointFactor *= 1.3f;
        }
        if (stage.fleetFaction.contentEquals("templars")) {
            pointFactor *= 2.0f;
        }
        if (stage.fleetFaction.contentEquals("cabal")) {
            pointFactor *= 1.4f;
        }
        if (stage.fleetFaction.contentEquals("diableavionics")) {
            pointFactor *= 1.1f;
        }
        if (stage.fleetFaction.contentEquals("ORA")) {
            pointFactor *= 1.2f;
        }
        int power = Math.round((float)(stage.maxPts + Math.round((float)stage.ptsFromBoss * 1.5f)) * (pointFactor *= 1.0f + stage.opBonus / 100.0f));
        int offLvl = stage.officerCount * stage.officerLevel;
        int cdrLvl = stage.level;
        power = (int)((float)power * ((float)cdrLvl / 200.0f + 1.0f));
        return power += cdrLvl + offLvl;
    }

    public static MarketAPI findNearestMarket(SectorEntityToken token, float maxDist) {
        List localMarkets = Misc.getMarketsInLocation((LocationAPI)token.getContainingLocation());
        float distToLocalMarket = Float.MAX_VALUE;
        MarketAPI closest = null;
        for (MarketAPI market : localMarkets) {
            float currDist;
            if (market.isPlanetConditionMarketOnly() || market.getPrimaryEntity() == null || market.getPrimaryEntity().getContainingLocation() != token.getContainingLocation() || (currDist = Misc.getDistance((Vector2f)market.getPrimaryEntity().getLocation(), (Vector2f)token.getLocation())) > maxDist || !(currDist < distToLocalMarket)) continue;
            distToLocalMarket = currDist;
            closest = market;
        }
        return closest;
    }

    public void advance(float amount) {
        if (!this.isEventStarted()) {
            return;
        }
        if (this.fleet != null && this.fleet.isAlive()) {
            if (this.fleet.isInCurrentLocation() && this.fleet.getFaction() != this.bountyFaction) {
                this.fleet.setFaction(this.bountyFaction.getId());
            } else if (!this.fleet.isInCurrentLocation() && !this.fleet.getFaction().getId().contentEquals("neutral")) {
                this.fleet.setFaction("neutral");
            }
        }
        if (this.isDone()) {
            return;
        }
        float days = Global.getSector().getClock().convertToDays(amount);
        this.elapsedDays += days;
        this.checkInterval.advance(days);
        if (this.checkInterval.intervalElapsed()) {
            for (FactionAPI fac : Global.getSector().getAllFactions()) {
                if (fac == Global.getSector().getFaction("player")) continue;
                fac.setRelationship("famous_bounty", RepLevel.INHOSPITABLE);
            }
            boolean freeToDespawn = true;
            if (Global.getSector().getPlayerFleet() != null && this.fleet != null && Global.getSector().getPlayerFleet().getContainingLocation() == this.fleet.getContainingLocation()) {
                freeToDespawn = false;
            }
            if (this.elapsedDays >= 180.0f && !this.isDone() && freeToDespawn) {
                Global.getSector().reportEventStage((CampaignEventPlugin)this, "other_end", this.market.getPrimaryEntity(), this.messagePriority);
                this.endEvent(false);
                return;
            }
        }
        if (this.fleet.getFlagship() == null || this.fleet.getFlagship().getCaptain() != this.person) {
            Global.getSector().reportEventStage((CampaignEventPlugin)this, "other_end", this.market.getPrimaryEntity(), this.messagePriority);
            this.endEvent(false);
        }
    }

    public void endEvent(boolean expire) {
        this.ended = true;
        if (expire) {
            SWP_IBBTracker.getTracker().reportStageExpired(this.thisStage);
        } else {
            SWP_IBBTracker.getTracker().reportStageCompleted(this.thisStage);
        }
        if (this.fleet != null) {
            this.fleet.getMemoryWithoutUpdate().set("$stillAlive", (Object)false);
            this.fleet.getMemoryWithoutUpdate().unset("$cfai_makeAggressive");
            this.fleet.getMemoryWithoutUpdate().set("$cfai_makeNonAggressive", (Object)true);
            this.fleet.getMemoryWithoutUpdate().set("$cfai_makeAllowDisengage", (Object)true);
            Misc.makeUnimportant((SectorEntityToken)this.fleet, (String)"swp_ibb");
            this.fleet.clearAssignments();
            if (this.hideoutLocation != null) {
                this.fleet.getAI().addAssignment(FleetAssignment.GO_TO_LOCATION_AND_DESPAWN, this.hideoutLocation, 1000000.0f, null);
            } else {
                this.fleet.despawn();
            }
        }
    }

    public String getCurrentImage() {
        return this.person.getPortraitSprite();
    }

    public String getCurrentMessageIcon() {
        return "graphics/swp/icons/intel/swp_famousbounty.png";
    }

    public CampaignEventPlugin.CampaignEventCategory getEventCategory() {
        return CampaignEventPlugin.CampaignEventCategory.MISSION;
    }

    public String getEventIcon() {
        return "graphics/swp/icons/intel/swp_famousbounty.png";
    }

    public String getEventName() {
        int daysLeft = (int)(180.0f - this.elapsedDays);
        String days = daysLeft > 0 ? ", " + daysLeft + " \u5929\u540e\u7ed3\u675f" : ", \u4ec5\u5269\u4e0d\u5230\u4e00\u5929";
        if (this.isDone()) {
            if (this.completed) {
                return "IBB: " + this.person.getName().getFullName() + " - \u5b8c\u6210";
            }
            return "IBB: " + this.person.getName().getFullName() + " - \u7ed3\u675f";
        }
        return "IBB: " + this.person.getName().getFullName() + " - " + Misc.getWithDGS((float)this.bountyCredits) + "\u00a2" + days;
    }

    public Color[] getHighlightColors(String stageId) {
        ArrayList<Color> result = new ArrayList<Color>(3);
        result.add(Global.getSettings().getColor("buttonShortcut"));
        if (stageId != null && stageId.startsWith("start_")) {
            result.add(Global.getSettings().getColor("buttonShortcut"));
        }
        if (Global.getSector().getPlayerFleet() != null && this.thisStage != null) {
            int dangerLevel;
            int powerLevel = SWP_Util.calculatePowerLevel(Global.getSector().getPlayerFleet());
            if (powerLevel < Math.round((float)(dangerLevel = SWP_FamousBountyEvent.calculatePowerLevel(this.thisStage)) * 0.25f)) {
                result.add(new Color(255, 0, 0));
            } else if (powerLevel < Math.round((float)dangerLevel * 0.5f)) {
                result.add(new Color(255, 85, 0));
            } else if (powerLevel < Math.round((float)dangerLevel * 0.75f)) {
                result.add(new Color(255, 170, 0));
            } else if (powerLevel < Math.round((float)dangerLevel * 1.0f)) {
                result.add(new Color(255, 255, 0));
            } else if (powerLevel < Math.round((float)dangerLevel * 1.5f)) {
                result.add(new Color(170, 255, 0));
            } else if (powerLevel < Math.round((float)dangerLevel * 2.0f)) {
                result.add(new Color(85, 255, 0));
            } else {
                result.add(new Color(0, 255, 0));
            }
        }
        return result.toArray(new Color[result.size()]);
    }

    public String[] getHighlights(String stageId) {
        ArrayList result = new ArrayList(3);
        this.addTokensToList(result, new String[]{"$bountyCredits"});
        if (stageId != null && stageId.startsWith("start_")) {
            this.addTokensToList(result, new String[]{"$daysLeft"});
        }
        if (Global.getSector().getPlayerFleet() != null && this.thisStage != null) {
            this.addTokensToList(result, new String[]{"$dangerLevel"});
        }
        return result.toArray(new String[result.size()]);
    }

    public void setParam(Object param) {
        this.market = (MarketAPI)param;
    }

    public FamousBountyStage getStage() {
        return this.thisStage;
    }

    public Map<String, String> getTokenReplacements() {
        Map map = super.getTokenReplacements();
        map.put("$bountyCredits", Misc.getDGSCredits((float)this.payment));
        map.put("$sender", "\u661f\u9645\u8d4f\u91d1\u59d4\u5458\u4f1a");
        map.put("$daysLeft", "" + (int)Math.max(1.0f, 180.0f - this.elapsedDays));
        map.put("$targetName", this.person.getName().getFullName());
        map.put("$targetRank", this.person.getRank());
        if (Global.getSector().getPlayerFleet() != null && this.thisStage != null) {
            int dangerLevel;
            int powerLevel = SWP_Util.calculatePowerLevel(Global.getSector().getPlayerFleet());
            String dangerString = powerLevel < Math.round((float)(dangerLevel = SWP_FamousBountyEvent.calculatePowerLevel(this.thisStage)) * 0.25f) ? "\u6781\u96be" : (powerLevel < Math.round((float)dangerLevel * 0.5f) ? "\u56f0\u96be" : (powerLevel < Math.round((float)dangerLevel * 0.75f) ? "\u8f83\u96be" : (powerLevel < Math.round((float)dangerLevel * 1.0f) ? "\u666e\u901a" : (powerLevel < Math.round((float)dangerLevel * 1.5f) ? "\u5bb9\u6613" : (powerLevel < Math.round((float)dangerLevel * 2.0f) ? "\u7b80\u5355" : "\u8f7b\u677e")))));
            map.put("$dangerLevel", dangerString);
        }
        if (this.targetDesc != null) {
            map.put("$targetDesc", this.targetDesc);
        }
        if (this.targetDescLong != null) {
            map.put("$targetDescLong", this.targetDescLong);
        }
        if (this.bountyFaction != null) {
            map.put("$targetFaction", this.bountyFaction.getDisplayName());
            map.put("$theTargetFaction", this.bountyFaction.getDisplayNameWithArticle());
            map.put("$targetFactionLong", this.bountyFaction.getDisplayNameLong());
            map.put("$theTargetFactionLong", this.bountyFaction.getDisplayNameLongWithArticle());
        }
        if (this.hideoutLocation != null) {
            if (this.hideoutLocation.getContainingLocation() instanceof StarSystemAPI) {
                map.put("$hideoutSystem", ((StarSystemAPI)this.hideoutLocation.getContainingLocation()).getBaseName());
            } else {
                map.put("$hideoutSystem", this.hideoutLocation.getContainingLocation().getName());
            }
            map.put("$hideout", this.hideoutLocation.getName());
        }
        if (SWPModPlugin.isExerelin) {
            map.put("$memberFactions", "\u591a\u6570\u6210\u5458\u52bf\u529b");
        } else {
            ArrayList<String> memberFactions = new ArrayList<String>(IBB_FACTIONS.size());
            for (String memberFacId : IBB_FACTIONS) {
                FactionAPI memberFac;
                try {
                    memberFac = Global.getSector().getFaction(memberFacId);
                }
                catch (Exception e) {
                    continue;
                }
                if (memberFac == null) continue;
                memberFactions.add(memberFac.getDisplayNameWithArticle());
            }
            map.put("$memberFactions", Misc.getAndJoined((String[])memberFactions.toArray(new String[memberFactions.size()])));
        }
        return map;
    }

    public void init(String type, CampaignEventTarget eventTarget) {
        super.init(type, eventTarget);
        this.thisStage = SWP_IBBTracker.getTracker().getLowestIncompleteStage();
        if (this.thisStage == null) {
            this.ended = true;
            return;
        }
        if ((SWP_IBBTracker.getTracker().isStagePosted(this.thisStage) || SWP_IBBTracker.getTracker().isStageBegun(this.thisStage)) && !SWPModPlugin.Param_LegacyIBB) {
            FamousBountyStage stage;
            float powerLevel = SWP_Util.calculatePowerLevel(Global.getSector().getPlayerFleet());
            int matchingStageNum = 0;
            int i = 0;
            while (i < FamousBountyStage.values().length && (float)SWP_FamousBountyEvent.calculatePowerLevel(stage = SWP_IBBTracker.getStage(i)) <= powerLevel) {
                matchingStageNum = i++;
            }
            int currentStageNum = this.thisStage.ordinal();
            int stageNum = matchingStageNum <= currentStageNum ? currentStageNum + Math.round(Math.abs((float)new Random().nextGaussian() * 2.0f)) : Math.max(MathUtils.getRandomNumberInRange((int)currentStageNum, (int)matchingStageNum), currentStageNum + Math.round(Math.abs((float)new Random().nextGaussian() * 2.0f)));
            for (stageNum = Math.max(currentStageNum, stageNum); stageNum > currentStageNum; --stageNum) {
                FamousBountyStage stage2 = SWP_IBBTracker.getStage(stageNum);
                if (SWP_IBBTracker.getTracker().isStageAvailable(stage2)) break;
            }
            this.thisStage = SWP_IBBTracker.getStage(stageNum);
            if (this.thisStage == null) {
                this.ended = true;
                return;
            }
        }
        if (!SWP_IBBTracker.getTracker().isStageAvailable(this.thisStage)) {
            this.ended = true;
            return;
        }
        this.messagePriority = MessagePriority.SECTOR;
        this.bountyFaction = Global.getSector().getFaction("famous_bounty");
        this.person = this.initPerson(this.bountyFaction);
        if (this.thisStage == null) {
            this.ended = true;
            return;
        }
        this.payment = this.bountyCredits = (float)this.thisStage.reward;
        this.\u5b83 = this.thisStage.machine;
        switch (this.thisStage) {
            case STAGE_UNDINE: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e24\u8258mod-\u62a4\u536b\u8230.";
                this.targetDescLong = "\u76ee\u6807, " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + ",\u636e\u8bf4\u6307\u6325\u7740\u7531\u4e00\u652f\u4e4c\u5408\u4e4b\u4f17\u7ec4\u6210\u7684\u5c0f\u578b\u8230\u961f, \u5305\u542b\u4e00\u7fa4\u53db\u53d8\u7684\u6d77\u76d7. \u4e3b\u8981\u7684\u5a01\u80c1\u662f " + this.person.getName().getLast() + "\u7684\u90a3\u5bf9\u72ec\u7279\u7684\u5f81\u4f10-\u7ea7,\u5e76\u4e14 " + this.heOrShe() + " \u5df2\u7528\u4e8e\u88ad\u51fb\u6c11\u7528\u8865\u7ed9\u8def\u7ebf.";
                break;
            }
            case STAGE_HADES: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u56db\u8258mod-\u8d27\u8230.";
                this.targetDescLong = "\u76ee\u6807, " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + ",\u636e\u8bf4\u62e5\u6709\u4e00\u652f\u5c0f\u578b\u6539\u88c5\u7684\u8d38\u6613\u5546\u961f, \u5e76\u5927\u591a\u90fd\u5c5e\u4e8e\u5176\u79c1\u4eba\u6240\u6709. \u800c " + this.person.getName().getLast() + " \u62e5\u6709\u7684\u90a3\u56db\u8258\u72ec\u7279\u7684\u5730\u72f1\u72ac-\u7ea7, \u662f " + this.heOrShe() + " \u51e0\u4e2a\u6708\u524d\u521a\u4ece\u67d0\u4f4d\u79c1\u4eba\u6536\u85cf\u5bb6\u624b\u4e2d\u5077\u8d70\u7684.";
                break;
            }
            case STAGE_PONY: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e24\u8258mod-\u8d27\u8230.";
                this.targetDescLong = "\u76ee\u6807, " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + ", \u5df2\u77e5\u62e5\u6709\u7740\u4e00\u652f\u79c1\u4eba\u8230\u961f, \u7531\u4e00\u5bf9\u72ec\u7279\u7684\u8d27\u8230\u4f5c\u4e3a\u65d7\u8230. \u5176\u4e2d\u662f\u4e00\u8258\u6539\u9020\u7248\u7684\u9aa1\u5b50-\u7ea7, \u548c " + this.person.getName().getLast() + " \u6700\u8fd1\u5077\u6765\u7684\u53e6\u4e00\u8258, \u72ec\u7279\u7684\u5854\u5c14\u82cf\u65af-\u7ea7. \u6ce8\u610f " + this.heOrSheCapital() + " \u662f\u4e00\u540d\u5371\u9669\u7684, \u4f1a\u4e0d\u62e9\u624b\u6bb5\u5730\u5c06\u661f\u57df\u5e26\u5165\u6df7\u4e71\u7684\u7f6a\u72af.";
                break;
            }
            case STAGE_ELDER_ORB: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e00\u8258mod-\u9a71\u9010\u8230.";
                this.targetDescLong = "\u76ee\u6807, " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + ", \u88ab\u6307\u63a7\u7eb5\u706b, \u8c0b\u6740, \u4fb5\u72af\u9690\u79c1\u800c\u88ab\u901a\u7f09. " + this.heOrSheCapital() + " \u4e0d\u4ec5\u662f\u4e00\u540d\u5371\u9669\u7684\u75af\u5b50, \u800c\u4e14\u56e0\u6700\u8fd1\u5728\u6267\u884c\u67d0\u4e9b\u5947\u5f02\u800c\u6050\u6016\u7684\u5b9e\u9a8c\u800c\u4f7f " + this.heOrShe() + " \u906d\u5230\u901a\u7f09. " + this.person.getName().getLast() + " \u76ee\u524d\u4e0d\u4ec5\u62e5\u6709\u4e00\u8258\u72ec\u7279\u7684\u773c\u9b54-\u7ea7, \u5e76\u4e14\u8fd8\u6709\u4e00\u652f\u5927\u578b\u8230\u961f\u4f9b " + this.hisOrHer() + " \u4f7f\u5524.";
                break;
            }
            case STAGE_FRACTURE: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e24\u8258mod-\u9a71\u9010\u8230.";
                this.targetDescLong = "\u76ee\u6807\u662f\u524d\u4efb\u7684\u72ee\u5fc3\u5b88\u536b\u8005\u519b\u5b98 " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + ", \u4e00\u5929, \u4ed6\u72c2\u5984\u7684\u5bf9\u6574\u7247\u661f\u57df\u5ba3\u6218. \u7ed3\u679c\u662f\u663e\u800c\u6613\u89c1\u7684, " + this.person.getName().getLast() + " \u73b0\u5728\u88ab\u5404\u52bf\u529b\u653f\u5e9c\u901a\u7f09. \u7531\u4e8e " + this.heOrSheCapital() + " \u62e5\u6709\u6539\u88c5\u7248\u7834\u7532-\u7ea7\u548c\u9524\u5934-\u7ea7\u5404\u4e00\u8258, \u4e5f\u8ba9 " + this.himOrHer() + " \u6210\u4e3a\u4e86\u4e00\u540d\u5371\u9669\u7684\u89d2\u8272.";
                break;
            }
            case STAGE_LIBERTY: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e00\u8258mod-\u5de1\u6d0b\u8230.";
                this.targetDescLong = "\u76ee\u6807, " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + ", \u66fe\u7ecf\u662f\u540d\u53d7\u4eba\u5c0a\u656c\u7684\u9886\u8896. \u53ef\u5982\u4eca " + this.heOrShe() + " \u56e0\u5931\u53bb\u4e86\u7406\u667a, \u5bfc\u81f4 " + this.hisOrHer() + " \u4ee5\u4e00\u4e2a\u865a\u6784\u7684\u5e1d\u56fd\u540d\u4e49, \u5bf9\u6240\u6709\u52bf\u529b\u53d1\u52a8\u653b\u51fb. " + this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u8258\u72ec\u4e00\u65e0\u4e8c\u7684\u5de1\u6d0b\u8230, \u548c\u4e00\u7fa4\u88ab\u6d17\u8111\u7684\u4eb2\u4fe1\u6240\u9a7e\u9a76\u7684\u8230\u961f.";
                break;
            }
            case STAGE_RAPTOR: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e00\u8258mod-\u5de1\u6d0b\u8230 \u548c\u4e00\u8258mod-\u9a71\u9010\u8230.";
                this.targetDescLong = "\u76ee\u6807, " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + ", \u662f\u4e00\u540d\u9000\u4f11\u6d77\u519b\u4e0a\u5c06\u7684\u513f\u5b50. " + this.heOrShe() + " \u5229\u7528\u6240\u638c\u63e1\u7684\u7279\u6743, \u800c\u83b7\u5f97\u4e86 " + this.person.getName().getLast() + " \u68a6\u5bd0\u4ee5\u6c42\u7684\u6539\u9020\u7248\u730e\u9e70-\u7ea7\u548c\u7f8e\u675c\u838e-\u7ea7. \u73b0\u5728, " + this.person.getName().getLast() + " \u8e29\u7740\u6bc1\u706d\u7684\u6b65\u4f10, \u6467\u6bc1\u7740 " + this.heOrShe() + " \u80fd\u902e\u5230\u7684\u6bcf\u4e00\u652f\u8230\u961f.";
                break;
            }
            case STAGE_BULLSEYE: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e24\u8258\u6539\u9020\u7248\u6218\u5217\u8230, \u56db\u8258\u6539\u9020\u7248\u9a71\u9010\u8230, \u56db\u8258\u6539\u9020\u7248\u62a4\u536b\u8230.";
                this.targetDescLong = "\u76ee\u6807, P.A.C.K \u4e0a\u5c06 " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + ", \u636e\u79f0\u66fe\u7ecf\u56e0\u672c\u4eba\u8981\u6c42 " + this.hisOrHer() + " \u5bf9\u81ea\u5df1\u505a\u4e86\u4e00\u4e2a\u57fa\u56e0\u62fc\u63a5\u624b\u672f. \u7136\u800c " + this.person.getName().getLast() + " \u7684\u624b\u672f\u56e0\u672a\u77e5\u539f\u56e0\u800c\u5931\u8d25\u4e86, \u4e5f\u8ba9\u65e0\u6cd5\u63a5\u53d7\u73b0\u5b9e\u7684 " + this.heOrShe() + " \u75af\u72c2\u7684\u5c06\u4e00\u6279\u8230\u8239\u6539\u9020\u540e, \u7528\u4e8e\u6253\u51fb\u65e0\u8f9c\u7684\u8f68\u9053\u7a7a\u95f4\u7ad9. \u6ce8\u610f: " + this.person.getName().getLast() + "\u7684\u8230\u961f\u4e3b\u8981\u7531 P.A.C.K \u7684\u519b\u8230\u7ec4\u6210; \u800c " + this.person.getName().getLast() + " \u4e5f\u662f\u5c11\u6570\u4e0d\u62e5\u6709MOD-\u8230\u8239\u7684\u76ee\u6807. \u76f8\u5e94\u7684, \u8fd9\u65b9\u9762\u7684\u96be\u5ea6\u8bc4\u4f30\u4e5f\u4f1a\u8fdb\u884c\u8c03\u6574.";
                break;
            }
            case STAGE_APEX: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e00\u8258mod-\u5de1\u6d0b\u8230.";
                this.targetDescLong = "\u76ee\u6807, " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + ", \u662f\u4e00\u4f4d\u8457\u540d\u7684\u6218\u6597\u82f1\u96c4, \u4ee5\u4e00\u624b\u4e4b\u529b\u5e73\u606f\u4e86 Byth \u7684\u53db\u4e71\u800c\u95fb\u540d. \u7136\u800c, " + this.heOrShe() + " \u540e\u6765\u4e0d\u5e78\u60a3\u4e0a\u4e86\u7cbe\u795e\u5206\u88c2\u75c7, \u6700\u7ec8\u53ec\u5524\u4e86\u81ea\u5df1\u5fe0\u5b9e\u7684\u8ffd\u968f\u8005\u4eec\u4e0e " + this.hisOrHer() + " \u7684\u8001\u8230\u961f\u5bf9\u661f\u57df\u5c55\u5f00\u4e86\u4e00\u7cfb\u5217\u6218\u4e8b. \u8bf7\u6ce8\u610f: \u5c3d\u7ba1 " + this.person.getName().getLast() + "\u60a3\u6709\u7cbe\u795e\u969c\u788d, \u4f46 " + this.heOrShe() + " \u4f9d\u65e7\u662f\u540d\u6280\u672f\u7cbe\u6e5b\u7684\u6307\u6325\u5b98\u517c\u98de\u884c\u5458. \u4e14\u62e5\u6709\u4e00\u8258\u6539\u9020\u7248\u7684\u96c4\u9e70-\u7ea7.";
                break;
            }
            case STAGE_EMPEROR: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e00\u8258mod-\u5de1\u6d0b\u8230 \u548c\u56db\u8258mod-\u70ae\u8247.";
                this.targetDescLong = "\u76ee\u6807, " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + ", \u66fe\u662f\u4e00\u4e2a\u53cc\u91cd\u7279\u5de5, \u4f5c\u4e3a\u4e00\u540d\u9738\u4e3b\u6307\u6325\u5b98\u7684\u540c\u65f6\u79d8\u5bc6\u4e3a\u901f\u5b50\u79d1\u6280\u670d\u52a1. \u5c3d\u7ba1 " + this.heOrSheCapital() + " \u6700\u7ec8\u80cc\u53db\u4e86\u901f\u5b50\u79d1\u6280, \u4f46\u5f88\u4e0d\u5e78, " + this.hisOrHer() + " \u8fd9\u65f6\u5374\u88ab\u9738\u4e3b\u6b63\u5f0f\u5ba3\u5e03\u4e3a\u53db\u56fd\u7f6a. \u73b0\u5728, " + this.person.getName().getLast() + " \u88ab\u4e24\u4e2a\u52bf\u529b\u5171\u540c\u60ac\u8d4f. \u4e0d\u8fc7 " + this.heOrSheCapital() + " \u51ed\u501f\u7740 " + this.hisOrHer() + " \u6240\u62e5\u6709\u7684\u4e00\u8258\u6539\u9020\u7248\u7edf\u6cbb\u8005-\u7ea7\u548c\u56db\u8258\u6539\u9020\u7248\u7684\u70ae\u8247\u4e3a\u4e3b\u529b, \u5e76\u5fe0\u8bda\u4e8e " + this.hisOrHer() + " \u7684\u8230\u961f, \u4e5f\u8ba9\u5927\u90e8\u5206\u8d4f\u91d1\u730e\u4eba\u671b\u800c\u5374\u6b65.";
                break;
            }
            case STAGE_GULF: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e00\u8258mod-\u5de1\u6d0b\u8230.";
                this.targetDescLong = "\u76ee\u6807, " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + " \u88ab \u6076\u9b54\u822a\u7535 \u4ee5\u53db\u56fd\u7f6a\u800c\u901a\u7f09. \u5c3d\u7ba1\u5728\u6b63\u5e38\u60c5\u51b5\u4e0b, \u56fd\u9645\u8d4f\u91d1\u59d4\u5458\u4f1a\u4e0d\u4f1a\u53d7\u7406 \u6076\u9b54\u822a\u7535 \u63d0\u4f9b\u7684\u60ac\u8d4f, \u53ef\u7531\u4e8e  " + this.person.getName().getLast() + " \u65e0\u5dee\u522b\u7684\u653b\u51fb\u59d4\u5458\u4f1a\u65d7\u4e0b\u7684\u57fa\u7840\u8bbe\u65bd, \u9020\u6210\u4e86\u4e0d\u53ef\u4f30\u91cf\u7684\u635f\u5931. \u56e0\u6b64\u5728 " + this.heOrShe() + " \u9020\u6210\u66f4\u591a\u7834\u574f\u524d,  \u6240\u6709 IBB \u6210\u5458\u52bf\u529b\u8feb\u5207\u7684\u60f3\u8981\u5c06\u4ed6\u5c3d\u65e9\u51fb\u6740. " + this.person.getName().getLast() + " \u6307\u6325\u6709\u4e00\u652f\u5927\u578b\u6076\u9b54\u8230\u961f, \u800c " + this.hisOrHer() + " \u5219\u9a7e\u9a76\u8fd9\u4e00\u8258\u72ec\u7279\u7684\u75be\u98ce-\u7ea7.";
                break;
            }
            case STAGE_FRAMEBREAKER: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e00\u8258mod-\u6218\u5217\u8230 \u548c\u4e24\u8258mod-\u5de1\u6d0b\u8230.";
                this.targetDescLong = "\u76ee\u6807, " + this.person.getName().getFirst() + " \"\u56fd\u738b\" " + this.person.getName().getLast() + ", \u5c06 " + this.himOrHer() + "\u81ea\u5df1\u4e00\u540d\u5362\u5fb7\u5148\u77e5, \u5e76\u4ee5\u6b64\u83b7\u5f97\u5927\u91cf\u7684\u72c2\u4fe1\u5f92. \u968f\u7740 " + this.hisOrHerCapital() + " \u7684\u8fd9\u4e9b\u4fe1\u5f92\u4eec\u4e0d\u65ad\u5730\u5bf9\u6240\u6709\u52bf\u529b\u7684\u5de1\u903b\u961f\u5e26\u6765\u9ebb\u70e6, \u5e76\u5728\u8fde\u7eed\u7684\u51b2\u7a81\u5347\u7ea7\u4e2d " + this.person.getName().getLast() + " to the IBB list. King " + this.person.getName().getLast() + " \u6307\u6325\u8005\u4e00\u8258\u5b8c\u5168\u7531\u72c2\u70ed\u5206\u5b50\u6539\u88c5\u8fc7\u7684\u7684\u653b\u52bf-\u7ea7. \u6b64\u5916 " + this.heOrSheCapital() + " \u8fd8\u62e5\u6709\u4e24\u8258\u7531\u4eb2\u4fe1\u9a7e\u9a76\u5e76\u6539\u88c5\u8fc7\u7684\u7edf\u6cbb\u8005-\u7ea7.";
                break;
            }
            case STAGE_LEVIATHAN: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e00\u8258mod-\u822a\u6bcd\u548c\u4e24\u8258mod-\u71c3\u6599\u8fd0\u8f93\u8230.";
                this.targetDescLong = "\u76ee\u6807, " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + ", \u66fe\u662f\u4e00\u540d\u4ebf\u4e07\u8eab\u5bb6\u7684\u8d38\u6613\u5927\u4ea8. \u4e0d\u8fc7, " + this.heOrShe() + " \u6700\u8fd1\u56e0\u88ab\u66dd\u5149\u5229\u7528\u98df\u7269\u77ed\u7f3a\u548c\u9ed1\u5e02\u725f\u5229\u800c\u9677\u5165\u4e0e\u6570\u4e2a\u653f\u5e9c\u7684\u51b2\u7a81\u4e2d. " + this.person.getName().getLast() + " \u76ee\u524d\u5728\u9003, \u4ee5\u6539\u88c5\u540e\u7684\u963f\u7279\u62c9\u65af-\u7ea7\u4e3a\u65d7\u8230\u6307\u6325\u7740\u4e00\u652f\u5e9e\u5927\u7684\u79c1\u6709\u8230\u961f. \u6b64\u5916 " + this.heOrSheCapital() + " \u8fd8\u62e5\u6709\u4e24\u8258\u6539\u9020\u7248\u7684\u8f89\u817e-\u7ea7.";
                break;
            }
            case STAGE_POSEIDON: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e00\u8258mod-\u822a\u6bcd.";
                this.targetDescLong = "\u76ee\u6807, " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + ", \u662f\u4e00\u540d\u5728\u9003\u6570\u5e74\u7684\u8457\u540d\u6050\u6016\u5206\u5b50. \u73b0\u5728, IBB\u53d1\u5e03\u8d4f\u91d1\u8981 " + this.hisOrHer() + " \u7684\u6027\u547d, \u8981\u6c42\u96c7\u4f63\u519b\u548c\u8d4f\u91d1\u730e\u4eba\u6765\u9664\u6389\u8fd9\u4e2a\u5371\u9669\u7684\u5bb6\u4f19. \u5728 " + this.hisOrHer() + " \u7684\u5927\u578b\u8230\u961f\u4e2d, " + this.person.getName().getLast() + " \u62e5\u6709\u4e00\u8258\u6539\u9020\u7248\u7684\u822a\u6bcd, \u636e\u8bf4\u662f " + this.heOrShe() + " \u4ece \u9ed1\u77f3\u8239\u575e \u63a0\u5f97, \u5e76\u4e14 " + this.heOrShe() + "\u8fd8\u5c06\u5c06\u6467\u6bc1\u5927\u534a\u7684\u8239\u4f53\u4fee\u597d, \u5e76\u4f7f\u5176\u6295\u5165\u4f7f\u7528.";
                break;
            }
            case STAGE_ILIAD: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e00\u8258mod-\u6218\u5217\u5de1\u6d0b\u8230 \u548c\u4e00\u8258mod-\u5de1\u6d0b\u8230.";
                this.targetDescLong = "\u76ee\u6807, " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + ", \u8fc7\u53bb\u662f\u4e00\u4e2a\u8457\u540d\u7684\u6307\u6325\u5b98, \u56e0\u4f24\u75c5\u4e00\u76f4\u5750\u7740\u8f6e\u6905, \u6700\u7ec8\u4e4b\u6218\u7559\u4e0b\u7684\u4f24\u75db\u65e0\u65f6\u65e0\u523b\u6298\u78e8\u7740 " + this.hisOrHer() + " \u7684\u5185\u5fc3, \u5982\u4eca, " + this.heOrShe() + " \u4e3a\u4e86\u5bfb\u6c42\u6062\u590d " + this.hisOrHer() + " \u6614\u65e5\u7684\u8363\u8000, \u9677\u5165\u75af\u72c2\u7684 " + this.hisOrHer() + " \u6307\u6325\u65d7\u4e0b\u7684\u65e0\u654c\u8230\u961f\u5728\u661f\u57df\u4e2d\u6a2a\u51b2\u76f4\u649e, \u5e76\u5c3d\u53ef\u80fd\u7684\u9020\u6210\u7834\u574f. " + this.person.getName().getLast() + " \u6307\u6325\u7740 " + this.hisOrHer() + " \u6539\u9020\u540e\u7684\u5965\u5fb7\u8d5b-\u7ea7\u548c\u6781\u5149-\u7ea7, \u4e5f\u4f7f " + this.hisOrHer() + " \u7684\u8230\u961f\u6781\u5176\u5371\u9669.";
                break;
            }
            case STAGE_OLYMPUS_X: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e00\u8258mod-\u5bfc\u5f39\u5e73\u53f0 \u548c\u516b\u8258mod-\u9a71\u9010\u8230.";
                this.targetDescLong = "\u76ee\u6807, " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + ", \u662f\u4e00\u540d\u4e0d\u77e5\u54ea\u91cc\u94bb\u51fa\u7684\u6076\u68cd. \u73b0\u5728 " + this.hisOrHerCapital() + " \u9886\u5bfc\u8005\u4e00\u652f\u5927\u578b\u5e1d\u56fd\u8230\u961f, \u5e76\u8fdb\u884c\u7740\u5927\u89c4\u6a21\u6740\u4f24\u7684\u4efb\u52a1. \u8bf7\u52a1\u5fc5\u5728 " + this.person.getName().getLast() + " \u4eb2\u624b\u7531 " + this.hisOrHer() + " \u6539\u9020\u7684\u5965\u6797\u5339\u65af-\u7ea7 \u9020\u6210\u66f4\u591a\u6c38\u4e45\u6027\u7834\u574f\u524d\u6467\u6bc1\u4ed6. \u8bf7\u6ce8\u610f: " + this.person.getName().getLast() + "\u7684\u8230\u961f\u8fd8\u62e5\u6709\u516b\u8258\u6539\u9020\u7248\u7684 \u7981\u536b\u519b-\u7ea7\u4f5c\u4e3a\u4ed6\u7684\u62a4\u822a\u7f16\u961f.";
                break;
            }
            case STAGE_FRANKENSTEIN: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e00\u8258mod-\u5de1\u6d0b\u8230.";
                this.targetDescLong = "\u76ee\u6807, " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + "\u5148\u751f, \u5728\u6700\u8fd1\u7ee7\u627f\u4e86\u4e00\u5927\u7b14\u8d22\u4ea7, \u4ee5\u53ca\u7531 " + this.hisOrHer() + "  \u7236\u4eb2\u6539\u9020\u6210\u7684\u5de1\u6d0b-\u8230, \u8fd9\u8258\u88ab\u65c1\u4eba\u79f0\u4e4b\u4e3a \u90aa\u6076\u805a\u5408\u4f53\u7684\u602a\u5f02\u5de1\u6d0b\u8230, \u4f3c\u4e4e\u9690\u85cf\u7740\u5df2\u6545\u7236\u4eb2\u7684\u6240\u6709\u79d8\u5bc6, \u4e3a\u4e86\u4e00\u63a2\u7a76\u7adf, \u5e74\u8f7b\u7684 " + this.person.getName().getLast() + ",\u8fd9\u540d\u66fe\u7ecf\u53d7\u4eba\u5c0a\u656c\u7684\u9a91\u58eb \u4ec5\u5728\u6570\u5929\u5185\u5c31\u9677\u5165\u4e86\u75af\u72c2, \u6ca1\u6709\u4eba\u77e5\u9053\u7aa5\u63a2\u5230\u201c\u771f\u7406\u201d\u7684 " + this.heOrShe() + " \u662f\u5982\u4f55\u6027\u60c5\u5927\u53d8, \u4f46\u662f\u65e9\u5df2\u5815\u843d\u7684\u9a91\u58eb \u5df2\u7ecf\u6c89\u9189\u4e8e\u72c2\u4e71\u7684\u4eab\u4e50\u4e4b\u4e2d, \u5e76\u5bfc\u81f4\u65e0\u6570\u4eba\u7684\u6b7b\u4ea1, \u5982\u4eca " + this.hisOrHer() + " \u73b0\u5728\u88ab\u4e00\u5927\u6279\u88c5\u5907\u7cbe\u70bc\u7684\u6d77\u76d7\u8ddf\u968f\u5e76\u4fdd\u62a4\u7740.";
                break;
            }
            case STAGE_LUCIFER: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e24\u8258mod-\u76f8\u4f4d\u5de1\u6d0b\u8230, \u56db\u8258mod-\u76f8\u4f4d\u9a71\u9010\u8230 \u548c\u516b\u8258mod-\u76f8\u4f4d\u62a4\u536b\u8230.";
                this.targetDescLong = "\u76ee\u6807, " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + " ,\u5728\u4e00\u6b21\u5931\u8d25\u7684\u901f\u5b50\u963f\u5c14\u6cd5\u4eba\u5de5\u667a\u80fd\u5b9e\u9a8c\u4e2d, " + this.heOrShe() + " \u8d81\u4e71\u5077\u4e86\u73cd\u8d35\u7684\u539f\u5f62\u76f8\u4f4d\u6838\u5fc3\u8ba1\u5212. \u5c3d\u7ba1\u4e0d\u4e45\u540e\u5c31\u88ab\u53d1\u73b0, \u4f46 " + this.person.getName().getLast() + " \u8fd0\u7528\u4e86\u8be5\u6280\u672f, \u6253\u9020\u4e86\u4e00\u652f\u5168\u90e8\u7531\u76f8\u4f4d\u6218\u8230\u7ec4\u6210\u7684\u5f3a\u5927\u8230\u961f. \u5982\u4eca " + this.hisOrHerCapital() + " \u7684\u5b58\u5728\u5df2\u7ecf\u8feb\u4f7fIBB\u5ba3\u5e03\u5c06\u5176\u4f5c\u4e3a A \u7ea7\u5934\u53f7\u8d4f\u91d1\u7f6a\u72af.";
                break;
            }
            case STAGE_ODIN: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e00\u8258mod-\u6218\u5217\u5de1\u6d0b\u8230\u548c\u516d\u8258mod-\u9a71\u9010\u8230.";
                this.targetDescLong = "\u76ee\u6807 " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + ". \u4f5c\u4e3a\u4e00\u79cd\u53e4\u8001\u7684\u4eba\u5de5\u667a\u80fd, " + this.heOrShe() + " \u8be6\u7ec6\u6570\u636e\u672a\u77e5, \u4f46\u5f88\u53ef\u80fd\u8bde\u751f\u4e8e\u201c\u5927\u5d29\u584c\u201d\u4e4b\u524d. \u540e\u6765, " + this.person.getName().getLast() + " \u4e0d\u4ec5\u6536\u8d2d\u4e86\u4e00\u652f\u5927\u578b\u6742\u724c\u8230\u961f, \u5e76\u5411\u661f\u57df\u6563\u64ad\u6218\u706b, " + this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f\u5927\u578b\u6742\u724c\u8230\u961f, \u5e76\u7531\u4e00\u8258\u6539\u9020\u7248\u7684\u5bc6\u7c73\u5c14-\u7ea7 \u548c\u516d\u8258\u6bd4\u7d22\u7687\u5973-\u7ea7\u62c5\u4efb\u4e3b\u529b.";
                break;
            }
            case STAGE_EUPHORIA: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u62ec\u4e00\u8258MOD-\u822a\u6bcd \u548c\u516d\u652fMOD-\u6218\u6597\u8054\u961f.";
                this.targetDescLong = "\u76ee\u6807, \u8457\u540d\u7684\u6bd2\u54c1\u5927\u4ea8 " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + ", \u88ab\u4ee5\u6050\u6016\u4e3b\u4e49\u548c\u53cd\u4eba\u7c7b\u7f6a\u800c\u906d\u5230\u63a7\u8bc9\u5e76\u88ab\u901a\u7f09. \u7531\u4e8e " + this.heOrSheCapital() + " \u66fe\u7ecf\u6d17\u52ab\u4e86 \u901f\u5b50\u79d1\u6280 \u7684\u5236\u836f\u4e2d\u5fc3, \u6740\u5bb3\u4e86\u6210\u5343\u4e0a\u4e07\u7684\u5e95\u5c42\u52b3\u52a8\u8005, \u5e76\u51fb\u57ae\u4e86\u81f3\u5c11\u4e00\u4e2a\u4e16\u754c\u7684\u7ecf\u6d4e\u547d\u8109. " + this.person.getName().getLast() + " \u88ab\u66dd\u4e0e \u661f\u5149\u7ed3\u793e \u6709\u5bc6\u5207\u7684\u5408\u4f5c\u5f80\u6765, \u5e76\u4ece\u4e2d\u6536\u8d2d\u4e86\u4e0d\u5c11\u9ad8\u7aef\u6218\u8230\u4ee5\u53ca\u5927\u91cf\u8230\u961f. \u6240\u4ee5\u8bf7\u4e07\u5206\u5c0f\u5fc3. " + this.person.getName().getLast() + " \u7684\u6700\u65b0\u7ebf\u7d22, " + this.heOrShe() + " \u6700\u540e\u4e00\u6b21\u9732\u9762\u66fe\u6307\u6325\u8005\u4e00\u8258\u72ec\u7279\u7684\u661f\u4f53-\u7ea7\u548c\u516d\u67b6\u72ec\u7279\u7684\u9ec4\u8702-\u6218\u6597\u8054\u961f.";
                break;
            }
            case STAGE_CLERIC: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e00\u8258mod-\u590d\u4ec7\u8005.";
                this.targetDescLong = "\u76ee\u6807, " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + ", \u662f\u4e00\u540d\u9677\u5165\u6b67\u9014\u7684 \u5723\u6bbf\u9a91\u58eb \u9886\u5bfc\u8005. \u867d\u7136\u8fd9\u901a\u5e38\u662f\u503c\u5f97\u5e86\u795d\u7684, \u4f46\u4e8b\u5b9e\u4e0a " + this.hisOrHer() + " \u5bf9\u81ea\u8eab\u7684\u5b9a\u4f4d\u4f9d\u65e7\u662f\u5236\u88c1 Domain. \u5e76\u4e14\u75af\u72c2\u7684 " + this.person.getName().getLast() + " \u66fe\u626c\u8a00\u8981\u8bd5\u56fe\u6bc1\u706d\u4e00\u5207, \u56e0\u6b64\u9274\u4e8e " + this.heOrShe() + " \u5f53\u524d\u7684\u60c5\u51b5\u4f7fIBB\u653e\u51fa\u4e86\u7a7a\u524d\u4ef7\u503c\u7684\u8d4f\u91d1\u6765\u5f81\u6c42 " + this.person.getName().getLast() + "\u7684\u8111\u888b. \u503c\u5f97\u4e00\u63d0\u7684\u662f " + this.hisOrHer() + " \u7684\u8230\u961f\u4e0d\u4ec5\u65e0\u6bd4\u5de8\u5927, \u4e14\u5305\u62ec\u4e00\u8258\u6765\u6e90\u4e0d\u660e\u7684\u6539\u9020\u7248\u5723\u9a91\u58eb. \u8bf7\u6253\u5341\u4e8c\u4e07\u5206\u7684\u5c0f\u5fc3.";
                break;
            }
            case STAGE_YAMATO: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e00\u8258mod-\u6218\u5217\u5de1\u6d0b\u8230.";
                this.targetDescLong = "\u76ee\u6807, " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + ", \u662f\u4e00\u4f4d\u8457\u540d\u7684\u6218\u4e89\u8001\u5175, \u4f46\u73b0\u5728 " + this.heOrShe() + " \u4e0d\u77e5\u7406\u7531\u7684\u53cd\u5bf9 \u6240\u6709\u52bf\u529b\u6210\u7acb\u7684\u653f\u5e9c. \u5982\u4eca " + this.person.getName().getLast() + " \u5e26\u7740\u5e9e\u5927\u7684\u79c1\u4eba\u8230\u961f\u5f00\u59cb\u5bf9\u6240\u6709\u52bf\u529b\u5c55\u5f00\u75af\u72c2\u6253\u51fb.  \u636e\u79f0 " + this.heOrSheCapital() + " \u6307\u6325\u7740\u4e00\u8258\u72ec\u7279\u7684\"\u4e0a\u5e1d\"\u4f5c\u4e3a\u65d7\u8230, \u80fd\u4e0e\u8fd9\u8258\u8457\u540d\u6218\u8230\u4e3a\u654c \u4e5f\u8bb8\u662f\u4f60\u5728\u5176\u6f2b\u957f\u7684\u804c\u4e1a\u751f\u6daf\u4e2d \u4e0d\u53ef\u591a\u89c1\u7684\u8bb8\u591a\u4f1f\u5927\u7684\u6218\u5f79.";
                break;
            }
            case STAGE_SPORESHIP: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e00\u8258\u5b62\u5b50\u6bcd\u8230.";
                this.targetDescLong = "\u76ee\u6807, " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + " ,\u662f\u4e00\u79cd\u4e0d\u77e5\u540d\u7684\u4eba\u5de5\u667a\u80fd\u6838\u5fc3, \u7406\u8bba\u4e0a\u6765\u8bf4\u5e94\u8be5\u662f\u7531\u4e00\u7ec4 \u963f\u5c14\u6cd5\u667a\u80fd\u6838\u5fc3 \u534f\u540c\u5de5\u4f5c\u7684\u805a\u5408\u4f53. " + this.heOrSheCapital() + " \u6700\u521d\u7684\u4f5c\u7528, \u5e94\u8be5\u662f\u4f5c\u4e3a Domain \u7eaa\u5143\u7684\u5927\u62d3\u5c55\u6b96\u6c11\u8fd0\u52a8\u4e2d,  \u626e\u6f14\u7740\u91cd\u8981\u89d2\u8272\u7684 Domain-\u5b62\u5b50\u6bcd\u8230\u7684\u64cd\u63a7\u7cfb\u7edf. " + this.person.getName().getLast() + "\u5c3d\u7ba1\u8fd9\u79cd\u65e9\u5df2\u9000\u5f79\u7684\u4e0d\u77e5\u5982\u4eca\u4e3a\u4f55\u8fd8\u5728\u8fd0\u4f5c, \u4f46 " + this.heOrShe() + " \u5374\u5728\u6700\u8fd1\u5f00\u59cb\u5927\u89c4\u6a21\u5efa\u9020 \u4e00\u652f\u5e9e\u5927\u7684\u5168\u81ea\u52a8\u8230\u961f. \u7167\u8fd9\u6837\u53d1\u5c55, \u5b83\u7684\u5b58\u5728\u4e25\u91cd\u8fdd\u53cd\u4e86 \u4eba\u5de5\u667a\u80fd\u7981\u4ee4\u7684\u591a\u9879\u6761\u6b3e, \u4e14\u8fd9\u4e9b\u6beb\u65e0\u7ea6\u675f\u7684\u6218\u4e89\u673a\u68b0 \u5bf9\u8fd9\u7247\u661f\u57df\u4e5f\u662f\u4e00\u79cd\u6781\u5927\u7684\u9690\u60a3. \u56e0\u6b64 IBB \u6210\u5458\u52bf\u529b\u7ecf\u8fc7\u8ba8\u8bba\u51b3\u5b9a, \u53d1\u5e03\u4e86\u5bf9\u8fd9\u4e2a\u81ea\u79f0 " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + " \u7684\u4eba\u5de5\u667a\u80fd\u7684\u60ac\u8d4f, \u5e76\u8981\u6c42\u6240\u6709\u8d4f\u91d1\u730e\u4eba\u5c3d\u5feb\u5c06\u5176\u6467\u6bc1.";
                break;
            }
            case STAGE_POPE: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + "  \u7684\u8230\u961f, \u5176\u4e2d\u5305\u542b\u4e86\u4e00\u8258mod-\u62e6\u622a\u8230.";
                this.targetDescLong = "\u6211\u4eec\u6ca1\u6709\u76ee\u6807 \u4efb\u4f55\u6709\u4ef7\u503c\u7684\u4fe1\u606f, " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + ", \u4f46\u6839\u636e " + this.hisOrHer() + " \u4e4b\u524d\u7684\u884c\u8e2a, \u53ef\u4ee5\u63a8\u6d4b\u51fa " + this.heOrShe() + " \u8fd0\u7528\u4e86\u67d0\u79cd\u65b9\u5f0f\u4e0e \u5362\u5fb7\u6559\u4f1a \u79d8\u5bc6\u7ed3\u76df, \u5e76\u5927\u81f4\u5224\u65ad\u51fa " + this.person.getName().getLast() + "\u7684\u8230\u961f\u7ec4\u6210.\u4f46\u8981\u5c0f\u5fc3 " + this.hisOrHer() + " \u62e5\u6709\u4e00\u652f\u975e\u5e38\u5e9e\u5927\u7684\u8230\u961f, \u5c24\u5176\u90a3\u8258\u72ec\u7279\u800c\u5de8\u5927\u7684\u4e3b\u529b\u8230.";
                break;
            }
            case STAGE_ZEUS: {
                this.targetDesc = this.person.getName().getLast() + " \u6307\u6325\u7740\u4e00\u652f " + this.fleetSizeString() + " \u7684\u8230\u961f, \u5176\u4e2d\u5305\u62ec\u4e24\u8258MOD-\u6218\u5217\u8230, \u4e00\u8258MOD-\u6218\u5217\u5de1\u6d0b\u8230 \u548c\u56db\u8258MOD-\u62a4\u536b\u8230.";
                this.targetDescLong = "\u91cd\u8981\u8b66\u544a: IBB \u521b\u59cb\u4eba " + this.person.getName().getFirst() + " " + this.person.getName().getLast() + " \u56e0\u64c5\u79bb\u804c\u5b88. \u56e0\u6b64\u5fc5\u987b\u5728\u4e8b\u6001\u5931\u63a7\u4e4b\u524d \u5c06\u6240\u6709\u53ef\u7528\u6218\u529b\u7d27\u6025\u53c2\u4e0e\u6253\u51fb  " + this.hisOrHer() + " \u7684\u8230\u961f, \u6ce8\u610f\uff1a " + this.heOrShe() + " \u7684\u5de8\u578b\u8230\u961f\u7531\u72ec\u6709\u7684 \u5178\u8303-\u7ea7\u3001 \u5f81\u670d\u8005-\u7ea7\u4ee5\u53ca \u653b\u52bf-\u7ea7\u62c5\u4efb\u4e3b\u529b. \u5efa\u8bae: " + this.person.getName().getLast() + " \u662f\u6700\u4f1f\u5927\u7684\u6218\u7565\u5bb6, \u4e14 " + this.heOrShe() + " \u4e5f\u662f\u661f\u57df\u4e2d\u6700\u8457\u540d\u7684\u8230\u8239\u8bbe\u8ba1/\u4fee\u6539\u5927\u5e08. \u4e0d\u4ec5\u5982\u6b64 " + this.heOrSheCapital() + " \u66f4\u662f\u6307\u6325\u7740\u661f\u57df\u4e2d\u73b0\u5b58\u89c4\u6a21\u6700\u5927, \u6700\u5148\u8fdb\u7684\u8230\u961f. \u4e0a\u5e1d\u4fdd\u4f51\u4f60, \u8d4f\u91d1\u730e\u4eba.";
                break;
            }
            default: {
                this.ended = true;
            }
        }
    }

    public boolean isDone() {
        return this.ended;
    }

    public void reportBattleOccurred(CampaignFleetAPI primaryWinner, BattleAPI battle) {
        if (!this.isEventStarted()) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        if (battle.isInvolved(this.fleet) && !battle.isPlayerInvolved() && (this.fleet.getFlagship() == null || this.fleet.getFlagship().getCaptain() != this.person)) {
            this.fleet.setCommander(this.fleet.getFaction().createRandomPerson());
            Global.getSector().reportEventStage((CampaignEventPlugin)this, "taken_end", this.market.getPrimaryEntity(), this.messagePriority);
            this.endEvent(false);
            return;
        }
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        if (!battle.isPlayerInvolved() || !battle.isInvolved(this.fleet) || battle.onPlayerSide(this.fleet)) {
            return;
        }
        if (this.fleet.getFlagship() != null && this.fleet.getFlagship().getCaptain() == this.person) {
            return;
        }
        RepLevel repLevel = playerFleet.getFaction().getRelationshipLevel(this.market.getFaction());
        if (!SWPModPlugin.isExerelin) {
            for (String ibbFaction : IBB_FACTIONS) {
                FactionAPI memberFac;
                try {
                    memberFac = Global.getSector().getFaction(ibbFaction);
                }
                catch (Exception e) {
                    continue;
                }
                if (memberFac == null || playerFleet.getFaction().getRelationshipLevel(memberFac).ordinal() <= repLevel.ordinal()) continue;
                repLevel = playerFleet.getFaction().getRelationshipLevel(memberFac);
            }
        }
        this.payment = (int)(this.bountyCredits * battle.getPlayerInvolvementFraction());
        if (this.payment <= 0.0f) {
            return;
        }
        this.completed = true;
        if (SWPModPlugin.isExerelin || repLevel.isAtWorst(RepLevel.SUSPICIOUS)) {
            String reportId = "bounty_payment_end";
            if (battle.getPlayerInvolvementFraction() < 1.0f) {
                reportId = "bounty_payment_share_end";
            }
            log.info((Object)String.format("%f \u7684\u8d4f\u91d1\u5df2\u7531\u661f\u9645\u8d4f\u91d1\u59d4\u5458\u4f1a\u652f\u4ed8", Float.valueOf(this.payment)));
            Global.getSector().reportEventStage((CampaignEventPlugin)this, reportId, this.market.getPrimaryEntity(), MessagePriority.ENSURE_DELIVERY, (OnMessageDeliveryScript)new BaseOnMessageDeliveryScript(){

                public void beforeDelivery(CommMessageAPI message) {
                    CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
                    playerFleet.getCargo().getCredits().add(SWP_FamousBountyEvent.this.payment);
                }
            });
        } else {
            log.info((Object)String.format("\u661f\u9645\u8d4f\u91d1\u59d4\u5458\u4f1a\u672a\u652f\u4ed8\u8d4f\u91d1", new Object[0]));
            Global.getSector().reportEventStage((CampaignEventPlugin)this, "bounty_no_payment_end", this.market.getPrimaryEntity(), MessagePriority.ENSURE_DELIVERY);
        }
        this.endEvent(false);
    }

    public void reportFleetDespawned(CampaignFleetAPI fleet, CampaignEventListener.FleetDespawnReason reason, Object param) {
        if (this.isDone()) {
            return;
        }
        if (this.fleet == fleet) {
            fleet.setCommander(fleet.getFaction().createRandomPerson());
            Global.getSector().reportEventStage((CampaignEventPlugin)this, "other_end", this.market.getPrimaryEntity(), this.messagePriority);
            this.endEvent(false);
        }
    }

    public void startEvent() {
        super.startEvent();
        if (this.person == null) {
            log.error((Object)"\u4e8b\u4ef6\u6fc0\u6d3b\u5931\u8d25: \u67e5\u65e0\u6b64\u4eba");
            this.endEvent(true);
            return;
        }
        this.faction = this.market.getFaction();
        this.eventTarget = new CampaignEventTarget(this.market);
        if (this.isDone()) {
            log.error((Object)"\u4e8b\u4ef6\u6fc0\u6d3b\u5931\u8d25: \u63d0\u524d\u7ed3\u675f");
            return;
        }
        this.pickHideoutLocation();
        if (this.isDone()) {
            log.error((Object)"\u4e8b\u4ef6\u6fc0\u6d3b\u5931\u8d25: \u85cf\u8eab\u5904\u4f4d\u7f6e\u65e0\u6548");
            return;
        }
        this.spawnFleet();
        SWP_IBBTracker.getTracker().reportStageBegan(this.thisStage);
        Global.getSector().reportEventStage((CampaignEventPlugin)this, "start", null, this.messagePriority, (OnMessageDeliveryScript)new BaseOnMessageDeliveryScript(){

            public void beforeDelivery(CommMessageAPI message) {
                if (SWP_FamousBountyEvent.this.hideoutLocation.getContainingLocation() instanceof StarSystemAPI) {
                    message.setStarSystemId(SWP_FamousBountyEvent.this.hideoutLocation.getContainingLocation().getId());
                }
            }
        });
        log.info((Object)String.format("Starting famous bounty for person %s", this.person.getName().getFullName()));
    }

    private String fleetSizeString() {
        int pts = this.thisStage.maxPts + this.thisStage.ptsFromBoss;
        if (pts < 10) {
            return "\u5f88\u5c0f";
        }
        if (pts < 20) {
            return "\u8f83\u5c0f";
        }
        if (pts < 40) {
            return "\u4e2d\u7b49";
        }
        if (pts < 60) {
            return "\u5927\u578b";
        }
        if (pts < 90) {
            return "\u5f88\u5927";
        }
        if (pts < 120) {
            return "\u5e9e\u5927";
        }
        return "\u8d85\u5927";
    }

    private String heOrShe() {
        if (this.\u5b83) {
            return "\u5b83";
        }
        if (this.person.getGender() == FullName.Gender.MALE) {
            return "\u4ed6";
        }
        return "\u5979";
    }

    private String heOrSheCapital() {
        if (this.\u5b83) {
            return "\u5b83";
        }
        if (this.person.getGender() == FullName.Gender.MALE) {
            return "\u4ed6";
        }
        return "\u5979";
    }

    private String himOrHer() {
        if (this.\u5b83) {
            return "\u5b83";
        }
        if (this.person.getGender() == FullName.Gender.MALE) {
            return "\u4ed6";
        }
        return "\u5979";
    }

    private String himOrHerCapital() {
        if (this.\u5b83) {
            return "\u5b83";
        }
        if (this.person.getGender() == FullName.Gender.MALE) {
            return "\u4ed6";
        }
        return "\u5979";
    }

    private String hisOrHer() {
        if (this.\u5b83) {
            return "\u5b83";
        }
        if (this.person.getGender() == FullName.Gender.MALE) {
            return "\u4ed6";
        }
        return "\u5979";
    }

    private String hisOrHerCapital() {
        if (this.\u5b83) {
            return "\u5b83";
        }
        if (this.person.getGender() == FullName.Gender.MALE) {
            return "\u4ed6";
        }
        return "\u5979";
    }

    private void pickHideoutLocation() {
        float emptyWeight = 1.0f;
        float occupiedWeight = 0.2f;
        for (float multMod = 1.0f; this.hideoutLocation == null && multMod <= 5.0f; multMod += 1.0f) {
            WeightedRandomPicker systemPicker = new WeightedRandomPicker();
            for (StarSystemAPI system : Global.getSector().getStarSystems()) {
                Object planet2;
                float weight = system.getPlanets().size();
                float mult = 1.0f;
                if (system.hasPulsar()) continue;
                if (system.hasTag("theme_misc_skip")) {
                    mult = 1.0f;
                } else if (system.hasTag("theme_misc")) {
                    mult = 3.0f;
                } else if (system.hasTag("theme_ruins")) {
                    mult = 7.0f;
                } else if (system.hasTag("theme_remnant_destroyed")) {
                    mult = 3.0f;
                }
                boolean viablePlanets = false;
                for (Object planet2 : system.getPlanets()) {
                    MarketAPI nearestMarket;
                    if (planet2.isStar() || (nearestMarket = SWP_FamousBountyEvent.findNearestMarket((SectorEntityToken)planet2, 3000.0f)) != null) continue;
                    viablePlanets = true;
                    break;
                }
                if (!viablePlanets) continue;
                boolean empty = true;
                planet2 = system.getPlanets().iterator();
                while (planet2.hasNext()) {
                    SectorEntityToken planet3 = (SectorEntityToken)planet2.next();
                    MarketAPI nearestMarket = SWP_FamousBountyEvent.findNearestMarket(planet3, 3000.0f);
                    if (nearestMarket != null || planet3.getMarket() == null || planet3.getMarket().isPlanetConditionMarketOnly()) continue;
                    empty = false;
                    break;
                }
                mult = empty ? (mult *= emptyWeight) : (mult *= occupiedWeight);
                if (mult <= 0.0f) continue;
                float minDist = 3000.0f + (float)(this.thisStage.ordinal() + 1) * 200.0f;
                float maxDist = 30000.0f + (float)(this.thisStage.ordinal() + 1) * 1000.0f;
                float dist = system.getLocation().length();
                float distMult = Math.max(0.0f, (maxDist *= multMod) - dist) / maxDist * (Math.max(0.0f, dist - (minDist /= multMod)) / minDist);
                systemPicker.add((Object)system, weight * mult * distMult);
            }
            StarSystemAPI system = (StarSystemAPI)systemPicker.pick();
            if (system == null) continue;
            WeightedRandomPicker picker = new WeightedRandomPicker();
            for (SectorEntityToken planet : system.getPlanets()) {
                MarketAPI nearestMarket;
                if (planet.isStar() || (nearestMarket = SWP_FamousBountyEvent.findNearestMarket(planet, 3000.0f)) != null) continue;
                picker.add((Object)planet);
            }
            this.hideoutLocation = (SectorEntityToken)picker.pick();
        }
        if (this.hideoutLocation == null) {
            log.info((Object)String.format("\u65e0\u6cd5\u627e\u5230 %s \u7684\u5177\u4f53\u85cf\u8eab\u4e4b\u5730", this.person.getName().getFullName()));
            this.endEvent(true);
        }
    }

    private void spawnFleet() {
        String fleetFactionId;
        float qf = this.thisStage.qf;
        float commanderLevel = this.thisStage.level;
        float officerLevel = this.thisStage.officerLevel;
        int officerCount = this.thisStage.officerCount;
        int maxPts = this.thisStage.maxPts;
        int ptsFromBoss = this.thisStage.ptsFromBoss;
        String fleetGenId = fleetFactionId = this.thisStage.fleetFaction;
        switch (fleetFactionId) {
            case "domain": {
                fleetGenId = "hegemony";
                break;
            }
            case "sector": {
                fleetGenId = "independent";
                break;
            }
            case "everything": {
                fleetGenId = "lions_guard";
                break;
            }
        }
        final FleetParams params = new FleetParams(this.hideoutLocation.getLocationInHyperspace(), this.market, fleetGenId, "famous_bounty", (float)Math.max(maxPts, 1), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, qf, 0.0f, 0, this.person, (int)commanderLevel);
        params.withOfficers = false;
        if (this.thisStage == FamousBountyStage.STAGE_SPORESHIP) {
            params.combatPts = (float)((double)params.combatPts * 0.67);
        }
        this.fleet = SWP_FleetFactory.enhancedCreateFleet(this.faction, Math.max(maxPts, 1) + ptsFromBoss, new SWP_FleetFactory.FleetFactoryDelegate(){

            @Override
            public CampaignFleetAPI createFleet() {
                return FleetFactoryV2.createFleet((FleetParams)params);
            }
        });
        String fleetName = this.person.getName().getFirst() + " " + this.person.getName().getLast() + " (IBB)";
        this.fleet.setName(fleetName);
        this.flagship = Global.getFactory().createFleetMember(FleetMemberType.SHIP, this.thisStage.flagship);
        this.flagshipName = this.thisStage.flagshipName;
        this.person.setPersonality(this.thisStage.personality);
        this.fleet.getMemoryWithoutUpdate().set("$banterText", (Object)this.thisStage.banterText);
        ArrayList<FleetMemberAPI> specialShips = new ArrayList<FleetMemberAPI>(10);
        switch (this.thisStage) {
            case STAGE_UNDINE: {
                FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_lasher_r_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Salamander");
                specialShips.add(member);
                break;
            }
            case STAGE_HADES: {
                FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_cerberus_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Dis");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_cerberus_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Sheol");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_cerberus_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Hell");
                specialShips.add(member);
                break;
            }
            case STAGE_PONY: {
                FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_tarsus_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Carpal");
                specialShips.add(member);
                break;
            }
            case STAGE_FRACTURE: {
                FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_hammerhead_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Phillipshead");
                specialShips.add(member);
                break;
            }
            case STAGE_RAPTOR: {
                FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_medusa_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Gorgon");
                specialShips.add(member);
                break;
            }
            case STAGE_BULLSEYE: {
                FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "pack_bulldog_bullseye_Bullseye");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Charlie");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "pack_pitbull_bullseye_Bullseye");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Buddy");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "pack_pitbull_bullseye_Bullseye");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Rocky");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "pack_komondor_bullseye_Bullseye");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Jake");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "pack_komondor_bullseye_Bullseye");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Jack");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "pack_schnauzer_bullseye_Bullseye");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Toby");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "pack_schnauzer_bullseye_Bullseye");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Cody");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "pack_schnauzer_bullseye_Bullseye");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Buster");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "pack_schnauzer_bullseye_Bullseye");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Duke");
                specialShips.add(member);
                break;
            }
            case STAGE_EMPEROR: {
                FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_brawler_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Boxer");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_brawler_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Fighter");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_brawler_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Fencer");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_brawler_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Wrestler");
                specialShips.add(member);
                break;
            }
            case STAGE_FRAMEBREAKER: {
                FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_dominator_luddic_path_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Ludd's Hammer");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_dominator_luddic_path_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Ludd's Wrath");
                specialShips.add(member);
                break;
            }
            case STAGE_LEVIATHAN: {
                FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_phaeton_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Clymene");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_phaeton_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Tethys");
                specialShips.add(member);
                break;
            }
            case STAGE_ILIAD: {
                FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_aurora_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Nebula");
                specialShips.add(member);
                break;
            }
            case STAGE_OLYMPUS_X: {
                FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ii_boss_praetorian_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Praefectum");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ii_boss_praetorian_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Secundus");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ii_boss_praetorian_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Tertius");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ii_boss_praetorian_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Quartus");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ii_boss_praetorian_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Quintus");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ii_boss_praetorian_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Sextus");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ii_boss_praetorian_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Septimus");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ii_boss_praetorian_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Octavus");
                specialShips.add(member);
                break;
            }
            case STAGE_LUCIFER: {
                this.fleet.getFleetData().clear();
                FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_doom_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Baphomet");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_euryale_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Euryale");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_euryale_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Moloch");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_euryale_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Asmodeus");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_euryale_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Mammon");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_afflictor_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Tormentor");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_afflictor_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Iblis");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_afflictor_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Dagon");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_afflictor_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Beelzebub");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_shade_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Phantom");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_shade_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Azazel");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_shade_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Apollyon");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_shade_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Samael");
                specialShips.add(member);
                break;
            }
            case STAGE_ODIN: {
                FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "msp_boss_potniaBis_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Maleficent");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "msp_boss_potniaBis_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Malevolent");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "msp_boss_potniaBis_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Malicious");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "msp_boss_potniaBis_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Nefarious");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "msp_boss_potniaBis_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Vicious");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "msp_boss_potniaBis_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Wicked");
                specialShips.add(member);
                break;
            }
            case STAGE_SPORESHIP: {
                params.factionId = "derelict";
                CampaignFleetAPI temp = SWP_FleetFactory.enhancedCreateFleet(this.faction, Math.max(maxPts, 1) + ptsFromBoss, new SWP_FleetFactory.FleetFactoryDelegate(){

                    @Override
                    public CampaignFleetAPI createFleet() {
                        return FleetFactoryV2.createFleet((FleetParams)params);
                    }
                });
                for (FleetMemberAPI member : temp.getFleetData().getMembersListCopy()) {
                    this.fleet.getFleetData().addFleetMember(member);
                }
                break;
            }
            case STAGE_ZEUS: {
                FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_conquest_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Nike");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_onslaught_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Ares");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_hyperion_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Helios");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_hyperion_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Solar");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_hyperion_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Planetar");
                specialShips.add(member);
                member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, "ssp_boss_hyperion_cus");
                this.fleet.getFleetData().addFleetMember(member);
                member.setShipName("Divinity");
                specialShips.add(member);
                break;
            }
        }
        FleetCompositionDoctrineAPI doctrine = this.faction.getCompositionDoctrine();
        float minLevel = officerLevel;
        minLevel -= minLevel * doctrine.getOfficerLevelVariance() * 0.5f;
        minLevel = (int)minLevel;
        if (minLevel < 1.0f) {
            minLevel = 1.0f;
        }
        float maxLevel = minLevel + minLevel * doctrine.getOfficerLevelVariance();
        if ((maxLevel = (float)((int)maxLevel)) < minLevel) {
            maxLevel = minLevel;
        }
        this.flagship.setShipName(this.flagshipName);
        this.fleet.getFleetData().addFleetMember(this.flagship);
        this.fleet.getFleetData().setFlagship(this.flagship);
        this.fleet.setCommander(this.person);
        this.flagship.setCaptain(this.person);
        this.fleet.setTransponderOn(true);
        this.fleet.removeAbility("go_dark");
        this.fleet.removeAbility("transponder");
        this.fleet.forceSync();
        SWP_FleetFactory.addCommanderAndOfficersFamous(officerCount, minLevel, maxLevel, this.fleet, specialShips, new Random());
        this.fleet.forceSync();
        float weight = FleetFactoryV2.getMemberWeight((FleetMemberAPI)this.fleet.getFlagship());
        float fighters = this.fleet.getFlagship().getVariant().getFittedWings().size();
        boolean wantCarrierSkills = weight > 0.0f && fighters / weight >= 0.5f;
        OfficerManagerEvent.SkillPickPreference pref = OfficerManagerEvent.SkillPickPreference.NON_CARRIER;
        if (wantCarrierSkills) {
            pref = OfficerManagerEvent.SkillPickPreference.CARRIER;
        }
        SWP_FleetFactory.levelOfficer(this.person, this.fleet.getFleetData(), this.thisStage.level, true, pref, new Random());
        FleetFactoryV2.addCommanderSkills((PersonAPI)this.person, (CampaignFleetAPI)this.fleet, (Random)new Random());
        this.person.setRankId(Ranks.SPACE_ADMIRAL);
        this.person.setPostId(Ranks.POST_FLEET_COMMANDER);
        this.fleet.getFleetData().sort();
        this.fleet.forceSync();
        this.fleet.updateCounts();
        HashMap<String, String> archetypeOverride = new HashMap<String, String>(specialShips.size());
        for (FleetMemberAPI member : specialShips) {
            archetypeOverride.put(member.getId(), "ULTIMATE");
        }
        ArrayList<String> noRandomize = new ArrayList<String>(1);
        noRandomize.add(this.flagship.getId());
        Misc.makeImportant((SectorEntityToken)this.fleet, (String)"swp_ibb", (float)180.0f);
        this.fleet.getMemoryWithoutUpdate().set("$level", (Object)Float.valueOf(commanderLevel));
        this.fleet.getMemoryWithoutUpdate().set("$opBonus", (Object)Float.valueOf(this.thisStage.opBonus));
        this.fleet.getMemoryWithoutUpdate().set("$fleetType", (Object)"famousBounty");
        if (this.thisStage == FamousBountyStage.STAGE_SPORESHIP) {
            this.fleet.getMemoryWithoutUpdate().set("$famousBountyFaction", (Object)"everything");
        } else {
            this.fleet.getMemoryWithoutUpdate().set("$famousBountyFaction", (Object)fleetFactionId);
        }
        this.fleet.getMemoryWithoutUpdate().set("$stillAlive", (Object)true);
        this.fleet.getMemoryWithoutUpdate().set("$ds_archetype_override", archetypeOverride);
        this.fleet.getMemoryWithoutUpdate().set("$ds_do_not_randomize", noRandomize);
        this.fleet.getMemoryWithoutUpdate().set("$stageName", (Object)this.thisStage.name());
        this.fleet.getMemoryWithoutUpdate().set("$cfai_makeAggressive", (Object)true);
        this.fleet.getMemoryWithoutUpdate().set("$fidConifgGen", (Object)new IBBInteractionConfigGen());
        this.fleet.setNoFactionInName(true);
        this.fleet.setFaction("neutral");
        FleetFactory.finishAndSync((CampaignFleetAPI)this.fleet);
        LocationAPI location = this.hideoutLocation.getContainingLocation();
        location.addEntity((SectorEntityToken)this.fleet);
        this.fleet.setLocation(this.hideoutLocation.getLocation().x - 500.0f, this.hideoutLocation.getLocation().y + 500.0f);
        this.fleet.getAI().addAssignment(FleetAssignment.ORBIT_AGGRESSIVE, this.hideoutLocation, 1000000.0f, null);
    }

    PersonAPI initPerson(FactionAPI bountyFaction) {
        PersonAPI bountyPerson = OfficerManagerEvent.createOfficer((FactionAPI)bountyFaction, (int)1, (boolean)true);
        bountyPerson.getName().setFirst(this.thisStage.firstName);
        bountyPerson.getName().setLast(this.thisStage.lastName);
        bountyPerson.getName().setGender(this.thisStage.gender);
        try {
            bountyPerson.setPortraitSprite(this.thisStage.portrait);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bountyPerson;
    }

    static {
        IBB_FACTIONS.add("hegemony");
        IBB_FACTIONS.add("persean");
        IBB_FACTIONS.add("interstellarimperium");
        IBB_FACTIONS.add("citadeldefenders");
        IBB_FACTIONS.add("shadow_industry");
        IBB_FACTIONS.add("tiandong");
        IBB_FACTIONS.add("ORA");
    }

    public static class IBBInteractionConfigGen
    implements FleetInteractionDialogPluginImpl.FIDConfigGen {
        public FleetInteractionDialogPluginImpl.FIDConfig createConfig() {
            FleetInteractionDialogPluginImpl.FIDConfig config = new FleetInteractionDialogPluginImpl.FIDConfig();
            config.showWarningDialogWhenNotHostile = false;
            config.impactsEnemyReputation = false;
            config.showFleetAttitude = false;
            config.pullInAllies = false;
            config.pullInEnemies = false;
            config.delegate = new FleetInteractionDialogPluginImpl.FIDDelegate(){

                public void battleContextCreated(InteractionDialogAPI dialog, BattleCreationContext bcc) {
                    bcc.enemyDeployAll = true;
                }

                public void notifyLeave(InteractionDialogAPI dialog) {
                }

                public void postPlayerSalvageGeneration(InteractionDialogAPI dialog, FleetEncounterContext context, CargoAPI salvage) {
                }
            };
            return config;
        }
    }

    public static enum FamousBountyStage {
        STAGE_UNDINE("Francis", "Butler", FullName.Gender.MALE, false, "graphics/swp/portraits/ibb_butler.png", SWP_Util.RequiredFaction.NONE, 52500, "ssp_boss_lasher_b_cus", "Undine", "reckless", 0.5f, 8, 6, 4, 8, 0.0f, 2, "pirates", "\u6240\u4ee5, \u4f60\u5c31\u662f\u6765\u62ff\u6211\u4eba\u5934\u7684\u8d4f\u91d1\u730e\u4eba. \u4f46\u4f60\u9a6c\u4e0a\u5c31\u4f1a\u53d1\u73b0 \u6211\u5e76\u4e0d\u662f\u4e00\u4e2a\u5bb9\u6613\u5f97\u624b\u7684\u730e\u7269!"),
        STAGE_HADES("Ryx", "Barlow", FullName.Gender.FEMALE, false, "graphics/swp/portraits/ibb_ryx.png", SWP_Util.RequiredFaction.NONE, 79500, "ssp_boss_cerberus_cus", "Hades", "steady", 0.5f, 12, 7, 4, 8, 0.0f, 4, "independent", "\u8fd9\u4e9b\u8239\u662f\u6211\u7684. \u4f60\u6c38\u8fdc\u522b\u60f3\u4ece\u6211\u8eab\u4e0a\u593a\u53bb!"),
        STAGE_PONY("Lisa", "Nanao", FullName.Gender.FEMALE, false, "graphics/swp/portraits/ibb_nanao.png", SWP_Util.RequiredFaction.NONE, 105000, "ssp_boss_mule_cus", "Pony", "cautious", 0.75f, 13, 8, 6, 12, 0.0f, 3, "independent", "\u6765\u4e00\u573a\u6b7b\u4ea1\u6e38\u620f, \u600e\u4e48\u6837!"),
        STAGE_ELDER_ORB("Ocula", "Gazer", FullName.Gender.FEMALE, false, "graphics/swp/portraits/ibb_gazer.png", SWP_Util.RequiredFaction.NONE, 140000, "ssp_boss_beholder_cus", "Elder Orb", "steady", 0.75f, 14, 10, 7, 18, 0.0f, 2, "sindrian_diktat", "\u563f, \u4f60\u80fd\u5148\u770b\u770b\u65f6\u95f4\u5417? \u6211\u60f3\u4f60\u4e4b\u540e\u7684\u6b7b\u4ea1\u8bc1\u660e\u4f1a\u7528\u5230\u8fd9\u4e9b."),
        STAGE_FRACTURE("Jaine", "Meredith", FullName.Gender.FEMALE, false, "graphics/swp/portraits/ibb_meredith.png", SWP_Util.RequiredFaction.NONE, 175000, "ssp_boss_sunder_cus", "Fracture", "steady", 0.5f, 15, 10, 6, 19, 0.0f, 4, "lions_guard", "\u6211\u5728\u6b64\u5411\u4f60\u5ba3\u6218, \u6307\u6325\u5b98. \u5168\u519b\u51fa\u51fb!"),
        STAGE_LIBERTY("Abrahamo", "Lincolni", FullName.Gender.MALE, false, "graphics/tiandong/portraits/tiandong_boss_abrahamo_lincolni.png", SWP_Util.RequiredFaction.TIANDONG, 160000, "tiandong_boss_wuzhang_Standard", "Liberty", "reckless", 0.5f, 16, 11, 6, 13, 0.0f, 6, "tiandong", "\u5f31\u8005\u4e0d\u914d\u62e5\u6709\u81ea\u7531!"),
        STAGE_RAPTOR("Blaize", "Rex", FullName.Gender.FEMALE, false, "graphics/swp/portraits/ibb_rex.png", SWP_Util.RequiredFaction.NONE, 235000, "ssp_boss_falcon_cus", "Raptor", "steady", 0.75f, 15, 12, 8, 31, 0.0f, 6, "independent", "\u8fd9\u4e9b\u90fd\u662f\u6211\u6700\u68d2\u7684\u8239. \u5982\u679c\u4f60\u6562\u52a8\u5b83\u4eec, \u6211\u4f1a\u8ba9\u4f60\u540e\u6094\u7684..."),
        STAGE_APEX("Mackie", "Corbin", FullName.Gender.MALE, false, "graphics/swp/portraits/ibb_corbin.png", SWP_Util.RequiredFaction.NONE, 220000, "ssp_boss_eagle_cus", "Apex", "aggressive", 0.75f, 18, 13, 7, 21, 0.0f, 5, "sindrian_diktat", "\u4f60\u548c\u4ed6\u4eec\u662f\u4e00\u4f19\u7684! \u654c\u4eba! \u51c6\u5907\u6b66\u5668! \u6218\u6597!"),
        STAGE_BULLSEYE("Max", "Bailey", FullName.Gender.MALE, false, "graphics/portraits/portrait_hegemony06.png", SWP_Util.RequiredFaction.JUNK_PIRATES, 300000, "pack_bulldog_bullseye_Bullseye", "Bullseye", "steady", 0.75f, 16, 11, 10, 32, 0.0f, 14, "pack", "\u54c7\u5594, \u653e\u8f7b\u677e, \u6df7\u86cb!"),
        STAGE_FRAMEBREAKER("Ned", "Ludd", FullName.Gender.MALE, false, "graphics/portraits/portrait_luddic00.png", SWP_Util.RequiredFaction.NONE, 350000, "ssp_boss_onslaught_luddic_path_cus", "Framebreaker", "reckless", 0.25f, 17, 13, 9, 48, 0.0f, 16, "luddic_path", "\u770b, \u6b63\u5982\u542f\u793a\u5f55\u4e3b\u6240\u9884\u8a00\u7684\u90a3\u6837, \u6211\u4eec\u8981\u505a\u4e00\u4ef6\u5343\u53e4\u7559\u540d\u7684\u5927\u4e8b. \u6211\u5c06\u5982\u70c8\u7130\u822c\u711a\u5c3d\u8fd9\u9ed1\u6697\u5b87\u5b99\u91cc\u7684\u6240\u6709\u7f6a\u6076! \u4eca\u5929, \u5728\u8fd9\u91cc, \u4e3b\u4e3a\u6211\u5e26\u6765\u4e86\u53e6\u4e00\u540d\u4e0d\u5fe0\u5b9e\u7684\u5f02\u6559\u5f92. \u5fcf\u6094\u7684\u65f6\u95f4\u5df2\u7ecf\u7ed3\u675f\u4e86, \u73b0\u5728, \u63a5\u53d7\u5ba1\u5224\u5427!"),
        STAGE_EMPEROR("Johnny", "Major", FullName.Gender.MALE, false, "graphics/swp/portraits/ibb_major.png", SWP_Util.RequiredFaction.NONE, 385000, "ssp_boss_dominator_cus", "Emperor", "aggressive", 0.5f, 18, 14, 12, 52, 0.0f, 10, "hegemony", "\u4f60\u4e5f\u5728\u8fd9\u91cc\u627e\u6211? \u597d\u5427, \u6211\u53ef\u4e0d\u4f1a\u675f\u624b\u5c31\u64d2! \u6709\u672c\u4e8b\u5c31\u6765!"),
        STAGE_GULF("Teresa", "Terror", FullName.Gender.FEMALE, false, "graphics/swp/portraits/ibb_terror.png", SWP_Util.RequiredFaction.DIABLE, 415000, "diableavionics_IBBgulf_fang", "Gulf", "steady", 0.75f, 20, 15, 11, 55, 0.0f, 6, "diableavionics", "\u4f60\u8fd9\u4e5f\u53eb\u8230\u961f? \u54c8! \u6211\u53ea\u9700\u7528\u4e00\u4e2a\u811a\u8dbe\u5934\u5c31\u53ef\u4ee5\u78be\u788e\u4f60."),
        STAGE_LEVIATHAN("Elaine", "Megas", FullName.Gender.FEMALE, false, "graphics/swp/portraits/ibb_megas.png", SWP_Util.RequiredFaction.NONE, 465000, "ssp_boss_atlas_cus", "Leviathan", "cautious", 0.25f, 19, 14, 15, 99, 0.0f, 10, "pirates", "\u867d\u7136\u8fd9\u662f\u4e00\u53e5\u5e9f\u8bdd, \u4f46\u6211\u771f\u7684\u53ea\u60f3\u597d\u597d\u505a\u7b14\u4e70\u5356!"),
        STAGE_POSEIDON("Marjatta", "Nemo", FullName.Gender.FEMALE, false, "graphics/portraits/ms_portrait_001.png", SWP_Util.RequiredFaction.SHADOWYARDS, 490000, "ms_boss_charybdis_cus", "Poseidon", "steady", 1.0f, 20, 16, 12, 63, 0.0f, 6, "shadow_industry", "\u4f60\u8eab\u4e0a\u6709\u6211\u60f3\u8981\u7684\u4e1c\u897f\u54e6? \u5514... \u561b. \u8ba9\u6211\u597d\u597d\u5730\u5206\u89e3\u4f60\u5427."),
        STAGE_ILIAD("Clade", "Midnight", FullName.Gender.MALE, false, "graphics/swp/portraits/ibb_midnight.png", SWP_Util.RequiredFaction.NONE, 430000, "ssp_boss_odyssey_cus", "Iliad", "steady", 1.0f, 22, 18, 8, 32, 0.0f, 12, "tritachyon", "\u62b1\u6b49, \u6307\u6325\u5b98. \u8fd9\u5e76\u4e0d\u662f\u4e2a\u4eba\u6069\u6028, \u4f46\u662f\u6211\u53ea\u60f3\u597d\u597d\u548c\u4f60\u6253\u4e00\u573a! \u51c6\u5907\u597d\u4e86\u5417?"),
        STAGE_OLYMPUS_X("Helmut", "Murkoph", FullName.Gender.MALE, false, "graphics/imperium/portraits/ii_portrait2.png", SWP_Util.RequiredFaction.IMPERIUM, 570000, "ii_boss_olympus_cus", "Olympus-X", "timid", 1.0f, 21, 19, 12, 56, 0.0f, 24, "interstellarimperium", "\u54c8\u54c8\u54c8\u54c8\u54c8\u54c8\uff01\u70e7\u8d77\u6765, \u5b9d\u8d1d, \u70e7\u8d77\u6765!"),
        STAGE_FRANKENSTEIN("Xenno", "Aura", FullName.Gender.MALE, false, "graphics/swp/portraits/ibb_aura.png", SWP_Util.RequiredFaction.NONE, 500000, "swp_boss_frankenstein_cus", "Frankenstein", "cautious", 0.75f, 26, 20, 14, 63, 0.0f, 6, "pirates", "\u54c7\u54e6! XD"),
        STAGE_ODIN("RA-002", "SHADOW", FullName.Gender.MALE, true, "graphics/portraits/ms_portrait_006.png", SWP_Util.RequiredFaction.SHADOWYARDS, 660000, "ms_boss_mimir_cus", "Odin", "aggressive", 0.5f, 23, 20, 14, 59, 0.0f, 20, "sector", "PURPOSE."),
        STAGE_LUCIFER("TTX", "LaCROIX", FullName.Gender.FEMALE, true, "graphics/swp/portraits/ibb_lacroix.png", SWP_Util.RequiredFaction.NONE, 570000, "ssp_boss_doom_cus", "Lucifer", "reckless", 1.0f, 28, 25, 9, 0, 0.0f, 40, "tritachyon", "I am sorry."),
        STAGE_EUPHORIA("Snipe", "Gunzup", FullName.Gender.MALE, false, "graphics/portraits/portrait_corporate06.png", SWP_Util.RequiredFaction.CABAL, 735000, "ssp_boss_astral_cus", "Euphoria", "steady", 1.0f, 29, 23, 13, 56, 1.0f, 16, "cabal", "\u6211\u4e0e\u4f60\u4e0d\u5728\u4e00\u4e2a\u751f\u547d\u9636\u5c42, \u51e1\u4eba! \u771f\u76f8\u53ea\u88ab\u771f\u6b63\u7684\u5f3a\u8005\u6240\u638c\u63a7, \u4f60\u8fd8\u4e0d\u660e\u767d\u5417?"),
        STAGE_CLERIC("Mathis", "Adelier", FullName.Gender.MALE, false, "graphics/templars/portraits/tem_portrait1.png", SWP_Util.RequiredFaction.TEMPLARS, 770000, "tem_boss_paladin_cus", "Cleric", "reckless", 1.0f, 29, 21, 12, 50, 3.0f, 8, "templars", "\u548c\u5e73\u5e74\u4ee3\u5df2\u7ecf\u7ed3\u675f. \u80dc\u5229\u7684\u65f6\u523b, \u6b63\u4e49\u7684\u88c1\u51b3, \u5df2\u7ecf\u5230\u6765. \u73b0\u5728, \u4f60\u5f53\u6c90\u6d74\u6218\u706b."),
        STAGE_YAMATO("Katsu", "Okita", FullName.Gender.MALE, false, "graphics/imperium/portraits/ii_okita.png", SWP_Util.RequiredFaction.IMPERIUM, 645000, "ii_boss_dominus_cus", "Yamato", "steady", 0.75f, 29, 22, 16, 56, 4.0f, 8, "interstellarimperium", "\u4f60\u4e0d\u80fd\u963b\u6b62\u6211\u62ef\u6551\u6211\u7684\u4eba\u6c11!"),
        STAGE_POPE("Adam", "Tipper", FullName.Gender.MALE, true, "graphics/swp/portraits/ibb_tipper.png", SWP_Util.RequiredFaction.TEMPLARS, 850000, "tem_boss_archbishop_cus", "Pope", "aggressive", 1.0f, 29, 20, 18, 58, 5.0f, 24, "lions_guard", "\u6211.\u662f.\u6c38\u6052."),
        STAGE_SPORESHIP("El", "Psi", FullName.Gender.MALE, true, "graphics/swp/portraits/ibb_psi.png", SWP_Util.RequiredFaction.NONE, 905000, "swp_boss_sporeship_cus", "DES S-02", "aggressive", 1.0f, 29, 21, 20, 76, 7.0f, 24, "remnant", "\u4f60\u4e0d\u662f\u6b27\u7c73\u8304."),
        STAGE_ZEUS("Gabriel", "Mosolov", FullName.Gender.MALE, false, "graphics/portraits/portrait_hegemony05.png", SWP_Util.RequiredFaction.NONE, 1250000, "ssp_boss_paragon_cus", "Zeus", "aggressive", 1.0f, 29, 24, 18, 85, 10.0f, 20, "everything", "\u611f\u8c22\u4f60\u5e72\u6389\u4e86\u6211\u6240\u6709\u7684\u5bf9\u624b. \u8bf7\u63a5\u6536\u6211\u6700\u8bda\u631a\u7684\u8c22\u610f. \u73b0\u5728, \u4f60\u53ef\u4ee5\u6b7b\u4e86.");

        public final String firstName;
        public final String lastName;
        public final FullName.Gender gender;
        public final boolean machine;
        public final String portrait;
        public final SWP_Util.RequiredFaction mod;
        public final int reward;
        public final String flagship;
        public final String flagshipName;
        public final String personality;
        public final float qf;
        public final int level;
        public final int officerLevel;
        public final int officerCount;
        public final int maxPts;
        public final float opBonus;
        public final int ptsFromBoss;
        public final String fleetFaction;
        public final String banterText;

        private FamousBountyStage(String firstName, String lastName, FullName.Gender gender, boolean machine, String portrait, SWP_Util.RequiredFaction mod, int reward, String flagship, String flagshipName, String personality, float qf, int level, int officerLevel, int officerCount, int maxPts, float opBonus, int ptsFromBoss, String fleetFaction, String banterText) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.gender = gender;
            this.machine = machine;
            this.portrait = portrait;
            this.mod = mod;
            this.reward = reward;
            this.flagship = flagship;
            this.flagshipName = flagshipName;
            this.personality = personality;
            this.qf = qf;
            this.level = level;
            this.officerLevel = officerLevel;
            this.officerCount = officerCount;
            this.maxPts = maxPts;
            this.opBonus = opBonus;
            this.ptsFromBoss = ptsFromBoss;
            if (!SWPModPlugin.hasDynaSector) {
                switch (fleetFaction) {
                    case "domain": {
                        this.fleetFaction = "hegemony";
                        break;
                    }
                    case "sector": {
                        this.fleetFaction = "independent";
                        break;
                    }
                    case "everything": {
                        this.fleetFaction = "lions_guard";
                        break;
                    }
                    default: {
                        this.fleetFaction = fleetFaction;
                        break;
                    }
                }
            } else {
                this.fleetFaction = fleetFaction;
            }
            this.banterText = banterText;
        }
    }
}

