/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.campaign.events;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.campaign.BaseScript;
import data.scripts.campaign.missions.SWP_FamousBountyEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SWP_IBBTracker
extends BaseScript {
    private final Set<String> stagesAllowed = new HashSet<String>(SWP_FamousBountyEvent.FamousBountyStage.values().length);
    private final Set<String> stagesBegan = new HashSet<String>(SWP_FamousBountyEvent.FamousBountyStage.values().length);
    private final Set<String> stagesCompleted = new HashSet<String>(SWP_FamousBountyEvent.FamousBountyStage.values().length);
    private final Set<String> stagesPosted = new HashSet<String>(SWP_FamousBountyEvent.FamousBountyStage.values().length);

    public static SWP_FamousBountyEvent.FamousBountyStage getStage(int stageNum) {
        if (stageNum < SWP_FamousBountyEvent.FamousBountyStage.values().length && stageNum >= 0) {
            return SWP_FamousBountyEvent.FamousBountyStage.values()[stageNum];
        }
        return null;
    }

    public static SWP_IBBTracker getTracker() {
        for (EveryFrameScript script : Global.getSector().getScripts()) {
            if (!(script instanceof SWP_IBBTracker)) continue;
            return (SWP_IBBTracker)script;
        }
        return null;
    }

    public void advance(float amount) {
    }

    public boolean allStagesComplete() {
        return this.stagesCompleted.size() >= this.stagesAllowed.size();
    }

    public SWP_FamousBountyEvent.FamousBountyStage getLowestIncompleteStage() {
        SWP_FamousBountyEvent.FamousBountyStage lowestStage = null;
        for (String stageName : this.stagesAllowed) {
            SWP_FamousBountyEvent.FamousBountyStage stage = SWP_FamousBountyEvent.FamousBountyStage.valueOf(stageName);
            if (stage == null || this.isStageComplete(stage) || lowestStage != null && stage.ordinal() >= lowestStage.ordinal()) continue;
            lowestStage = stage;
        }
        return lowestStage;
    }

    public boolean isDone() {
        return false;
    }

    public boolean isStageAllowed(SWP_FamousBountyEvent.FamousBountyStage stage) {
        if (stage == null) {
            return false;
        }
        return this.stagesAllowed.contains(stage.name());
    }

    public boolean isStageAvailable(SWP_FamousBountyEvent.FamousBountyStage stage) {
        if (stage == null) {
            return false;
        }
        if (!this.isStageAllowed(stage)) {
            return false;
        }
        if (this.isStagePosted(stage)) {
            return false;
        }
        if (this.isStageBegun(stage)) {
            return false;
        }
        return !this.isStageComplete(stage);
    }

    public boolean isStageBegun(SWP_FamousBountyEvent.FamousBountyStage stage) {
        if (stage == null) {
            return false;
        }
        return this.stagesBegan.contains(stage.name());
    }

    public boolean isStageComplete(SWP_FamousBountyEvent.FamousBountyStage stage) {
        if (stage == null) {
            return false;
        }
        return this.stagesCompleted.contains(stage.name());
    }

    public boolean isStagePosted(SWP_FamousBountyEvent.FamousBountyStage stage) {
        if (stage == null) {
            return false;
        }
        return this.stagesPosted.contains(stage.name());
    }

    public boolean noStagesAvailable() {
        for (String stageName : this.stagesAllowed) {
            SWP_FamousBountyEvent.FamousBountyStage stage = SWP_FamousBountyEvent.FamousBountyStage.valueOf(stageName);
            if (stage == null || !this.isStageAvailable(stage)) continue;
            return false;
        }
        return true;
    }

    public boolean noStagesComplete() {
        return this.stagesCompleted.size() <= 0;
    }

    public void refresh() {
        this.stagesAllowed.clear();
        for (SWP_FamousBountyEvent.FamousBountyStage stage : SWP_FamousBountyEvent.FamousBountyStage.values()) {
            if (!stage.mod.isLoaded()) continue;
            this.stagesAllowed.add(stage.name());
        }
        Iterator<String> iter = this.stagesPosted.iterator();
        while (iter.hasNext()) {
            SWP_FamousBountyEvent.FamousBountyStage stage;
            String stageName = iter.next();
            try {
                stage = SWP_FamousBountyEvent.FamousBountyStage.valueOf(stageName);
            }
            catch (IllegalArgumentException ex) {
                stage = null;
            }
            if (stage != null) continue;
            iter.remove();
        }
        iter = this.stagesBegan.iterator();
        while (iter.hasNext()) {
            SWP_FamousBountyEvent.FamousBountyStage stage;
            String stageName = iter.next();
            try {
                stage = SWP_FamousBountyEvent.FamousBountyStage.valueOf(stageName);
            }
            catch (IllegalArgumentException ex) {
                stage = null;
            }
            if (stage != null) continue;
            iter.remove();
        }
        iter = this.stagesCompleted.iterator();
        while (iter.hasNext()) {
            SWP_FamousBountyEvent.FamousBountyStage stage;
            String stageName = iter.next();
            try {
                stage = SWP_FamousBountyEvent.FamousBountyStage.valueOf(stageName);
            }
            catch (IllegalArgumentException ex) {
                stage = null;
            }
            if (stage != null) continue;
            iter.remove();
        }
    }

    public void reportStageBegan(SWP_FamousBountyEvent.FamousBountyStage stage) {
        if (stage == null) {
            return;
        }
        this.stagesBegan.add(stage.name());
        this.stagesPosted.remove(stage.name());
    }

    public void reportStageCompleted(SWP_FamousBountyEvent.FamousBountyStage stage) {
        if (stage == null) {
            return;
        }
        this.stagesBegan.add(stage.name());
        this.stagesCompleted.add(stage.name());
        this.stagesPosted.remove(stage.name());
    }

    public void reportStageExpired(SWP_FamousBountyEvent.FamousBountyStage stage) {
        if (stage == null) {
            return;
        }
        this.stagesBegan.remove(stage.name());
        this.stagesCompleted.remove(stage.name());
        this.stagesPosted.remove(stage.name());
    }

    public void reportStagePosted(SWP_FamousBountyEvent.FamousBountyStage stage) {
        if (stage == null) {
            return;
        }
        this.stagesPosted.add(stage.name());
    }

    public void reset() {
        this.stagesBegan.clear();
        this.stagesCompleted.clear();
        this.stagesPosted.clear();
    }
}

