/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.campaign.events;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignMissionPlugin;
import com.fs.starfarer.api.campaign.MissionBoardAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.SWPModPlugin;
import data.scripts.campaign.events.SWP_IBBTracker;
import data.scripts.campaign.missions.SWP_FamousBountyEvent;
import data.scripts.campaign.missions.SWP_FamousBountyMission;
import org.apache.log4j.Logger;

public class SWP_EventStarter
implements EveryFrameScript {
    public static Logger log = Global.getLogger(SWP_EventStarter.class);
    private final IntervalUtil famousBountyTracker = new IntervalUtil(10.0f, 10.0f);
    private float totalDays = 0.0f;

    public void advance(float amount) {
        float days = Global.getSector().getClock().convertToDays(amount);
        this.totalDays += days;
        this.startFamousBountiesIfNeeded(days);
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }

    private void startFamousBountiesIfNeeded(float days) {
        if (!SWPModPlugin.Module_FamousBounties) {
            return;
        }
        if (SWPModPlugin.Param_LegacyIBB) {
            this.startFamousBountiesLegacy(days);
            return;
        }
        if (this.totalDays < 30.0f) {
            return;
        }
        this.famousBountyTracker.advance(days);
        if (this.famousBountyTracker.intervalElapsed()) {
            if (SWP_IBBTracker.getTracker().noStagesAvailable()) {
                return;
            }
            if (Global.getSector().getPlayerFleet() == null) {
                return;
            }
            SWP_FamousBountyMission mission = new SWP_FamousBountyMission(Global.getSector().getHyperspace().createToken(99999.0f, 99999.0f));
            SWP_FamousBountyEvent famousBountyEvent = (SWP_FamousBountyEvent)mission.getPrimedEvent();
            if (famousBountyEvent != null) {
                boolean isAvailable = false;
                for (MarketAPI mkt : Global.getSector().getEconomy().getMarketsCopy()) {
                    if (mkt.getSize() < 3 || mkt.hasCondition("decivilized") || mkt.hasCondition("abandoned_station") || !SWPModPlugin.isExerelin && !SWP_FamousBountyEvent.IBB_FACTIONS.contains(mkt.getFactionId())) continue;
                    int numAtMarket = 0;
                    block1: for (MissionBoardAPI.MissionAvailabilityAPI availability : Global.getSector().getMissionBoard().getMissionsCopy()) {
                        if (!(availability.getMission() instanceof SWP_FamousBountyMission)) continue;
                        for (SectorEntityToken token : mkt.getConnectedEntities()) {
                            if (!availability.getAvailableAt().contains(token)) continue;
                            ++numAtMarket;
                            continue block1;
                        }
                    }
                    int adjust = 0;
                    if (mkt.hasCondition("military_base") || mkt.hasCondition("ii_interstellarbazaar") || mkt.hasCondition("ii_military_complex")) {
                        ++adjust;
                    }
                    if (mkt.hasCondition("headquarters")) {
                        ++adjust;
                    }
                    if (mkt.hasCondition("regional_capital")) {
                        ++adjust;
                    }
                    if (mkt.hasCondition("spaceport") || mkt.hasCondition("orbital_station")) {
                        ++adjust;
                    }
                    if (mkt.hasCondition("trade_center") || mkt.hasCondition("ii_interstellarbazaar")) {
                        ++adjust;
                    }
                    if (mkt.hasCondition("free_market")) {
                        ++adjust;
                    }
                    adjust -= numAtMarket;
                    boolean add = false;
                    for (int i = 0; i < mkt.getSize(); ++i) {
                        if (mkt.getSize() >= 4 - adjust && Math.random() > 0.35) {
                            add = true;
                            break;
                        }
                        --adjust;
                    }
                    if (!add) continue;
                    Global.getSector().getMissionBoard().makeAvailableAt((CampaignMissionPlugin)mission, mkt);
                    isAvailable = true;
                }
                if (!isAvailable) {
                    famousBountyEvent.endEvent(true);
                }
            }
        }
    }

    private void startFamousBountiesLegacy(float days) {
        if (!SWPModPlugin.Module_FamousBounties || !SWPModPlugin.Param_LegacyIBB) {
            return;
        }
        if (this.totalDays < 30.0f) {
            return;
        }
        this.famousBountyTracker.advance(days);
        if (this.famousBountyTracker.intervalElapsed()) {
            if (SWP_IBBTracker.getTracker().noStagesAvailable()) {
                return;
            }
            SWP_FamousBountyMission mission = new SWP_FamousBountyMission(Global.getSector().getHyperspace().createToken(99999.0f, 99999.0f));
            SWP_FamousBountyEvent famousBountyEvent = (SWP_FamousBountyEvent)mission.getPrimedEvent();
            if (famousBountyEvent != null) {
                boolean isAvailable = false;
                for (MarketAPI mkt : Global.getSector().getEconomy().getMarketsCopy()) {
                    if (mkt.getSize() < 3 || mkt.hasCondition("decivilized") || mkt.hasCondition("abandoned_station") || !SWPModPlugin.isExerelin && !SWP_FamousBountyEvent.IBB_FACTIONS.contains(mkt.getFactionId())) continue;
                    Global.getSector().getMissionBoard().makeAvailableAt((CampaignMissionPlugin)mission, mkt);
                    isAvailable = true;
                }
                if (!isAvailable) {
                    famousBountyEvent.endEvent(true);
                }
            }
        }
    }
}

