/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.campaign;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.FleetDataAPI;
import com.fs.starfarer.api.characters.OfficerDataAPI;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.events.OfficerManagerEvent;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV2;
import com.fs.starfarer.api.loading.FleetCompositionDoctrineAPI;
import com.fs.starfarer.api.plugins.OfficerLevelupPlugin;
import com.fs.starfarer.api.util.Misc;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import java.util.Collection;
import java.util.List;
import java.util.Random;

public class SWP_FleetFactory {
    public static void addCommanderAndOfficersFamous(int total, float minLevel, float maxLevel, CampaignFleetAPI fleet, Collection<FleetMemberAPI> specialShips, Random random) {
        float weight;
        FleetMemberAPI member2;
        OfficerLevelupPlugin plugin = (OfficerLevelupPlugin)Global.getSettings().getPlugin("officerLevelUp");
        int max = plugin.getMaxLevel(null);
        List members = fleet.getFleetData().getMembersListCopy();
        WeightedRandomPicker picker = new WeightedRandomPicker(random);
        for (FleetMemberAPI member2 : members) {
            if (member2.isFighterWing() || member2.isFlagship() || !member2.getCaptain().isDefault()) continue;
            float q = member2.getVariant().getQuality();
            if (member2.isCivilian()) {
                q *= 1.0E-4f;
            }
            for (FleetMemberAPI special : specialShips) {
                if (!special.getId().contentEquals(member2.getId())) continue;
                q += 1000.0f;
                break;
            }
            weight = (float)member2.getFleetPointCost() * 0.5f + (float)member2.getFleetPointCost() * q;
            picker.add((Object)member2, weight);
        }
        for (int i = 0; i < total + 1 && (member2 = (FleetMemberAPI)picker.pickAndRemove()) != null; ++i) {
            PersonAPI person;
            int level = Math.min(max, Math.round(minLevel + random.nextFloat() * (maxLevel - minLevel)));
            if (Misc.isEasy()) {
                level = (int)Math.ceil((float)level * Global.getSettings().getFloat("easyOfficerLevelMult"));
            }
            if (level <= 0) continue;
            weight = FleetFactoryV2.getMemberWeight((FleetMemberAPI)member2);
            float fighters = member2.getVariant().getFittedWings().size();
            boolean wantCarrierSkills = weight > 0.0f && fighters / weight >= 0.5f;
            OfficerManagerEvent.SkillPickPreference pref = OfficerManagerEvent.SkillPickPreference.NON_CARRIER;
            if (wantCarrierSkills) {
                pref = OfficerManagerEvent.SkillPickPreference.CARRIER;
            }
            if ((person = OfficerManagerEvent.createOfficer((FactionAPI)fleet.getFaction(), (int)level, (boolean)true, (OfficerManagerEvent.SkillPickPreference)pref, (Random)random)).getPersonalityAPI().getId().equals("timid")) {
                person.setPersonality("cautious");
            }
            member2.setCaptain(person);
        }
    }

    public static CampaignFleetAPI enhancedCreateFleet(FactionAPI faction, int fleetSize, FleetFactoryDelegate delegate) {
        FleetCompositionDoctrineAPI doctrine = faction.getCompositionDoctrine();
        float preSmall = doctrine.getSmall();
        float preFast = doctrine.getFast();
        float preMedium = doctrine.getMedium();
        float preLarge = doctrine.getLarge();
        float preCapital = doctrine.getCapital();
        float preSmallCarrierProbability = doctrine.getSmallCarrierProbability();
        float preMediumCarrierProbability = doctrine.getMediumCarrierProbability();
        float preLargeCarrierProbability = doctrine.getLargeCarrierProbability();
        if (fleetSize > 25 && fleetSize <= 50) {
            doctrine.setSmall(preSmall * 0.5f);
            doctrine.setFast(preFast * 0.5f);
            doctrine.setMedium(preMedium);
            doctrine.setLarge(preLarge * 1.25f);
            doctrine.setCapital(preCapital * 1.5f);
            doctrine.setSmallCarrierProbability(preSmallCarrierProbability * 0.8f);
            doctrine.setMediumCarrierProbability(preMediumCarrierProbability * 0.9f);
            doctrine.setLargeCarrierProbability(preLargeCarrierProbability);
        } else if (fleetSize > 50 && fleetSize <= 100) {
            doctrine.setSmall(preSmall * 0.25f);
            doctrine.setFast(preFast * 0.25f);
            doctrine.setMedium(preMedium * 0.75f);
            doctrine.setLarge(preLarge);
            doctrine.setCapital(preCapital * 1.25f);
            doctrine.setSmallCarrierProbability(preSmallCarrierProbability * 0.5f);
            doctrine.setMediumCarrierProbability(preMediumCarrierProbability * 0.65f);
            doctrine.setLargeCarrierProbability(preLargeCarrierProbability * 0.8f);
        } else if (fleetSize > 100) {
            doctrine.setSmall(preSmall * 0.125f);
            doctrine.setFast(preFast * 0.125f);
            doctrine.setMedium(preMedium * 0.375f);
            doctrine.setLarge(preLarge * 0.75f);
            doctrine.setCapital(preCapital);
            doctrine.setSmallCarrierProbability(preSmallCarrierProbability * 0.2f);
            doctrine.setMediumCarrierProbability(preMediumCarrierProbability * 0.4f);
            doctrine.setLargeCarrierProbability(preLargeCarrierProbability * 0.6f);
        }
        CampaignFleetAPI fleet = delegate.createFleet();
        doctrine.setSmall(preSmall);
        doctrine.setFast(preFast);
        doctrine.setMedium(preMedium);
        doctrine.setLarge(preLarge);
        doctrine.setCapital(preCapital);
        doctrine.setSmallCarrierProbability(preSmallCarrierProbability);
        doctrine.setMediumCarrierProbability(preMediumCarrierProbability);
        doctrine.setLargeCarrierProbability(preLargeCarrierProbability);
        return fleet;
    }

    public static void levelOfficer(PersonAPI person, FleetDataAPI fleetData, int toLevel, boolean alwaysPickHigherSkill, OfficerManagerEvent.SkillPickPreference pref, Random random) {
        OfficerLevelupPlugin plugin;
        if (random == null) {
            random = new Random();
        }
        if (toLevel > (plugin = (OfficerLevelupPlugin)Global.getSettings().getPlugin("officerLevelUp")).getMaxLevel(person)) {
            toLevel = plugin.getMaxLevel(person);
        }
        person.getStats().setSkipRefresh(true);
        OfficerDataAPI officerData = fleetData.getOfficerData(person);
        if (officerData == null) {
            officerData = Global.getFactory().createOfficerData(person);
        }
        long xp = plugin.getXPForLevel(toLevel);
        officerData.addXP(xp - person.getStats().getXP());
        while (officerData.canLevelUp()) {
            String skillId = OfficerManagerEvent.pickSkill((PersonAPI)officerData.getPerson(), (List)officerData.getSkillPicks(), (boolean)alwaysPickHigherSkill, (OfficerManagerEvent.SkillPickPreference)pref, (Random)random);
            if (skillId == null) continue;
            officerData.levelUp(skillId);
        }
        person.getStats().setSkipRefresh(false);
        person.getStats().refreshCharacterStatsEffects();
    }

    public static interface FleetFactoryDelegate {
        public CampaignFleetAPI createFleet();
    }
}

