/*
 * Decompiled with CFR 0.152.
 */
package data.missions.swp_magnificent7;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.impl.campaign.fleets.FleetFactoryV2;
import com.fs.starfarer.api.impl.campaign.fleets.FleetParams;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import data.scripts.SWPModPlugin;
import data.scripts.campaign.SWP_FleetFactory;
import java.util.ArrayList;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class MissionDefinition
implements MissionDefinitionPlugin {
    public static final String ENEMY_FACTION_ID = "pirates";
    public static final int ENEMY_FLEET_SIZE = 27;
    protected static final List<String> FACTIONS = new ArrayList<String>();
    protected FactionAPI currentFaction = null;
    protected WeightedRandomPicker<String> factionPicker = new WeightedRandomPicker();

    protected static void initFactions() {
        FACTIONS.clear();
        FACTIONS.add("hegemony");
        FACTIONS.add("tritachyon");
        FACTIONS.add("independent");
        MissionDefinition.addFactionIfExists("interstellarimperium");
        MissionDefinition.addFactionIfExists("citadeldefenders");
        MissionDefinition.addFactionIfExists("blackrock_driveyards");
        MissionDefinition.addFactionIfExists("exigency");
        MissionDefinition.addFactionIfExists("shadow_industry");
        MissionDefinition.addFactionIfExists("mayorate");
        MissionDefinition.addFactionIfExists("pack");
        MissionDefinition.addFactionIfExists("tiandong");
        MissionDefinition.addFactionIfExists("diableavionics");
        MissionDefinition.addFactionIfExists("SCY");
        MissionDefinition.addFactionIfExists("ORA");
        MissionDefinition.addFactionIfExists("dassault_mikoyan");
        MissionDefinition.addFactionIfExists("Coalition");
        MissionDefinition.addFactionIfExists("pbc");
        MissionDefinition.addFactionIfExists("neutrinocorp");
    }

    protected static void addFactionIfExists(String factionId) {
        if (Global.getSector().getFaction(factionId) != null) {
            FACTIONS.add(factionId);
        }
    }

    protected String getRole(String type) {
        WeightedRandomPicker picker = new WeightedRandomPicker();
        switch (type) {
            case "cruiser": {
                picker.add((Object)"combatLarge", 15.0f);
                picker.add((Object)"carrierMedium", 3.0f);
            }
            case "destroyer": {
                picker.add((Object)"combatMedium", 10.0f);
                picker.add((Object)"escortMedium", 5.0f);
                break;
            }
            case "frigate": {
                picker.add((Object)"combatSmall", 12.0f);
                picker.add((Object)"escortSmall", 5.0f);
                picker.add((Object)"fastAttack", 5.0f);
                break;
            }
            case "carrier": {
                return "carrierSmall";
            }
        }
        return (String)picker.pick();
    }

    protected String getRandomFaction() {
        if (this.factionPicker.isEmpty()) {
            this.factionPicker.addAll(FACTIONS);
        }
        return (String)this.factionPicker.pickAndRemove();
    }

    protected String getPlayerShip(String type) {
        this.currentFaction = Global.getSector().getFaction(this.getRandomFaction());
        float quality = MathUtils.getRandomNumberInRange((float)0.8f, (float)1.0f);
        List picks = this.currentFaction.pickShip(this.getRole(type), quality);
        if (picks.isEmpty()) {
            return this.getPlayerShip(type);
        }
        return ((ShipRolePick)picks.get((int)0)).variantId;
    }

    protected void addPlayerShip(MissionDefinitionAPI api, String type, String name, String personality, boolean isFlagship) {
        String variantId = this.getPlayerShip(type);
        FleetMemberAPI member = api.addToFleet(FleetSide.PLAYER, variantId, FleetMemberType.SHIP, name, isFlagship);
        if (isFlagship) {
            api.defeatOnShipLoss(name);
        }
    }

    protected void addPlayerShip(MissionDefinitionAPI api, String type, String name, String personality) {
        this.addPlayerShip(api, type, name, personality, false);
    }

    public void defineMission(MissionDefinitionAPI api) {
        MissionDefinition.initFactions();
        api.initFleet(FleetSide.PLAYER, "ISS", FleetGoal.ATTACK, false);
        api.initFleet(FleetSide.ENEMY, "", FleetGoal.ATTACK, true);
        api.setFleetTagline(FleetSide.PLAYER, "\u4e03\u540d\u52c7\u6562\u7684\u82f1\u96c4");
        api.setFleetTagline(FleetSide.ENEMY, "\u6d77\u76d7\u63a0\u593a\u8230\u961f");
        if (!SWPModPlugin.hasUnderworld) {
            api.addBriefingItem("UNDERWORLD REQUIRED");
            api.addBriefingItem("\u4e0b\u8f7d \u661f\u5149\u7ed3\u793e \u6765\u6267\u884c\u8fd9\u4e2a\u4efb\u52a1!");
        }
        if (!SWPModPlugin.hasUnderworld) {
            return;
        }
        api.addBriefingItem("\u51fb\u8d25\u6d77\u76d7");
        api.addBriefingItem("ISS Yojimbo \u5fc5\u987b\u5b58\u6d3b");
        api.addBriefingItem("\u70b9\u51fb\u4efb\u52a1\u9762\u677f\u53ef\u5237\u65b0\u8230\u8239 (\u517c\u5bb9\u5176\u5b83 Mod \u8230\u8239)");
        this.addPlayerShip(api, "cruiser", "ISS Yojimbo", "steady", true);
        this.addPlayerShip(api, "cruiser", "ISS Palisade", "aggressive");
        this.addPlayerShip(api, "destroyer", "ISS True Love Kiss", "steady");
        this.addPlayerShip(api, "destroyer", "ISS Aloysha Popovich", "steady");
        this.addPlayerShip(api, "frigate", "ISS Sound of Silence", "aggressive");
        this.addPlayerShip(api, "frigate", "ISS Defiant", "steady");
        this.addPlayerShip(api, "carrier", "ISS Maia", "cautious");
        MarketAPI market = Global.getFactory().createMarket("fake_market", "Fake market", 7);
        FactionAPI enemyFaction = Global.getSector().getFaction(ENEMY_FACTION_ID);
        final FleetParams params = new FleetParams(new Vector2f(0.0f, 0.0f), market, ENEMY_FACTION_ID, null, "missionFleet", 27.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.8f, 0.0f, 0);
        params.withOfficers = false;
        CampaignFleetAPI fleet = SWP_FleetFactory.enhancedCreateFleet(enemyFaction, 27, new SWP_FleetFactory.FleetFactoryDelegate(){

            @Override
            public CampaignFleetAPI createFleet() {
                return FleetFactoryV2.createFleet((FleetParams)params);
            }
        });
        for (FleetMemberAPI member : fleet.getFleetData().getMembersInPriorityOrder()) {
            api.addFleetMember(FleetSide.ENEMY, member);
        }
        float width = 16000.0f;
        float height = 14000.0f;
        api.initMap(-width / 2.0f, width / 2.0f, -height / 2.0f, height / 2.0f);
        for (int i = 0; i < 8; ++i) {
            float x = (float)Math.random() * width - width / 2.0f;
            float y = (float)Math.random() * height - height / 2.0f;
            float radius = 100.0f + (float)Math.random() * 400.0f;
            api.addNebula(x, y, radius);
        }
        api.addObjective(width * 0.4f, -height * 0.2f, "nav_buoy");
        api.addObjective(-width * 0.4f, height * 0.15f, "sensor_array");
        api.addObjective(0.0f, 0.0f, "comm_relay");
        api.addAsteroidField(0.0f, 0.0f, 45.0f, width, 20.0f, 70.0f, 250);
        api.addPlanet(0.0f, 0.0f, 250.0f, "frozen", 350.0f, true);
    }
}

