/*
 * Decompiled with CFR 0.152.
 */
package data.missions.duelofthecentury;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.characters.PersonAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.EveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import data.scripts.SWPModPlugin;
import java.awt.Color;
import java.util.List;
import org.dark.shaders.light.LightAPI;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.dark.shaders.post.PostProcessShader;
import org.lwjgl.util.vector.Vector3f;

public class MissionDefinition
implements MissionDefinitionPlugin {
    public void defineMission(MissionDefinitionAPI api) {
        api.initFleet(FleetSide.PLAYER, "FOF", FleetGoal.ATTACK, false);
        api.initFleet(FleetSide.ENEMY, "ISS", FleetGoal.ATTACK, true);
        api.setFleetTagline(FleetSide.PLAYER, "\u88ab\u76d7\u7684 \u9ad8\u8d35\u65e0\u6bd4-\u7ea7 \u539f\u578b\u8230");
        api.setFleetTagline(FleetSide.ENEMY, "\"\u4fdd\u536b\u8005\" \u7cbe\u82f1\u8d4f\u91d1\u730e\u4eba");
        api.setHyperspaceMode(true);
        api.addBriefingItem("\u51fb\u8d25 \"\u4fdd\u536b\u8005\".");
        api.addBriefingItem("\u9ad8\u8d35\u65e0\u6bd4-\u7ea7\u7684\u6280\u80fd\u662f\u65e0\u53ef\u6311\u5254\u7684\uff0c \u8bf7\u5728\u6218\u6597\u4e2d\u5229\u7528\u5176\u7279\u6027\u6765\u5316\u4e3a\u4f18\u52bf\u3002");
        api.addBriefingItem("\u7531\u4e8e\u8230\u8239\u53d7\u5230\u9644\u8fd1\u6052\u661f\u70ed\u91cf\u7684\u5f71\u54cd\uff0c \u5bfc\u81f4\u5e45\u80fd\u4f1a\u968f\u7740\u65f6\u95f4\u63a8\u79fb\u800c\u7f13\u6162\u589e\u52a0\u3002");
        PersonAPI captain = api.addToFleet(FleetSide.PLAYER, "ssp_excelsior_cap", FleetMemberType.SHIP, "FOF Excelsior", true).getCaptain();
        captain.getStats().setAptitudeLevel("combat", 3.0f);
        captain.getStats().setAptitudeLevel("technology", 3.0f);
        captain.getStats().setSkillLevel("combat_endurance", 3.0f);
        captain.getStats().setSkillLevel("missile_specialization", 3.0f);
        captain.getStats().setSkillLevel("ordnance_expert", 3.0f);
        captain.getStats().setSkillLevel("target_analysis", 3.0f);
        captain.getStats().setSkillLevel("damage_control", 3.0f);
        captain.getStats().setSkillLevel("impact_mitigation", 3.0f);
        captain.getStats().setSkillLevel("defensive_systems", 3.0f);
        captain.getStats().setSkillLevel("advanced_countermeasures", 3.0f);
        captain.getStats().setSkillLevel("evasive_action", 3.0f);
        captain.getStats().setSkillLevel("helmsmanship", 3.0f);
        captain.getStats().setSkillLevel("gunnery_implants", 3.0f);
        captain.getStats().setSkillLevel("flux_modulation", 3.0f);
        api.addToFleet(FleetSide.ENEMY, "hyperion_Strike", FleetMemberType.SHIP, "ISS Mozart", true);
        if (SWPModPlugin.hasUnderworld) {
            api.addToFleet(FleetSide.ENEMY, "ssp_venomx_sta", FleetMemberType.SHIP, "ISS Beethoven", false);
        } else {
            api.addToFleet(FleetSide.ENEMY, "hyperion_Strike", FleetMemberType.SHIP, "ISS Beethoven", false);
        }
        if (SWPModPlugin.blackrockExists) {
            api.addToFleet(FleetSide.ENEMY, "brdy_imaginos_shock", FleetMemberType.SHIP, "ISS Vivaldi", false);
        } else {
            api.addToFleet(FleetSide.ENEMY, "hyperion_Attack", FleetMemberType.SHIP, "ISS Vivaldi", false);
        }
        if (SWPModPlugin.exigencyExists) {
            api.addToFleet(FleetSide.ENEMY, "exigency_indra_Standard", FleetMemberType.SHIP, "ISS Tartini", false);
        } else {
            api.addToFleet(FleetSide.ENEMY, "hyperion_Strike", FleetMemberType.SHIP, "ISS Tartini", false);
        }
        if (SWPModPlugin.shadowyardsExists) {
            api.addToFleet(FleetSide.ENEMY, "ms_shamash_EMP", FleetMemberType.SHIP, "ISS Mendelssohn", false);
        } else {
            api.addToFleet(FleetSide.ENEMY, "hyperion_Attack", FleetMemberType.SHIP, "ISS Mendelssohn", false);
        }
        if (SWPModPlugin.templarsExists) {
            api.addToFleet(FleetSide.ENEMY, "tem_jesuit_est", FleetMemberType.SHIP, "ISS Paganini", false);
        } else {
            api.addToFleet(FleetSide.ENEMY, "hyperion_Strike", FleetMemberType.SHIP, "ISS Paganini", false);
        }
        if (SWPModPlugin.imperiumExists) {
            api.addToFleet(FleetSide.ENEMY, "ii_maximus_str", FleetMemberType.SHIP, "ISS Dvorak", false);
        } else {
            api.addToFleet(FleetSide.ENEMY, "hyperion_Attack", FleetMemberType.SHIP, "ISS Dvorak", false);
        }
        if (SWPModPlugin.scyExists) {
            api.addToFleet(FleetSide.ENEMY, "SCY_stymphalianbird_combat", FleetMemberType.SHIP, "ISS Saint-Saens", false);
        } else {
            api.addToFleet(FleetSide.ENEMY, "hyperion_Strike", FleetMemberType.SHIP, "ISS Saint-Saens", false);
        }
        if (SWPModPlugin.diableExists) {
            api.addToFleet(FleetSide.ENEMY, "diableavionics_versant_standard", FleetMemberType.SHIP, "ISS Haydn", false);
        } else {
            api.addToFleet(FleetSide.ENEMY, "hyperion_Attack", FleetMemberType.SHIP, "ISS Haydn", false);
        }
        float width = 10000.0f;
        float height = 10000.0f;
        api.initMap(-width / 2.0f, width / 2.0f, -height / 2.0f, height / 2.0f);
        api.addAsteroidField(0.0f, 0.0f, (float)Math.random() * 360.0f, width, 30.0f, 200.0f, 500);
        api.addPlugin((EveryFrameCombatPlugin)new Plugin());
    }

    private static final class Plugin
    extends BaseEveryFrameCombatPlugin {
        private boolean reallyStarted = false;
        private boolean started = false;

        private Plugin() {
        }

        public void advance(float amount, List<InputEventAPI> events) {
            if (!this.started) {
                this.started = true;
                return;
            }
            if (!this.reallyStarted) {
                this.reallyStarted = true;
                StandardLight sun = new StandardLight();
                sun.setType(3);
                sun.setDirection((Vector3f)new Vector3f(-1.0f, -1.0f, -0.2f).normalise());
                sun.setIntensity(0.0f);
                sun.setSpecularIntensity(2.0f);
                sun.setColor(new Color(212, 91, 22));
                sun.makePermanent();
                LightShader.addLight((LightAPI)sun);
                sun = new StandardLight();
                sun.setType(3);
                sun.setDirection((Vector3f)new Vector3f(0.0f, 0.0f, -1.0f).normalise());
                sun.setIntensity(0.75f);
                sun.setSpecularIntensity(0.0f);
                sun.setColor(new Color(212, 91, 22));
                sun.makePermanent();
                LightShader.addLight((LightAPI)sun);
                PostProcessShader.setSaturation((boolean)false, (float)1.1f);
                PostProcessShader.setLightness((boolean)false, (float)1.1f);
                PostProcessShader.setContrast((boolean)false, (float)1.1f);
                PostProcessShader.setNoise((boolean)false, (float)0.1f);
            }
            if (Global.getCombatEngine().isPaused()) {
                return;
            }
            for (ShipAPI ship : Global.getCombatEngine().getShips()) {
                if (!ship.getHullSpec().getHullId().contentEquals("ssp_excelsior")) continue;
                ship.getFluxTracker().increaseFlux(100.0f * amount, true);
            }
        }

        public void init(CombatEngineAPI engine) {
        }
    }
}

