/*
 * Decompiled with CFR 0.152.
 */
package data.missions.atopthemountain;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import data.scripts.SWPModPlugin;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class MissionDefinition
implements MissionDefinitionPlugin {
    private static Vector2f getSafeSpawn(FleetSide side, float mapX, float mapY) {
        Vector2f spawnLocation = new Vector2f();
        spawnLocation.x = MathUtils.getRandomNumberInRange((float)(-mapX / 2.0f), (float)(mapX / 2.0f));
        spawnLocation.y = side == FleetSide.PLAYER ? -mapY / 2.0f : mapY / 2.0f;
        return spawnLocation;
    }

    public void defineMission(MissionDefinitionAPI api) {
        api.initFleet(FleetSide.PLAYER, "", FleetGoal.ATTACK, false);
        api.initFleet(FleetSide.ENEMY, "ISA", FleetGoal.ATTACK, true);
        api.setFleetTagline(FleetSide.PLAYER, "\u5723\u6bbf\u9a91\u58eb \u5148\u950b\u961f");
        api.setFleetTagline(FleetSide.ENEMY, "\u5e1d\u56fd \u8fb9\u9632\u961f");
        if (!SWPModPlugin.templarsExists) {
            api.addBriefingItem("\u9700\u8981 \u5723\u6bbf\u9a91\u58eb\u56e2");
            api.addBriefingItem("\u4e0b\u8f7d \u5723\u6bbf\u9a91\u58eb\u56e2 \u6765\u6267\u884c\u8fd9\u4e2a\u4efb\u52a1!");
        }
        if (!SWPModPlugin.imperiumExists) {
            api.addBriefingItem("\u9700\u8981 \u661f\u9645\u5e1d\u56fd");
            api.addBriefingItem("\u4e0b\u8f7d \u661f\u9645\u5e1d\u56fd \u6765\u6267\u884c\u8fd9\u4e2a\u4efb\u52a1!");
        }
        if (!SWPModPlugin.templarsExists || !SWPModPlugin.imperiumExists) {
            return;
        }
        api.addBriefingItem("\u51fb\u8d25\u4eb5\u6e0e\u8005");
        api.addToFleet(FleetSide.PLAYER, "tem_paladin_agi", FleetMemberType.SHIP, "Punisher", true);
        api.addToFleet(FleetSide.PLAYER, "tem_chevalier_est", FleetMemberType.SHIP, "Vindicator", false);
        api.addToFleet(FleetSide.PLAYER, "tem_crusader_def", FleetMemberType.SHIP, "Shield", false).getCaptain().setPersonality("cautious");
        api.addToFleet(FleetSide.PLAYER, "tem_crusader_def", FleetMemberType.SHIP, "Aegis", false).getCaptain().setPersonality("cautious");
        api.addToFleet(FleetSide.PLAYER, "tem_jesuit_ati", FleetMemberType.SHIP, "Guisarme", false).getCaptain().setPersonality("cautious");
        api.addToFleet(FleetSide.PLAYER, "tem_jesuit_ati", FleetMemberType.SHIP, "Fauchard", false).getCaptain().setPersonality("cautious");
        api.addToFleet(FleetSide.ENEMY, "ii_caesar_for", FleetMemberType.SHIP, "ISA Citadel", false);
        api.addToFleet(FleetSide.ENEMY, "ii_olympus_a_sta", FleetMemberType.SHIP, "ISA Armageddon", false);
        api.addToFleet(FleetSide.ENEMY, "ii_jupiter_art", FleetMemberType.SHIP, "ISA Clocktower", false);
        api.addToFleet(FleetSide.ENEMY, "ii_jupiter_mob", FleetMemberType.SHIP, "ISA Guardian", false);
        api.addToFleet(FleetSide.ENEMY, "ii_adamas_eli", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_malleus_art", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_dictator_def", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_dictator_sta", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_sebastos_ig_imp", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_sebastos_art", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_sebastos_art", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_praetorian_ig_imp", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_praetorian_ig_imp", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_legionary_sta", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_legionary_bal", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_hammerhead_i_eli", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_hammerhead_i_eli", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_decurion_ig_imp", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_decurion_ig_imp", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_maximus_bea", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_maximus_bea", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_invictus_arm", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_invictus_arm", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_basileus_str", FleetMemberType.SHIP, false);
        api.addToFleet(FleetSide.ENEMY, "ii_basileus_str", FleetMemberType.SHIP, false);
        float width = 14000.0f;
        float height = 20000.0f;
        api.initMap(-width / 2.0f, width / 2.0f, -height / 2.0f, height / 2.0f);
        for (int i = 0; i < 8; ++i) {
            float x = (float)Math.random() * width - width / 2.0f;
            float y = (float)Math.random() * height - height / 2.0f;
            float radius = 100.0f + (float)Math.random() * 400.0f;
            api.addNebula(x, y, radius);
        }
        api.addObjective(width * 0.4f, -height * 0.15f, "nav_buoy");
        api.addObjective(-width * 0.4f, -height * 0.15f, "sensor_array");
        api.addAsteroidField(0.0f, 0.0f, 45.0f, width, 20.0f, 70.0f, 250);
    }

    private static final class Plugin
    extends BaseEveryFrameCombatPlugin {
        private boolean done = false;
        private final float mapX;
        private final float mapY;
        private float timer = 5.0f;

        private Plugin(float mapX, float mapY) {
            this.mapX = mapX;
            this.mapY = mapY;
        }

        public void advance(float amount, List<InputEventAPI> events) {
            if (this.done || Global.getCombatEngine() == null || Global.getCombatEngine().isPaused()) {
                return;
            }
            this.timer -= amount;
            if (this.timer <= 0.0f) {
                for (FleetMemberAPI member : Global.getCombatEngine().getFleetManager(FleetSide.ENEMY).getReservesCopy()) {
                    if (Global.getCombatEngine().getFleetManager(FleetSide.ENEMY).getDeployedCopy().contains(member)) continue;
                    Global.getCombatEngine().getFleetManager(FleetSide.ENEMY).spawnFleetMember(member, MissionDefinition.getSafeSpawn(FleetSide.ENEMY, this.mapX, this.mapY), 270.0f, 1.0f);
                }
                this.done = true;
            }
        }

        public void init(CombatEngineAPI engine) {
        }
    }
}

