/*
 * Decompiled with CFR 0.152.
 */
package data.missions.arcade;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.SoundPlayerAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import data.missions.arcade.MissionPlugin;
import java.awt.Color;
import java.util.List;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class UnrealAnnouncer
extends BaseEveryFrameCombatPlugin {
    private static final Color BACKGROUND_COLOR = new Color(0, 0, 0, 255);
    private static final Color HIGH_COLOR = new Color(160, 255, 0, 255);
    private static final Color LOW_COLOR = new Color(255, 0, 0, 255);
    private static final Color MID_COLOR = new Color(255, 255, 0, 255);
    private static final Color WARP_JITTER_COLOR = new Color(0, 255, 255, 255);
    private static boolean comboOn = false;
    private static float comboTimer = 0.0f;
    private static int deathCount = 0;
    private static final float height = 8.0f;
    private static final Vector2f position = new Vector2f(Global.getSettings().getScreenWidth() / 2.0f, 5.0f);
    private static int spreeKills = 0;
    private static float timerCap = 1.0f;
    private static final float width = Global.getSettings().getScreenHeight() / 4.5f - 20.0f;
    private CombatEngineAPI engine;

    public static void addKill(float degree, int type) {
        if (deathCount <= 1) {
            comboTimer = 20.0f;
            comboOn = true;
        }
        float overkillPrevention = 1.0f / (1.0f + (float)deathCount / 20.0f);
        float timeBonus = (float)Math.pow(degree, 0.75);
        comboTimer = type == 1 ? (comboTimer += 1.5f * timeBonus * overkillPrevention) : (type == 2 ? (comboTimer += 1.0f * timeBonus * overkillPrevention) : (type == 3 ? (comboTimer += 2.5f * timeBonus * overkillPrevention) : (type == 4 ? (comboTimer += 1.0f * timeBonus * overkillPrevention) : (type == 99 ? (comboTimer += 1.5f * timeBonus * overkillPrevention) : (comboTimer += 0.5f * timeBonus * overkillPrevention)))));
        deathCount = type == 0 ? ++deathCount : (type == 1 ? (deathCount += 2) : (type == 2 ? (deathCount += 2) : (type == 3 ? (deathCount += 3) : (type == 4 ? (deathCount += 2) : (type == 99 ? (deathCount += 4) : ++deathCount)))));
    }

    public static int getComboMulti() {
        return deathCount;
    }

    private static float getBaseWarpMult(int comboMultiplier, float factor) {
        return 1.0f / (1.0f + (float)(comboMultiplier - 1) * factor);
    }

    private static float getWarpMult(int comboMultiplier, float factor, float timer) {
        float baseTimeMult = UnrealAnnouncer.getBaseWarpMult(comboMultiplier, factor);
        return 1.0f / (1.0f + (float)(comboMultiplier - 1) * (factor * Math.max(Math.min(timer / (5.0f * baseTimeMult), 1.0f), 0.0f)));
    }

    private static void glColor(Color color, float alphaMult) {
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult)));
    }

    private static void resetKills() {
        deathCount = 0;
        spreeKills = 0;
        comboTimer = 0.0f;
        comboOn = false;
    }

    public void advance(float amount, List<InputEventAPI> events) {
        float baseTimeMult = UnrealAnnouncer.getBaseWarpMult(deathCount, 0.125f);
        float playerTimeMult = UnrealAnnouncer.getWarpMult(deathCount, 0.125f, comboTimer);
        float playerShotTimeMult = UnrealAnnouncer.getWarpMult(deathCount, 0.1f, comboTimer);
        float bossTimeMult = UnrealAnnouncer.getWarpMult(deathCount, 0.075f, comboTimer);
        if (!this.engine.isPaused()) {
            if (!comboOn && deathCount > 0) {
                comboOn = true;
                comboTimer = 20.0f;
            }
            if (comboOn) {
                timerCap = Math.max(timerCap, comboTimer);
                comboTimer -= amount / playerTimeMult;
                this.engine.getPlayerShip().setCurrentCR(1.0f);
                if (deathCount > 1) {
                    this.engine.getPlayerShip().setJitterUnder((Object)this, WARP_JITTER_COLOR, 0.2f / playerTimeMult, Math.round(5.0f / playerTimeMult), 0.5f / playerTimeMult, 3.0f / playerTimeMult);
                    this.engine.getTimeMult().modifyMult("wombo_combo", playerTimeMult);
                    this.engine.getPlayerShip().getMutableStats().getTimeMult().modifyMult("wombo_combo", 1.0f / playerTimeMult);
                    this.engine.getPlayerShip().getMutableStats().getProjectileSpeedMult().modifyMult("wombo_combo", 1.0f / playerShotTimeMult);
                    this.engine.getPlayerShip().getMutableStats().getMissileAccelerationBonus().modifyMult("wombo_combo", 1.0f / playerShotTimeMult);
                    this.engine.getPlayerShip().getMutableStats().getMissileMaxSpeedBonus().modifyMult("wombo_combo", 1.0f / playerShotTimeMult);
                    this.engine.getPlayerShip().getMutableStats().getMissileMaxTurnRateBonus().modifyMult("wombo_combo", 1.0f / playerShotTimeMult);
                    this.engine.getPlayerShip().getMutableStats().getMissileTurnAccelerationBonus().modifyMult("wombo_combo", 1.0f / playerShotTimeMult);
                    for (ShipAPI ship : this.engine.getShips()) {
                        if (ship == this.engine.getPlayerShip() || !ship.isAlive() || !MissionPlugin.BOSS_SHIPS.containsKey(ship.getHullSpec().getHullId())) continue;
                        ship.getMutableStats().getTimeMult().modifyMult("wombo_combo", 1.0f / bossTimeMult);
                        ship.getMutableStats().getProjectileSpeedMult().modifyMult("wombo_combo", 1.0f / bossTimeMult);
                        ship.getMutableStats().getMissileAccelerationBonus().modifyMult("wombo_combo", 1.0f / bossTimeMult);
                        ship.getMutableStats().getMissileMaxSpeedBonus().modifyMult("wombo_combo", 1.0f / bossTimeMult);
                        ship.getMutableStats().getMissileMaxTurnRateBonus().modifyMult("wombo_combo", 1.0f / bossTimeMult);
                        ship.getMutableStats().getMissileTurnAccelerationBonus().modifyMult("wombo_combo", 1.0f / bossTimeMult);
                    }
                }
            }
            if (comboOn && deathCount > spreeKills) {
                this.playSound(deathCount);
                spreeKills = deathCount;
            }
            if (comboOn && comboTimer <= 0.0f) {
                UnrealAnnouncer.resetKills();
                timerCap = 1.0f;
                this.engine.getPlayerShip().setCurrentCR(1.0f);
                this.engine.getTimeMult().unmodify("wombo_combo");
                this.engine.getPlayerShip().getMutableStats().getTimeMult().unmodify("wombo_combo");
                for (ShipAPI ship : this.engine.getShips()) {
                    if (ship == this.engine.getPlayerShip() || !ship.isAlive() || !MissionPlugin.BOSS_SHIPS.containsKey(ship.getHullSpec().getHullId())) continue;
                    ship.getMutableStats().getTimeMult().unmodify("wombo_combo");
                }
            }
        }
        GL11.glPushAttrib((int)1048575);
        int w = (int)((float)Display.getWidth() * Display.getPixelScaleFactor());
        int h = (int)((float)Display.getHeight() * Display.getPixelScaleFactor());
        GL11.glViewport((int)0, (int)0, (int)w, (int)h);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)Global.getSettings().getScreenWidth(), (double)0.0, (double)Global.getSettings().getScreenHeight(), (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)0.01f, (float)0.01f, (float)0.0f);
        if (deathCount > 1) {
            GL11.glBegin((int)7);
            UnrealAnnouncer.glColor(BACKGROUND_COLOR, 1.0f);
            GL11.glVertex2f((float)(UnrealAnnouncer.position.x - width * 0.5f + 1.0f), (float)(UnrealAnnouncer.position.y + 4.0f - 1.0f));
            GL11.glVertex2f((float)(UnrealAnnouncer.position.x + width * 0.5f - width * (1.0f - comboTimer / timerCap) + 1.0f), (float)(UnrealAnnouncer.position.y + 4.0f - 1.0f));
            GL11.glVertex2f((float)(UnrealAnnouncer.position.x + width * 0.5f - width * (1.0f - comboTimer / timerCap) + 1.0f), (float)(UnrealAnnouncer.position.y - 4.0f - 1.0f));
            GL11.glVertex2f((float)(UnrealAnnouncer.position.x - width * 0.5f + 1.0f), (float)(UnrealAnnouncer.position.y - 4.0f - 1.0f));
            if (comboTimer <= 5.0f) {
                UnrealAnnouncer.glColor(LOW_COLOR, 1.0f);
            } else if (comboTimer <= 10.0f) {
                UnrealAnnouncer.glColor(MID_COLOR, 1.0f);
            } else {
                UnrealAnnouncer.glColor(HIGH_COLOR, 1.0f);
            }
            GL11.glVertex2f((float)(UnrealAnnouncer.position.x - width * 0.5f), (float)(UnrealAnnouncer.position.y + 4.0f));
            GL11.glVertex2f((float)(UnrealAnnouncer.position.x + width * 0.5f - width * (1.0f - comboTimer / timerCap)), (float)(UnrealAnnouncer.position.y + 4.0f));
            GL11.glVertex2f((float)(UnrealAnnouncer.position.x + width * 0.5f - width * (1.0f - comboTimer / timerCap)), (float)(UnrealAnnouncer.position.y - 4.0f));
            GL11.glVertex2f((float)(UnrealAnnouncer.position.x - width * 0.5f), (float)(UnrealAnnouncer.position.y - 4.0f));
            GL11.glEnd();
        }
        GL11.glDisable((int)3042);
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
        deathCount = 0;
        spreeKills = 0;
        comboTimer = 0.0f;
        timerCap = 1.0f;
        comboOn = false;
        engine.getPlayerShip().setCurrentCR(1.0f);
    }

    private void playSound(int recentKills) {
        SoundPlayerAPI sp = Global.getSoundPlayer();
        float pitch = 1.0f;
        float vol = 1.0f;
        if (recentKills == 2) {
            sp.playUISound("two_kills", pitch, vol);
        } else if (recentKills == 3) {
            sp.playUISound("three_kills", pitch, vol);
        } else if (recentKills == 4) {
            sp.playUISound("four_kills", pitch, vol);
        } else if (recentKills == 5) {
            sp.playUISound("five_kills", pitch, vol);
        } else if (recentKills == 6) {
            sp.playUISound("six_kills", pitch, vol);
        } else if (recentKills == 7) {
            sp.playUISound("seven_kills", pitch, vol);
        } else if (recentKills == 8) {
            sp.playUISound("eight_kills", pitch, vol);
        } else if (recentKills == 9) {
            sp.playUISound("nine_kills", pitch, vol);
        } else if (recentKills == 10) {
            sp.playUISound("ten_kills", pitch, vol);
        } else if (recentKills == 11) {
            sp.playUISound("eleven_kills", pitch, vol);
        } else if (recentKills == 12) {
            sp.playUISound("twelve_kills", pitch, vol);
        } else if (recentKills == 13) {
            sp.playUISound("thirteen_kills", pitch, vol);
        } else if (recentKills == 14) {
            sp.playUISound("fourteen_kills", pitch, vol);
        } else if (recentKills == 15) {
            sp.playUISound("fifteen_kills", pitch, vol);
        } else if (recentKills == 16) {
            sp.playUISound("sixteen_kills", pitch, vol);
        } else if (recentKills == 17) {
            sp.playUISound("seventeen_kills", pitch, vol);
        } else if (recentKills == 18) {
            sp.playUISound("eighteen_kills", pitch, vol);
        } else if (recentKills == 19) {
            sp.playUISound("ninteen_kills", pitch, vol);
        } else if (recentKills == 20) {
            sp.playUISound("twenty_kills", pitch, vol);
        } else if (recentKills == 21) {
            sp.playUISound("twentyone_kills", pitch, vol);
        } else if (recentKills == 22) {
            sp.playUISound("twentytwo_kills", pitch, vol);
        } else if (recentKills >= 23) {
            sp.playUISound("wtf_kills", pitch, vol);
        }
    }
}

