/*
 * Decompiled with CFR 0.152.
 */
package data.missions.arcade;

import com.fs.starfarer.api.Global;
import java.awt.Color;
import java.util.List;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class ProgressBar {
    private static final Color BACKGROUND_COLOR = new Color(50, 50, 50, 255);
    private static final Color BORDER_COLOR = new Color(96, 96, 96, 255);
    private static final Color NOTCH1_COLOR = new Color(0, 0, 0, 255);
    private static final Color NOTCH2_COLOR = new Color(191, 191, 191, 255);
    private static final Color PROGRESS_COLOR = new Color(255, 204, 0, 255);
    private final float height;
    private final List<Float> notches;
    private final Vector2f position;
    private float progress;
    private final float width;

    private static void glColor(Color color, float alphaMult) {
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult)));
    }

    public ProgressBar(float progress, List<Float> notches, Vector2f position, float height, float width) {
        this.progress = progress;
        this.notches = notches;
        this.position = new Vector2f((ReadableVector2f)position);
        this.position.y = Global.getSettings().getScreenHeight() - this.position.y;
        this.height = height;
        this.width = width;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public void render() {
        GL11.glPushAttrib((int)1048575);
        int w = (int)((float)Display.getWidth() * Display.getPixelScaleFactor());
        int h = (int)((float)Display.getHeight() * Display.getPixelScaleFactor());
        GL11.glViewport((int)0, (int)0, (int)w, (int)h);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)Global.getSettings().getScreenWidth(), (double)0.0, (double)Global.getSettings().getScreenHeight(), (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)0.01f, (float)0.01f, (float)0.0f);
        GL11.glBegin((int)7);
        ProgressBar.glColor(BACKGROUND_COLOR, 0.5f);
        GL11.glVertex2f((float)(this.position.x - this.width * 0.5f), (float)(this.position.y + this.height * 0.5f));
        GL11.glVertex2f((float)(this.position.x + this.width * 0.5f), (float)(this.position.y + this.height * 0.5f));
        GL11.glVertex2f((float)(this.position.x + this.width * 0.5f), (float)(this.position.y - this.height * 0.5f));
        GL11.glVertex2f((float)(this.position.x - this.width * 0.5f), (float)(this.position.y - this.height * 0.5f));
        ProgressBar.glColor(PROGRESS_COLOR, 0.75f);
        GL11.glVertex2f((float)(this.position.x - this.width * 0.5f), (float)(this.position.y + this.height * 0.5f - this.height * (1.0f - this.progress)));
        GL11.glVertex2f((float)(this.position.x + this.width * 0.5f), (float)(this.position.y + this.height * 0.5f - this.height * (1.0f - this.progress)));
        GL11.glVertex2f((float)(this.position.x + this.width * 0.5f), (float)(this.position.y - this.height * 0.5f));
        GL11.glVertex2f((float)(this.position.x - this.width * 0.5f), (float)(this.position.y - this.height * 0.5f));
        GL11.glEnd();
        GL11.glBegin((int)2);
        GL11.glLineWidth((float)4.0f);
        ProgressBar.glColor(BORDER_COLOR, 1.0f);
        GL11.glVertex2f((float)(this.position.x - this.width * 0.5f), (float)(this.position.y + this.height * 0.5f));
        GL11.glVertex2f((float)(this.position.x + this.width * 0.5f), (float)(this.position.y + this.height * 0.5f));
        GL11.glVertex2f((float)(this.position.x + this.width * 0.5f), (float)(this.position.y - this.height * 0.5f));
        GL11.glVertex2f((float)(this.position.x - this.width * 0.5f), (float)(this.position.y - this.height * 0.5f));
        GL11.glEnd();
        GL11.glBegin((int)1);
        for (Float notch : this.notches) {
            if (this.progress >= notch.floatValue()) {
                ProgressBar.glColor(NOTCH1_COLOR, 0.75f);
            } else {
                ProgressBar.glColor(NOTCH2_COLOR, 0.75f);
            }
            GL11.glVertex2f((float)(this.position.x - (float)Math.floor(this.width * 0.25f)), (float)(this.position.y + this.height * 0.5f - this.height * (1.0f - notch.floatValue())));
            GL11.glVertex2f((float)(this.position.x + (float)Math.ceil(this.width * 0.25f)), (float)(this.position.y + this.height * 0.5f - this.height * (1.0f - notch.floatValue())));
        }
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }
}

