/*
 * Decompiled with CFR 0.152.
 */
package data.missions.arcade;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.ArmorGridAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatAssignmentType;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.CombatFleetManagerAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DeployedFleetMemberAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.combat.WeaponGroupAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.fleet.ShipRolePick;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.util.WeightedRandomPicker;
import data.missions.arcade.HealthBar;
import data.missions.arcade.ProgressBar;
import data.missions.arcade.UnrealAnnouncer;
import data.scripts.SWPModPlugin;
import data.scripts.util.DS_Defs;
import data.scripts.util.SWP_Multi;
import data.scripts.util.SWP_Util;
import data.scripts.variants.DS_VariantRandomizer;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.dark.shaders.post.PostProcessShader;
import org.json.JSONException;
import org.json.JSONObject;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.entities.AnchoredEntity;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MissionPlugin
extends BaseEveryFrameCombatPlugin {
    private static final Map<ShipAPI.HullSize, Integer> AURA_MOD = new HashMap<ShipAPI.HullSize, Integer>(6);
    private static final String DATA_KEY = "SSP_Arcade";
    private static final WeightedRandomPicker<String> FACTIONS = new WeightedRandomPicker();
    private static final WeightedRandomPicker<String> ROLES = new WeightedRandomPicker();
    private static final WeightedRandomPicker<String> SPECIAL_SHIPS = new WeightedRandomPicker();
    private static final Vector2f ZERO = new Vector2f();
    private static boolean first = true;
    static final Map<String, Float> BOSS_SHIPS = new HashMap<String, Float>(9);
    private HealthBar bar1 = null;
    private HealthBar bar2 = null;
    private HealthBar bar3 = null;
    private float bossAmmoRegenTimer = 0.0f;
    private float bossFlash = 0.0f;
    private int bossLevel = 0;
    private float buffLevel = 0.0f;
    private boolean combatOver = false;
    private CombatEngineAPI engine;
    private float mapX = 0.0f;
    private float mapY = 0.0f;
    private float maxPoints = 50.0f;
    private ProgressBar pbar = null;
    private int points = 0;
    private float scale = 1.0f;
    private float snapback = 0.0f;
    private int threshold = 0;
    private int ultralevel = 0;
    private float warningBeep = 0.0f;

    public void advance(float amount, List<InputEventAPI> events) {
        Object[] entries;
        ShipAPI[] ships;
        ShipAPI playerShip = this.engine.getPlayerShip();
        this.pbar.setProgress(Math.min((this.maxPoints - 50.0f) / 87.5f, 1.0f));
        this.pbar.render();
        if (!this.engine.isPaused()) {
            this.bossFlash += amount;
            this.bossAmmoRegenTimer += amount;
        }
        LocalData localData = (LocalData)this.engine.getCustomData().get(DATA_KEY);
        Map<ShipAPI, Integer> shipTypes = localData.shipTypes;
        Map<ShipAPI, Float> shipWorths = localData.shipWorths;
        float realBuff = (float)Math.pow(this.buffLevel * 0.33f, 0.4);
        float mookBuff = (float)Math.pow(this.buffLevel * 0.33f * this.scale, 0.7);
        List bufflist = this.engine.getShips();
        for (ShipAPI ship : bufflist) {
            if (ship == playerShip || !ship.isAlive()) continue;
            ship.getMutableStats().getBallisticWeaponDamageMult().modifyMult("arcade", 0.75f + mookBuff);
            ship.getMutableStats().getEnergyWeaponDamageMult().modifyMult("arcade", 0.75f + mookBuff);
            ship.getMutableStats().getBallisticRoFMult().modifyMult("arcade", 1.0f + mookBuff * 0.1f);
            ship.getMutableStats().getEnergyRoFMult().modifyMult("arcade", 1.0f + mookBuff * 0.1f);
            ship.getMutableStats().getBeamWeaponDamageMult().modifyMult("arcade", 1.0f + mookBuff * 0.1f);
            ship.getMutableStats().getMissileWeaponDamageMult().modifyMult("arcade", 0.75f + mookBuff);
            ship.getMutableStats().getFluxDissipation().modifyMult("arcade", 0.75f + mookBuff);
            ship.getMutableStats().getFluxCapacity().modifyMult("arcade", 0.75f + mookBuff * 0.5f);
            ship.getMutableStats().getAcceleration().modifyMult("arcade", 1.0f + mookBuff * 0.1f);
            ship.getMutableStats().getDeceleration().modifyMult("arcade", 1.0f + mookBuff * 0.1f);
            ship.getMutableStats().getArmorDamageTakenMult().modifyMult("arcade", 1.0f / (1.0f + mookBuff * 0.75f));
            ship.getMutableStats().getHullDamageTakenMult().modifyMult("arcade", 1.0f / (1.0f + mookBuff * 0.75f));
            ship.getMutableStats().getMaxSpeed().modifyMult("arcade", 1.0f + mookBuff * 0.1f);
            ship.getMutableStats().getEnergyWeaponRangeBonus().modifyMult("arcade", 1.0f + mookBuff * 0.35f);
            ship.getMutableStats().getBallisticWeaponRangeBonus().modifyMult("arcade", 1.0f + mookBuff * 0.35f);
            ship.getMutableStats().getWeaponHealthBonus().modifyMult("arcade", 1.0f + mookBuff * 0.5f);
            ship.getMutableStats().getMissileRoFMult().modifyMult("arcade", 1.0f + mookBuff * 0.1f);
            ship.getMutableStats().getMissileGuidance().modifyMult("arcade", 1.0f + mookBuff * 0.1f);
            ship.getMutableStats().getWeaponTurnRateBonus().modifyMult("arcade", 1.0f + mookBuff * 0.1f);
            ship.getMutableStats().getMissileMaxSpeedBonus().modifyMult("arcade", 1.0f + mookBuff * 0.25f);
            ship.getMutableStats().getMissileAccelerationBonus().modifyMult("arcade", 1.0f + mookBuff * 0.25f);
            ship.getMutableStats().getMissileMaxTurnRateBonus().modifyMult("arcade", 1.0f + mookBuff * 0.25f);
            ship.getMutableStats().getMissileTurnAccelerationBonus().modifyMult("arcade", 1.0f + mookBuff * 0.25f);
            ship.getMutableStats().getProjectileSpeedMult().modifyMult("arcade", 1.0f + mookBuff * 0.35f);
            ship.getMutableStats().getShieldUpkeepMult().modifyMult("arcade", 1.0f + mookBuff * 1.25f);
            ship.getMutableStats().getPhaseCloakActivationCostBonus().modifyMult("arcade", 1.0f + mookBuff);
            ship.getMutableStats().getPhaseCloakUpkeepCostBonus().modifyMult("arcade", 1.0f + mookBuff * 1.25f);
            if (ship.getOriginalOwner() != 1) {
                ship.setOriginalOwner(1);
                ship.setOwner(1);
            }
            if (ship.isFighter() && ship.getWing() != null) {
                ship.getWing().setWingOwner(1);
            }
            float shipRadius = SWP_Util.effectiveRadius(ship);
            Object shipForStats = ship;
            if (shipForStats.getWing() != null) {
                shipForStats = shipForStats.getWing().getSourceShip();
            }
            if (!shipTypes.containsKey(shipForStats)) continue;
            switch (shipTypes.get(shipForStats)) {
                case 1: {
                    int i;
                    for (i = 0; i < AURA_MOD.get(ship.getHullSize()); ++i) {
                        if (!(Math.random() < (double)(amount * 6.0f)) || this.engine.isPaused()) continue;
                        this.engine.addSmoothParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 12.5f + 2.5f, (float)Math.random() * 1.0f, 1.0f, new Color(255, 255, 100));
                    }
                    if ((int)(this.engine.getTotalElapsedTime(true) * 60.0f) % 15 == 0) {
                        ship.getSpriteAPI().setColor(new Color(255, 255, 100));
                        for (WeaponAPI weapon : ship.getAllWeapons()) {
                            if (weapon.getSlot().isHidden()) continue;
                            if (weapon.getSprite() != null) {
                                weapon.getSprite().setColor(new Color(255, 255, 100));
                            }
                            if (weapon.getBarrelSpriteAPI() == null) continue;
                            weapon.getBarrelSpriteAPI().setColor(new Color(255, 255, 100));
                        }
                        if (ship.getDeployedDrones() != null) {
                            for (ShipAPI drone : ship.getDeployedDrones()) {
                                drone.getSpriteAPI().setColor(new Color(255, 255, 100));
                                drone.getMutableStats().getArmorDamageTakenMult().modifyMult("mook", 0.5f);
                                drone.getMutableStats().getHullDamageTakenMult().modifyMult("mook", 0.5f);
                                drone.getMutableStats().getShieldDamageTakenMult().modifyMult("mook", 0.5f);
                                drone.getMutableStats().getWeaponDamageTakenMult().modifyMult("mook", 0.25f);
                                drone.getMutableStats().getEngineDamageTakenMult().modifyMult("mook", 0.25f);
                                drone.getMutableStats().getAcceleration().modifyMult("mook", 0.5f);
                                drone.getMutableStats().getDeceleration().modifyMult("mook", 0.5f);
                                drone.getMutableStats().getMaxSpeed().modifyMult("mook", 0.5f);
                                drone.getMutableStats().getShieldTurnRateMult().modifyMult("mook", 0.25f);
                                drone.getMutableStats().getShieldUnfoldRateMult().modifyMult("mook", 0.5f);
                                if (drone.getShield() != null) {
                                    drone.getShield().setInnerColor(new Color(255, 255, 100));
                                    drone.getShield().setRingColor(new Color(255, 255, 180));
                                }
                                if (drone.getEngineController() == null) continue;
                                drone.getEngineController().fadeToOtherColor((Object)this, new Color(255, 255, 180), new Color(255, 255, 100), 1.0f, 1.0f);
                            }
                        }
                        if (ship.isShipWithModules()) {
                            for (ShipAPI child : SWP_Multi.getChildren(ship)) {
                                child.getSpriteAPI().setColor(new Color(255, 255, 100));
                                child.getMutableStats().getArmorDamageTakenMult().modifyMult("mook", 0.5f);
                                child.getMutableStats().getHullDamageTakenMult().modifyMult("mook", 0.5f);
                                child.getMutableStats().getShieldDamageTakenMult().modifyMult("mook", 0.5f);
                                child.getMutableStats().getWeaponDamageTakenMult().modifyMult("mook", 0.25f);
                                child.getMutableStats().getEngineDamageTakenMult().modifyMult("mook", 0.25f);
                                child.getMutableStats().getAcceleration().modifyMult("mook", 0.5f);
                                child.getMutableStats().getDeceleration().modifyMult("mook", 0.5f);
                                child.getMutableStats().getMaxSpeed().modifyMult("mook", 0.5f);
                                child.getMutableStats().getShieldTurnRateMult().modifyMult("mook", 0.25f);
                                child.getMutableStats().getShieldUnfoldRateMult().modifyMult("mook", 0.5f);
                                if (child.getShield() != null) {
                                    child.getShield().setInnerColor(new Color(255, 255, 100));
                                    child.getShield().setRingColor(new Color(255, 255, 180));
                                }
                                if (child.getEngineController() == null) continue;
                                child.getEngineController().fadeToOtherColor((Object)this, new Color(255, 255, 180), new Color(255, 255, 100), 1.0f, 1.0f);
                            }
                        }
                        if (ship.getShield() != null) {
                            ship.getShield().setInnerColor(new Color(255, 255, 100));
                            ship.getShield().setRingColor(new Color(255, 255, 180));
                        }
                        if (ship.getEngineController() != null) {
                            ship.getEngineController().fadeToOtherColor((Object)this, new Color(255, 255, 180), new Color(255, 255, 100), 1.0f, 1.0f);
                        }
                    }
                    ship.getMutableStats().getArmorDamageTakenMult().modifyMult("mook", 0.5f);
                    ship.getMutableStats().getHullDamageTakenMult().modifyMult("mook", 0.5f);
                    ship.getMutableStats().getShieldDamageTakenMult().modifyMult("mook", 0.5f);
                    ship.getMutableStats().getWeaponDamageTakenMult().modifyMult("mook", 0.25f);
                    ship.getMutableStats().getEngineDamageTakenMult().modifyMult("mook", 0.25f);
                    ship.getMutableStats().getAcceleration().modifyMult("mook", 0.5f);
                    ship.getMutableStats().getDeceleration().modifyMult("mook", 0.5f);
                    ship.getMutableStats().getMaxSpeed().modifyMult("mook", 0.5f);
                    ship.getMutableStats().getMaxTurnRate().modifyMult("mook", 0.5f);
                    ship.getMutableStats().getTurnAcceleration().modifyMult("mook", 0.5f);
                    ship.getMutableStats().getShieldTurnRateMult().modifyMult("mook", 0.25f);
                    ship.getMutableStats().getShieldUnfoldRateMult().modifyMult("mook", 0.5f);
                    break;
                }
                case 2: {
                    int i;
                    for (i = 0; i < AURA_MOD.get(ship.getHullSize()); ++i) {
                        if (!(Math.random() < (double)(amount * 9.0f)) || this.engine.isPaused()) continue;
                        this.engine.addSmoothParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 10.0f + 5.0f, (float)Math.random() * 0.75f + 0.25f, 1.0f, new Color(255, 150, 100));
                    }
                    if ((int)(this.engine.getTotalElapsedTime(true) * 60.0f) % 15 == 0) {
                        ship.getSpriteAPI().setColor(new Color(255, 150, 100));
                        for (WeaponAPI weapon : ship.getAllWeapons()) {
                            if (weapon.getSlot().isHidden()) continue;
                            if (weapon.getSprite() != null) {
                                weapon.getSprite().setColor(new Color(255, 150, 100));
                            }
                            if (weapon.getBarrelSpriteAPI() == null) continue;
                            weapon.getBarrelSpriteAPI().setColor(new Color(255, 150, 100));
                        }
                        if (ship.getDeployedDrones() != null) {
                            for (ShipAPI drone : ship.getDeployedDrones()) {
                                drone.getSpriteAPI().setColor(new Color(255, 150, 100));
                                drone.getMutableStats().getFluxDissipation().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getFluxCapacity().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getBallisticRoFMult().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getEnergyRoFMult().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getMissileRoFMult().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getBeamWeaponDamageMult().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getBallisticWeaponDamageMult().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getEnergyWeaponDamageMult().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getMissileWeaponDamageMult().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getShieldUpkeepMult().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getPhaseCloakActivationCostBonus().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getPhaseCloakUpkeepCostBonus().modifyMult("mook", 2.0f);
                                if (drone.getShield() != null) {
                                    drone.getShield().setInnerColor(new Color(255, 150, 100));
                                    drone.getShield().setRingColor(new Color(255, 205, 180));
                                }
                                if (drone.getEngineController() == null) continue;
                                drone.getEngineController().fadeToOtherColor((Object)this, new Color(255, 205, 180), new Color(255, 150, 100), 1.0f, 1.0f);
                            }
                        }
                        if (ship.isShipWithModules()) {
                            for (ShipAPI child : SWP_Multi.getChildren(ship)) {
                                child.getSpriteAPI().setColor(new Color(255, 150, 100));
                                child.getMutableStats().getFluxDissipation().modifyMult("mook", 2.0f);
                                child.getMutableStats().getFluxCapacity().modifyMult("mook", 2.0f);
                                child.getMutableStats().getBallisticRoFMult().modifyMult("mook", 2.0f);
                                child.getMutableStats().getEnergyRoFMult().modifyMult("mook", 2.0f);
                                child.getMutableStats().getMissileRoFMult().modifyMult("mook", 2.0f);
                                child.getMutableStats().getBeamWeaponDamageMult().modifyMult("mook", 2.0f);
                                child.getMutableStats().getBallisticWeaponDamageMult().modifyMult("mook", 2.0f);
                                child.getMutableStats().getEnergyWeaponDamageMult().modifyMult("mook", 2.0f);
                                child.getMutableStats().getMissileWeaponDamageMult().modifyMult("mook", 2.0f);
                                child.getMutableStats().getShieldUpkeepMult().modifyMult("mook", 2.0f);
                                child.getMutableStats().getPhaseCloakActivationCostBonus().modifyMult("mook", 2.0f);
                                child.getMutableStats().getPhaseCloakUpkeepCostBonus().modifyMult("mook", 2.0f);
                                if (child.getShield() != null) {
                                    child.getShield().setInnerColor(new Color(255, 150, 100));
                                    child.getShield().setRingColor(new Color(255, 205, 180));
                                }
                                if (child.getEngineController() == null) continue;
                                child.getEngineController().fadeToOtherColor((Object)this, new Color(255, 205, 180), new Color(255, 150, 100), 1.0f, 1.0f);
                            }
                        }
                        if (ship.getShield() != null) {
                            ship.getShield().setInnerColor(new Color(255, 150, 100));
                            ship.getShield().setRingColor(new Color(255, 205, 180));
                        }
                        if (ship.getEngineController() != null) {
                            ship.getEngineController().fadeToOtherColor((Object)this, new Color(255, 205, 180), new Color(255, 150, 100), 1.0f, 1.0f);
                        }
                    }
                    ship.getMutableStats().getFluxDissipation().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getFluxCapacity().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getBallisticRoFMult().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getEnergyRoFMult().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getMissileRoFMult().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getBeamWeaponDamageMult().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getBallisticWeaponDamageMult().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getEnergyWeaponDamageMult().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getMissileWeaponDamageMult().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getShieldUpkeepMult().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getPhaseCloakActivationCostBonus().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getPhaseCloakUpkeepCostBonus().modifyMult("mook", 2.0f);
                    break;
                }
                case 3: {
                    int i;
                    for (i = 0; i < AURA_MOD.get(ship.getHullSize()); ++i) {
                        if (!(Math.random() < (double)(amount * 12.0f)) || this.engine.isPaused()) continue;
                        this.engine.addSmoothParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 7.5f + 7.5f, (float)Math.random() * 0.5f + 0.5f, 1.0f, new Color(50, 150, 255));
                    }
                    if ((int)(this.engine.getTotalElapsedTime(true) * 60.0f) % 15 == 0) {
                        ship.getSpriteAPI().setColor(new Color(50, 150, 255));
                        for (WeaponAPI weapon : ship.getAllWeapons()) {
                            if (weapon.getSlot().isHidden()) continue;
                            if (weapon.getSprite() != null) {
                                weapon.getSprite().setColor(new Color(50, 150, 255));
                            }
                            if (weapon.getBarrelSpriteAPI() == null) continue;
                            weapon.getBarrelSpriteAPI().setColor(new Color(50, 150, 255));
                        }
                        if (ship.getDeployedDrones() != null) {
                            for (ShipAPI drone : ship.getDeployedDrones()) {
                                drone.getSpriteAPI().setColor(new Color(50, 150, 255));
                                drone.getMutableStats().getArmorDamageTakenMult().modifyMult("mook", 0.5f);
                                drone.getMutableStats().getHullDamageTakenMult().modifyMult("mook", 0.25f);
                                drone.getMutableStats().getWeaponDamageTakenMult().modifyMult("mook", 0.25f);
                                drone.getMutableStats().getEngineDamageTakenMult().modifyMult("mook", 0.25f);
                                drone.getMutableStats().getAcceleration().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getDeceleration().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getMaxSpeed().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getFluxDissipation().modifyMult("mook", 3.0f);
                                drone.getMutableStats().getFluxCapacity().modifyMult("mook", 3.0f);
                                drone.getMutableStats().getBallisticRoFMult().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getEnergyRoFMult().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getMissileRoFMult().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getBeamWeaponDamageMult().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getBallisticWeaponDamageMult().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getEnergyWeaponDamageMult().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getMissileWeaponDamageMult().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getShieldUpkeepMult().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getPhaseCloakActivationCostBonus().modifyMult("mook", 2.0f);
                                drone.getMutableStats().getPhaseCloakUpkeepCostBonus().modifyMult("mook", 2.0f);
                                if (drone.getShield() != null) {
                                    drone.getShield().setInnerColor(new Color(50, 150, 255));
                                    drone.getShield().setRingColor(new Color(155, 205, 255));
                                }
                                if (drone.getEngineController() == null) continue;
                                drone.getEngineController().fadeToOtherColor((Object)this, new Color(155, 205, 255), new Color(50, 150, 255), 1.0f, 1.0f);
                            }
                        }
                        if (ship.isShipWithModules()) {
                            for (ShipAPI child : SWP_Multi.getChildren(ship)) {
                                child.getSpriteAPI().setColor(new Color(50, 150, 255));
                                child.getMutableStats().getArmorDamageTakenMult().modifyMult("mook", 0.5f);
                                child.getMutableStats().getHullDamageTakenMult().modifyMult("mook", 0.25f);
                                child.getMutableStats().getWeaponDamageTakenMult().modifyMult("mook", 0.25f);
                                child.getMutableStats().getEngineDamageTakenMult().modifyMult("mook", 0.25f);
                                child.getMutableStats().getAcceleration().modifyMult("mook", 2.0f);
                                child.getMutableStats().getDeceleration().modifyMult("mook", 2.0f);
                                child.getMutableStats().getMaxSpeed().modifyMult("mook", 2.0f);
                                child.getMutableStats().getFluxDissipation().modifyMult("mook", 3.0f);
                                child.getMutableStats().getFluxCapacity().modifyMult("mook", 3.0f);
                                child.getMutableStats().getBallisticRoFMult().modifyMult("mook", 2.0f);
                                child.getMutableStats().getEnergyRoFMult().modifyMult("mook", 2.0f);
                                child.getMutableStats().getMissileRoFMult().modifyMult("mook", 2.0f);
                                child.getMutableStats().getBeamWeaponDamageMult().modifyMult("mook", 2.0f);
                                child.getMutableStats().getBallisticWeaponDamageMult().modifyMult("mook", 2.0f);
                                child.getMutableStats().getEnergyWeaponDamageMult().modifyMult("mook", 2.0f);
                                child.getMutableStats().getMissileWeaponDamageMult().modifyMult("mook", 2.0f);
                                child.getMutableStats().getShieldUpkeepMult().modifyMult("mook", 2.0f);
                                child.getMutableStats().getPhaseCloakActivationCostBonus().modifyMult("mook", 2.0f);
                                child.getMutableStats().getPhaseCloakUpkeepCostBonus().modifyMult("mook", 2.0f);
                                if (child.getShield() != null) {
                                    child.getShield().setInnerColor(new Color(50, 150, 255));
                                    child.getShield().setRingColor(new Color(155, 205, 255));
                                }
                                if (child.getEngineController() == null) continue;
                                child.getEngineController().fadeToOtherColor((Object)this, new Color(155, 205, 255), new Color(50, 150, 255), 1.0f, 1.0f);
                            }
                        }
                        if (ship.getShield() != null) {
                            ship.getShield().setInnerColor(new Color(50, 150, 255));
                            ship.getShield().setRingColor(new Color(155, 205, 255));
                        }
                        if (ship.getEngineController() != null) {
                            ship.getEngineController().fadeToOtherColor((Object)this, new Color(155, 205, 255), new Color(50, 150, 255), 1.0f, 1.0f);
                        }
                    }
                    ship.getMutableStats().getArmorDamageTakenMult().modifyMult("mook", 0.5f);
                    ship.getMutableStats().getHullDamageTakenMult().modifyMult("mook", 0.25f);
                    ship.getMutableStats().getWeaponDamageTakenMult().modifyMult("mook", 0.25f);
                    ship.getMutableStats().getEngineDamageTakenMult().modifyMult("mook", 0.25f);
                    ship.getMutableStats().getAcceleration().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getDeceleration().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getMaxSpeed().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getTurnAcceleration().modifyMult("mook", 1.5f);
                    ship.getMutableStats().getMaxTurnRate().modifyMult("mook", 1.5f);
                    ship.getMutableStats().getFluxDissipation().modifyMult("mook", 3.0f);
                    ship.getMutableStats().getFluxCapacity().modifyMult("mook", 3.0f);
                    ship.getMutableStats().getBallisticRoFMult().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getEnergyRoFMult().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getMissileRoFMult().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getBeamWeaponDamageMult().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getBallisticWeaponDamageMult().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getEnergyWeaponDamageMult().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getMissileWeaponDamageMult().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getShieldUpkeepMult().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getPhaseCloakActivationCostBonus().modifyMult("mook", 2.0f);
                    ship.getMutableStats().getPhaseCloakUpkeepCostBonus().modifyMult("mook", 2.0f);
                    break;
                }
                case 4: {
                    float shieldsize;
                    int i;
                    for (i = 0; i < AURA_MOD.get(ship.getHullSize()); ++i) {
                        if (!(Math.random() < (double)(amount * 6.0f)) || this.engine.isPaused()) continue;
                        this.engine.addSmoothParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 12.5f + 2.5f, (float)Math.random() * 1.0f, 1.0f, new Color(100, 255, 150));
                    }
                    if ((int)(this.engine.getTotalElapsedTime(true) * 60.0f) % 15 == 0) {
                        ship.getSpriteAPI().setColor(new Color(100, 255, 150));
                        for (WeaponAPI weapon : ship.getAllWeapons()) {
                            if (weapon.getSlot().isHidden()) continue;
                            if (weapon.getSprite() != null) {
                                weapon.getSprite().setColor(new Color(100, 255, 150));
                            }
                            if (weapon.getBarrelSpriteAPI() == null) continue;
                            weapon.getBarrelSpriteAPI().setColor(new Color(100, 255, 150));
                        }
                        if (ship.getDeployedDrones() != null) {
                            for (ShipAPI drone : ship.getDeployedDrones()) {
                                drone.getSpriteAPI().setColor(new Color(100, 255, 150));
                                if (drone.getShield() == null || drone.getShield().getType() != ShieldAPI.ShieldType.FRONT) {
                                    drone.setShield(ShieldAPI.ShieldType.FRONT, 0.0f, 0.0f, 180.0f);
                                }
                                drone.getMutableStats().getShieldUpkeepMult().modifyMult("mook", 0.0f);
                                drone.getMutableStats().getShieldDamageTakenMult().modifyMult("mook", 0.0f);
                                drone.getMutableStats().getShieldUnfoldRateMult().modifyMult("mook", 5.0f);
                                drone.getMutableStats().getTurnAcceleration().modifyMult("mook", 1.5f);
                                drone.getMutableStats().getMaxTurnRate().modifyMult("mook", 1.5f);
                                drone.getMutableStats().getArmorDamageTakenMult().modifyMult("mook", 0.8f);
                                drone.getMutableStats().getHullDamageTakenMult().modifyMult("mook", 0.8f);
                                if (drone.getShield() != null) {
                                    drone.getShield().setInnerColor(new Color(100, 255, 150));
                                    drone.getShield().setRingColor(new Color(180, 255, 205));
                                }
                                if (drone.getEngineController() == null) continue;
                                drone.getEngineController().fadeToOtherColor((Object)this, new Color(180, 255, 205), new Color(100, 255, 150), 1.0f, 1.0f);
                            }
                        }
                        if (ship.isShipWithModules()) {
                            for (ShipAPI child : SWP_Multi.getChildren(ship)) {
                                child.getSpriteAPI().setColor(new Color(100, 255, 150));
                                child.getMutableStats().getShieldUpkeepMult().modifyMult("mook", 0.0f);
                                child.getMutableStats().getShieldDamageTakenMult().modifyMult("mook", 0.0f);
                                child.getMutableStats().getShieldUnfoldRateMult().modifyMult("mook", 5.0f);
                                child.getMutableStats().getTurnAcceleration().modifyMult("mook", 1.5f);
                                child.getMutableStats().getMaxTurnRate().modifyMult("mook", 1.5f);
                                child.getMutableStats().getArmorDamageTakenMult().modifyMult("mook", 0.8f);
                                child.getMutableStats().getHullDamageTakenMult().modifyMult("mook", 0.8f);
                                if (child.getShield() != null) {
                                    child.getShield().setInnerColor(new Color(100, 255, 150));
                                    child.getShield().setRingColor(new Color(180, 255, 205));
                                }
                                if (child.getEngineController() == null) continue;
                                child.getEngineController().fadeToOtherColor((Object)this, new Color(180, 255, 205), new Color(100, 255, 150), 1.0f, 1.0f);
                            }
                        }
                        if (ship.getShield() != null) {
                            ship.getShield().setInnerColor(new Color(100, 255, 150));
                            ship.getShield().setRingColor(new Color(180, 255, 205));
                        }
                        if (ship.getEngineController() != null) {
                            ship.getEngineController().fadeToOtherColor((Object)this, new Color(180, 255, 205), new Color(100, 255, 150), 1.0f, 1.0f);
                        }
                    }
                    switch (ship.getHullSize()) {
                        case FIGHTER: {
                            shieldsize = 180.0f;
                            break;
                        }
                        case FRIGATE: {
                            shieldsize = 210.0f;
                            break;
                        }
                        case DESTROYER: {
                            shieldsize = 240.0f;
                            break;
                        }
                        case CRUISER: {
                            shieldsize = 270.0f;
                            break;
                        }
                        case CAPITAL_SHIP: {
                            shieldsize = 300.0f;
                            break;
                        }
                        default: {
                            shieldsize = 300.0f;
                        }
                    }
                    if (ship.getShield() == null || ship.getShield().getType() != ShieldAPI.ShieldType.FRONT || ship.getShield().getArc() != shieldsize) {
                        ship.setShield(ShieldAPI.ShieldType.FRONT, 0.0f, 0.0f, shieldsize);
                    }
                    ship.getMutableStats().getShieldUpkeepMult().modifyMult("mook", 0.0f);
                    ship.getMutableStats().getShieldDamageTakenMult().modifyMult("mook", 0.0f);
                    ship.getMutableStats().getShieldUnfoldRateMult().modifyMult("mook", 5.0f);
                    ship.getMutableStats().getTurnAcceleration().modifyMult("mook", 1.5f);
                    ship.getMutableStats().getMaxTurnRate().modifyMult("mook", 1.5f);
                    ship.getMutableStats().getArmorDamageTakenMult().modifyMult("mook", 0.8f);
                    ship.getMutableStats().getHullDamageTakenMult().modifyMult("mook", 0.8f);
                    break;
                }
            }
            if (!BOSS_SHIPS.containsKey(shipForStats.getHullSpec().getHullId())) continue;
            float snapbackdistance = 1750.0f;
            float snapbackpower = 1.0f;
            block170: for (int i = 0; i < AURA_MOD.get(ship.getHullSize()); ++i) {
                if (!(Math.random() < (double)(amount * 15.0f)) || this.engine.isPaused()) continue;
                switch (shipForStats.getHullSpec().getHullId()) {
                    case "ssp_superhyperion": {
                        this.engine.addSmoothParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 10.0f + 5.0f, (float)Math.random() * 0.25f + 0.75f, 1.0f, new Color(255, 255, 255));
                        continue block170;
                    }
                    case "ssp_oberon": {
                        this.engine.addSmoothParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 10.0f + 5.0f, (float)Math.random() * 0.25f + 0.75f, 1.0f, new Color(255, 185, 0));
                        continue block170;
                    }
                    case "ssp_ultron": {
                        this.engine.addSmoothParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 10.0f + 5.0f, (float)Math.random() * 0.25f + 0.75f, 1.0f, new Color(200, 100, 255));
                        continue block170;
                    }
                    case "ssp_zeus": {
                        this.engine.addSmoothParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 10.0f + 5.0f, (float)Math.random() * 0.25f + 0.75f, 1.0f, new Color(255, 255, 255));
                        continue block170;
                    }
                    case "ssp_ezekiel": {
                        this.engine.addSmoothParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 10.0f + 5.0f, (float)Math.random() * 0.25f + 0.75f, 1.0f, new Color(255, 255, 255));
                        continue block170;
                    }
                    case "ssp_cristarium": {
                        this.engine.addSmoothParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 10.0f + 5.0f, (float)Math.random() * 0.25f + 0.75f, 1.0f, new Color(150, 225, 255));
                        continue block170;
                    }
                    case "ssp_zero": {
                        this.engine.addSmoothParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 10.0f + 5.0f, (float)Math.random() * 0.25f + 0.75f, 1.0f, new Color(255, 50, 150));
                        continue block170;
                    }
                    case "ssp_superzero": {
                        this.engine.addSmoothParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 15.0f + 5.0f, (float)Math.random() * 0.25f + 0.75f, 1.0f, new Color(255, 0, 0));
                        continue block170;
                    }
                    case "ssp_hyperzero": {
                        this.engine.addSmoothParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 20.0f + 5.0f, (float)Math.random() * 0.25f + 0.75f, 1.0f, new Color(50, 50, 50));
                        continue block170;
                    }
                }
            }
            ship.getMutableStats().getAutofireAimAccuracy().modifyMult("boss", 5.0f);
            switch (shipForStats.getHullSpec().getHullId()) {
                case "ssp_superhyperion": {
                    ship.getMutableStats().getBallisticWeaponDamageMult().modifyMult("boss", 1.5f);
                    ship.getMutableStats().getEnergyWeaponDamageMult().modifyMult("boss", 1.5f);
                    ship.getMutableStats().getMissileWeaponDamageMult().modifyMult("boss", 1.5f);
                    ship.getMutableStats().getEngineDamageTakenMult().modifyMult("boss", 0.1f);
                    ship.getMutableStats().getHullDamageTakenMult().modifyMult("boss", 0.33f);
                    ship.getMutableStats().getAcceleration().modifyMult("boss", 1.5f);
                    ship.getMutableStats().getDeceleration().modifyMult("boss", 1.5f);
                    switch (this.bossLevel) {
                        case 11: {
                            ship.getMutableStats().getBallisticRoFMult().modifyMult("boss", 1.5f);
                            ship.getMutableStats().getEnergyRoFMult().modifyMult("boss", 1.5f);
                            ship.getMutableStats().getMissileRoFMult().modifyMult("boss", 1.5f);
                            ship.getMutableStats().getBeamWeaponDamageMult().modifyMult("boss", 1.5f);
                            ship.getMutableStats().getOverloadTimeMod().modifyMult("boss", 1.5f);
                            break;
                        }
                        case 12: {
                            ship.getMutableStats().getBallisticRoFMult().modifyMult("boss", 3.0f);
                            ship.getMutableStats().getEnergyRoFMult().modifyMult("boss", 3.0f);
                            ship.getMutableStats().getMissileRoFMult().modifyMult("boss", 3.0f);
                            ship.getMutableStats().getBeamWeaponDamageMult().modifyMult("boss", 3.0f);
                            ship.getMutableStats().getFluxDissipation().modifyMult("boss", 1.5f);
                            ship.getMutableStats().getOverloadTimeMod().modifyMult("boss", 1.0f);
                            ship.getMutableStats().getFluxDissipation().modifyMult("boss", 1.25f);
                            ship.getMutableStats().getFluxCapacity().modifyMult("boss", 1.25f);
                            break;
                        }
                        default: {
                            ship.getMutableStats().getBallisticRoFMult().modifyMult("boss", 4.0f);
                            ship.getMutableStats().getEnergyRoFMult().modifyMult("boss", 4.0f);
                            ship.getMutableStats().getMissileRoFMult().modifyMult("boss", 4.0f);
                            ship.getMutableStats().getBeamWeaponDamageMult().modifyMult("boss", 4.0f);
                            ship.getMutableStats().getFluxDissipation().modifyMult("boss", 2.0f);
                            ship.getMutableStats().getOverloadTimeMod().modifyMult("boss", 0.5f);
                            ship.getMutableStats().getFluxDissipation().modifyMult("boss", 1.5f);
                            ship.getMutableStats().getFluxCapacity().modifyMult("boss", 1.5f);
                        }
                    }
                    ship.getMutableStats().getVentRateMult().modifyMult("boss", 0.5f);
                    ship.getMutableStats().getArmorDamageTakenMult().modifyMult("boss", 0.33f);
                    ship.getMutableStats().getWeaponDamageTakenMult().modifyMult("boss", 0.33f);
                    ship.getMutableStats().getKineticShieldDamageTakenMult().modifyMult("boss", 0.67f);
                    ship.getMutableStats().getHighExplosiveShieldDamageTakenMult().modifyMult("boss", 1.5f);
                    if (this.maxPoints > 137.5f) {
                        if (Math.random() < (double)(amount * 30.0f) && !this.engine.isPaused()) {
                            this.engine.addHitParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 15.0f + 10.0f, (float)Math.random() * 0.5f + 0.5f, 1.5f, new Color(255, 0, 0));
                        }
                        ship.getMutableStats().getBallisticRoFMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getEnergyRoFMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMissileRoFMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getBeamWeaponDamageMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMaxSpeed().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMaxTurnRate().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getTurnAcceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getAcceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getDeceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getProjectileSpeedMult().modifyMult("rage", 2.0f);
                        snapbackdistance = 1000.0f;
                        snapbackpower = 3.0f;
                    }
                    if (ship != shipForStats) break;
                    this.bar1.render();
                    if (this.bar2 != null) {
                        this.bar2.render();
                    }
                    if (this.bar3 != null) {
                        this.bar3.render();
                    }
                    for (WeaponGroupAPI group : ship.getWeaponGroupsCopy()) {
                        if (group.isAutofiring()) continue;
                        group.toggleOn();
                    }
                    break;
                }
                case "ssp_oberon": {
                    ship.getMutableStats().getOverloadTimeMod().modifyMult("boss", 0.5f);
                    ship.getMutableStats().getWeaponDamageTakenMult().modifyMult("boss", 0.33f);
                    ship.getMutableStats().getHullDamageTakenMult().modifyMult("boss", 0.33f);
                    ship.getMutableStats().getAcceleration().modifyMult("boss", 1.5f);
                    ship.getMutableStats().getDeceleration().modifyMult("boss", 1.5f);
                    if (this.maxPoints > 75.0f) {
                        if (Math.random() < (double)(amount * 30.0f) && !this.engine.isPaused()) {
                            this.engine.addHitParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 15.0f + 10.0f, (float)Math.random() * 0.5f + 0.5f, 1.5f, new Color(255, 0, 0));
                        }
                        ship.getMutableStats().getBallisticRoFMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getEnergyRoFMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMissileRoFMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getBeamWeaponDamageMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMaxSpeed().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMaxTurnRate().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getTurnAcceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getAcceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getDeceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getProjectileSpeedMult().modifyMult("rage", 2.0f);
                        snapbackdistance = 1000.0f;
                        snapbackpower = 3.0f;
                    }
                    if (ship != shipForStats) break;
                    this.bar1.render();
                    break;
                }
                case "ssp_ultron": {
                    ship.getMutableStats().getBallisticWeaponDamageMult().modifyMult("boss", 1.5f);
                    ship.getMutableStats().getEnergyWeaponDamageMult().modifyMult("boss", 1.5f);
                    ship.getMutableStats().getMissileWeaponDamageMult().modifyMult("boss", 1.5f);
                    ship.getMutableStats().getArmorDamageTakenMult().modifyMult("boss", 0.33f);
                    ship.getMutableStats().getHullDamageTakenMult().modifyMult("boss", 0.33f);
                    ship.getMutableStats().getOverloadTimeMod().modifyMult("boss", 2.0f);
                    ship.getMutableStats().getVentRateMult().modifyMult("boss", 0.5f);
                    ship.getMutableStats().getShieldUnfoldRateMult().modifyMult("boss", 0.25f);
                    ship.getMutableStats().getShieldTurnRateMult().modifyMult("boss", 0.25f);
                    ship.getMutableStats().getWeaponDamageTakenMult().modifyMult("boss", 0.33f);
                    ship.getMutableStats().getAcceleration().modifyMult("boss", 1.5f);
                    ship.getMutableStats().getDeceleration().modifyMult("boss", 1.5f);
                    if (this.maxPoints > 87.5f) {
                        if (Math.random() < (double)(amount * 30.0f) && !this.engine.isPaused()) {
                            this.engine.addHitParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 15.0f + 10.0f, (float)Math.random() * 0.5f + 0.5f, 1.5f, new Color(255, 0, 0));
                        }
                        ship.getMutableStats().getBallisticRoFMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getEnergyRoFMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMissileRoFMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getBeamWeaponDamageMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMaxSpeed().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMaxTurnRate().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getTurnAcceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getAcceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getDeceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getProjectileSpeedMult().modifyMult("rage", 2.0f);
                        snapbackdistance = 1000.0f;
                        snapbackpower = 3.0f;
                    }
                    if (ship != shipForStats) break;
                    this.bar1.render();
                    break;
                }
                case "ssp_zeus": {
                    ship.getMutableStats().getBallisticWeaponDamageMult().modifyMult("boss", 1.5f);
                    ship.getMutableStats().getEnergyWeaponDamageMult().modifyMult("boss", 1.5f);
                    ship.getMutableStats().getMissileWeaponDamageMult().modifyMult("boss", 1.5f);
                    ship.getMutableStats().getHullDamageTakenMult().modifyMult("boss", 0.33f);
                    ship.getMutableStats().getBallisticRoFMult().modifyMult("boss", 1.5f);
                    ship.getMutableStats().getEnergyRoFMult().modifyMult("boss", 1.5f);
                    ship.getMutableStats().getMissileRoFMult().modifyMult("boss", 1.5f);
                    ship.getMutableStats().getArmorDamageTakenMult().modifyMult("boss", 0.5f);
                    ship.getMutableStats().getProjectileSpeedMult().modifyMult("boss", 0.5f);
                    ship.getMutableStats().getWeaponDamageTakenMult().modifyMult("boss", 0.33f);
                    ship.getMutableStats().getEngineDamageTakenMult().modifyMult("boss", 0.5f);
                    ship.getMutableStats().getAcceleration().modifyMult("boss", 1.5f);
                    ship.getMutableStats().getDeceleration().modifyMult("boss", 1.5f);
                    if (this.maxPoints > 100.0f) {
                        if (Math.random() < (double)(amount * 30.0f) && !this.engine.isPaused()) {
                            this.engine.addHitParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 15.0f + 10.0f, (float)Math.random() * 0.5f + 0.5f, 1.5f, new Color(255, 0, 0));
                        }
                        ship.getMutableStats().getBallisticRoFMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getEnergyRoFMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMissileRoFMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getBeamWeaponDamageMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMaxSpeed().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMaxTurnRate().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getTurnAcceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getAcceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getDeceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getProjectileSpeedMult().modifyMult("rage", 2.0f);
                        snapbackdistance = 1000.0f;
                        snapbackpower = 3.0f;
                    }
                    if (ship != shipForStats) break;
                    this.bar1.render();
                    break;
                }
                case "ssp_ezekiel": {
                    ship.getMutableStats().getBallisticWeaponDamageMult().modifyMult("boss", 1.75f);
                    ship.getMutableStats().getEnergyWeaponDamageMult().modifyMult("boss", 1.75f);
                    ship.getMutableStats().getMissileWeaponDamageMult().modifyMult("boss", 1.75f);
                    ship.getMutableStats().getHullDamageTakenMult().modifyMult("boss", 0.33f);
                    ship.getMutableStats().getArmorDamageTakenMult().modifyMult("boss", 0.33f);
                    ship.getMutableStats().getWeaponDamageTakenMult().modifyMult("boss", 0.33f);
                    ship.getMutableStats().getAcceleration().modifyMult("boss", 1.5f);
                    ship.getMutableStats().getDeceleration().modifyMult("boss", 1.5f);
                    if (this.maxPoints > 112.5f) {
                        if (Math.random() < (double)(amount * 30.0f) && !this.engine.isPaused()) {
                            this.engine.addHitParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 15.0f + 10.0f, (float)Math.random() * 0.5f + 0.5f, 1.5f, new Color(255, 0, 0));
                        }
                        ship.getMutableStats().getBallisticRoFMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getEnergyRoFMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMissileRoFMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getBeamWeaponDamageMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMaxSpeed().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMaxTurnRate().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getTurnAcceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getAcceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getDeceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getProjectileSpeedMult().modifyMult("rage", 2.0f);
                        snapbackdistance = 1000.0f;
                        snapbackpower = 3.0f;
                    }
                    if (ship != shipForStats) break;
                    this.bar1.render();
                    break;
                }
                case "ssp_cristarium": {
                    if (ship.getDeployedDrones() != null) {
                        for (ShipAPI drone : ship.getDeployedDrones()) {
                            drone.getMutableStats().getBallisticWeaponDamageMult().modifyMult("boss", 2.5f);
                            drone.getMutableStats().getEnergyWeaponDamageMult().modifyMult("boss", 2.5f);
                            drone.getMutableStats().getMissileWeaponDamageMult().modifyMult("boss", 2.5f);
                            drone.getMutableStats().getWeaponTurnRateBonus().modifyMult("boss", 20.0f);
                            drone.getMutableStats().getHullDamageTakenMult().modifyMult("boss", 0.33f);
                            drone.getMutableStats().getEngineDamageTakenMult().modifyMult("boss", 0.0f);
                            drone.getMutableStats().getArmorDamageTakenMult().modifyMult("boss", 0.33f);
                            drone.getMutableStats().getAcceleration().modifyMult("boss", 1.5f);
                            drone.getMutableStats().getDeceleration().modifyMult("boss", 1.5f);
                        }
                    }
                    ship.getMutableStats().getBallisticWeaponDamageMult().modifyMult("boss", 2.5f);
                    ship.getMutableStats().getEnergyWeaponDamageMult().modifyMult("boss", 2.5f);
                    ship.getMutableStats().getMissileWeaponDamageMult().modifyMult("boss", 2.5f);
                    ship.getMutableStats().getBallisticRoFMult().modifyMult("boss", 4.0f);
                    ship.getMutableStats().getHullDamageTakenMult().modifyMult("boss", 0.4f);
                    ship.getMutableStats().getEnergyRoFMult().modifyMult("boss", 4.0f);
                    ship.getMutableStats().getMissileRoFMult().modifyMult("boss", 4.0f);
                    ship.getMutableStats().getWeaponTurnRateBonus().modifyMult("boss", 20.0f);
                    ship.getMutableStats().getEngineDamageTakenMult().modifyMult("boss", 0.0f);
                    ship.getMutableStats().getArmorDamageTakenMult().modifyMult("boss", 0.33f);
                    ship.getMutableStats().getWeaponDamageTakenMult().modifyMult("boss", 0.33f);
                    ship.getMutableStats().getAcceleration().modifyMult("boss", 1.5f);
                    ship.getMutableStats().getDeceleration().modifyMult("boss", 1.5f);
                    if (this.maxPoints > 125.0f) {
                        if (Math.random() < (double)(amount * 30.0f) && !this.engine.isPaused()) {
                            this.engine.addHitParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 15.0f + 10.0f, (float)Math.random() * 0.5f + 0.5f, 1.5f, new Color(255, 0, 0));
                        }
                        ship.getMutableStats().getBallisticRoFMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getEnergyRoFMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMissileRoFMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getBeamWeaponDamageMult().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMaxSpeed().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMaxTurnRate().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getTurnAcceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getAcceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getDeceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getProjectileSpeedMult().modifyMult("rage", 2.0f);
                        snapbackdistance = 1000.0f;
                        snapbackpower = 3.0f;
                    }
                    if (ship != shipForStats) break;
                    this.bar1.render();
                    break;
                }
                case "ssp_zero": {
                    ship.getMutableStats().getBallisticWeaponDamageMult().modifyMult("boss", 2.0f);
                    ship.getMutableStats().getEnergyWeaponDamageMult().modifyMult("boss", 2.0f);
                    ship.getMutableStats().getMissileWeaponDamageMult().modifyMult("boss", 2.0f);
                    if ((double)ship.getHullLevel() <= 0.33) {
                        ship.getMutableStats().getArmorDamageTakenMult().modifyMult("boss", 0.11f);
                        ship.getMutableStats().getHullDamageTakenMult().modifyMult("boss", 0.11f);
                        ship.getMutableStats().getAcceleration().modifyMult("boss", 2.5f);
                        ship.getMutableStats().getDeceleration().modifyMult("boss", 2.5f);
                        ship.getMutableStats().getMaxSpeed().modifyMult("boss", 1.5f);
                        ship.getMutableStats().getMaxTurnRate().modifyMult("boss", 1.5f);
                        ship.getMutableStats().getTurnAcceleration().modifyMult("boss", 1.5f);
                        ship.getMutableStats().getFluxDissipation().modifyMult("boss", 2.0f);
                        ship.getMutableStats().getFluxCapacity().modifyMult("boss", 2.0f);
                    } else if ((double)ship.getHullLevel() <= 0.67) {
                        ship.getMutableStats().getArmorDamageTakenMult().modifyMult("boss", 0.22f);
                        ship.getMutableStats().getHullDamageTakenMult().modifyMult("boss", 0.22f);
                        ship.getMutableStats().getAcceleration().modifyMult("boss", 2.0f);
                        ship.getMutableStats().getDeceleration().modifyMult("boss", 2.0f);
                        ship.getMutableStats().getMaxSpeed().modifyMult("boss", 1.25f);
                        ship.getMutableStats().getMaxTurnRate().modifyMult("boss", 1.25f);
                        ship.getMutableStats().getTurnAcceleration().modifyMult("boss", 1.25f);
                        ship.getMutableStats().getFluxDissipation().modifyMult("boss", 1.5f);
                        ship.getMutableStats().getFluxCapacity().modifyMult("boss", 1.5f);
                    } else {
                        ship.getMutableStats().getArmorDamageTakenMult().modifyMult("boss", 0.33f);
                        ship.getMutableStats().getHullDamageTakenMult().modifyMult("boss", 0.33f);
                        ship.getMutableStats().getAcceleration().modifyMult("boss", 1.5f);
                        ship.getMutableStats().getDeceleration().modifyMult("boss", 1.5f);
                    }
                    ship.getMutableStats().getVentRateMult().modifyMult("boss", 2.0f);
                    ship.getMutableStats().getBallisticRoFMult().modifyMult("arcade", 1.0f);
                    ship.getMutableStats().getEnergyRoFMult().modifyMult("arcade", 1.0f);
                    ship.getMutableStats().getMissileRoFMult().modifyMult("arcade", 1.0f);
                    ship.getMutableStats().getEnergyWeaponRangeBonus().modifyMult("arcade", 1.0f);
                    ship.getMutableStats().getBallisticWeaponRangeBonus().modifyMult("arcade", 1.0f);
                    ship.getMutableStats().getWeaponDamageTakenMult().modifyMult("boss", 0.01f);
                    ship.getMutableStats().getEmpDamageTakenMult().modifyMult("boss", 0.01f);
                    if (this.maxPoints > 150.0f) {
                        if (Math.random() < (double)(amount * 30.0f) && !this.engine.isPaused()) {
                            this.engine.addHitParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 15.0f + 10.0f, (float)Math.random() * 0.5f + 0.5f, 1.5f, new Color(255, 0, 0));
                        }
                        ship.getMutableStats().getBallisticWeaponDamageMult().modifyMult("boss", 4.0f);
                        ship.getMutableStats().getEnergyWeaponDamageMult().modifyMult("boss", 4.0f);
                        ship.getMutableStats().getMissileWeaponDamageMult().modifyMult("boss", 4.0f);
                        ship.getMutableStats().getMaxSpeed().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMaxTurnRate().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getTurnAcceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getAcceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getDeceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getProjectileSpeedMult().modifyMult("rage", 2.0f);
                        snapbackdistance = 1000.0f;
                        snapbackpower = 3.0f;
                    }
                    if (ship != shipForStats) break;
                    this.bar1.render();
                    break;
                }
                case "ssp_superzero": {
                    ship.getMutableStats().getBallisticWeaponDamageMult().modifyMult("boss", 2.25f);
                    ship.getMutableStats().getEnergyWeaponDamageMult().modifyMult("boss", 2.25f);
                    ship.getMutableStats().getMissileWeaponDamageMult().modifyMult("boss", 2.25f);
                    if ((double)ship.getHullLevel() <= 0.33) {
                        ship.getMutableStats().getArmorDamageTakenMult().modifyMult("boss", 0.17f);
                        ship.getMutableStats().getHullDamageTakenMult().modifyMult("boss", 0.17f);
                        ship.getMutableStats().getAcceleration().modifyMult("boss", 2.5f);
                        ship.getMutableStats().getDeceleration().modifyMult("boss", 2.5f);
                        ship.getMutableStats().getMaxSpeed().modifyMult("boss", 1.5f);
                        ship.getMutableStats().getMaxTurnRate().modifyMult("boss", 1.5f);
                        ship.getMutableStats().getTurnAcceleration().modifyMult("boss", 1.5f);
                        ship.getMutableStats().getFluxDissipation().modifyMult("boss", 2.0f);
                        ship.getMutableStats().getFluxCapacity().modifyMult("boss", 2.0f);
                    } else if ((double)ship.getHullLevel() <= 0.67) {
                        ship.getMutableStats().getArmorDamageTakenMult().modifyMult("boss", 0.25f);
                        ship.getMutableStats().getHullDamageTakenMult().modifyMult("boss", 0.25f);
                        ship.getMutableStats().getAcceleration().modifyMult("boss", 2.0f);
                        ship.getMutableStats().getDeceleration().modifyMult("boss", 2.0f);
                        ship.getMutableStats().getMaxSpeed().modifyMult("boss", 1.25f);
                        ship.getMutableStats().getMaxTurnRate().modifyMult("boss", 1.25f);
                        ship.getMutableStats().getTurnAcceleration().modifyMult("boss", 1.25f);
                        ship.getMutableStats().getFluxDissipation().modifyMult("boss", 1.5f);
                        ship.getMutableStats().getFluxCapacity().modifyMult("boss", 1.5f);
                    } else {
                        ship.getMutableStats().getArmorDamageTakenMult().modifyMult("boss", 0.33f);
                        ship.getMutableStats().getHullDamageTakenMult().modifyMult("boss", 0.33f);
                        ship.getMutableStats().getAcceleration().modifyMult("boss", 1.5f);
                        ship.getMutableStats().getDeceleration().modifyMult("boss", 1.5f);
                    }
                    ship.getMutableStats().getVentRateMult().modifyMult("boss", 2.0f);
                    ship.getMutableStats().getBallisticRoFMult().modifyMult("arcade", 1.5f);
                    ship.getMutableStats().getEnergyRoFMult().modifyMult("arcade", 1.5f);
                    ship.getMutableStats().getMissileRoFMult().modifyMult("arcade", 1.5f);
                    ship.getMutableStats().getEnergyWeaponRangeBonus().modifyMult("arcade", 1.25f);
                    ship.getMutableStats().getBallisticWeaponRangeBonus().modifyMult("arcade", 1.25f);
                    ship.getMutableStats().getWeaponDamageTakenMult().modifyMult("boss", 0.01f);
                    ship.getMutableStats().getEmpDamageTakenMult().modifyMult("boss", 0.01f);
                    if (this.maxPoints > 155.0f) {
                        if (Math.random() < (double)(amount * 30.0f) && !this.engine.isPaused()) {
                            this.engine.addHitParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 15.0f + 10.0f, (float)Math.random() * 0.5f + 0.5f, 1.5f, new Color(255, 0, 0));
                        }
                        ship.getMutableStats().getBallisticWeaponDamageMult().modifyMult("boss", 4.5f);
                        ship.getMutableStats().getEnergyWeaponDamageMult().modifyMult("boss", 4.5f);
                        ship.getMutableStats().getMissileWeaponDamageMult().modifyMult("boss", 4.5f);
                        ship.getMutableStats().getMaxSpeed().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMaxTurnRate().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getTurnAcceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getAcceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getDeceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getProjectileSpeedMult().modifyMult("rage", 2.0f);
                        snapbackdistance = 1000.0f;
                        snapbackpower = 3.0f;
                    }
                    if (ship != shipForStats) break;
                    if (Math.random() < (double)(amount * 2.4f) && !this.engine.isPaused()) {
                        Vector2f point = MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius);
                        this.engine.spawnEmpArc(ship, point, (CombatEntityAPI)ship, (CombatEntityAPI)ship, DamageType.OTHER, 0.0f, 0.0f, 1000.0f, null, 5.0f, new Color(255, 50, 50), new Color(255, 50, 50));
                    }
                    this.bar1.render();
                    break;
                }
                case "ssp_hyperzero": {
                    ship.getMutableStats().getBallisticWeaponDamageMult().modifyMult("boss", 2.5f);
                    ship.getMutableStats().getEnergyWeaponDamageMult().modifyMult("boss", 2.5f);
                    ship.getMutableStats().getMissileWeaponDamageMult().modifyMult("boss", 2.5f);
                    if ((double)ship.getHullLevel() <= 0.33) {
                        ship.getMutableStats().getArmorDamageTakenMult().modifyMult("boss", 0.19f);
                        ship.getMutableStats().getHullDamageTakenMult().modifyMult("boss", 0.19f);
                        ship.getMutableStats().getAcceleration().modifyMult("boss", 2.5f);
                        ship.getMutableStats().getDeceleration().modifyMult("boss", 2.5f);
                        ship.getMutableStats().getMaxSpeed().modifyMult("boss", 1.5f);
                        ship.getMutableStats().getMaxTurnRate().modifyMult("boss", 1.5f);
                        ship.getMutableStats().getTurnAcceleration().modifyMult("boss", 1.5f);
                        ship.getMutableStats().getFluxDissipation().modifyMult("boss", 2.0f);
                        ship.getMutableStats().getFluxCapacity().modifyMult("boss", 2.0f);
                    } else if ((double)ship.getHullLevel() <= 0.67) {
                        ship.getMutableStats().getArmorDamageTakenMult().modifyMult("boss", 0.26f);
                        ship.getMutableStats().getHullDamageTakenMult().modifyMult("boss", 0.26f);
                        ship.getMutableStats().getAcceleration().modifyMult("boss", 2.0f);
                        ship.getMutableStats().getDeceleration().modifyMult("boss", 2.0f);
                        ship.getMutableStats().getMaxSpeed().modifyMult("boss", 1.25f);
                        ship.getMutableStats().getMaxTurnRate().modifyMult("boss", 1.25f);
                        ship.getMutableStats().getTurnAcceleration().modifyMult("boss", 1.25f);
                        ship.getMutableStats().getFluxDissipation().modifyMult("boss", 1.5f);
                        ship.getMutableStats().getFluxCapacity().modifyMult("boss", 1.5f);
                    } else {
                        ship.getMutableStats().getArmorDamageTakenMult().modifyMult("boss", 0.33f);
                        ship.getMutableStats().getHullDamageTakenMult().modifyMult("boss", 0.33f);
                        ship.getMutableStats().getAcceleration().modifyMult("boss", 1.5f);
                        ship.getMutableStats().getDeceleration().modifyMult("boss", 1.5f);
                    }
                    ship.getMutableStats().getVentRateMult().modifyMult("boss", 2.0f);
                    ship.getMutableStats().getBallisticRoFMult().modifyMult("arcade", 2.0f);
                    ship.getMutableStats().getEnergyRoFMult().modifyMult("arcade", 2.0f);
                    ship.getMutableStats().getMissileRoFMult().modifyMult("arcade", 2.0f);
                    ship.getMutableStats().getEnergyWeaponRangeBonus().modifyMult("arcade", 1.5f);
                    ship.getMutableStats().getBallisticWeaponRangeBonus().modifyMult("arcade", 1.5f);
                    ship.getMutableStats().getWeaponDamageTakenMult().modifyMult("boss", 0.01f);
                    ship.getMutableStats().getEmpDamageTakenMult().modifyMult("boss", 0.01f);
                    if (this.maxPoints > 160.0f) {
                        if (Math.random() < (double)(amount * 30.0f) && !this.engine.isPaused()) {
                            this.engine.addHitParticle(MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)shipRadius), ZERO, (float)Math.random() * 15.0f + 10.0f, (float)Math.random() * 0.5f + 0.5f, 1.5f, new Color(255, 0, 0));
                        }
                        ship.getMutableStats().getBallisticWeaponDamageMult().modifyMult("boss", 5.0f);
                        ship.getMutableStats().getEnergyWeaponDamageMult().modifyMult("boss", 5.0f);
                        ship.getMutableStats().getMissileWeaponDamageMult().modifyMult("boss", 5.0f);
                        ship.getMutableStats().getMaxSpeed().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getMaxTurnRate().modifyMult("rage", 2.0f);
                        ship.getMutableStats().getTurnAcceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getAcceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getDeceleration().modifyMult("rage", 3.0f);
                        ship.getMutableStats().getProjectileSpeedMult().modifyMult("rage", 2.0f);
                        snapbackdistance = 1000.0f;
                        snapbackpower = 3.0f;
                    }
                    if (ship != shipForStats) break;
                    if (Math.random() < (double)(amount * 4.8f) && !this.engine.isPaused()) {
                        Vector2f point = MathUtils.getRandomPointInCircle((Vector2f)ship.getLocation(), (float)(shipRadius * 1.5f));
                        this.engine.spawnEmpArc(ship, point, (CombatEntityAPI)ship, (CombatEntityAPI)ship, DamageType.OTHER, 0.0f, 0.0f, 1000.0f, null, 5.0f, new Color(150, 150, 150), new Color(255, 255, 255));
                    }
                    this.bar1.render();
                    break;
                }
                default: {
                    ship.getMutableStats().getBallisticWeaponDamageMult().modifyMult("boss", 2.0f);
                    ship.getMutableStats().getEnergyWeaponDamageMult().modifyMult("boss", 2.0f);
                    ship.getMutableStats().getMissileWeaponDamageMult().modifyMult("boss", 2.0f);
                    ship.getMutableStats().getArmorDamageTakenMult().modifyMult("boss", 0.33f);
                    ship.getMutableStats().getHullDamageTakenMult().modifyMult("boss", 0.33f);
                    ship.getMutableStats().getWeaponDamageTakenMult().modifyMult("boss", 0.33f);
                    ship.getMutableStats().getAcceleration().modifyMult("boss", 1.5f);
                    ship.getMutableStats().getDeceleration().modifyMult("boss", 1.5f);
                    if (ship != shipForStats) break;
                    this.bar1.render();
                }
            }
            List weapons = ship.getAllWeapons();
            for (WeaponAPI weapon : weapons) {
                if (weapon.getMaxAmmo() > 0 && weapon.getMaxAmmo() < 100000 && !weapon.getId().contentEquals("empbomb") && !weapon.getId().contentEquals("godmode")) {
                    weapon.setAmmo(weapon.getMaxAmmo());
                }
                if (!(this.bossAmmoRegenTimer >= 120.0f) || !weapon.getId().contentEquals("empbomb") && !weapon.getId().contentEquals("godmode")) continue;
                weapon.setAmmo(1);
            }
            if (ship == shipForStats && this.bossFlash >= 3.0f && !this.engine.isPaused()) {
                Vector2f loc = new Vector2f((ReadableVector2f)ship.getLocation());
                loc.setY(loc.y + shipRadius);
                switch (ship.getHullSpec().getHullId()) {
                    case "ssp_superhyperion": {
                        switch (ship.getVariant().getHullVariantId()) {
                            case "ssp_superhyperion_hul": {
                                this.engine.addFloatingText(loc, "\u80e1\u514b-\u970d\u6839", 75.0f, Color.ORANGE, (CombatEntityAPI)ship, 2.0f, 2.0f);
                                ship.getSpriteAPI().setColor(new Color(255, 0, 0));
                                for (WeaponAPI weapon : ship.getAllWeapons()) {
                                    if (weapon.getSlot().isHidden()) continue;
                                    if (weapon.getSprite() != null) {
                                        weapon.getSprite().setColor(new Color(255, 0, 0));
                                    }
                                    if (weapon.getBarrelSpriteAPI() == null) continue;
                                    weapon.getBarrelSpriteAPI().setColor(new Color(255, 0, 0));
                                }
                                if (ship.getShield() != null) {
                                    ship.getShield().setInnerColor(new Color(255, 0, 0));
                                    ship.getShield().setRingColor(new Color(255, 130, 130));
                                }
                                if (ship.getEngineController() == null) break;
                                ship.getEngineController().fadeToOtherColor((Object)this, new Color(255, 130, 130), new Color(255, 0, 0), 1.0f, 1.0f);
                                break;
                            }
                            case "ssp_superhyperion_she": {
                                this.engine.addFloatingText(loc, "\u827e\u9f99-\u897f\u8036\u514b", 75.0f, Color.ORANGE, (CombatEntityAPI)ship, 2.0f, 2.0f);
                                ship.getSpriteAPI().setColor(new Color(255, 255, 0));
                                for (WeaponAPI weapon : ship.getAllWeapons()) {
                                    if (weapon.getSlot().isHidden()) continue;
                                    if (weapon.getSprite() != null) {
                                        weapon.getSprite().setColor(new Color(255, 255, 0));
                                    }
                                    if (weapon.getBarrelSpriteAPI() == null) continue;
                                    weapon.getBarrelSpriteAPI().setColor(new Color(255, 255, 0));
                                }
                                if (ship.getShield() != null) {
                                    ship.getShield().setInnerColor(new Color(255, 255, 0));
                                    ship.getShield().setRingColor(new Color(255, 255, 130));
                                }
                                if (ship.getEngineController() == null) break;
                                ship.getEngineController().fadeToOtherColor((Object)this, new Color(255, 255, 130), new Color(255, 255, 0), 1.0f, 1.0f);
                                break;
                            }
                            case "ssp_superhyperion_war": {
                                this.engine.addFloatingText(loc, "\u7ec8\u6781\u6218\u58eb", 75.0f, Color.ORANGE, (CombatEntityAPI)ship, 2.0f, 2.0f);
                                ship.getSpriteAPI().setColor(new Color(255, 0, 255));
                                for (WeaponAPI weapon : ship.getAllWeapons()) {
                                    if (weapon.getSlot().isHidden()) continue;
                                    if (weapon.getSprite() != null) {
                                        weapon.getSprite().setColor(new Color(255, 0, 255));
                                    }
                                    if (weapon.getBarrelSpriteAPI() == null) continue;
                                    weapon.getBarrelSpriteAPI().setColor(new Color(255, 0, 255));
                                }
                                if (ship.getShield() != null) {
                                    ship.getShield().setInnerColor(new Color(255, 0, 255));
                                    ship.getShield().setRingColor(new Color(255, 130, 255));
                                }
                                if (ship.getEngineController() == null) break;
                                ship.getEngineController().fadeToOtherColor((Object)this, new Color(255, 130, 255), new Color(255, 0, 255), 1.0f, 1.0f);
                            }
                        }
                        break;
                    }
                    case "ssp_oberon": {
                        this.engine.addFloatingText(loc, "\u5965\u4f2f\u9f99", 75.0f, Color.ORANGE, (CombatEntityAPI)ship, 2.0f, 2.0f);
                        break;
                    }
                    case "ssp_ultron": {
                        this.engine.addFloatingText(loc, "\u5965\u521b", 75.0f, Color.ORANGE, (CombatEntityAPI)ship, 2.0f, 2.0f);
                        break;
                    }
                    case "ssp_zeus": {
                        this.engine.addFloatingText(loc, "Zeus", 100.0f, Color.ORANGE, (CombatEntityAPI)ship, 2.0f, 2.0f);
                        break;
                    }
                    case "ssp_ezekiel": {
                        this.engine.addFloatingText(loc, "\u4ee5\u897f\u7ed3", 75.0f, Color.ORANGE, (CombatEntityAPI)ship, 2.0f, 2.0f);
                        break;
                    }
                    case "ssp_cristarium": {
                        this.engine.addFloatingText(loc, "\u76b1\u7eb9", 75.0f, Color.ORANGE, (CombatEntityAPI)ship, 2.0f, 2.0f);
                        break;
                    }
                    case "ssp_zero": {
                        this.engine.addFloatingText(loc, "\u96f6", 75.0f, Color.ORANGE, (CombatEntityAPI)ship, 2.0f, 2.0f);
                        break;
                    }
                    case "ssp_superzero": {
                        this.engine.addFloatingText(loc, "\u8d85\u7ea7\u96f6", 75.0f, Color.RED, (CombatEntityAPI)ship, 2.0f, 2.0f);
                        break;
                    }
                    case "ssp_hyperzero": {
                        this.engine.addFloatingText(loc, "\u6b27\u7c73\u8304\u96f6", 75.0f, Color.WHITE, (CombatEntityAPI)ship, 2.0f, 2.0f);
                        break;
                    }
                }
            }
            if (ship.getHullSpec().getHullId().contentEquals("ssp_superhyperion")) continue;
            boolean travelOn = this.snapback > 20.0f;
            float distance = MathUtils.getDistance((CombatEntityAPI)ship, (CombatEntityAPI)playerShip);
            this.snapback = distance > 1750.0f ? (this.snapback += (1.0f + (distance - snapbackdistance) / 750.0f) * amount * snapbackpower) : (this.snapback > 20.0f ? Math.max(this.snapback - (30.0f + (snapbackdistance - distance) / 10.0f) * amount, 0.0f) : Math.max(this.snapback - (3.0f + (snapbackdistance - distance) / 250.0f) * amount, 0.0f));
            if (this.snapback > 20.0f) {
                if (!travelOn) {
                    if (!this.engine.getViewport().isNearViewport(ship.getLocation(), ship.getCollisionRadius())) {
                        ship.turnOnTravelDrive();
                        ship.setFacing(VectorUtils.getAngle((Vector2f)ship.getLocation(), (Vector2f)playerShip.getLocation()));
                        continue;
                    }
                    this.snapback = 19.0f;
                    continue;
                }
                ship.turnOnTravelDrive();
                ship.setFacing(VectorUtils.getAngle((Vector2f)ship.getLocation(), (Vector2f)playerShip.getLocation()));
                continue;
            }
            if (ship.getTravelDrive() == null || !ship.getTravelDrive().isOn()) continue;
            ship.turnOffTravelDrive();
        }
        if (this.bossFlash >= 3.0f && !this.engine.isPaused()) {
            this.bossFlash -= 3.0f;
        }
        if (this.bossAmmoRegenTimer >= 120.0f && !this.engine.isPaused()) {
            this.bossAmmoRegenTimer -= 120.0f;
        }
        if (this.engine.isPaused()) {
            return;
        }
        playerShip.getMutableStats().getBallisticWeaponDamageMult().modifyMult("arcade", 2.0f + (float)Math.pow(realBuff, 2.0));
        playerShip.getMutableStats().getEnergyWeaponDamageMult().modifyMult("arcade", 2.0f + (float)Math.pow(realBuff, 2.0));
        playerShip.getMutableStats().getMissileWeaponDamageMult().modifyMult("arcade", 1.0f + (float)Math.pow(realBuff, 2.0));
        playerShip.getMutableStats().getMaxCombatHullRepairFraction().modifyFlat("arcade", 1.0f);
        playerShip.getMutableStats().getBallisticRoFMult().modifyMult("arcade", 1.0f + realBuff * 0.25f);
        playerShip.getMutableStats().getEnergyRoFMult().modifyMult("arcade", 1.0f + realBuff * 0.25f);
        playerShip.getMutableStats().getBeamWeaponDamageMult().modifyMult("arcade", 1.0f + realBuff * 0.5f);
        playerShip.getMutableStats().getMissileRoFMult().modifyMult("arcade", 1.0f + realBuff);
        playerShip.getMutableStats().getMissileMaxSpeedBonus().modifyMult("arcade", 1.0f + realBuff * 0.5f);
        playerShip.getMutableStats().getMissileAccelerationBonus().modifyMult("arcade", 1.0f + realBuff * 1.0f);
        playerShip.getMutableStats().getMissileMaxTurnRateBonus().modifyMult("arcade", 1.0f + realBuff * 1.0f);
        playerShip.getMutableStats().getMissileTurnAccelerationBonus().modifyMult("arcade", 1.0f + realBuff * 1.0f);
        playerShip.getMutableStats().getShieldDamageTakenMult().modifyMult("arcade", 1.0f / (0.7f + realBuff * 0.7f));
        playerShip.getMutableStats().getProjectileSpeedMult().modifyMult("arcade", 1.0f + realBuff * 0.25f);
        playerShip.getMutableStats().getHardFluxDissipationFraction().modifyFlat("arcade", 1.0f - 1.0f / (1.25f + realBuff * 0.25f));
        playerShip.getMutableStats().getWeaponDamageTakenMult().modifyMult("arcade", 0.25f);
        playerShip.getMutableStats().getEngineDamageTakenMult().modifyMult("arcade", 0.25f);
        playerShip.getMutableStats().getBallisticWeaponFluxCostMod().modifyMult("arcade", 0.6f + realBuff * 0.6f);
        playerShip.getMutableStats().getEnergyWeaponFluxCostMod().modifyMult("arcade", 0.6f + realBuff * 0.6f);
        playerShip.getMutableStats().getMissileWeaponFluxCostMod().modifyMult("arcade", 0.6f + realBuff * 0.6f);
        playerShip.getMutableStats().getFluxDissipation().modifyMult("arcade", 1.0f + realBuff);
        playerShip.getMutableStats().getFluxCapacity().modifyMult("arcade", 1.0f + realBuff);
        playerShip.getMutableStats().getArmorDamageTakenMult().modifyMult("arcade", 1.0f / (1.0f + realBuff * 0.5f));
        playerShip.getMutableStats().getHullDamageTakenMult().modifyMult("arcade", 1.0f / (1.0f + realBuff));
        playerShip.getMutableStats().getAcceleration().modifyMult("arcade", 1.0f + realBuff * 0.25f);
        playerShip.getMutableStats().getDeceleration().modifyMult("arcade", 1.0f + realBuff * 0.25f);
        playerShip.getMutableStats().getMaxSpeed().modifyMult("arcade", 1.0f + realBuff * 0.25f);
        playerShip.getMutableStats().getShieldUnfoldRateMult().modifyMult("arcade", 2.5f);
        playerShip.getMutableStats().getOverloadTimeMod().modifyMult("arcade", 1.0f / (2.0f + realBuff * 0.25f));
        playerShip.getMutableStats().getVentRateMult().modifyMult("arcade", 1.0f + realBuff * 0.25f);
        playerShip.getMutableStats().getShieldUpkeepMult().modifyMult("arcade", 1.0f + realBuff);
        playerShip.getMutableStats().getPhaseCloakActivationCostBonus().modifyMult("arcade", 1.0f + realBuff);
        playerShip.getMutableStats().getPhaseCloakUpkeepCostBonus().modifyMult("arcade", 1.0f + realBuff);
        playerShip.getMutableStats().getKineticShieldDamageTakenMult().modifyMult("arcade", 0.67f);
        playerShip.getMutableStats().getHighExplosiveShieldDamageTakenMult().modifyMult("arcade", 1.5f);
        List weapons = playerShip.getAllWeapons();
        if (this.bossLevel == 0 && this.maxPoints > 62.5f) {
            this.engine.addFloatingText(playerShip.getLocation(), "BOSS \u6765\u88ad", 150.0f, Color.ORANGE, (CombatEntityAPI)playerShip, 2.0f, 10.0f);
            this.heal();
            this.makeBoss(1);
            this.bossLevel = 1;
            Global.getSoundPlayer().playUISound("newround", 1.0f, 1.0f);
        } else if (this.bossLevel == 2 && this.maxPoints > 75.0f) {
            this.engine.addFloatingText(playerShip.getLocation(), "BOSS \u6765\u88ad", 150.0f, Color.ORANGE, (CombatEntityAPI)playerShip, 3.0f, 10.0f);
            this.heal();
            this.makeBoss(2);
            this.bossLevel = 3;
            Global.getSoundPlayer().playUISound("newround", 1.0f, 1.0f);
        } else if (this.bossLevel == 4 && this.maxPoints > 87.5f) {
            this.engine.addFloatingText(playerShip.getLocation(), "BOSS \u6765\u88ad", 150.0f, Color.ORANGE, (CombatEntityAPI)playerShip, 4.0f, 10.0f);
            this.heal();
            this.makeBoss(3);
            this.bossLevel = 5;
            Global.getSoundPlayer().playUISound("newround", 1.0f, 1.0f);
        } else if (this.bossLevel == 6 && this.maxPoints > 100.0f) {
            this.engine.addFloatingText(playerShip.getLocation(), "BOSS \u6765\u88ad", 150.0f, Color.ORANGE, (CombatEntityAPI)playerShip, 5.0f, 10.0f);
            this.heal();
            this.makeBoss(4);
            this.bossLevel = 7;
            Global.getSoundPlayer().playUISound("newround", 1.0f, 1.0f);
        } else if (this.bossLevel == 8 && this.maxPoints > 112.5f) {
            this.engine.addFloatingText(playerShip.getLocation(), "BOSS \u6765\u88ad", 150.0f, Color.ORANGE, (CombatEntityAPI)playerShip, 6.0f, 10.0f);
            this.heal();
            this.makeBoss(5);
            this.bossLevel = 9;
            Global.getSoundPlayer().playUISound("newround", 1.0f, 1.0f);
        } else if (this.bossLevel == 10 && this.maxPoints > 125.0f) {
            this.engine.addFloatingText(playerShip.getLocation(), "BOSS \u6765\u88ad", 150.0f, Color.ORANGE, (CombatEntityAPI)playerShip, 7.0f, 10.0f);
            this.heal();
            this.makeBoss(6);
            this.bossLevel = 11;
            Global.getSoundPlayer().playUISound("newround", 1.0f, 1.0f);
        } else if (this.bossLevel == 14 && this.maxPoints > 137.5f) {
            this.heal();
            int superammo1 = 0;
            int superammo2 = 0;
            for (WeaponAPI weapon : weapons) {
                if (weapon.getId().contentEquals("empbomb")) {
                    superammo1 = weapon.getAmmo();
                }
                if (!weapon.getId().contentEquals("godmode")) continue;
                superammo2 = weapon.getAmmo();
            }
            if (superammo1 >= 14 && superammo2 >= 14) {
                Global.getSoundPlayer().playUISound("newround", 1.0f, 1.0f);
                Global.getSoundPlayer().playUISound("newround", 1.5f, 1.5f);
                Global.getSoundPlayer().playUISound("newround", 2.0f, 2.0f);
                this.engine.addFloatingText(playerShip.getLocation(), "\u51c6\u5907\u53d7\u6b7b", 150.0f, Color.RED, (CombatEntityAPI)playerShip, 32.0f, 10.0f);
                this.ultralevel = 2;
            } else if (superammo1 >= 14 || superammo2 >= 14) {
                Global.getSoundPlayer().playUISound("newround", 1.0f, 1.0f);
                Global.getSoundPlayer().playUISound("newround", 1.5f, 1.5f);
                this.engine.addFloatingText(playerShip.getLocation(), "\u771f-\u6700\u7ec8 BOSS \u6765\u88ad", 150.0f, Color.ORANGE, (CombatEntityAPI)playerShip, 16.0f, 10.0f);
                this.ultralevel = 1;
            } else {
                Global.getSoundPlayer().playUISound("newround", 1.0f, 1.0f);
                this.engine.addFloatingText(playerShip.getLocation(), "\u6700\u7ec8 BOSS \u6765\u88ad", 150.0f, Color.ORANGE, (CombatEntityAPI)playerShip, 8.0f, 10.0f);
                this.ultralevel = 0;
            }
            this.makeBoss(7);
            this.bossLevel = 15;
        }
        if (this.threshold == 0 && this.maxPoints > 57.5f) {
            this.engine.addFloatingText(playerShip.getLocation(), "\u96be\u5ea6 I", 150.0f, Color.GREEN, (CombatEntityAPI)playerShip, 2.0f, 10.0f);
            this.heal();
            this.threshold = 1;
            for (WeaponAPI weapon : weapons) {
                if (!weapon.getId().contentEquals("empbomb") && !weapon.getId().contentEquals("godmode")) continue;
                weapon.setAmmo(weapon.getAmmo() + 1);
            }
            PostProcessShader.setSaturation((boolean)false, (float)1.03f);
            PostProcessShader.setContrast((boolean)false, (float)1.03f);
        } else if (this.threshold == 1 && this.maxPoints > 70.0f) {
            this.engine.addFloatingText(playerShip.getLocation(), "\u96be\u5ea6 II", 150.0f, Color.GREEN, (CombatEntityAPI)playerShip, 2.0f, 10.0f);
            this.heal();
            this.threshold = 2;
            for (WeaponAPI weapon : weapons) {
                if (!weapon.getId().contentEquals("empbomb") && !weapon.getId().contentEquals("godmode")) continue;
                weapon.setAmmo(weapon.getAmmo() + 1);
            }
            PostProcessShader.setSaturation((boolean)false, (float)1.06f);
            PostProcessShader.setContrast((boolean)false, (float)1.06f);
        } else if (this.threshold == 2 && this.maxPoints > 82.5f) {
            this.engine.addFloatingText(playerShip.getLocation(), "\u96be\u5ea6 III", 150.0f, Color.YELLOW, (CombatEntityAPI)playerShip, 4.0f, 10.0f);
            this.heal();
            this.threshold = 3;
            for (WeaponAPI weapon : weapons) {
                if (!weapon.getId().contentEquals("empbomb") && !weapon.getId().contentEquals("godmode")) continue;
                weapon.setAmmo(weapon.getAmmo() + 1);
            }
            PostProcessShader.setSaturation((boolean)false, (float)1.09f);
            PostProcessShader.setContrast((boolean)false, (float)1.09f);
        } else if (this.threshold == 3 && this.maxPoints > 95.0f) {
            this.engine.addFloatingText(playerShip.getLocation(), "\u96be\u5ea6 IV", 150.0f, Color.YELLOW, (CombatEntityAPI)playerShip, 4.0f, 10.0f);
            this.heal();
            this.threshold = 4;
            for (WeaponAPI weapon : weapons) {
                if (!weapon.getId().contentEquals("empbomb") && !weapon.getId().contentEquals("godmode")) continue;
                weapon.setAmmo(weapon.getAmmo() + 1);
            }
            PostProcessShader.setSaturation((boolean)false, (float)1.12f);
            PostProcessShader.setContrast((boolean)false, (float)1.12f);
        } else if (this.threshold == 4 && this.maxPoints > 107.5f) {
            this.engine.addFloatingText(playerShip.getLocation(), "\u96be\u5ea6 V", 150.0f, Color.RED, (CombatEntityAPI)playerShip, 6.0f, 10.0f);
            this.heal();
            this.threshold = 5;
            for (WeaponAPI weapon : weapons) {
                if (!weapon.getId().contentEquals("empbomb") && !weapon.getId().contentEquals("godmode")) continue;
                weapon.setAmmo(weapon.getAmmo() + 1);
            }
            PostProcessShader.setSaturation((boolean)false, (float)1.15f);
            PostProcessShader.setContrast((boolean)false, (float)1.15f);
        } else if (this.threshold == 5 && this.maxPoints > 120.0f) {
            this.engine.addFloatingText(playerShip.getLocation(), "\u96be\u5ea6 VI", 150.0f, Color.RED, (CombatEntityAPI)playerShip, 6.0f, 10.0f);
            this.heal();
            this.threshold = 6;
            for (WeaponAPI weapon : weapons) {
                if (!weapon.getId().contentEquals("empbomb") && !weapon.getId().contentEquals("godmode")) continue;
                weapon.setAmmo(weapon.getAmmo() + 1);
            }
            PostProcessShader.setSaturation((boolean)false, (float)1.18f);
            PostProcessShader.setContrast((boolean)false, (float)1.18f);
        } else if (this.threshold == 6 && this.maxPoints > 132.5f) {
            this.engine.addFloatingText(playerShip.getLocation(), "\u96be\u5ea6 MAX", 150.0f, Color.WHITE, (CombatEntityAPI)playerShip, 8.0f, 10.0f);
            this.heal();
            this.threshold = 7;
            for (WeaponAPI weapon : weapons) {
                if (!weapon.getId().contentEquals("empbomb") && !weapon.getId().contentEquals("godmode")) continue;
                weapon.setAmmo(weapon.getAmmo() + 1);
            }
            PostProcessShader.setSaturation((boolean)false, (float)1.21f);
            PostProcessShader.setContrast((boolean)false, (float)1.21f);
        }
        if (this.combatOver) {
            this.combatOver = true;
            CombatFleetManagerAPI eManager = this.engine.getFleetManager(FleetSide.ENEMY);
            eManager.getTaskManager(false).orderFullRetreat();
            if (this.bossLevel < 16) {
                this.engine.addFloatingText(this.engine.getViewport().getCenter(), "\u6e38\u620f\u7ed3\u675f! \u5f97\u5206: " + this.points, 100.0f, Color.YELLOW, (CombatEntityAPI)new SimpleEntity(this.engine.getViewport().getCenter()), 0.0f, 1.0f / amount);
                PostProcessShader.resetDefaults();
            } else {
                this.engine.addFloatingText(this.engine.getViewport().getCenter(), "\u4f60\u8d62\u4e86! \u5f97\u5206: " + this.points, 100.0f, Color.GREEN, (CombatEntityAPI)new SimpleEntity(this.engine.getViewport().getCenter()), 0.0f, 1.0f / amount);
                PostProcessShader.resetDefaults();
                ShipAPI[] ships2 = this.engine.getShips().toArray(new ShipAPI[this.engine.getShips().size()]);
                for (ShipAPI ship : ships2) {
                    if (ship == null) {
                        return;
                    }
                    if (ship.isAlive() && ship.getOwner() != playerShip.getOwner()) {
                        this.engine.applyDamage((CombatEntityAPI)ship, ship.getLocation(), 100000.0f, DamageType.OTHER, 0.0f, true, false, (Object)playerShip);
                        continue;
                    }
                    if (!ship.isPiece()) continue;
                    this.engine.removeEntity((CombatEntityAPI)ship);
                }
            }
            return;
        }
        if (playerShip.getHitpoints() < 0.0f) {
            this.engine.removeEntity((CombatEntityAPI)playerShip);
        }
        if (!playerShip.isAlive()) {
            this.combatOver = true;
            Global.getSoundPlayer().playUISound("youaredead", 1.0f, 1.0f);
            if (this.bossLevel < 1) {
                Global.getSoundPlayer().playUISound("fail", 1.0f, 1.0f);
            } else if (this.bossLevel >= 16) {
                Global.getSoundPlayer().playUISound("win", 1.0f, 1.0f);
                for (WeaponAPI weapon : weapons) {
                    if (!weapon.getId().contentEquals("empbomb") && !weapon.getId().contentEquals("godmode")) continue;
                    this.points = (int)((float)this.points + (float)weapon.getAmmo() * 5000.0f);
                }
            } else if (UnrealAnnouncer.getComboMulti() >= 5) {
                Global.getSoundPlayer().playUISound("denied", 1.0f, 1.0f);
            }
        }
        for (WeaponAPI weapon : weapons) {
            if (!weapon.getId().contentEquals("empbomb") && !weapon.getId().contentEquals("godmode")) continue;
            weapon.repair();
        }
        if (playerShip.getFluxTracker().getFluxLevel() >= 0.75f && playerShip.getShield() != null && playerShip.getShield().isOn()) {
            float intensity = playerShip.getFluxTracker().getFluxLevel() - 0.75f + 0.05f;
            if ((float)Math.random() < intensity * 100.0f * amount) {
                float angle = (float)Math.random() * 360.0f;
                Vector2f point1 = MathUtils.getPointOnCircumference((Vector2f)playerShip.getShield().getLocation(), (float)playerShip.getShield().getRadius(), (float)angle);
                Vector2f point2 = MathUtils.getPointOnCircumference((Vector2f)playerShip.getShield().getLocation(), (float)playerShip.getShield().getRadius(), (float)(angle + 30.0f));
                Global.getCombatEngine().spawnEmpArc(playerShip, point1, (CombatEntityAPI)new AnchoredEntity((CombatEntityAPI)playerShip, point1), (CombatEntityAPI)new AnchoredEntity((CombatEntityAPI)playerShip, point2), DamageType.ENERGY, 0.0f, 0.0f, 10000.0f, null, intensity * 0.4f, new Color(100, 200, 255, 5 * (int)intensity), new Color(255, 255, 255, 5 * (int)intensity));
            }
            this.warningBeep += amount * playerShip.getMutableStats().getTimeMult().getModifiedValue();
            if (this.warningBeep >= 0.517f / (1.0f + (intensity - 5.0f) / 100.0f)) {
                Global.getSoundPlayer().playUISound("shieldwarning", 1.0f + (intensity - 5.0f) / 100.0f, 0.25f + intensity / 100.0f);
                this.warningBeep -= 0.517f / (1.0f + (intensity - 5.0f) / 100.0f);
            }
        }
        this.engine.setDoNotEndCombat(true);
        for (ShipAPI ship : ships = this.engine.getShips().toArray(new ShipAPI[this.engine.getShips().size()])) {
            CombatFleetManagerAPI eManager;
            FleetMemberAPI fmember;
            DeployedFleetMemberAPI dfmember;
            if (ship == null) {
                return;
            }
            if (!ship.isFighter() && this.engine.getPlayerShip() != ship && ship.isAlive() && !shipWorths.containsKey(ship) && (dfmember = this.engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(ship)) != null && (fmember = dfmember.getMember()) != null) {
                shipWorths.put(ship, Float.valueOf(fmember.getFleetPointCost()));
                shipTypes.put(ship, 0);
            }
            if (ship.isAlive() && this.engine.getPlayerShip() != ship && !ship.isShuttlePod() && !ship.isWingLeader() && !ship.isDrone() && (eManager = this.engine.getFleetManager(FleetSide.ENEMY)).getTaskManager(false).getAssignmentFor(ship) != null && eManager.getTaskManager(false).getAssignmentFor(ship).getType() == CombatAssignmentType.RETREAT) {
                eManager.getTaskManager(false).orderSearchAndDestroy(eManager.getDeployedFleetMember(ship), false);
            }
            if (ship.getSpriteAPI() != null && (ship.isAlive() || ship.isHulk()) && this.engine.isEntityInPlay((CombatEntityAPI)ship)) continue;
            this.engine.removeEntity((CombatEntityAPI)ship);
        }
        for (Object obj : entries = shipWorths.entrySet().toArray()) {
            Map.Entry entry = (Map.Entry)obj;
            ShipAPI ship = (ShipAPI)entry.getKey();
            float worth = ((Float)entry.getValue()).floatValue();
            if (!(!ship.isHulk() && this.engine.isEntityInPlay((CombatEntityAPI)ship) || ship.isFighter() || this.engine.getPlayerShip() == ship)) {
                playerShip.getMutableStats().getHullDamageTakenMult().unmodify("startingbonus");
                playerShip.getMutableStats().getEmpDamageTakenMult().unmodify("startingbonus");
                playerShip.getMutableStats().getArmorDamageTakenMult().unmodify("startingbonus");
                UnrealAnnouncer.addKill(worth, shipTypes.get(ship));
                int bonusMultiplier = UnrealAnnouncer.getComboMulti();
                if (bonusMultiplier == 0) {
                    bonusMultiplier = 1;
                }
                if ((float)this.points <= 1.0f) {
                    Global.getSoundPlayer().playUISound("firstkill", 1.0f, 1.0f);
                    int supers = 1 + (this.threshold + Math.max(this.threshold - 1, 0)) / 2;
                    for (WeaponAPI weapon : weapons) {
                        if (!weapon.getId().contentEquals("empbomb") && !weapon.getId().contentEquals("godmode")) continue;
                        weapon.setAmmo(supers);
                    }
                }
                playerShip.getFluxTracker().decreaseFlux(worth * 1000.0f * (float)Math.sqrt(this.threshold + 1) / (float)Math.pow(bonusMultiplier, 0.33));
                if (BOSS_SHIPS.containsKey(ship.getHullSpec().getHullId())) {
                    float superscalar;
                    block93 : switch (this.bossLevel) {
                        case 1: {
                            superscalar = 1.0f;
                            break;
                        }
                        case 3: {
                            superscalar = 1.5f;
                            break;
                        }
                        case 5: {
                            superscalar = 2.0f;
                            break;
                        }
                        case 7: {
                            superscalar = 2.5f;
                            break;
                        }
                        case 9: {
                            superscalar = 3.0f;
                            break;
                        }
                        case 11: 
                        case 12: 
                        case 13: {
                            superscalar = 2.0f;
                            break;
                        }
                        case 15: {
                            switch (this.ultralevel) {
                                case 2: {
                                    superscalar = 36.0f;
                                    break block93;
                                }
                                case 1: {
                                    superscalar = 12.0f;
                                    break block93;
                                }
                            }
                            superscalar = 4.0f;
                            break;
                        }
                        default: {
                            superscalar = 1.0f;
                        }
                    }
                    this.points = (int)((float)this.points + worth * 10.0f * superscalar * this.scale);
                    this.engine.addFloatingText(new Vector2f((ReadableVector2f)ship.getLocation()), "+" + (int)(worth * 10.0f * superscalar * this.scale), 100.0f, Color.ORANGE, (CombatEntityAPI)new SimpleEntity(new Vector2f((ReadableVector2f)ship.getLocation())), 2.0f, 3.0f);
                    if (this.bossLevel != 11 && this.bossLevel != 12 && this.bossLevel != 15) {
                        this.snapback = 0.0f;
                        for (WeaponAPI weapon : weapons) {
                            if (!weapon.getId().contentEquals("empbomb") && !weapon.getId().contentEquals("godmode")) continue;
                            weapon.setAmmo(weapon.getAmmo() + 1);
                        }
                    }
                    ++this.bossLevel;
                    this.heal();
                } else {
                    this.points = (int)((float)this.points + worth * (float)bonusMultiplier * (float)(this.threshold + 1) * this.scale);
                    switch (shipTypes.get(ship)) {
                        case 0: {
                            this.engine.addFloatingText(new Vector2f((ReadableVector2f)ship.getLocation()), "+" + (int)(worth * (float)bonusMultiplier * (float)(this.threshold + 1) * this.scale), 35.0f, Color.WHITE, (CombatEntityAPI)new SimpleEntity(new Vector2f((ReadableVector2f)ship.getLocation())), 4.0f, 3.0f);
                            break;
                        }
                        case 1: {
                            this.engine.addFloatingText(new Vector2f((ReadableVector2f)ship.getLocation()), "+" + (int)(worth * (float)bonusMultiplier * (float)(this.threshold + 1) * this.scale), 50.0f, new Color(255, 255, 100), (CombatEntityAPI)new SimpleEntity(new Vector2f((ReadableVector2f)ship.getLocation())), 4.0f, 3.0f);
                            break;
                        }
                        case 2: {
                            this.engine.addFloatingText(new Vector2f((ReadableVector2f)ship.getLocation()), "+" + (int)(worth * (float)bonusMultiplier * (float)(this.threshold + 1) * this.scale), 65.0f, new Color(255, 150, 100), (CombatEntityAPI)new SimpleEntity(new Vector2f((ReadableVector2f)ship.getLocation())), 4.0f, 3.0f);
                            break;
                        }
                        case 3: {
                            this.engine.addFloatingText(new Vector2f((ReadableVector2f)ship.getLocation()), "+" + (int)(worth * (float)bonusMultiplier * (float)(this.threshold + 1) * this.scale), 80.0f, new Color(50, 150, 255), (CombatEntityAPI)new SimpleEntity(new Vector2f((ReadableVector2f)ship.getLocation())), 4.0f, 3.0f);
                            break;
                        }
                        case 4: {
                            this.engine.addFloatingText(new Vector2f((ReadableVector2f)ship.getLocation()), "+" + (int)(worth * (float)bonusMultiplier * (float)(this.threshold + 1) * this.scale), 50.0f, new Color(100, 255, 150), (CombatEntityAPI)new SimpleEntity(new Vector2f((ReadableVector2f)ship.getLocation())), 4.0f, 3.0f);
                        }
                    }
                    this.buffLevel += worth / 750.0f;
                    this.maxPoints += 1.33f / (1.0f + this.buffLevel * 0.33f) * worth * 0.04f;
                }
                if ((ship.getHullSpec().getHullId().contentEquals("ssp_zero") || ship.getHullSpec().getHullId().contentEquals("ssp_superzero") || ship.getHullSpec().getHullId().contentEquals("ssp_hyperzero")) && this.bossLevel >= 16) {
                    Global.getSoundPlayer().playUISound("win", 1.0f, 1.0f);
                    this.combatOver = true;
                    for (WeaponAPI weapon : weapons) {
                        if (!weapon.getId().contentEquals("empbomb") && !weapon.getId().contentEquals("godmode")) continue;
                        this.points = (int)((float)this.points + (float)weapon.getAmmo() * 5000.0f * this.scale);
                        this.engine.addFloatingText(MathUtils.getRandomPointInCircle((Vector2f)playerShip.getLocation(), (float)100.0f), "+" + (float)weapon.getAmmo() * 5000.0f * this.scale, 50.0f, Color.ORANGE, (CombatEntityAPI)new SimpleEntity(new Vector2f((ReadableVector2f)playerShip.getLocation())), 8.0f, 3.0f);
                    }
                }
                Vector2f playerShipLoc = playerShip.getLocation();
                Vector2f comboBonusTxt = new Vector2f((ReadableVector2f)playerShipLoc);
                Vector2f totalPointsTxt = new Vector2f((ReadableVector2f)playerShipLoc);
                comboBonusTxt.setY(comboBonusTxt.y + 70.0f);
                totalPointsTxt.setY(totalPointsTxt.y - 50.0f);
                if (UnrealAnnouncer.getComboMulti() > 1) {
                    this.engine.addFloatingText(comboBonusTxt, bonusMultiplier + "X \u8fde\u6740\u5956\u52b1!", 40.0f + (float)bonusMultiplier * 5.0f, Color.red, (CombatEntityAPI)playerShip, (float)bonusMultiplier, 3.0f);
                }
                this.engine.addFloatingText(totalPointsTxt, "\u5956\u52b1\u5206: " + this.points, 50.0f, Color.green, (CombatEntityAPI)playerShip, 2.0f, 3.0f);
                for (WeaponAPI weapon : weapons) {
                    if (weapon.getId().contentEquals("empbomb") || weapon.getId().contentEquals("godmode")) continue;
                    weapon.repair();
                    weapon.setRemainingCooldownTo(0.0f);
                    if (weapon.getAmmo() >= 100000 || weapon.getAmmo() < 0) continue;
                    if (weapon.getDerivedStats().getSustainedDps() < weapon.getDerivedStats().getDps()) {
                        weapon.setAmmo(Math.min(Math.max(weapon.getMaxAmmo() + (int)((float)weapon.getMaxAmmo() * worth * (float)Math.sqrt(bonusMultiplier) / 3.0f), weapon.getAmmo()), weapon.getMaxAmmo() * 10));
                        continue;
                    }
                    weapon.setAmmo(Math.min(weapon.getAmmo() + (int)((float)weapon.getMaxAmmo() * (float)Math.sqrt(worth * (float)Math.sqrt(bonusMultiplier) * ((float)weapon.getMaxAmmo() / (1.0f + (float)weapon.getAmmo())) / 300.0f)), weapon.getMaxAmmo() * 10));
                }
                shipTypes.remove(ship);
                shipWorths.remove(ship);
                if (this.engine.isEntityInPlay((CombatEntityAPI)ship) && !BOSS_SHIPS.containsKey(ship.getHullSpec().getHullId())) {
                    this.engine.removeEntity((CombatEntityAPI)ship);
                }
            }
            if (!ship.isHulk() && this.engine.isEntityInPlay((CombatEntityAPI)ship) || ship.isFighter() || ship.isDrone() || this.engine.getPlayerShip() == ship) continue;
            shipTypes.remove(ship);
            shipWorths.remove(ship);
            if (!this.engine.isEntityInPlay((CombatEntityAPI)ship) || BOSS_SHIPS.containsKey(ship.getHullSpec().getHullId())) continue;
            this.engine.removeEntity((CombatEntityAPI)ship);
        }
        int fp = 0;
        int numShips = 0;
        for (ShipAPI s : ships) {
            FleetMemberAPI fmember;
            DeployedFleetMemberAPI dfmember;
            if (this.engine.getPlayerShip() == s || !s.isAlive() || s.isFighter() || !shipTypes.containsKey(s) || BOSS_SHIPS.containsKey(s.getHullSpec().getHullId()) || (dfmember = this.engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(s)) == null || (fmember = dfmember.getMember()) == null) continue;
            int type = shipTypes.get(s);
            switch (type) {
                case 4: {
                    fp = (int)((float)fp + (float)fmember.getFleetPointCost() * 2.0f);
                    break;
                }
                case 3: {
                    fp = (int)((float)fp + (float)fmember.getFleetPointCost() * 3.0f);
                    break;
                }
                case 2: {
                    fp = (int)((float)fp + (float)fmember.getFleetPointCost() * 2.5f);
                    break;
                }
                case 1: {
                    fp = (int)((float)fp + (float)fmember.getFleetPointCost() * 2.0f);
                    break;
                }
                case 0: {
                    fp += fmember.getFleetPointCost();
                    break;
                }
            }
            ++numShips;
        }
        if ((float)fp < this.maxPoints || numShips < 2) {
            ArrayList<ShipAPI> spawnList = new ArrayList<ShipAPI>(10);
            int bound = 100;
            while (((float)fp < this.maxPoints || numShips < 2) && bound > 0) {
                --bound;
                int type = 0;
                double rand = Math.random();
                switch (this.threshold) {
                    case 0: {
                        if (rand >= 0.99) {
                            type = 3;
                            break;
                        }
                        if (rand >= 0.97) {
                            type = 2;
                            break;
                        }
                        if (!(rand >= 0.93)) break;
                        if (Math.random() > 0.75) {
                            type = 4;
                            break;
                        }
                        type = 1;
                        break;
                    }
                    case 1: {
                        if (rand >= 0.98) {
                            type = 3;
                            break;
                        }
                        if (rand >= 0.94) {
                            type = 2;
                            break;
                        }
                        if (!(rand >= 0.86)) break;
                        if (Math.random() > 0.75) {
                            type = 4;
                            break;
                        }
                        type = 1;
                        break;
                    }
                    case 2: {
                        if (rand >= 0.97) {
                            type = 3;
                            break;
                        }
                        if (rand >= 0.91) {
                            type = 2;
                            break;
                        }
                        if (!(rand >= 0.79)) break;
                        if (Math.random() > 0.75) {
                            type = 4;
                            break;
                        }
                        type = 1;
                        break;
                    }
                    case 3: {
                        if (rand >= 0.96) {
                            type = 3;
                            break;
                        }
                        if (rand >= 0.88) {
                            type = 2;
                            break;
                        }
                        if (!(rand >= 0.72)) break;
                        if (Math.random() > 0.75) {
                            type = 4;
                            break;
                        }
                        type = 1;
                        break;
                    }
                    case 4: {
                        if (rand >= 0.95) {
                            type = 3;
                            break;
                        }
                        if (rand >= 0.85) {
                            type = 2;
                            break;
                        }
                        if (!(rand >= 0.65)) break;
                        if (Math.random() > 0.75) {
                            type = 4;
                            break;
                        }
                        type = 1;
                        break;
                    }
                    case 5: {
                        if (rand >= 0.94) {
                            type = 3;
                            break;
                        }
                        if (rand >= 0.82) {
                            type = 2;
                            break;
                        }
                        if (!(rand >= 0.58)) break;
                        if (Math.random() > 0.75) {
                            type = 4;
                            break;
                        }
                        type = 1;
                        break;
                    }
                    case 6: {
                        if (rand >= 0.92) {
                            type = 3;
                            break;
                        }
                        if (rand >= 0.76) {
                            type = 2;
                            break;
                        }
                        if (!(rand >= 0.51)) break;
                        if (Math.random() > 0.75) {
                            type = 4;
                            break;
                        }
                        type = 1;
                        break;
                    }
                    case 7: {
                        if (rand >= 0.897) {
                            type = 3;
                            break;
                        }
                        if (rand >= 0.69) {
                            type = 2;
                            break;
                        }
                        if (!(rand >= 0.44)) break;
                        if (Math.random() > 0.75) {
                            type = 4;
                            break;
                        }
                        type = 1;
                        break;
                    }
                }
                ShipAPI spawned = this.makeShip(type);
                if (spawned == null) continue;
                spawned.setOriginalOwner(1);
                spawned.setOwner(1);
                if (spawned.isFighter()) {
                    rand = Math.max(Math.random(), Math.max(rand, Math.random()));
                    switch (this.threshold) {
                        case 0: {
                            if (rand >= 0.99) {
                                type = 3;
                                break;
                            }
                            if (rand >= 0.97) {
                                type = 2;
                                break;
                            }
                            if (!(rand >= 0.93)) break;
                            if (Math.random() > 0.75) {
                                type = 4;
                                break;
                            }
                            type = 1;
                            break;
                        }
                        case 1: {
                            if (rand >= 0.98) {
                                type = 3;
                                break;
                            }
                            if (rand >= 0.94) {
                                type = 2;
                                break;
                            }
                            if (!(rand >= 0.86)) break;
                            if (Math.random() > 0.75) {
                                type = 4;
                                break;
                            }
                            type = 1;
                            break;
                        }
                        case 2: {
                            if (rand >= 0.97) {
                                type = 3;
                                break;
                            }
                            if (rand >= 0.91) {
                                type = 2;
                                break;
                            }
                            if (!(rand >= 0.79)) break;
                            if (Math.random() > 0.75) {
                                type = 4;
                                break;
                            }
                            type = 1;
                            break;
                        }
                        case 3: {
                            if (rand >= 0.96) {
                                type = 3;
                                break;
                            }
                            if (rand >= 0.88) {
                                type = 2;
                                break;
                            }
                            if (!(rand >= 0.72)) break;
                            if (Math.random() > 0.75) {
                                type = 4;
                                break;
                            }
                            type = 1;
                            break;
                        }
                        case 4: {
                            if (rand >= 0.95) {
                                type = 3;
                                break;
                            }
                            if (rand >= 0.85) {
                                type = 2;
                                break;
                            }
                            if (!(rand >= 0.65)) break;
                            if (Math.random() > 0.75) {
                                type = 4;
                                break;
                            }
                            type = 1;
                            break;
                        }
                        case 5: {
                            if (rand >= 0.94) {
                                type = 3;
                                break;
                            }
                            if (rand >= 0.82) {
                                type = 2;
                                break;
                            }
                            if (!(rand >= 0.58)) break;
                            if (Math.random() > 0.75) {
                                type = 4;
                                break;
                            }
                            type = 1;
                            break;
                        }
                        case 6: {
                            if (rand >= 0.92) {
                                type = 3;
                                break;
                            }
                            if (rand >= 0.76) {
                                type = 2;
                                break;
                            }
                            if (!(rand >= 0.51)) break;
                            if (Math.random() > 0.75) {
                                type = 4;
                                break;
                            }
                            type = 1;
                            break;
                        }
                        case 7: {
                            if (rand >= 0.897) {
                                type = 3;
                                break;
                            }
                            if (rand >= 0.69) {
                                type = 2;
                                break;
                            }
                            if (!(rand >= 0.44)) break;
                            if (Math.random() > 0.75) {
                                type = 4;
                                break;
                            }
                            type = 1;
                            break;
                        }
                    }
                }
                spawnList.add(spawned);
                ArrayList<ShipAPI> shipList = new ArrayList<ShipAPI>(spawnList.size());
                if (!spawned.isFighter()) {
                    shipList.add(spawned);
                    ++numShips;
                } else {
                    shipList.addAll(spawned.getWing().getWingMembers());
                }
                for (ShipAPI shp : shipList) {
                    if ((shp.getShield() == null || shp.getShield() != null && shp.getShield().getType() == ShieldAPI.ShieldType.PHASE) && type == 4) {
                        type = 1;
                    }
                    shipTypes.put(shp, type);
                    switch (type) {
                        case 4: {
                            shipWorths.put(shp, Float.valueOf(1.0f * (float)this.engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(shp).getMember().getFleetPointCost()));
                            if (shp.isFighter()) break;
                            fp = (int)((float)fp + (float)this.engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(shp).getMember().getFleetPointCost() * 2.0f);
                            break;
                        }
                        case 3: {
                            shipWorths.put(shp, Float.valueOf(2.0f * (float)this.engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(shp).getMember().getFleetPointCost()));
                            if (shp.isFighter()) break;
                            fp = (int)((float)fp + (float)this.engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(shp).getMember().getFleetPointCost() * 3.0f);
                            break;
                        }
                        case 2: {
                            shipWorths.put(shp, Float.valueOf(1.0f * (float)this.engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(shp).getMember().getFleetPointCost()));
                            if (shp.isFighter()) break;
                            fp = (int)((float)fp + (float)this.engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(shp).getMember().getFleetPointCost() * 2.5f);
                            break;
                        }
                        case 1: {
                            shipWorths.put(shp, Float.valueOf(1.0f * (float)this.engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(shp).getMember().getFleetPointCost()));
                            if (shp.isFighter()) break;
                            fp = (int)((float)fp + (float)this.engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(shp).getMember().getFleetPointCost() * 2.0f);
                            break;
                        }
                        case 0: {
                            shipWorths.put(shp, Float.valueOf(0.5f * (float)this.engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(shp).getMember().getFleetPointCost()));
                            if (shp.isFighter()) break;
                            fp += this.engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(shp).getMember().getFleetPointCost();
                        }
                    }
                }
            }
            for (ShipAPI newShip : spawnList) {
                if (newShip.isFighter()) continue;
                int type = shipTypes.get(newShip);
                switch (type) {
                    case 3: {
                        newShip.setCRAtDeployment(0.8f);
                        newShip.setCurrentCR(0.8f);
                        break;
                    }
                    case 2: 
                    case 4: {
                        newShip.setCRAtDeployment(0.7f);
                        newShip.setCurrentCR(0.7f);
                        break;
                    }
                    case 1: {
                        newShip.setCRAtDeployment(0.5f);
                        newShip.setCurrentCR(0.5f);
                        break;
                    }
                    case 0: {
                        newShip.setCRAtDeployment(0.6f);
                        newShip.setCurrentCR(0.6f);
                    }
                }
                this.engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(newShip).getMember().getCaptain().setPersonality("aggressive");
                newShip.getShipAI().forceCircumstanceEvaluation();
            }
        }
        for (ShipAPI ship : ships) {
            if (ship.isAlive() || !this.engine.isEntityInPlay((CombatEntityAPI)ship) || BOSS_SHIPS.containsKey(ship.getHullSpec().getHullId())) continue;
            this.engine.removeEntity((CombatEntityAPI)ship);
        }
    }

    public void init(CombatEngineAPI engine) {
        if (first) {
            first = false;
            this.init();
        }
        this.engine = engine;
        Global.getCombatEngine().getCustomData().put(DATA_KEY, new LocalData());
        this.mapX = engine.getMapWidth();
        this.mapY = engine.getMapHeight();
        this.combatOver = false;
        try {
            this.reloadSettings();
        }
        catch (IOException | JSONException ex) {
            this.maxPoints = 50.0f;
            this.buffLevel = 0.0f;
            this.threshold = 0;
            this.bossLevel = 0;
            Global.getLogger(MissionPlugin.class).log((Priority)Level.ERROR, (Object)ex);
        }
        this.points = 0;
        this.bossFlash = 0.0f;
        this.snapback = 0.0f;
        engine.getPlayerShip().getMutableStats().getHullDamageTakenMult().modifyMult("startingbonus", 0.0f);
        engine.getPlayerShip().getMutableStats().getEmpDamageTakenMult().modifyMult("startingbonus", 0.0f);
        engine.getPlayerShip().getMutableStats().getArmorDamageTakenMult().modifyMult("startingbonus", 1.0E-5f);
        ArrayList<Float> notches = new ArrayList<Float>(13);
        notches.add(Float.valueOf(0.08571428f));
        notches.add(Float.valueOf(0.14285713f));
        notches.add(Float.valueOf(0.22857141f));
        notches.add(Float.valueOf(0.28571427f));
        notches.add(Float.valueOf(0.37142855f));
        notches.add(Float.valueOf(0.4285714f));
        notches.add(Float.valueOf(0.5142857f));
        notches.add(Float.valueOf(0.57142854f));
        notches.add(Float.valueOf(0.6571428f));
        notches.add(Float.valueOf(0.7142857f));
        notches.add(Float.valueOf(0.79999995f));
        notches.add(Float.valueOf(0.8571428f));
        notches.add(Float.valueOf(0.9428571f));
        this.pbar = new ProgressBar(0.0f, notches, new Vector2f(Global.getSettings().getScreenWidth() - 10.5f, Global.getSettings().getScreenHeight() * 0.375f + 20.0f), Global.getSettings().getScreenHeight() * 0.75f - 20.0f, 12.0f);
    }

    public void reloadSettings() throws IOException, JSONException {
        JSONObject settings = Global.getSettings().loadJSON("arcadeSettings.json");
        this.threshold = settings.getInt("startingDifficulty");
        switch (this.threshold) {
            case 1: {
                this.maxPoints = 57.5f;
                this.buffLevel = 0.2f;
                this.bossLevel = 0;
                break;
            }
            case 2: {
                this.maxPoints = 70.0f;
                this.buffLevel = 0.55f;
                this.bossLevel = 2;
                break;
            }
            case 3: {
                this.maxPoints = 82.5f;
                this.buffLevel = 0.935f;
                this.bossLevel = 4;
                break;
            }
            case 4: {
                this.maxPoints = 95.0f;
                this.buffLevel = 1.365f;
                this.bossLevel = 6;
                break;
            }
            case 5: {
                this.maxPoints = 107.5f;
                this.buffLevel = 1.85f;
                this.bossLevel = 8;
                break;
            }
            case 6: {
                this.maxPoints = 120.0f;
                this.buffLevel = 2.375f;
                this.bossLevel = 10;
                break;
            }
            case 7: {
                this.maxPoints = 132.5f;
                this.buffLevel = 2.965f;
                this.bossLevel = 14;
                break;
            }
            default: {
                this.maxPoints = 50.0f;
                this.buffLevel = 0.0f;
                this.bossLevel = 0;
            }
        }
        this.scale = (float)settings.getDouble("difficultyScalar");
    }

    private void heal() {
        this.engine.getPlayerShip().getFluxTracker().setHardFlux(0.0f);
        this.engine.getPlayerShip().getFluxTracker().setCurrFlux(0.0f);
        this.engine.getPlayerShip().setHitpoints(this.engine.getPlayerShip().getMaxHitpoints());
        ArmorGridAPI armorGrid = this.engine.getPlayerShip().getArmorGrid();
        for (int x = 0; x < armorGrid.getGrid().length; ++x) {
            for (int y = 0; y < armorGrid.getGrid()[x].length; ++y) {
                armorGrid.setArmorValue(x, y, armorGrid.getMaxArmorInCell());
            }
        }
    }

    private void init() {
        FACTIONS.add((Object)"pirates", 1.0f);
        FACTIONS.add((Object)"hegemony", 1.0f);
        FACTIONS.add((Object)"sindrian_diktat", 0.5f);
        FACTIONS.add((Object)"lions_guard", 0.25f);
        FACTIONS.add((Object)"independent", 1.0f);
        FACTIONS.add((Object)"scavengers", 0.5f);
        FACTIONS.add((Object)"tritachyon", 1.0f);
        FACTIONS.add((Object)"persean", 1.0f);
        FACTIONS.add((Object)"luddic_path", 0.5f);
        FACTIONS.add((Object)"luddic_church", 1.0f);
        FACTIONS.add((Object)"derelict", 0.5f);
        FACTIONS.add((Object)"remnant", 0.5f);
        if (SWPModPlugin.hasDynaSector) {
            FACTIONS.add((Object)"domain", 0.25f);
            FACTIONS.add((Object)"sector", 0.5f);
            FACTIONS.add((Object)"everything", 1.0f);
        }
        if (SWPModPlugin.imperiumExists) {
            FACTIONS.add((Object)"interstellarimperium", 1.0f);
        }
        if (SWPModPlugin.citadelExists) {
            FACTIONS.add((Object)"citadeldefenders", 1.0f);
        }
        if (SWPModPlugin.blackrockExists) {
            FACTIONS.add((Object)"blackrock_driveyards", 1.0f);
        }
        if (SWPModPlugin.exigencyExists) {
            FACTIONS.add((Object)"exipirated", 0.5f);
            FACTIONS.add((Object)"exigency", 0.75f);
        }
        if (SWPModPlugin.templarsExists) {
            FACTIONS.add((Object)"templars", 0.25f);
        }
        if (SWPModPlugin.shadowyardsExists) {
            FACTIONS.add((Object)"shadow_industry", 1.0f);
        }
        if (SWPModPlugin.mayorateExists) {
            FACTIONS.add((Object)"mayorate", 1.0f);
        }
        if (SWPModPlugin.junkPiratesExists) {
            FACTIONS.add((Object)"junk_pirates", 1.0f);
            FACTIONS.add((Object)"pack", 0.75f);
            FACTIONS.add((Object)"syndicate_asp", 0.5f);
        }
        if (SWPModPlugin.scyExists) {
            FACTIONS.add((Object)"SCY", 1.0f);
        }
        if (SWPModPlugin.tiandongExists) {
            FACTIONS.add((Object)"tiandong", 0.75f);
        }
        if (SWPModPlugin.diableExists) {
            FACTIONS.add((Object)"diableavionics", 0.75f);
        }
        if (SWPModPlugin.oraExists) {
            FACTIONS.add((Object)"ORA", 0.75f);
        }
        if (SWPModPlugin.hasUnderworld) {
            FACTIONS.add((Object)"cabal", 0.25f);
        }
        if (SWPModPlugin.tyradorExists) {
            FACTIONS.add((Object)"Coalition", 1.0f);
        }
        if (SWPModPlugin.dmeExists) {
            FACTIONS.add((Object)"dassault_mikoyan", 0.75f);
        }
    }

    private void makeBoss(int level) {
        String id;
        LocalData localData = (LocalData)this.engine.getCustomData().get(DATA_KEY);
        Map<ShipAPI, Integer> shipTypes = localData.shipTypes;
        Map<ShipAPI, Float> shipWorths = localData.shipWorths;
        block0 : switch (level) {
            case 1: {
                id = "ssp_oberon_ult";
                break;
            }
            case 2: {
                id = "ssp_ultron_ult";
                break;
            }
            case 3: {
                id = "ssp_zeus_ult";
                break;
            }
            case 4: {
                id = "ssp_ezekiel_ult";
                break;
            }
            case 5: {
                id = "ssp_cristarium_ult";
                break;
            }
            case 6: {
                id = "ssp_superhyperion_war";
                break;
            }
            case 7: {
                switch (this.ultralevel) {
                    case 2: {
                        id = "ssp_hyperzero_ult";
                        break block0;
                    }
                    case 1: {
                        id = "ssp_superzero_ult";
                        break block0;
                    }
                }
                id = "ssp_zero_ult";
                break;
            }
            default: {
                id = "ssp_superhyperion_str";
            }
        }
        this.mapX = this.engine.getMapWidth();
        this.mapY = this.engine.getMapHeight();
        ShipAPI boss = this.engine.getFleetManager(FleetSide.ENEMY).spawnShipOrWing(id, SWP_Util.getSafeSpawn(500.0f, FleetSide.ENEMY, this.mapX, this.mapY), 270.0f, 3.0f);
        shipWorths.put(boss, Float.valueOf((float)this.engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(boss).getMember().getFleetPointCost() * 2.0f));
        shipTypes.put(boss, 99);
        boss.setCRAtDeployment(1.0f);
        boss.setCurrentCR(1.0f);
        this.engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(boss).getMember().getCaptain().setPersonality("aggressive");
        boss.getShipAI().forceCircumstanceEvaluation();
        this.bar1 = new HealthBar(boss, new Vector2f(Global.getSettings().getScreenWidth() / 2.0f, 20.0f), 35.0f, 400.0f);
        if (level == 6) {
            id = "ssp_superhyperion_hul";
            boss = this.engine.getFleetManager(FleetSide.ENEMY).spawnShipOrWing(id, SWP_Util.getSafeSpawn(500.0f, FleetSide.ENEMY, this.mapX, this.mapY), 270.0f, 3.0f);
            shipWorths.put(boss, Float.valueOf((float)this.engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(boss).getMember().getFleetPointCost() * 2.0f));
            shipTypes.put(boss, 99);
            boss.setCRAtDeployment(1.0f);
            boss.setCurrentCR(1.0f);
            this.engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(boss).getMember().getCaptain().setPersonality("aggressive");
            boss.getShipAI().forceCircumstanceEvaluation();
            this.bar2 = new HealthBar(boss, new Vector2f(Global.getSettings().getScreenWidth() / 2.0f, 60.0f), 35.0f, 400.0f);
            id = "ssp_superhyperion_she";
            boss = this.engine.getFleetManager(FleetSide.ENEMY).spawnShipOrWing(id, SWP_Util.getSafeSpawn(500.0f, FleetSide.ENEMY, this.mapX, this.mapY), 270.0f, 3.0f);
            shipWorths.put(boss, Float.valueOf((float)this.engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(boss).getMember().getFleetPointCost() * 2.0f));
            shipTypes.put(boss, 99);
            boss.setCRAtDeployment(1.0f);
            boss.setCurrentCR(1.0f);
            this.engine.getFleetManager(FleetSide.ENEMY).getDeployedFleetMember(boss).getMember().getCaptain().setPersonality("aggressive");
            boss.getShipAI().forceCircumstanceEvaluation();
            this.bar3 = new HealthBar(boss, new Vector2f(Global.getSettings().getScreenWidth() / 2.0f, 100.0f), 35.0f, 400.0f);
        }
    }

    private ShipAPI makeShip(int type) {
        int bound = 100;
        while (bound > 0) {
            --bound;
            String role = (String)ROLES.pick();
            ArrayList<FleetMemberAPI> members = new ArrayList<FleetMemberAPI>(1);
            if (Math.random() > 0.025) {
                List picks = Global.getSector().getFaction((String)FACTIONS.pick()).pickShip(role, (float)Math.random());
                for (ShipRolePick pick : picks) {
                    FleetMemberAPI member = Global.getFactory().createFleetMember(FleetMemberType.SHIP, pick.variantId);
                    members.add(member);
                }
            } else {
                for (int i = 0; i < 10; ++i) {
                    FleetMemberAPI member;
                    String hull = (String)SPECIAL_SHIPS.pick();
                    try {
                        member = hull.endsWith("_wing") ? Global.getFactory().createFleetMember(FleetMemberType.FIGHTER_WING, hull) : Global.getFactory().createFleetMember(FleetMemberType.SHIP, hull);
                    }
                    catch (Exception e) {
                        member = null;
                    }
                    if (member == null) continue;
                    members.add(member);
                    break;
                }
            }
            if (members.isEmpty()) continue;
            for (FleetMemberAPI member : members) {
                if (member.isFighterWing()) continue;
                String faction = (String)FACTIONS.pick();
                float bonus = (float)this.threshold * 5.0f;
                if (SPECIAL_SHIPS.getItems().contains(member.getHullId() + "_Hull") || SPECIAL_SHIPS.getItems().contains(member.getHullId())) {
                    bonus += 30.0f;
                }
                ArrayList<String> factionList = new ArrayList<String>(1);
                factionList.add(faction);
                DS_VariantRandomizer.setVariant((FleetMemberAPI)member, factionList, null, (DS_Defs.Archetype)DS_Defs.Archetype.ARCADE, (float)((float)Math.random()), (float)bonus, (boolean)false, (Random)new Random());
                if (!member.getVariant().getDisplayName().contentEquals("Arcade")) continue;
                member.getRepairTracker().setCrashMothballed(false);
                member.getRepairTracker().setMothballed(false);
                member.getCrewComposition().addCrew(member.getNeededCrew());
                member.getRepairTracker().setCR(1.0f);
                this.mapX = this.engine.getMapWidth();
                this.mapY = this.engine.getMapHeight();
                return this.engine.getFleetManager(1).spawnFleetMember(member, SWP_Util.getSafeSpawn(SWP_Util.getMemberRadiusEstimate(member), FleetSide.ENEMY, this.mapX, this.mapY), 270.0f, 3.0f);
            }
        }
        return null;
    }

    static {
        ROLES.add((Object)"fastAttack", 2.0f);
        ROLES.add((Object)"escortSmall", 2.0f);
        ROLES.add((Object)"escortMedium", 2.5f);
        ROLES.add((Object)"combatSmall", 4.0f);
        ROLES.add((Object)"combatMedium", 5.0f);
        ROLES.add((Object)"combatLarge", 4.0f);
        ROLES.add((Object)"combatCapital", 3.0f);
        ROLES.add((Object)"combatFreighterSmall", 2.0f);
        ROLES.add((Object)"combatFreighterMedium", 2.5f);
        ROLES.add((Object)"combatFreighterLarge", 2.0f);
        ROLES.add((Object)"civilianRandom", 0.5f);
        ROLES.add((Object)"carrierSmall", 1.0f);
        ROLES.add((Object)"carrierMedium", 1.25f);
        ROLES.add((Object)"carrierLarge", 1.0f);
        ROLES.add((Object)"freighterSmall", 0.5f);
        ROLES.add((Object)"freighterMedium", 0.625f);
        ROLES.add((Object)"freighterLarge", 0.5f);
        ROLES.add((Object)"tankerSmall", 0.5f);
        ROLES.add((Object)"tankerMedium", 0.625f);
        ROLES.add((Object)"tankerLarge", 0.5f);
        ROLES.add((Object)"personnelSmall", 0.5f);
        ROLES.add((Object)"personnelMedium", 0.625f);
        ROLES.add((Object)"personnelLarge", 0.5f);
        ROLES.add((Object)"tug", 0.5f);
        ROLES.add((Object)"crig", 0.5f);
        ROLES.add((Object)"utility", 0.5f);
        BOSS_SHIPS.put("ssp_superhyperion", Float.valueOf(4.0f));
        BOSS_SHIPS.put("ssp_oberon", Float.valueOf(2.0f));
        BOSS_SHIPS.put("ssp_ultron", Float.valueOf(3.0f));
        BOSS_SHIPS.put("ssp_zeus", Float.valueOf(2.0f));
        BOSS_SHIPS.put("ssp_ezekiel", Float.valueOf(4.0f));
        BOSS_SHIPS.put("ssp_cristarium", Float.valueOf(2.0f));
        BOSS_SHIPS.put("ssp_zero", Float.valueOf(4.0f));
        BOSS_SHIPS.put("ssp_superzero", Float.valueOf(5.0f));
        BOSS_SHIPS.put("ssp_hyperzero", Float.valueOf(6.0f));
        SPECIAL_SHIPS.add((Object)"ii_boss_praetorian_Hull", 5.0f);
        SPECIAL_SHIPS.add((Object)"ii_boss_olympus_Hull", 1.0f);
        SPECIAL_SHIPS.add((Object)"ii_boss_dominus_Hull", 1.0f);
        SPECIAL_SHIPS.add((Object)"msp_boss_potniaBis_Hull", 4.0f);
        SPECIAL_SHIPS.add((Object)"ms_boss_charybdis_Hull", 3.0f);
        SPECIAL_SHIPS.add((Object)"ms_boss_mimir_Hull", 2.0f);
        SPECIAL_SHIPS.add((Object)"tem_boss_paladin_Hull", 1.0f);
        SPECIAL_SHIPS.add((Object)"tem_boss_archbishop_Hull", 0.5f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_phaeton_Hull", 4.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_hammerhead_Hull", 5.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_sunder_Hull", 5.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_tarsus_Hull", 5.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_medusa_Hull", 4.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_falcon_Hull", 4.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_hyperion_Hull", 4.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_paragon_Hull", 1.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_mule_Hull", 3.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_aurora_Hull", 2.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_odyssey_Hull", 1.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_atlas_Hull", 2.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_afflictor_Hull", 4.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_brawler_Hull", 5.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_cerberus_Hull", 5.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_dominator_Hull", 3.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_doom_Hull", 2.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_euryale_Hull", 3.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_lasher_b_Hull", 5.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_lasher_r_Hull", 5.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_onslaught_Hull", 1.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_shade_Hull", 4.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_eagle_Hull", 3.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_beholder_Hull", 3.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_dominator_luddic_path_Hull", 4.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_onslaught_luddic_path_Hull", 2.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_astral_Hull", 1.0f);
        SPECIAL_SHIPS.add((Object)"ssp_boss_conquest_Hull", 1.0f);
        SPECIAL_SHIPS.add((Object)"swp_boss_frankenstein_Hull", 2.0f);
        SPECIAL_SHIPS.add((Object)"swp_boss_sporeship_cus", 0.5f);
        SPECIAL_SHIPS.add((Object)"swp_banana_Hull", 1.0f);
        SPECIAL_SHIPS.add((Object)"tiandong_boss_wuzhang_Hull", 2.0f);
        SPECIAL_SHIPS.add((Object)"pack_bulldog_bullseye_Hull", 3.0f);
        SPECIAL_SHIPS.add((Object)"pack_pitbull_bullseye_Hull", 4.0f);
        SPECIAL_SHIPS.add((Object)"pack_komondor_bullseye_Hull", 4.0f);
        SPECIAL_SHIPS.add((Object)"pack_schnauzer_bullseye_Hull", 5.0f);
        SPECIAL_SHIPS.add((Object)"diableavionics_IBBgulf_Hull", 2.0f);
        AURA_MOD.put(ShipAPI.HullSize.FIGHTER, 1);
        AURA_MOD.put(ShipAPI.HullSize.FRIGATE, 2);
        AURA_MOD.put(ShipAPI.HullSize.DESTROYER, 4);
        AURA_MOD.put(ShipAPI.HullSize.DEFAULT, 4);
        AURA_MOD.put(ShipAPI.HullSize.CRUISER, 6);
        AURA_MOD.put(ShipAPI.HullSize.CAPITAL_SHIP, 8);
    }

    private static final class LocalData {
        final Map<ShipAPI, Integer> shipTypes = new LinkedHashMap<ShipAPI, Integer>(100);
        final Map<ShipAPI, Float> shipWorths = new LinkedHashMap<ShipAPI, Float>(100);

        private LocalData() {
        }
    }
}

