/*
 * Decompiled with CFR 0.152.
 */
package data.missions.arcade;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.EveryFrameCombatPlugin;
import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import data.missions.arcade.MissionPlugin;
import data.missions.arcade.UnrealAnnouncer;
import data.scripts.SWPModPlugin;
import java.io.IOException;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.json.JSONException;
import org.json.JSONObject;

public class MissionDefinition
implements MissionDefinitionPlugin {
    public static final String SETTINGS_FILE = "arcadeSettings.json";
    private String ship = "ssp_superhyperion_str";

    public void defineMission(MissionDefinitionAPI api) {
        try {
            this.reloadSettings();
        }
        catch (IOException | JSONException ex) {
            Global.getLogger(MissionDefinition.class).log((Priority)Level.ERROR, (Object)ex);
        }
        api.initFleet(FleetSide.PLAYER, "", FleetGoal.ATTACK, false, 25);
        api.initFleet(FleetSide.ENEMY, "SS", FleetGoal.ATTACK, true, 10);
        api.setFleetTagline(FleetSide.PLAYER, "\u73a9\u5bb6");
        api.setFleetTagline(FleetSide.ENEMY, "\u654c\u4eba");
        if (!SWPModPlugin.hasDynaSector) {
            api.addBriefingItem("\u9700\u8981 \u52bf\u529b\u5f00\u5c40");
            api.addBriefingItem("\u4e0b\u8f7d \u52bf\u529b\u5f00\u5c40 \u6765\u6267\u884c\u8fd9\u4e2a\u4efb\u52a1!");
            return;
        }
        api.addBriefingItem("\u51fb\u8d25\u6bcf\u4e00\u8258\u654c\u8230\u90fd\u4f1a\u4f7f\u4f60\u53d8\u5f97\u66f4\u4e3a\u5f3a\u5927");
        api.addBriefingItem("\u968f\u7740\u65f6\u95f4\u7684\u63a8\u79fb\uff0c \u654c\u4eba\u5c06\u4f1a\u8d8a\u6765\u8d8a\u5f3a");
        api.addBriefingItem("\u8fde\u7eed\u51fb\u6740\u4f1a\u83b7\u5f97\u989d\u5916\u5206\u6570");
        api.addBriefingItem("\u51fb\u8d25\u6bcf\u4e00\u8258\u654c\u8230\u90fd\u4f1a\u4f7f\u5f39\u836f\u91cd\u65b0\u751f\u6210");
        api.addToFleet(FleetSide.PLAYER, this.ship, FleetMemberType.SHIP, "\u786c\u6c49 \u5170\u8fea-\u8428\u7ef4\u5947", true).getCaptain().setPersonality("aggressive");
        api.addToFleet(FleetSide.ENEMY, "ox_Standard", FleetMemberType.SHIP, "Scape", false).getCaptain().setPersonality("aggressive");
        api.addToFleet(FleetSide.ENEMY, "ox_Standard", FleetMemberType.SHIP, "Goat", false).getCaptain().setPersonality("aggressive");
        float width = 6000.0f;
        float height = 6000.0f;
        api.initMap(-width / 2.0f, width / 2.0f, -height / 2.0f, height / 2.0f);
        api.addPlugin((EveryFrameCombatPlugin)new MissionPlugin());
        api.addPlugin((EveryFrameCombatPlugin)new UnrealAnnouncer());
    }

    public void reloadSettings() throws IOException, JSONException {
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);
        this.ship = settings.getString("playerShip");
    }
}

