/*
 * Decompiled with CFR 0.152.
 */
package data.missions.arcade;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.ArmorGridAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import java.awt.Color;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class HealthBar {
    private static final Color ARMOR_COLOR = new Color(255, 255, 0, 255);
    private static final Color BACKGROUND_COLOR = new Color(50, 50, 50, 255);
    private static final Color BORDER_COLOR = new Color(96, 96, 96, 255);
    private static final Color HULL_COLOR = new Color(160, 255, 0, 255);
    private final float height;
    private final Vector2f position;
    private final ShipAPI ship;
    private final float width;

    private static float armorLevel(ShipAPI ship) {
        if (ship == null || !Global.getCombatEngine().isEntityInPlay((CombatEntityAPI)ship)) {
            return 0.0f;
        }
        float current = 0.0f;
        float total = 0.0f;
        ArmorGridAPI armorGrid = ship.getArmorGrid();
        for (int x = 0; x < armorGrid.getGrid().length; ++x) {
            for (int y = 0; y < armorGrid.getGrid()[x].length; ++y) {
                current += armorGrid.getArmorFraction(x, y);
                total += 1.0f;
            }
        }
        return current / total;
    }

    private static void glColor(Color color, float alphaMult) {
        GL11.glColor4ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()), (byte)((byte)((float)color.getAlpha() * alphaMult)));
    }

    private static float hullLevel(ShipAPI ship) {
        if (ship == null || !Global.getCombatEngine().isEntityInPlay((CombatEntityAPI)ship)) {
            return 0.0f;
        }
        return ship.getHullLevel();
    }

    public HealthBar(ShipAPI ship, Vector2f position, float height, float width) {
        this.ship = ship;
        this.position = new Vector2f((ReadableVector2f)position);
        this.position.y = Global.getSettings().getScreenHeight() - this.position.y;
        this.height = height;
        this.width = width;
    }

    public void render() {
        GL11.glPushAttrib((int)1048575);
        int w = (int)((float)Display.getWidth() * Display.getPixelScaleFactor());
        int h = (int)((float)Display.getHeight() * Display.getPixelScaleFactor());
        GL11.glViewport((int)0, (int)0, (int)w, (int)h);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)Global.getSettings().getScreenWidth(), (double)0.0, (double)Global.getSettings().getScreenHeight(), (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)0.01f, (float)0.01f, (float)0.0f);
        GL11.glBegin((int)7);
        HealthBar.glColor(BACKGROUND_COLOR, 0.5f);
        GL11.glVertex2f((float)(this.position.x - this.width * 0.5f), (float)(this.position.y + this.height * 0.5f));
        GL11.glVertex2f((float)(this.position.x + this.width * 0.5f), (float)(this.position.y + this.height * 0.5f));
        GL11.glVertex2f((float)(this.position.x + this.width * 0.5f), (float)(this.position.y - this.height * 0.5f));
        GL11.glVertex2f((float)(this.position.x - this.width * 0.5f), (float)(this.position.y - this.height * 0.5f));
        HealthBar.glColor(HULL_COLOR, 0.75f);
        GL11.glVertex2f((float)(this.position.x - this.width * 0.5f), (float)(this.position.y + this.height * 0.5f));
        GL11.glVertex2f((float)(this.position.x + this.width * 0.5f - this.width * (1.0f - HealthBar.hullLevel(this.ship))), (float)(this.position.y + this.height * 0.5f));
        GL11.glVertex2f((float)(this.position.x + this.width * 0.5f - this.width * (1.0f - HealthBar.hullLevel(this.ship))), (float)(this.position.y - this.height * 0.5f));
        GL11.glVertex2f((float)(this.position.x - this.width * 0.5f), (float)(this.position.y - this.height * 0.5f));
        HealthBar.glColor(ARMOR_COLOR, 0.5f);
        GL11.glVertex2f((float)(this.position.x - this.width * 0.5f), (float)this.position.y);
        GL11.glVertex2f((float)(this.position.x + this.width * 0.5f - this.width * (1.0f - HealthBar.armorLevel(this.ship))), (float)this.position.y);
        GL11.glVertex2f((float)(this.position.x + this.width * 0.5f - this.width * (1.0f - HealthBar.armorLevel(this.ship))), (float)(this.position.y - this.height * 0.5f));
        GL11.glVertex2f((float)(this.position.x - this.width * 0.5f), (float)(this.position.y - this.height * 0.5f));
        GL11.glEnd();
        GL11.glBegin((int)2);
        GL11.glLineWidth((float)4.0f);
        HealthBar.glColor(BORDER_COLOR, 1.0f);
        GL11.glVertex2f((float)(this.position.x - this.width * 0.5f), (float)(this.position.y + this.height * 0.5f));
        GL11.glVertex2f((float)(this.position.x + this.width * 0.5f), (float)(this.position.y + this.height * 0.5f));
        GL11.glVertex2f((float)(this.position.x + this.width * 0.5f), (float)(this.position.y - this.height * 0.5f));
        GL11.glVertex2f((float)(this.position.x - this.width * 0.5f), (float)(this.position.y - this.height * 0.5f));
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }
}

