/*
 * Decompiled with CFR 0.152.
 */
package data.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import java.util.HashMap;
import java.util.Map;

public class UnstableInjector
extends BaseHullMod {
    private static final float RANGE_MULT = 0.85f;
    private static final Map<ShipAPI.HullSize, Float> mag = new HashMap<ShipAPI.HullSize, Float>(4);

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getMaxSpeed().modifyFlat(id, mag.get(hullSize).floatValue());
        stats.getBallisticWeaponRangeBonus().modifyMult(id, 0.85f);
        stats.getEnergyWeaponRangeBonus().modifyMult(id, 0.85f);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "" + mag.get(ShipAPI.HullSize.FRIGATE).intValue();
        }
        if (index == 1) {
            return "" + mag.get(ShipAPI.HullSize.DESTROYER).intValue();
        }
        if (index == 2) {
            return "" + mag.get(ShipAPI.HullSize.CRUISER).intValue();
        }
        if (index == 3) {
            return "" + mag.get(ShipAPI.HullSize.CAPITAL_SHIP).intValue();
        }
        if (index == 4) {
            return "" + Math.round(14.999998f);
        }
        return null;
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (ship != null && ship.getVariant().getHullMods().contains("brdrive")) {
            return "\u4e0e\u9ed1\u77f3\u9a71\u52a8\u8f6c\u6362\u51b2\u7a81";
        }
        if (ship != null && ship.getVariant().getHullMods().contains("SCY_engineering")) {
            return "\u4e0eScy\u5f15\u64ce\u51b2\u7a81";
        }
        if (ship != null && ship.getVariant().getHullMods().contains("ii_fire_control")) {
            return "\u4e0e\u5e1d\u56fd FFCS \u6838\u5fc3\u51b2\u7a81";
        }
        return null;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return !ship.getVariant().getHullMods().contains("brdrive") && !ship.getVariant().getHullMods().contains("SCY_engineering") && !ship.getVariant().getHullMods().contains("ii_fire_control");
    }

    static {
        mag.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(25.0f));
        mag.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(20.0f));
        mag.put(ShipAPI.HullSize.CRUISER, Float.valueOf(15.0f));
        mag.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(15.0f));
    }
}

