/*
 * Decompiled with CFR 0.152.
 */
package data.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class SafetyOverrides
extends BaseHullMod {
    private static final float FLUX_DISSIPATION_MULT = 2.0f;
    private static final float PEAK_MULT = 0.33f;
    private static final float RANGE_MULT = 0.25f;
    private static final float RANGE_THRESHOLD = 450.0f;
    private static final Color color = new Color(255, 100, 255, 255);
    private static final Map<ShipAPI.HullSize, Float> speed = new HashMap<ShipAPI.HullSize, Float>(4);

    public void advanceInCombat(ShipAPI ship, float amount) {
        ship.getEngineController().fadeToOtherColor((Object)this, color, null, 1.0f, 0.4f);
        ship.getEngineController().extendFlame((Object)this, 0.25f, 0.25f, 0.25f);
    }

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getMaxSpeed().modifyFlat(id, speed.get(hullSize).floatValue());
        stats.getAcceleration().modifyFlat(id, speed.get(hullSize).floatValue() * 2.0f);
        stats.getDeceleration().modifyFlat(id, speed.get(hullSize).floatValue() * 2.0f);
        stats.getZeroFluxMinimumFluxLevel().modifyFlat(id, 2.0f);
        stats.getFluxDissipation().modifyMult(id, 2.0f);
        stats.getPeakCRDuration().modifyMult(id, 0.33f);
        stats.getVentRateMult().modifyMult(id, 0.0f);
        stats.getWeaponRangeThreshold().modifyFlat(id, 450.0f);
        stats.getWeaponRangeMultPastThreshold().modifyMult(id, 0.25f);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "" + speed.get(ShipAPI.HullSize.FRIGATE).intValue();
        }
        if (index == 1) {
            return "" + speed.get(ShipAPI.HullSize.DESTROYER).intValue();
        }
        if (index == 2) {
            return "" + speed.get(ShipAPI.HullSize.CRUISER).intValue();
        }
        if (index == 3) {
            return Misc.getRoundedValue((float)2.0f);
        }
        if (index == 4) {
            return Misc.getRoundedValue((float)0.33f);
        }
        if (index == 5) {
            return Misc.getRoundedValue((float)450.0f);
        }
        return null;
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (ship.getVariant().getHullSize() == ShipAPI.HullSize.CAPITAL_SHIP) {
            return "\u4e0d\u80fd\u5b89\u88c5\u5728\u4e3b\u529b\u8230\u4e0a";
        }
        if (ship.getVariant().hasHullMod("civgrade")) {
            return "\u4e0d\u80fd\u88ab\u5b89\u88c5\u5728\u6c11\u7528\u8239\u4e0a";
        }
        if (ship.getVariant().hasHullMod("swp_arcade")) {
            return "\u4e0d\u80fd\u5b89\u88c5\u5728\u592a\u9633\u795e-\u7ea7\u4e0a";
        }
        if (ship.getVariant().getHullMods().contains("brdrive")) {
            return "\u4e0e\u9ed1\u77f3\u9a71\u52a8\u8f6c\u6362\u51b2\u7a81";
        }
        if (ship.getVariant().getHullMods().contains("ii_fire_control")) {
            return "\u4e0e\u5e1d\u56fd FFCS \u6838\u5fc3\u51b2\u7a81";
        }
        return null;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        if (ship.getVariant().getHullSize() == ShipAPI.HullSize.CAPITAL_SHIP) {
            return false;
        }
        if (ship.getVariant().hasHullMod("civgrade")) {
            return false;
        }
        if (ship.getVariant().hasHullMod("swp_arcade")) {
            return false;
        }
        if (ship.getVariant().hasHullMod("brdrive")) {
            return false;
        }
        return !ship.getVariant().hasHullMod("ii_fire_control");
    }

    static {
        speed.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(50.0f));
        speed.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(30.0f));
        speed.put(ShipAPI.HullSize.CRUISER, Float.valueOf(20.0f));
        speed.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(10.0f));
    }
}

