/*
 * Decompiled with CFR 0.152.
 */
package data.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import java.util.HashMap;
import java.util.Map;

public class HeavyArmor
extends BaseHullMod {
    public static final float MANEUVER_PENALTY = 20.0f;
    private static final Map<ShipAPI.HullSize, Float> mag = new HashMap<ShipAPI.HullSize, Float>(4);

    public void applyEffectsBeforeShipCreation(ShipAPI.HullSize hullSize, MutableShipStatsAPI stats, String id) {
        stats.getArmorBonus().modifyFlat(id, mag.get(hullSize).floatValue());
        stats.getAcceleration().modifyMult(id, 0.8f);
        stats.getDeceleration().modifyMult(id, 0.8f);
        stats.getTurnAcceleration().modifyMult(id, 0.8f);
        stats.getMaxTurnRate().modifyMult(id, 0.8f);
    }

    public String getDescriptionParam(int index, ShipAPI.HullSize hullSize) {
        if (index == 0) {
            return "" + mag.get(ShipAPI.HullSize.FRIGATE).intValue();
        }
        if (index == 1) {
            return "" + mag.get(ShipAPI.HullSize.DESTROYER).intValue();
        }
        if (index == 2) {
            return "" + mag.get(ShipAPI.HullSize.CRUISER).intValue();
        }
        if (index == 3) {
            return "" + mag.get(ShipAPI.HullSize.CAPITAL_SHIP).intValue();
        }
        if (index == 4) {
            return "20";
        }
        return null;
    }

    public String getUnapplicableReason(ShipAPI ship) {
        if (ship != null && ship.getVariant().getHullMods().contains("brimaginosregen")) {
            return "\u4e0e\u7eb3\u7c73\u6676\u683c\u88c5\u7532\u51b2\u7a81";
        }
        if (ship != null && ship.getVariant().getHullMods().contains("SCY_lightArmor")) {
            return "\u4e0e\u8f7b\u578b\u7535\u9540\u51b2\u7a81";
        }
        if (ship != null && ship.getVariant().getHullMods().contains("ii_conduits")) {
            return "\u4e0e\u5e1d\u56fd HFR \u7ba1\u9053\u51b2\u7a81";
        }
        return null;
    }

    public boolean isApplicableToShip(ShipAPI ship) {
        return ship != null && !ship.getVariant().getHullMods().contains("brimaginosregen") && !ship.getVariant().getHullMods().contains("SCY_lightArmor") && !ship.getVariant().getHullMods().contains("ii_conduits");
    }

    static {
        mag.put(ShipAPI.HullSize.FRIGATE, Float.valueOf(100.0f));
        mag.put(ShipAPI.HullSize.DESTROYER, Float.valueOf(200.0f));
        mag.put(ShipAPI.HullSize.CRUISER, Float.valueOf(300.0f));
        mag.put(ShipAPI.HullSize.CAPITAL_SHIP, Float.valueOf(400.0f));
    }
}

